sas.ltjs.define(["require", "exports", "sas/ltjs/commons/ltjsEnvironment", "sas/ltjs/commons/WrappableCloset", "sas/ltjs/commons/events/EventDispatcher", "sas/ltjs/transport/lib", "sas/ltjs/transport/models/TransportModel"], function (require, exports, ltjsEnvironment_1, WrappableCloset_1, EventDispatcher_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var BatchUpdateStatus = ltjsEnvironment_1.createModule([114, 13, 50265, 50031], EventDispatcher_1.default);
    /**
     *
     */
    BatchUpdateStatus._create = function () {
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_BatchUpdateStatus_create();
        //-- Convert abstract(commons::VOID) from jni(void) to js()
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::BatchUpdateStatus)", "static", "new", "-->", "(transport::BatchUpdateStatus)", rc);
        return rc;
    };
    /**
     * @return {number}
     */
    BatchUpdateStatus.prototype.getInvalidCount = function () {
        var invalidCount_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("invalidCount");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getIntProperty(this._getValidClosetAddress(), invalidCount_jni);
        //-- Convert abstract(commons::INT) from jni(int) to js(number)
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::BatchUpdateStatus)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#invalidCount", "-->", "(commons::INT)", Module.deps['TraceUtil'].traceConversions.convertInt(rc));
        return rc;
    };
    /**
     * @param {number} value
     *
     */
    BatchUpdateStatus.prototype.setInvalidCount = function (value) {
        //-- Convert abstract(commons::INT) from js(number) to jni(int)
        var value_jni = value;
        var invalidCount_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("invalidCount");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setIntProperty(this._getValidClosetAddress(), value_jni, invalidCount_name_jni);
        Module.deps['TraceUtil'].log("(transport::BatchUpdateStatus)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#invalidCount", "(commons::INT)", Module.deps['TraceUtil'].traceConversions.convertInt(value));
        return this;
    };
    /**
     * @return {number}
     */
    BatchUpdateStatus.prototype.getPendingCount = function () {
        var pendingCount_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("pendingCount");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getIntProperty(this._getValidClosetAddress(), pendingCount_jni);
        //-- Convert abstract(commons::INT) from jni(int) to js(number)
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::BatchUpdateStatus)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#pendingCount", "-->", "(commons::INT)", Module.deps['TraceUtil'].traceConversions.convertInt(rc));
        return rc;
    };
    /**
     * @param {number} value
     *
     */
    BatchUpdateStatus.prototype.setPendingCount = function (value) {
        //-- Convert abstract(commons::INT) from js(number) to jni(int)
        var value_jni = value;
        var pendingCount_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("pendingCount");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setIntProperty(this._getValidClosetAddress(), value_jni, pendingCount_name_jni);
        Module.deps['TraceUtil'].log("(transport::BatchUpdateStatus)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#pendingCount", "(commons::INT)", Module.deps['TraceUtil'].traceConversions.convertInt(value));
        return this;
    };
    /**
     * @return {number}
     */
    BatchUpdateStatus.prototype.getSuccessfulCount = function () {
        var successfulCount_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("successfulCount");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getIntProperty(this._getValidClosetAddress(), successfulCount_jni);
        //-- Convert abstract(commons::INT) from jni(int) to js(number)
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::BatchUpdateStatus)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#successfulCount", "-->", "(commons::INT)", Module.deps['TraceUtil'].traceConversions.convertInt(rc));
        return rc;
    };
    /**
     * @param {number} value
     *
     */
    BatchUpdateStatus.prototype.setSuccessfulCount = function (value) {
        //-- Convert abstract(commons::INT) from js(number) to jni(int)
        var value_jni = value;
        var successfulCount_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("successfulCount");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setIntProperty(this._getValidClosetAddress(), value_jni, successfulCount_name_jni);
        Module.deps['TraceUtil'].log("(transport::BatchUpdateStatus)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#successfulCount", "(commons::INT)", Module.deps['TraceUtil'].traceConversions.convertInt(value));
        return this;
    };
    /**
     * @return {number}
     */
    BatchUpdateStatus.prototype.getUnsuccessfulCount = function () {
        var unsuccessfulCount_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("unsuccessfulCount");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getIntProperty(this._getValidClosetAddress(), unsuccessfulCount_jni);
        //-- Convert abstract(commons::INT) from jni(int) to js(number)
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::BatchUpdateStatus)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#unsuccessfulCount", "-->", "(commons::INT)", Module.deps['TraceUtil'].traceConversions.convertInt(rc));
        return rc;
    };
    /**
     * @param {number} value
     *
     */
    BatchUpdateStatus.prototype.setUnsuccessfulCount = function (value) {
        //-- Convert abstract(commons::INT) from js(number) to jni(int)
        var value_jni = value;
        var unsuccessfulCount_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("unsuccessfulCount");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setIntProperty(this._getValidClosetAddress(), value_jni, unsuccessfulCount_name_jni);
        Module.deps['TraceUtil'].log("(transport::BatchUpdateStatus)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#unsuccessfulCount", "(commons::INT)", Module.deps['TraceUtil'].traceConversions.convertInt(value));
        return this;
    };
    /**
     * @return {Array.<TransportModel| null> | null}
     */
    BatchUpdateStatus.prototype.getInvalidModels = function () {
        var invalidModels_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("invalidModels");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getWrappableVectorProperty(this._getValidClosetAddress(), invalidModels_jni);
        //-- Convert abstract(<transport::TransportModel>) from jni(size_t) to js(TransportModel)
        var rc = WrappableCloset_1.getWrapperArray(rc_jni);
        Module.deps['TraceUtil'].log("(transport::BatchUpdateStatus)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#invalidModels", "-->", "(MONITORED_VECTOR<transport::TransportModel>)", Module.deps['TraceUtil'].traceConversions.convertArray(rc, Module.deps['TraceUtil'].traceConversions.convertModel));
        return rc;
    };
    /**
     * @param {Array.<TransportModel| null> | null} value
     *
     */
    BatchUpdateStatus.prototype.setInvalidModels = function (value) {
        //-- Convert abstract(<transport::TransportModel>) from js(TransportModel) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertObjectArrayToC(value);
        var invalidModels_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("invalidModels");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setWrappableVectorProperty(this._getValidClosetAddress(), value_jni, invalidModels_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::BatchUpdateStatus)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#invalidModels", "(MONITORED_VECTOR<transport::TransportModel>)", Module.deps['TraceUtil'].traceConversions.convertArray(value, Module.deps['TraceUtil'].traceConversions.convertModel));
        return this;
    };
    /**
     * @return {Array.<TransportModel| null> | null}
     */
    BatchUpdateStatus.prototype.getUnsuccessfulModels = function () {
        var unsuccessfulModels_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("unsuccessfulModels");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getWrappableVectorProperty(this._getValidClosetAddress(), unsuccessfulModels_jni);
        //-- Convert abstract(<transport::TransportModel>) from jni(size_t) to js(TransportModel)
        var rc = WrappableCloset_1.getWrapperArray(rc_jni);
        Module.deps['TraceUtil'].log("(transport::BatchUpdateStatus)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#unsuccessfulModels", "-->", "(MONITORED_VECTOR<transport::TransportModel>)", Module.deps['TraceUtil'].traceConversions.convertArray(rc, Module.deps['TraceUtil'].traceConversions.convertModel));
        return rc;
    };
    /**
     * @param {Array.<TransportModel| null> | null} value
     *
     */
    BatchUpdateStatus.prototype.setUnsuccessfulModels = function (value) {
        //-- Convert abstract(<transport::TransportModel>) from js(TransportModel) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertObjectArrayToC(value);
        var unsuccessfulModels_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("unsuccessfulModels");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setWrappableVectorProperty(this._getValidClosetAddress(), value_jni, unsuccessfulModels_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::BatchUpdateStatus)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#unsuccessfulModels", "(MONITORED_VECTOR<transport::TransportModel>)", Module.deps['TraceUtil'].traceConversions.convertArray(value, Module.deps['TraceUtil'].traceConversions.convertModel));
        return this;
    };
    exports.default = BatchUpdateStatus;
});
