sas.ltjs.define(["require", "exports", "sas/ltjs/commons/ltjsEnvironment", "sas/ltjs/commons/WrappableCloset", "sas/ltjs/commons/events/EventDispatcher", "sas/ltjs/transport/lib", "sas/ltjs/transport/models/TransportModel", "./BaseReport"], function (require, exports, ltjsEnvironment_1, WrappableCloset_1, EventDispatcher_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var BaseReportCollectionOwner = ltjsEnvironment_1.createModule([114, 13, 50265, 50030], EventDispatcher_1.default);
    /**
     *
     */
    BaseReportCollectionOwner._create = function () {
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_BaseReportCollectionOwner_create();
        //-- Convert abstract(commons::VOID) from jni(void) to js()
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::BaseReportCollectionOwner)", "static", "new", "-->", "(transport::BaseReportCollectionOwner)", rc);
        return rc;
    };
    /**
     * @return {Array.<BaseReport| null> | null}
     */
    BaseReportCollectionOwner.prototype.getReports = function () {
        var reports_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("reports");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getWrappableVectorProperty(this._getValidClosetAddress(), reports_jni);
        //-- Convert abstract(<transport::BaseReport>) from jni(size_t) to js(BaseReport)
        var rc = WrappableCloset_1.getWrapperArray(rc_jni);
        Module.deps['TraceUtil'].log("(transport::BaseReportCollectionOwner)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#reports", "-->", "(MONITORED_VECTOR<transport::BaseReport>)", Module.deps['TraceUtil'].traceConversions.convertArray(rc, Module.deps['TraceUtil'].traceConversions.convertModel));
        return rc;
    };
    /**
     * @param {Array.<BaseReport| null> | null} value
     *
     */
    BaseReportCollectionOwner.prototype.setReports = function (value) {
        //-- Convert abstract(<transport::BaseReport>) from js(BaseReport) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertObjectArrayToC(value);
        var reports_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("reports");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setWrappableVectorProperty(this._getValidClosetAddress(), value_jni, reports_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::BaseReportCollectionOwner)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#reports", "(MONITORED_VECTOR<transport::BaseReport>)", Module.deps['TraceUtil'].traceConversions.convertArray(value, Module.deps['TraceUtil'].traceConversions.convertModel));
        return this;
    };
    exports.default = BaseReportCollectionOwner;
});
