sas.ltjs.define(["require", "exports", "sas/ltjs/commons/ltjsEnvironment", "sas/ltjs/commons/WrappableCloset", "sas/ltjs/commons/ClosetObject", "sas/ltjs/commons/events/EventDispatcher", "sas/ltjs/transport/lib", "./SubserviceManager", "./Voucher"], function (require, exports, ltjsEnvironment_1, WrappableCloset_1, ClosetObject_1, EventDispatcher_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var TextTemplatesManager = ltjsEnvironment_1.createModule([50257, 50259], EventDispatcher_1.default);
    /**
     * Examine the BIRD, if there is an embedded text template then process/evaluate it to obtain the resulting string(s).
     * @param {Report| null} report
     * @param {boolean} userStateEnabled
     * @return {Voucher| null}
     */
    TextTemplatesManager.prototype._getSummaryMessage_ob = function (report, userStateEnabled) {
        //-- Convert abstract(transport::Report) from js(Report) to jni(size_t)
        var report_jni = ClosetObject_1.default._getValidClosetAddress(report);
        //-- Convert abstract(commons::BOOLEAN) from js(boolean) to jni(bool)
        var userStateEnabled_jni = !!userStateEnabled;
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_TextTemplatesManager_getSummaryMessage_ob(this._getValidClosetAddress(), report_jni, userStateEnabled_jni);
        //-- Convert abstract(transport::Voucher) from jni(size_t) to js(Voucher)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::TextTemplatesManager)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "getSummaryMessage", "(transport::Report)", Module.deps['TraceUtil'].traceConversions.convertModel(report), "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(userStateEnabled), "-->", "(transport::Voucher)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * Examine the BIRD, if there is an embedded text template then process/evaluate it to obtain the resulting string(s).
     * @param {string| null} reportUri
     * @param {string| null} reportStateUri
     * @return {Voucher| null}
     */
    TextTemplatesManager.prototype._getSummaryMessage_ss = function (reportUri, reportStateUri) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var reportUri_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(reportUri);
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var reportStateUri_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(reportStateUri);
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_TextTemplatesManager_getSummaryMessage_ss(this._getValidClosetAddress(), reportUri_jni, reportStateUri_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(reportUri_jni);
        ltjsEnvironment_1.ltjsModule.releasePrimitive(reportStateUri_jni);
        //-- Convert abstract(transport::Voucher) from jni(size_t) to js(Voucher)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::TextTemplatesManager)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "getSummaryMessage", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(reportUri), "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(reportStateUri), "-->", "(transport::Voucher)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    TextTemplatesManager.prototype.getSummaryMessage = function ( /*arguments*/) {
        return ClosetObject_1.default.callOverloadedFunction(this, "_getSummaryMessage", Array.prototype.slice.call(arguments));
    };
    exports.default = TextTemplatesManager;
});
