sas.ltjs.define(["require", "exports", "sas/ltjs/commons/ltjsEnvironment", "sas/ltjs/commons/WrappableCloset", "sas/ltjs/commons/ClosetObject", "sas/ltjs/commons/events/EventDispatcher", "sas/ltjs/transport/lib", "./SubserviceManager", "./Voucher"], function (require, exports, ltjsEnvironment_1, WrappableCloset_1, ClosetObject_1, EventDispatcher_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var ReportViewerNLUManager = ltjsEnvironment_1.createModule([50257, 50227], EventDispatcher_1.default);
    /**
     * Determine intent given a natural language communication.
     * @param {AbstractReportViewerNLUParcel| null} parcel
     * @return {Voucher| null}
     */
    ReportViewerNLUManager.prototype.interpretations = function (parcel) {
        //-- Convert abstract(transport::AbstractReportViewerNLUParcel) from js(AbstractReportViewerNLUParcel) to jni(size_t)
        var parcel_jni = ClosetObject_1.default._getValidClosetAddress(parcel);
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_ReportViewerNLUManager_interpretations(this._getValidClosetAddress(), parcel_jni);
        //-- Convert abstract(transport::Voucher) from jni(size_t) to js(Voucher)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::ReportViewerNLUManager)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "interpretations", "(transport::AbstractReportViewerNLUParcel)", Module.deps['TraceUtil'].traceConversions.convertModel(parcel), "-->", "(transport::Voucher)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    exports.default = ReportViewerNLUManager;
});
