sas.ltjs.define(["require", "exports", "sas/ltjs/commons/ltjsEnvironment", "sas/ltjs/commons/WrappableCloset", "sas/ltjs/commons/ClosetObject", "sas/ltjs/commons/events/EventDispatcher", "sas/ltjs/transport/lib", "./SubserviceManager", "./CommentManager", "./Voucher", "./ReportStatus", "./MobileBIClientURL"], function (require, exports, ltjsEnvironment_1, WrappableCloset_1, ClosetObject_1, EventDispatcher_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var ReportManager = ltjsEnvironment_1.createModule([50257, 50209], EventDispatcher_1.default);
    ReportManager.REPORT_DELETED = 60067;
    ReportManager.REPORT_UPDATED = 60068;
    ReportManager.REPORT_CHANGED = 60069;
    ReportManager.REPORT_READY = 60070;
    /**
     * Returns the CommentManager for the given report.
     * @param {Report| null} report
     * @return {CommentManager| null}
     */
    ReportManager.prototype.getCommentManager = function (report) {
        //-- Convert abstract(transport::Report) from js(Report) to jni(size_t)
        var report_jni = ClosetObject_1.default._getValidClosetAddress(report);
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_ReportManager_getCommentManager(this._getValidClosetAddress(), report_jni);
        //-- Convert abstract(transport::CommentManager) from jni(size_t) to js(CommentManager)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::ReportManager)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "getCommentManager", "(transport::Report)", Module.deps['TraceUtil'].traceConversions.convertModel(report), "-->", "(transport::CommentManager)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * Acquires the full report and adds it to the depot.  If this report already exists in the depot, then the report is updated with the latest content from the server.  If the auto-download depot configuration option is enabled, then all report assets that are new or have changed will be downloaded automatically.  In this case, updates may be observed as events dispatched from this report's DownloadStatus.  Downloaded report files will be saved in a uuid-named subdirectory under the 'reportSubdirectory' specified in the depot configuration - ie. (cacheDirectoryPath)/(reportSubdirectory)/(uuid).  Media: Report. Warnings: .
     * @param {Report| null} report
     * @return {Voucher| null}
     */
    ReportManager.prototype._getReport_o = function (report) {
        //-- Convert abstract(transport::Report) from js(Report) to jni(size_t)
        var report_jni = ClosetObject_1.default._getValidClosetAddress(report);
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_ReportManager_getReport_o(this._getValidClosetAddress(), report_jni);
        //-- Convert abstract(transport::Voucher) from jni(size_t) to js(Voucher)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::ReportManager)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "getReport", "(transport::Report)", Module.deps['TraceUtil'].traceConversions.convertModel(report), "-->", "(transport::Voucher)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * Acquires the full report and adds it to the depot.  If this report already exists in the depot, then the report is updated with the latest content from the server.  If the auto-download depot configuration option is enabled, then all report assets that are new or have changed will be downloaded automatically.  In this case, updates may be observed as events dispatched from this report's DownloadStatus.  Downloaded report files will be saved in a uuid-named subdirectory under the 'reportSubdirectory' specified in the depot configuration - ie. (cacheDirectoryPath)/(reportSubdirectory)/(uuid).  Media: Report. Warnings: .
     * @param {string| null} location
     * @return {Voucher| null}
     */
    ReportManager.prototype._getReport_s = function (location) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var location_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(location);
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_ReportManager_getReport_s(this._getValidClosetAddress(), location_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(location_jni);
        //-- Convert abstract(transport::Voucher) from jni(size_t) to js(Voucher)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::ReportManager)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "getReport", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(location), "-->", "(transport::Voucher)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * Acquires the full report with current user state and adds it to the depot.  If this report already exists in the depot, then the report is updated with the latest content from the server.  If the auto-download depot configuration option is enabled, then all report assets that are new or have changed will be downloaded automatically.  In this case, updates may be observed as events dispatched from this report's DownloadStatus.  Downloaded report files will be saved in a uuid-named subdirectory under the 'reportSubdirectory' specified in the depot configuration - ie. (cacheDirectoryPath)/(reportSubdirectory)/(uuid).  Media: Report. Warnings: .
     * @param {Report| null} report
     * @return {Voucher| null}
     */
    ReportManager.prototype._getReportWithUserState_o = function (report) {
        //-- Convert abstract(transport::Report) from js(Report) to jni(size_t)
        var report_jni = ClosetObject_1.default._getValidClosetAddress(report);
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_ReportManager_getReportWithUserState_o(this._getValidClosetAddress(), report_jni);
        //-- Convert abstract(transport::Voucher) from jni(size_t) to js(Voucher)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::ReportManager)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "getReportWithUserState", "(transport::Report)", Module.deps['TraceUtil'].traceConversions.convertModel(report), "-->", "(transport::Voucher)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * Acquires the full report with current user state and adds it to the depot.  If this report already exists in the depot, then the report is updated with the latest content from the server.  If the auto-download depot configuration option is enabled, then all report assets that are new or have changed will be downloaded automatically.  In this case, updates may be observed as events dispatched from this report's DownloadStatus.  Downloaded report files will be saved in a uuid-named subdirectory under the 'reportSubdirectory' specified in the depot configuration - ie. (cacheDirectoryPath)/(reportSubdirectory)/(uuid).  Media: Report. Warnings: .
     * @param {string| null} location
     * @return {Voucher| null}
     */
    ReportManager.prototype._getReportWithUserState_s = function (location) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var location_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(location);
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_ReportManager_getReportWithUserState_s(this._getValidClosetAddress(), location_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(location_jni);
        //-- Convert abstract(transport::Voucher) from jni(size_t) to js(Voucher)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::ReportManager)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "getReportWithUserState", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(location), "-->", "(transport::Voucher)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * Acquires the full report and adds it to the depot.  If this report already exists in the depot, then the report is updated with the latest content from the server.  If the auto-download depot configuration option is enabled, then all report assets that are new or have changed will be downloaded automatically.  In this case, updates may be observed as events dispatched from this report's DownloadStatus.  Downloaded report files will be saved in a uuid-named subdirectory under the 'reportSubdirectory' specified in the depot configuration - ie. (cacheDirectoryPath)/(reportSubdirectory)/(uuid).  Media: Report. Warnings: .
     * @param {string| null} reposKey
     * @return {Voucher| null}
     */
    ReportManager.prototype.getReportByReposKey = function (reposKey) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var reposKey_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(reposKey);
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_ReportManager_getReportByReposKey(this._getValidClosetAddress(), reposKey_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(reposKey_jni);
        //-- Convert abstract(transport::Voucher) from jni(size_t) to js(Voucher)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::ReportManager)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "getReportByReposKey", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(reposKey), "-->", "(transport::Voucher)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * Acquires the full report and adds it to the depot.  Any existing copies of this report are ignored, and the given uuid will be used for the report.  If the auto-download depot configuration option is enabled, then all report assets that are new or have changed will be downloaded automatically.  In this case, updates may be observed as events dispatched from this report's DownloadStatus.  Downloaded report files will be saved in a uuid-named subdirectory under the 'reportSubdirectory' specified in the depot configuration - ie. (cacheDirectoryPath)/(reportSubdirectory)/(uuid).  Media: Report. Warnings: .
     * @param {string| null} location
     * @param {string| null} uuid
     * @return {Voucher| null}
     */
    ReportManager.prototype.getNewReportInstance = function (location, uuid) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var location_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(location);
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var uuid_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(uuid);
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_ReportManager_getNewReportInstance(this._getValidClosetAddress(), location_jni, uuid_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(location_jni);
        ltjsEnvironment_1.ltjsModule.releasePrimitive(uuid_jni);
        //-- Convert abstract(transport::Voucher) from jni(size_t) to js(Voucher)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::ReportManager)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "getNewReportInstance", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(location), "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(uuid), "-->", "(transport::Voucher)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * Acquires the full report with user state and adds it to the depot.  Any existing copies of this report are ignored, and the given uuid will be used for the report.  If the auto-download depot configuration option is enabled, then all report assets that are new or have changed will be downloaded automatically.  In this case, updates may be observed as events dispatched from this report's DownloadStatus.  Downloaded report files will be saved in a uuid-named subdirectory under the 'reportSubdirectory' specified in the depot configuration - ie. (cacheDirectoryPath)/(reportSubdirectory)/(uuid).  Media: Report. Warnings: .
     * @param {string| null} location
     * @param {string| null} uuid
     * @return {Voucher| null}
     */
    ReportManager.prototype.getNewReportInstanceWithUserState = function (location, uuid) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var location_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(location);
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var uuid_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(uuid);
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_ReportManager_getNewReportInstanceWithUserState(this._getValidClosetAddress(), location_jni, uuid_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(location_jni);
        ltjsEnvironment_1.ltjsModule.releasePrimitive(uuid_jni);
        //-- Convert abstract(transport::Voucher) from jni(size_t) to js(Voucher)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::ReportManager)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "getNewReportInstanceWithUserState", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(location), "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(uuid), "-->", "(transport::Voucher)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * Retrieves the report metadata, assigns a UUID, creates a DisplayRecord, and registers the report with the depot.  Tethered Reports are not generated and downloaded until they are opened.  Media: Report. Warnings: .
     * @param {Report| null} report
     * @return {Voucher| null}
     */
    ReportManager.prototype._initializeTetheredReport_o = function (report) {
        //-- Convert abstract(transport::Report) from js(Report) to jni(size_t)
        var report_jni = ClosetObject_1.default._getValidClosetAddress(report);
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_ReportManager_initializeTetheredReport_o(this._getValidClosetAddress(), report_jni);
        //-- Convert abstract(transport::Voucher) from jni(size_t) to js(Voucher)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::ReportManager)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "initializeTetheredReport", "(transport::Report)", Module.deps['TraceUtil'].traceConversions.convertModel(report), "-->", "(transport::Voucher)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * Retrieves the report metadata, assigns a UUID, creates a DisplayRecord, and registers the report with the depot.  Tethered Reports are not generated and downloaded until they are opened.  Media: Report. Warnings: .
     * @param {string| null} location
     * @return {Voucher| null}
     */
    ReportManager.prototype._initializeTetheredReport_s = function (location) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var location_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(location);
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_ReportManager_initializeTetheredReport_s(this._getValidClosetAddress(), location_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(location_jni);
        //-- Convert abstract(transport::Voucher) from jni(size_t) to js(Voucher)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::ReportManager)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "initializeTetheredReport", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(location), "-->", "(transport::Voucher)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * Retrieves the report metadata only. Will not generate, download, or add to the depot.  Media: Report. Warnings: .
     * @param {Report| null} report
     * @return {Voucher| null}
     */
    ReportManager.prototype._getReportMetadata_o = function (report) {
        //-- Convert abstract(transport::Report) from js(Report) to jni(size_t)
        var report_jni = ClosetObject_1.default._getValidClosetAddress(report);
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_ReportManager_getReportMetadata_o(this._getValidClosetAddress(), report_jni);
        //-- Convert abstract(transport::Voucher) from jni(size_t) to js(Voucher)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::ReportManager)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "getReportMetadata", "(transport::Report)", Module.deps['TraceUtil'].traceConversions.convertModel(report), "-->", "(transport::Voucher)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * Retrieves the report metadata only. Will not generate, download, or add to the depot.  Media: Report. Warnings: .
     * @param {string| null} location
     * @return {Voucher| null}
     */
    ReportManager.prototype._getReportMetadata_s = function (location) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var location_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(location);
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_ReportManager_getReportMetadata_s(this._getValidClosetAddress(), location_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(location_jni);
        //-- Convert abstract(transport::Voucher) from jni(size_t) to js(Voucher)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::ReportManager)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "getReportMetadata", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(location), "-->", "(transport::Voucher)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * Records that a report has been opened - updates the DisplayRecord timestamp and isDisplayed status / Submits a request to update the recents history.  Media: None.  Warnings: .
     * @param {Report| null} report
     *
     */
    ReportManager.prototype.reportOpened = function (report) {
        //-- Convert abstract(transport::Report) from js(Report) to jni(size_t)
        var report_jni = ClosetObject_1.default._getValidClosetAddress(report);
        ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_ReportManager_reportOpened(this._getValidClosetAddress(), report_jni);
        Module.deps['TraceUtil'].log("(transport::ReportManager)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "reportOpened", "(transport::Report)", Module.deps['TraceUtil'].traceConversions.convertModel(report));
        return this;
    };
    /**
     * Records that a report has been closed - resets the DisplayRecord isDisplayed status / Cleans up report artifacts for tethered connections.  Media: None.  Warnings: .
     * @param {Report| null} report
     *
     */
    ReportManager.prototype.reportClosed = function (report) {
        //-- Convert abstract(transport::Report) from js(Report) to jni(size_t)
        var report_jni = ClosetObject_1.default._getValidClosetAddress(report);
        ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_ReportManager_reportClosed(this._getValidClosetAddress(), report_jni);
        Module.deps['TraceUtil'].log("(transport::ReportManager)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "reportClosed", "(transport::Report)", Module.deps['TraceUtil'].traceConversions.convertModel(report));
        return this;
    };
    /**
     * Generates a PDF of the 'baseline' report.  If the depot is configured to download printed reports, the PDF will be saved under the current report subdirectory - ie. (cacheDirectoryPath)/(reportSubdirectory)/(uuid)/report.pdf.  A filename of 'report.pdf' will be assigned.  A FileLocation object will be returned - identifying either the path to the PDF in the local filesystem or an URL that can be used to retrieve the file if it has not yet been downloaded.  Media: FileLocation. Warnings: .
     * @param {PrintSetup| null} printSetup
     * @param {string| null} location
     * @return {Voucher| null}
     */
    ReportManager.prototype._printReport_os = function (printSetup, location) {
        //-- Convert abstract(transport::PrintSetup) from js(PrintSetup) to jni(size_t)
        var printSetup_jni = ClosetObject_1.default._getValidClosetAddress(printSetup);
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var location_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(location);
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_ReportManager_printReport_os(this._getValidClosetAddress(), printSetup_jni, location_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(location_jni);
        //-- Convert abstract(transport::Voucher) from jni(size_t) to js(Voucher)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::ReportManager)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "printReport", "(transport::PrintSetup)", Module.deps['TraceUtil'].traceConversions.convertModel(printSetup), "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(location), "-->", "(transport::Voucher)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * Generates a PDF of the report, with it's current report state.  If the depot is configured to download printed reports, the PDF will be saved under the current report subdirectory - ie. (cacheDirectoryPath)/(reportSubdirectory)/(uuid)/report.sha1.pdf.  A filename of 'report.sha1.pdf' will be assigned, where 'sha1' is the SHA1 of the report state XML.  A FileLocation object will be returned - identifying either the path to the PDF in the local filesystem or an URL that can be used to retrieve the file if it has not yet been downloaded.  Media: FileLocation. Warnings: .
     * @param {PrintSetup| null} printSetup
     * @param {string| null} location
     * @param {string| null} reportState
     * @return {Voucher| null}
     */
    ReportManager.prototype._printReport_oss = function (printSetup, location, reportState) {
        //-- Convert abstract(transport::PrintSetup) from js(PrintSetup) to jni(size_t)
        var printSetup_jni = ClosetObject_1.default._getValidClosetAddress(printSetup);
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var location_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(location);
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var reportState_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(reportState);
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_ReportManager_printReport_oss(this._getValidClosetAddress(), printSetup_jni, location_jni, reportState_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(location_jni);
        ltjsEnvironment_1.ltjsModule.releasePrimitive(reportState_jni);
        //-- Convert abstract(transport::Voucher) from jni(size_t) to js(Voucher)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::ReportManager)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "printReport", "(transport::PrintSetup)", Module.deps['TraceUtil'].traceConversions.convertModel(printSetup), "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(location), "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(reportState), "-->", "(transport::Voucher)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * Generates a PDF of the report, with it's current report state.  If the depot is configured to download printed reports, the PDF will be saved under the current report subdirectory, using the provided filename - ie. (cacheDirectoryPath)/(reportSubdirectory)/(uuid)/(filename).  A FileLocation object will be returned - identifying either the path to the PDF in the local filesystem or an URL that can be used to retrieve the file if it has not yet been downloaded.  Media: FileLocation. Warnings: .
     * @param {PrintSetup| null} printSetup
     * @param {string| null} location
     * @param {string| null} reportState
     * @param {string| null} filename
     * @return {Voucher| null}
     */
    ReportManager.prototype._printReport_osss = function (printSetup, location, reportState, filename) {
        //-- Convert abstract(transport::PrintSetup) from js(PrintSetup) to jni(size_t)
        var printSetup_jni = ClosetObject_1.default._getValidClosetAddress(printSetup);
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var location_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(location);
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var reportState_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(reportState);
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var filename_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(filename);
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_ReportManager_printReport_osss(this._getValidClosetAddress(), printSetup_jni, location_jni, reportState_jni, filename_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(location_jni);
        ltjsEnvironment_1.ltjsModule.releasePrimitive(reportState_jni);
        ltjsEnvironment_1.ltjsModule.releasePrimitive(filename_jni);
        //-- Convert abstract(transport::Voucher) from jni(size_t) to js(Voucher)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::ReportManager)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "printReport", "(transport::PrintSetup)", Module.deps['TraceUtil'].traceConversions.convertModel(printSetup), "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(location), "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(reportState), "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(filename), "-->", "(transport::Voucher)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * Generates a PDF of the 'baseline' report.  If the depot is configured to download printed reports, the PDF will be saved under the current report subdirectory - ie. (cacheDirectoryPath)/(reportSubdirectory)/(uuid)/report.pdf.  A filename of 'report.pdf' will be assigned.  A FileLocation object will be returned - identifying either the path to the PDF in the local filesystem or an URL that can be used to retrieve the file if it has not yet been downloaded.  Media: FileLocation. Warnings: .
     * @param {PrintSetup| null} printSetup
     * @param {Report| null} report
     * @return {Voucher| null}
     */
    ReportManager.prototype._printReport_oo = function (printSetup, report) {
        //-- Convert abstract(transport::PrintSetup) from js(PrintSetup) to jni(size_t)
        var printSetup_jni = ClosetObject_1.default._getValidClosetAddress(printSetup);
        //-- Convert abstract(transport::Report) from js(Report) to jni(size_t)
        var report_jni = ClosetObject_1.default._getValidClosetAddress(report);
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_ReportManager_printReport_oo(this._getValidClosetAddress(), printSetup_jni, report_jni);
        //-- Convert abstract(transport::Voucher) from jni(size_t) to js(Voucher)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::ReportManager)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "printReport", "(transport::PrintSetup)", Module.deps['TraceUtil'].traceConversions.convertModel(printSetup), "(transport::Report)", Module.deps['TraceUtil'].traceConversions.convertModel(report), "-->", "(transport::Voucher)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * Generates a PDF of the report, with it's current report state.  If the depot is configured to download printed reports, the PDF will be saved under the current report subdirectory - ie. (cacheDirectoryPath)/(reportSubdirectory)/(uuid)/report.sha1.pdf.  A filename of 'report.sha1.pdf' will be assigned, where 'sha1' is the SHA1 of the report state XML.  A FileLocation object will be returned - identifying either the path to the PDF in the local filesystem or an URL that can be used to retrieve the file if it has not yet been downloaded.  Media: FileLocation. Warnings: .
     * @param {PrintSetup| null} printSetup
     * @param {Report| null} report
     * @param {string| null} reportState
     * @return {Voucher| null}
     */
    ReportManager.prototype._printReport_oos = function (printSetup, report, reportState) {
        //-- Convert abstract(transport::PrintSetup) from js(PrintSetup) to jni(size_t)
        var printSetup_jni = ClosetObject_1.default._getValidClosetAddress(printSetup);
        //-- Convert abstract(transport::Report) from js(Report) to jni(size_t)
        var report_jni = ClosetObject_1.default._getValidClosetAddress(report);
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var reportState_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(reportState);
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_ReportManager_printReport_oos(this._getValidClosetAddress(), printSetup_jni, report_jni, reportState_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(reportState_jni);
        //-- Convert abstract(transport::Voucher) from jni(size_t) to js(Voucher)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::ReportManager)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "printReport", "(transport::PrintSetup)", Module.deps['TraceUtil'].traceConversions.convertModel(printSetup), "(transport::Report)", Module.deps['TraceUtil'].traceConversions.convertModel(report), "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(reportState), "-->", "(transport::Voucher)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * Generates a PDF of the report, with it's current report state.  If the depot is configured to download printed reports, the PDF will be saved under the current report subdirectory, using the provided filename - ie. (cacheDirectoryPath)/(reportSubdirectory)/(uuid)/(filename).  A FileLocation object will be returned - identifying either the path to the PDF in the local filesystem or an URL that can be used to retrieve the file if it has not yet been downloaded.  Media: FileLocation. Warnings: .
     * @param {PrintSetup| null} printSetup
     * @param {Report| null} report
     * @param {string| null} reportState
     * @param {string| null} filename
     * @return {Voucher| null}
     */
    ReportManager.prototype._printReport_ooss = function (printSetup, report, reportState, filename) {
        //-- Convert abstract(transport::PrintSetup) from js(PrintSetup) to jni(size_t)
        var printSetup_jni = ClosetObject_1.default._getValidClosetAddress(printSetup);
        //-- Convert abstract(transport::Report) from js(Report) to jni(size_t)
        var report_jni = ClosetObject_1.default._getValidClosetAddress(report);
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var reportState_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(reportState);
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var filename_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(filename);
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_ReportManager_printReport_ooss(this._getValidClosetAddress(), printSetup_jni, report_jni, reportState_jni, filename_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(reportState_jni);
        ltjsEnvironment_1.ltjsModule.releasePrimitive(filename_jni);
        //-- Convert abstract(transport::Voucher) from jni(size_t) to js(Voucher)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::ReportManager)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "printReport", "(transport::PrintSetup)", Module.deps['TraceUtil'].traceConversions.convertModel(printSetup), "(transport::Report)", Module.deps['TraceUtil'].traceConversions.convertModel(report), "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(reportState), "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(filename), "-->", "(transport::Voucher)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * Checks to see if any of the specified reports have been updated on the server and initiates a 'getReport' call to regenerate those that have changed.  If the depot is configured to auto-update, then this function will be initated from the Depot on a periodic basis and should not need to be called directly from the client application.  The 'dateUpdated' will be updated on the report's DisplayRecord and a 'ReportUpdate' notification will be dispatched from the Report object if any changes are detected.  Media: None. Warnings: .
     * @param {Array.<Report| null> | null} reports
     * @return {Voucher| null}
     */
    ReportManager.prototype.checkForUpdates = function (reports) {
        //-- Convert abstract(<transport::Report>) from js(Report) to jni(size_t)
        var reports_jni = ltjsEnvironment_1.ltjsModule.convertObjectArrayToC(reports);
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_ReportManager_checkForUpdates(this._getValidClosetAddress(), reports_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(reports_jni);
        //-- Convert abstract(transport::Voucher) from jni(size_t) to js(Voucher)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::ReportManager)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "checkForUpdates", "(ARRAY<transport::Report>)", Module.deps['TraceUtil'].traceConversions.convertArray(reports, Module.deps['TraceUtil'].traceConversions.convertModel), "-->", "(transport::Voucher)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * Downloads the server thumbnail for the specified report.  The thumbnail is saved under the 'thumbnailSubdirectory' specified in the depot configuration, with a filename matching the uuid - ie. (cacheDirectoryPath)/(thumbnailSubdirectory)/(uuid).png.  Media: FileLocation.  Warnings: .
     * @param {Report| null} report
     * @return {Voucher| null}
     */
    ReportManager.prototype.getThumbnail = function (report) {
        //-- Convert abstract(transport::Report) from js(Report) to jni(size_t)
        var report_jni = ClosetObject_1.default._getValidClosetAddress(report);
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_ReportManager_getThumbnail(this._getValidClosetAddress(), report_jni);
        //-- Convert abstract(transport::Voucher) from jni(size_t) to js(Voucher)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::ReportManager)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "getThumbnail", "(transport::Report)", Module.deps['TraceUtil'].traceConversions.convertModel(report), "-->", "(transport::Voucher)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * Gets the URL string to use when sharing this report.
     * @param {BaseReport| null} report
     * @return {string| null}
     */
    ReportManager.prototype.getShareURL = function (report) {
        //-- Convert abstract(transport::BaseReport) from js(BaseReport) to jni(size_t)
        var report_jni = ClosetObject_1.default._getValidClosetAddress(report);
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_ReportManager_getShareURL(this._getValidClosetAddress(), report_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::ReportManager)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "getShareURL", "(transport::BaseReport)", Module.deps['TraceUtil'].traceConversions.convertModel(report), "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * Gets the URL string to use when sharing this report.
     * @param {BaseReport| null} report
     * @param {string| null} section
     * @return {string| null}
     */
    ReportManager.prototype.getShareURLWithSection = function (report, section) {
        //-- Convert abstract(transport::BaseReport) from js(BaseReport) to jni(size_t)
        var report_jni = ClosetObject_1.default._getValidClosetAddress(report);
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var section_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(section);
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_ReportManager_getShareURLWithSection(this._getValidClosetAddress(), report_jni, section_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(section_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::ReportManager)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "getShareURLWithSection", "(transport::BaseReport)", Module.deps['TraceUtil'].traceConversions.convertModel(report), "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(section), "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * Gets the URL string to use for opening the report on the device. See http://sww.sas.com/saspedia/Mobile_BI/Client_URL for the spec.
     * @param {BaseReport| null} report
     * @return {string| null}
     */
    ReportManager.prototype.getMobileBIClientURL = function (report) {
        //-- Convert abstract(transport::BaseReport) from js(BaseReport) to jni(size_t)
        var report_jni = ClosetObject_1.default._getValidClosetAddress(report);
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_ReportManager_getMobileBIClientURL(this._getValidClosetAddress(), report_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::ReportManager)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "getMobileBIClientURL", "(transport::BaseReport)", Module.deps['TraceUtil'].traceConversions.convertModel(report), "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * Gets the URL string to use for opening the report on the device. See http://sww.sas.com/saspedia/Mobile_BI/Client_URL for the spec.
     * @param {BaseReport| null} report
     * @param {string| null} section
     * @return {string| null}
     */
    ReportManager.prototype.getMobileBIClientURLWithSection = function (report, section) {
        //-- Convert abstract(transport::BaseReport) from js(BaseReport) to jni(size_t)
        var report_jni = ClosetObject_1.default._getValidClosetAddress(report);
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var section_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(section);
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_ReportManager_getMobileBIClientURLWithSection(this._getValidClosetAddress(), report_jni, section_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(section_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::ReportManager)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "getMobileBIClientURLWithSection", "(transport::BaseReport)", Module.deps['TraceUtil'].traceConversions.convertModel(report), "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(section), "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * Retrieves the list of Alerts defined for this report.  The list is returned as a property of the Report.  The 'subscribe' attribute on each AlertableElement identifies whether or not the user is currently subscribed to that alert.  Media: Report.  Warnings: .
     * @param {Report| null} report
     * @return {Voucher| null}
     */
    ReportManager.prototype.getAlertableItems = function (report) {
        //-- Convert abstract(transport::Report) from js(Report) to jni(size_t)
        var report_jni = ClosetObject_1.default._getValidClosetAddress(report);
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_ReportManager_getAlertableItems(this._getValidClosetAddress(), report_jni);
        //-- Convert abstract(transport::Voucher) from jni(size_t) to js(Voucher)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::ReportManager)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "getAlertableItems", "(transport::Report)", Module.deps['TraceUtil'].traceConversions.convertModel(report), "-->", "(transport::Voucher)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * Subscribes to the specified Alert and retrieves the updated list of Alertable Items.  Media: Report.  Warnings: .
     * @param {Report| null} report
     * @param {string| null} alertName
     * @return {Voucher| null}
     */
    ReportManager.prototype.subscribeToAlert = function (report, alertName) {
        //-- Convert abstract(transport::Report) from js(Report) to jni(size_t)
        var report_jni = ClosetObject_1.default._getValidClosetAddress(report);
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var alertName_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(alertName);
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_ReportManager_subscribeToAlert(this._getValidClosetAddress(), report_jni, alertName_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(alertName_jni);
        //-- Convert abstract(transport::Voucher) from jni(size_t) to js(Voucher)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::ReportManager)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "subscribeToAlert", "(transport::Report)", Module.deps['TraceUtil'].traceConversions.convertModel(report), "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(alertName), "-->", "(transport::Voucher)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * Unsubscribes from the specified Alert and retrieves the updated list of Alertable Items.  Media: Report.  Warnings: .
     * @param {Report| null} report
     * @param {string| null} alertName
     * @return {Voucher| null}
     */
    ReportManager.prototype.unsubscribeFromAlert = function (report, alertName) {
        //-- Convert abstract(transport::Report) from js(Report) to jni(size_t)
        var report_jni = ClosetObject_1.default._getValidClosetAddress(report);
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var alertName_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(alertName);
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_ReportManager_unsubscribeFromAlert(this._getValidClosetAddress(), report_jni, alertName_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(alertName_jni);
        //-- Convert abstract(transport::Voucher) from jni(size_t) to js(Voucher)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::ReportManager)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "unsubscribeFromAlert", "(transport::Report)", Module.deps['TraceUtil'].traceConversions.convertModel(report), "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(alertName), "-->", "(transport::Voucher)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * Makes sure that the report has a UUID assigned to it.
     * @param {Depot| null} depot
     * @param {Report| null} report
     *
     */
    ReportManager.prototype.ensureUUID = function (depot, report) {
        //-- Convert abstract(transport::Depot) from js(Depot) to jni(size_t)
        var depot_jni = ClosetObject_1.default._getValidClosetAddress(depot);
        //-- Convert abstract(transport::Report) from js(Report) to jni(size_t)
        var report_jni = ClosetObject_1.default._getValidClosetAddress(report);
        ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_ReportManager_ensureUUID(this._getValidClosetAddress(), depot_jni, report_jni);
        Module.deps['TraceUtil'].log("(transport::ReportManager)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "ensureUUID", "(transport::Depot)", Module.deps['TraceUtil'].traceConversions.convertModel(depot), "(transport::Report)", Module.deps['TraceUtil'].traceConversions.convertModel(report));
        return this;
    };
    /**
     * Generates the UUID for a report.
     * @param {Depot| null} depot
     * @param {BaseReport| null} report
     * @return {string| null}
     */
    ReportManager.prototype.buildUUID = function (depot, report) {
        //-- Convert abstract(transport::Depot) from js(Depot) to jni(size_t)
        var depot_jni = ClosetObject_1.default._getValidClosetAddress(depot);
        //-- Convert abstract(transport::BaseReport) from js(BaseReport) to jni(size_t)
        var report_jni = ClosetObject_1.default._getValidClosetAddress(report);
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_ReportManager_buildUUID(this._getValidClosetAddress(), depot_jni, report_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::ReportManager)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "buildUUID", "(transport::Depot)", Module.deps['TraceUtil'].traceConversions.convertModel(depot), "(transport::BaseReport)", Module.deps['TraceUtil'].traceConversions.convertModel(report), "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * Gets the path to the subdirectory for a given report.
     * @param {Report| null} report
     * @return {string| null}
     */
    ReportManager.prototype.getReportSubdirectoryPath = function (report) {
        //-- Convert abstract(transport::Report) from js(Report) to jni(size_t)
        var report_jni = ClosetObject_1.default._getValidClosetAddress(report);
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_ReportManager_getReportSubdirectoryPath(this._getValidClosetAddress(), report_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::ReportManager)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "getReportSubdirectoryPath", "(transport::Report)", Module.deps['TraceUtil'].traceConversions.convertModel(report), "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * Gets the path to the thumbnail for a given report.
     * @param {Report| null} report
     * @return {string| null}
     */
    ReportManager.prototype.getThumbnailPath = function (report) {
        //-- Convert abstract(transport::Report) from js(Report) to jni(size_t)
        var report_jni = ClosetObject_1.default._getValidClosetAddress(report);
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_ReportManager_getThumbnailPath(this._getValidClosetAddress(), report_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::ReportManager)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "getThumbnailPath", "(transport::Report)", Module.deps['TraceUtil'].traceConversions.convertModel(report), "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * Gets the report status.
     * @param {BaseReport| null} baseReport
     * @return {ReportStatus}
     */
    ReportManager.prototype.getReportStatus = function (baseReport) {
        //-- Convert abstract(transport::BaseReport) from js(BaseReport) to jni(size_t)
        var baseReport_jni = ClosetObject_1.default._getValidClosetAddress(baseReport);
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_ReportManager_getReportStatus(this._getValidClosetAddress(), baseReport_jni);
        //-- Convert abstract(transport::ReportStatus) from jni(int) to js(ReportStatus)
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::ReportManager)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "getReportStatus", "(transport::BaseReport)", Module.deps['TraceUtil'].traceConversions.convertModel(baseReport), "-->", "(transport::ReportStatus::type)", Module.deps['TraceUtil'].traceConversions.convertEnum(rc));
        return rc;
    };
    /**
     * Gets the current download progress for this report.
     * @param {Report| null} report
     * @return {number}
     */
    ReportManager.prototype.getSubscriptionProgress = function (report) {
        //-- Convert abstract(transport::Report) from js(Report) to jni(size_t)
        var report_jni = ClosetObject_1.default._getValidClosetAddress(report);
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_ReportManager_getSubscriptionProgress(this._getValidClosetAddress(), report_jni);
        //-- Convert abstract(commons::FLOAT) from jni(double) to js(number)
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::ReportManager)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "getSubscriptionProgress", "(transport::Report)", Module.deps['TraceUtil'].traceConversions.convertModel(report), "-->", "(commons::FLOAT)", Module.deps['TraceUtil'].traceConversions.convertFloat(rc));
        return rc;
    };
    /**
     * Given an array of report paths (in the format '/SAS Projects/Mobile/Users/Greg/Comment Testing'), look up the reports in the folder service. The RequestedResource on the Voucher will be a ReportLocationPairs object.
     * @param {Array.<string| null> | null} reportPaths
     * @return {Voucher| null}
     */
    ReportManager.prototype.lookUpReportsByPath = function (reportPaths) {
        //-- Convert abstract(<commons::STRING>) from js(string) to jni(size_t)
        var reportPaths_jni = ltjsEnvironment_1.ltjsModule.convertStringArrayToC(reportPaths);
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_ReportManager_lookUpReportsByPath(this._getValidClosetAddress(), reportPaths_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releaseAllPrimitives(reportPaths_jni);
        //-- Convert abstract(transport::Voucher) from jni(size_t) to js(Voucher)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::ReportManager)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "lookUpReportsByPath", "(ARRAY<commons::STRING>)", Module.deps['TraceUtil'].traceConversions.convertArray(reportPaths, Module.deps['TraceUtil'].traceConversions.convertString), "-->", "(transport::Voucher)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * Returns a boolean indicating whether or not the report is associated with a tethered connection.
     * @param {BaseReport| null} report
     * @return {boolean}
     */
    ReportManager.prototype.isTethered = function (report) {
        //-- Convert abstract(transport::BaseReport) from js(BaseReport) to jni(size_t)
        var report_jni = ClosetObject_1.default._getValidClosetAddress(report);
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_ReportManager_isTethered(this._getValidClosetAddress(), report_jni);
        //-- Convert abstract(commons::BOOLEAN) from jni(bool) to js(boolean)
        var rc = !!rc_jni;
        Module.deps['TraceUtil'].log("(transport::ReportManager)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "isTethered", "(transport::BaseReport)", Module.deps['TraceUtil'].traceConversions.convertModel(report), "-->", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(rc));
        return rc;
    };
    /**
     * Returns a boolean indicating whether or not the report is printable.  This takes into account both the server configuration and the object type.
     * @param {BaseReport| null} report
     * @return {boolean}
     */
    ReportManager.isPrintable = function (report) {
        //-- Convert abstract(transport::BaseReport) from js(BaseReport) to jni(size_t)
        var report_jni = ClosetObject_1.default._getValidClosetAddress(report);
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_ReportManager_isPrintable(report_jni);
        //-- Convert abstract(commons::BOOLEAN) from jni(bool) to js(boolean)
        var rc = !!rc_jni;
        Module.deps['TraceUtil'].log("(transport::ReportManager)", "static", "isPrintable", "(transport::BaseReport)", Module.deps['TraceUtil'].traceConversions.convertModel(report), "-->", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(rc));
        return rc;
    };
    /**
     * Returns a boolean indicating whether or not the report can be removed from the depot.  Reports cannot be removed if they are associated with a subscribed collection.
     * @param {Report| null} report
     * @return {boolean}
     */
    ReportManager.isRemovable = function (report) {
        //-- Convert abstract(transport::Report) from js(Report) to jni(size_t)
        var report_jni = ClosetObject_1.default._getValidClosetAddress(report);
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_ReportManager_isRemovable(report_jni);
        //-- Convert abstract(commons::BOOLEAN) from jni(bool) to js(boolean)
        var rc = !!rc_jni;
        Module.deps['TraceUtil'].log("(transport::ReportManager)", "static", "isRemovable", "(transport::Report)", Module.deps['TraceUtil'].traceConversions.convertModel(report), "-->", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(rc));
        return rc;
    };
    /**
     * A convenience function added primarily for JNI wrappers, which currently fail when calling member functions defined in virtually inherited base classes (like EventDispatcher::dispatchEvent).
     * @param {PortableEvent| null} query
     * @param {Report| null} report
     *
     */
    ReportManager.handleDataQuery = function (query, report) {
        //-- Convert abstract(commons::PortableEvent) from js(PortableEvent) to jni(size_t)
        var query_jni = ClosetObject_1.default._getValidClosetAddress(query);
        //-- Convert abstract(transport::Report) from js(Report) to jni(size_t)
        var report_jni = ClosetObject_1.default._getValidClosetAddress(report);
        ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_ReportManager_handleDataQuery(query_jni, report_jni);
        Module.deps['TraceUtil'].log("(transport::ReportManager)", "static", "handleDataQuery", "(commons::PortableEvent)", Module.deps['TraceUtil'].traceConversions.convertModel(query), "(transport::Report)", Module.deps['TraceUtil'].traceConversions.convertModel(report));
        return this;
    };
    /**
     * Parse the client URL sent by the server when the user clicks a share link. See http://sww.sas.com/saspedia/Mobile_BI/Client_URL
     * @param {string| null} clientURL
     * @return {MobileBIClientURL| null}
     */
    ReportManager.parseMobileBIClientURL = function (clientURL) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var clientURL_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(clientURL);
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_ReportManager_parseMobileBIClientURL(clientURL_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(clientURL_jni);
        //-- Convert abstract(transport::MobileBIClientURL) from jni(size_t) to js(MobileBIClientURL)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::ReportManager)", "static", "parseMobileBIClientURL", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(clientURL), "-->", "(transport::MobileBIClientURL)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * Returns true if the user is allowed to save state for this report, false if not.
     * @param {BaseReport| null} report
     * @return {boolean}
     */
    ReportManager.prototype.canSaveReportState = function (report) {
        //-- Convert abstract(transport::BaseReport) from js(BaseReport) to jni(size_t)
        var report_jni = ClosetObject_1.default._getValidClosetAddress(report);
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_ReportManager_canSaveReportState(this._getValidClosetAddress(), report_jni);
        //-- Convert abstract(commons::BOOLEAN) from jni(bool) to js(boolean)
        var rc = !!rc_jni;
        Module.deps['TraceUtil'].log("(transport::ReportManager)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "canSaveReportState", "(transport::BaseReport)", Module.deps['TraceUtil'].traceConversions.convertModel(report), "-->", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(rc));
        return rc;
    };
    /**
     * Sets the theme version to use for all report packages requests.
     * @param {string| null} themeVersion
     *
     */
    ReportManager.prototype.setThemeVersion = function (themeVersion) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var themeVersion_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(themeVersion);
        ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_ReportManager_setThemeVersion(this._getValidClosetAddress(), themeVersion_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(themeVersion_jni);
        Module.deps['TraceUtil'].log("(transport::ReportManager)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "setThemeVersion", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(themeVersion));
        return this;
    };
    ReportManager.prototype.initializeTetheredReport = function ( /*arguments*/) {
        return ClosetObject_1.default.callOverloadedFunction(this, "_initializeTetheredReport", Array.prototype.slice.call(arguments));
    };
    ReportManager.prototype.getReportMetadata = function ( /*arguments*/) {
        return ClosetObject_1.default.callOverloadedFunction(this, "_getReportMetadata", Array.prototype.slice.call(arguments));
    };
    ReportManager.prototype.getReportWithUserState = function ( /*arguments*/) {
        return ClosetObject_1.default.callOverloadedFunction(this, "_getReportWithUserState", Array.prototype.slice.call(arguments));
    };
    ReportManager.prototype.printReport = function ( /*arguments*/) {
        return ClosetObject_1.default.callOverloadedFunction(this, "_printReport", Array.prototype.slice.call(arguments));
    };
    ReportManager.prototype.getReport = function ( /*arguments*/) {
        return ClosetObject_1.default.callOverloadedFunction(this, "_getReport", Array.prototype.slice.call(arguments));
    };
    exports.default = ReportManager;
});
