sas.ltjs.define(["require", "exports", "sas/ltjs/commons/ltjsEnvironment", "sas/ltjs/commons/WrappableCloset", "sas/ltjs/commons/ClosetObject", "sas/ltjs/transport/lib", "./VoucherEvent", "sas/ltjs/transport/models/TransportModel", "./warnings/TransportWarning"], function (require, exports, ltjsEnvironment_1, WrappableCloset_1, ClosetObject_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var MuxVoucherEvent = ltjsEnvironment_1.createModule([110, 50283, 50165], ClosetObject_1.default);
    /**
     * @return {TransportModel| null}
     */
    MuxVoucherEvent.prototype.getRequestedResource = function () {
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_MuxVoucherEvent_getRequestedResource(this._getValidClosetAddress());
        //-- Convert abstract(transport::TransportModel) from jni(size_t) to js(TransportModel)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::MuxVoucherEvent)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "getRequestedResource", "-->", "(transport::TransportModel)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * @return {TransportWarning| null}
     */
    MuxVoucherEvent.prototype.getWarning = function () {
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_MuxVoucherEvent_getWarning(this._getValidClosetAddress());
        //-- Convert abstract(transport::TransportWarning) from jni(size_t) to js(TransportWarning)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::MuxVoucherEvent)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "getWarning", "-->", "(transport::TransportWarning)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    exports.default = MuxVoucherEvent;
});
