sas.ltjs.define(["require", "exports", "sas/ltjs/commons/ltjsEnvironment", "sas/ltjs/commons/WrappableCloset", "sas/ltjs/commons/ClosetObject", "sas/ltjs/commons/events/EventDispatcher", "sas/ltjs/transport/lib", "sas/ltjs/transport/models/TransportModel", "sas/ltjs/transport/models/local/Connection"], function (require, exports, ltjsEnvironment_1, WrappableCloset_1, ClosetObject_1, EventDispatcher_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var MuxUpdate = ltjsEnvironment_1.createModule([114, 13, 50265, 50164], EventDispatcher_1.default);
    /**
     *
     */
    MuxUpdate._create = function () {
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_MuxUpdate_create();
        //-- Convert abstract(commons::VOID) from jni(void) to js()
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::MuxUpdate)", "static", "new", "-->", "(transport::MuxUpdate)", rc);
        return rc;
    };
    /**
     * @return {TransportModel| null}
     */
    MuxUpdate.prototype.getSource = function () {
        var source_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("source");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getWrappableProperty(this._getValidClosetAddress(), source_jni);
        //-- Convert abstract(transport::TransportModel) from jni(size_t) to js(TransportModel)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::MuxUpdate)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#source", "-->", "(transport::TransportModel)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * @param {TransportModel| null} value
     *
     */
    MuxUpdate.prototype.setSource = function (value) {
        //-- Convert abstract(transport::TransportModel) from js(TransportModel) to jni(size_t)
        var value_jni = ClosetObject_1.default._getValidClosetAddress(value);
        var source_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("source");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setWrappableProperty(this._getValidClosetAddress(), value_jni, source_name_jni);
        Module.deps['TraceUtil'].log("(transport::MuxUpdate)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#source", "(transport::TransportModel)", Module.deps['TraceUtil'].traceConversions.convertModel(value));
        return this;
    };
    /**
     * @return {TransportModel| null}
     */
    MuxUpdate.prototype.getModel = function () {
        var model_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("model");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getWrappableProperty(this._getValidClosetAddress(), model_jni);
        //-- Convert abstract(transport::TransportModel) from jni(size_t) to js(TransportModel)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::MuxUpdate)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#model", "-->", "(transport::TransportModel)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * @param {TransportModel| null} value
     *
     */
    MuxUpdate.prototype.setModel = function (value) {
        //-- Convert abstract(transport::TransportModel) from js(TransportModel) to jni(size_t)
        var value_jni = ClosetObject_1.default._getValidClosetAddress(value);
        var model_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("model");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setWrappableProperty(this._getValidClosetAddress(), value_jni, model_name_jni);
        Module.deps['TraceUtil'].log("(transport::MuxUpdate)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#model", "(transport::TransportModel)", Module.deps['TraceUtil'].traceConversions.convertModel(value));
        return this;
    };
    /**
     * @return {Connection| null}
     */
    MuxUpdate.prototype.getConnection = function () {
        var connection_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("connection");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getWrappableProperty(this._getValidClosetAddress(), connection_jni);
        //-- Convert abstract(transport::Connection) from jni(size_t) to js(Connection)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::MuxUpdate)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#connection", "-->", "(transport::Connection)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * @param {Connection| null} value
     *
     */
    MuxUpdate.prototype.setConnection = function (value) {
        //-- Convert abstract(transport::Connection) from js(Connection) to jni(size_t)
        var value_jni = ClosetObject_1.default._getValidClosetAddress(value);
        var connection_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("connection");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setWrappableProperty(this._getValidClosetAddress(), value_jni, connection_name_jni);
        Module.deps['TraceUtil'].log("(transport::MuxUpdate)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#connection", "(transport::Connection)", Module.deps['TraceUtil'].traceConversions.convertModel(value));
        return this;
    };
    exports.default = MuxUpdate;
});
