sas.ltjs.define(["require", "exports", "sas/ltjs/commons/ltjsEnvironment", "sas/ltjs/commons/WrappableCloset", "sas/ltjs/commons/events/EventDispatcher", "sas/ltjs/transport/lib", "sas/ltjs/commons/events/EventDispatcher", "./Voucher"], function (require, exports, ltjsEnvironment_1, WrappableCloset_1, EventDispatcher_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var MuxManager = ltjsEnvironment_1.createModule([50163], EventDispatcher_1.default);
    /**
     * @param {Array.<BaseReport| null> | null} baseReports
     * @return {Voucher| null}
     */
    MuxManager.prototype.addFavorites = function (baseReports) {
        //-- Convert abstract(<transport::BaseReport>) from js(BaseReport) to jni(size_t)
        var baseReports_jni = ltjsEnvironment_1.ltjsModule.convertObjectArrayToC(baseReports);
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_MuxManager_addFavorites(this._getValidClosetAddress(), baseReports_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(baseReports_jni);
        //-- Convert abstract(transport::Voucher) from jni(size_t) to js(Voucher)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::MuxManager)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "addFavorites", "(ARRAY<transport::BaseReport>)", Module.deps['TraceUtil'].traceConversions.convertArray(baseReports, Module.deps['TraceUtil'].traceConversions.convertModel), "-->", "(transport::Voucher)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * @param {Array.<Report| null> | null} reports
     * @return {Voucher| null}
     */
    MuxManager.prototype.removeFavorites = function (reports) {
        //-- Convert abstract(<transport::Report>) from js(Report) to jni(size_t)
        var reports_jni = ltjsEnvironment_1.ltjsModule.convertObjectArrayToC(reports);
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_MuxManager_removeFavorites(this._getValidClosetAddress(), reports_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(reports_jni);
        //-- Convert abstract(transport::Voucher) from jni(size_t) to js(Voucher)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::MuxManager)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "removeFavorites", "(ARRAY<transport::Report>)", Module.deps['TraceUtil'].traceConversions.convertArray(reports, Module.deps['TraceUtil'].traceConversions.convertModel), "-->", "(transport::Voucher)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    exports.default = MuxManager;
});
