sas.ltjs.define(["require", "exports", "sas/ltjs/commons/ltjsEnvironment", "sas/ltjs/commons/events/EventDispatcher", "sas/ltjs/transport/lib", "sas/ltjs/transport/models/TransportModel", "./MobileBIClientURLAction"], function (require, exports, ltjsEnvironment_1, EventDispatcher_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var MobileBIClientURL = ltjsEnvironment_1.createModule([114, 13, 50265, 50162], EventDispatcher_1.default);
    /**
     *
     */
    MobileBIClientURL._create = function () {
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_MobileBIClientURL_create();
        //-- Convert abstract(commons::VOID) from jni(void) to js()
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::MobileBIClientURL)", "static", "new", "-->", "(transport::MobileBIClientURL)", rc);
        return rc;
    };
    /**
     * @return {string| null}
     */
    MobileBIClientURL.prototype.getScheme = function () {
        var scheme_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("scheme");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), scheme_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::MobileBIClientURL)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#scheme", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    MobileBIClientURL.prototype.setScheme = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var scheme_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("scheme");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, scheme_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::MobileBIClientURL)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#scheme", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    MobileBIClientURL.prototype.getHostname = function () {
        var hostname_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("hostname");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), hostname_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::MobileBIClientURL)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#hostname", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    MobileBIClientURL.prototype.setHostname = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var hostname_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("hostname");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, hostname_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::MobileBIClientURL)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#hostname", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {number}
     */
    MobileBIClientURL.prototype.getPort = function () {
        var port_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("port");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getIntProperty(this._getValidClosetAddress(), port_jni);
        //-- Convert abstract(commons::INT) from jni(int) to js(number)
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::MobileBIClientURL)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#port", "-->", "(commons::INT)", Module.deps['TraceUtil'].traceConversions.convertInt(rc));
        return rc;
    };
    /**
     * @param {number} value
     *
     */
    MobileBIClientURL.prototype.setPort = function (value) {
        //-- Convert abstract(commons::INT) from js(number) to jni(int)
        var value_jni = value;
        var port_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("port");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setIntProperty(this._getValidClosetAddress(), value_jni, port_name_jni);
        Module.deps['TraceUtil'].log("(transport::MobileBIClientURL)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#port", "(commons::INT)", Module.deps['TraceUtil'].traceConversions.convertInt(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    MobileBIClientURL.prototype.getDescription = function () {
        var description_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("description");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), description_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::MobileBIClientURL)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#description", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    MobileBIClientURL.prototype.setDescription = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var description_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("description");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, description_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::MobileBIClientURL)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#description", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    MobileBIClientURL.prototype.getReportLocation = function () {
        var reportLocation_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("reportLocation");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), reportLocation_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::MobileBIClientURL)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#reportLocation", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    MobileBIClientURL.prototype.setReportLocation = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var reportLocation_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("reportLocation");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, reportLocation_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::MobileBIClientURL)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#reportLocation", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    MobileBIClientURL.prototype.getSection = function () {
        var section_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("section");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), section_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::MobileBIClientURL)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#section", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    MobileBIClientURL.prototype.setSection = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var section_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("section");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, section_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::MobileBIClientURL)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#section", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {MobileBIClientURLAction}
     */
    MobileBIClientURL.prototype.getAction = function () {
        var action_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("action");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getIntProperty(this._getValidClosetAddress(), action_jni);
        //-- Convert abstract(transport::MobileBIClientURLAction) from jni(int) to js(MobileBIClientURLAction)
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::MobileBIClientURL)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#action", "-->", "(transport::MobileBIClientURLAction::type)", Module.deps['TraceUtil'].traceConversions.convertEnum(rc));
        return rc;
    };
    /**
     * @param {MobileBIClientURLAction} value
     *
     */
    MobileBIClientURL.prototype.setAction = function (value) {
        //-- Convert abstract(transport::MobileBIClientURLAction) from js(MobileBIClientURLAction) to jni(int)
        var value_jni = value;
        var action_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("action");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setIntProperty(this._getValidClosetAddress(), value_jni, action_name_jni);
        Module.deps['TraceUtil'].log("(transport::MobileBIClientURL)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#action", "(transport::MobileBIClientURLAction::type)", Module.deps['TraceUtil'].traceConversions.convertEnum(value));
        return this;
    };
    /**
     * @return {boolean}
     */
    MobileBIClientURL.prototype.getGuest = function () {
        var guest_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("guest");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getBooleanProperty(this._getValidClosetAddress(), guest_jni);
        //-- Convert abstract(commons::BOOLEAN) from jni(bool) to js(boolean)
        var rc = !!rc_jni;
        Module.deps['TraceUtil'].log("(transport::MobileBIClientURL)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#guest", "-->", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(rc));
        return rc;
    };
    /**
     * @param {boolean} value
     *
     */
    MobileBIClientURL.prototype.setGuest = function (value) {
        //-- Convert abstract(commons::BOOLEAN) from js(boolean) to jni(bool)
        var value_jni = !!value;
        var guest_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("guest");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setBooleanProperty(this._getValidClosetAddress(), value_jni, guest_name_jni);
        Module.deps['TraceUtil'].log("(transport::MobileBIClientURL)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#guest", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    MobileBIClientURL.prototype.getUserid = function () {
        var userid_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("userid");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), userid_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::MobileBIClientURL)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#userid", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    MobileBIClientURL.prototype.setUserid = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var userid_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("userid");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, userid_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::MobileBIClientURL)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#userid", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    MobileBIClientURL.prototype.getPassword = function () {
        var password_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("password");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), password_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::MobileBIClientURL)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#password", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    MobileBIClientURL.prototype.setPassword = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var password_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("password");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, password_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::MobileBIClientURL)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#password", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    exports.default = MobileBIClientURL;
});
