sas.ltjs.define(["require", "exports", "sas/ltjs/commons/ltjsEnvironment", "sas/ltjs/commons/WrappableCloset", "sas/ltjs/commons/ClosetObject", "sas/ltjs/commons/events/EventDispatcher", "sas/ltjs/transport/lib", "./SubserviceManager", "./Voucher", "sas/ltjs/transport/models/media/particles/FavoriteState", "sas/ltjs/transport/models/local/Folder"], function (require, exports, ltjsEnvironment_1, WrappableCloset_1, ClosetObject_1, EventDispatcher_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var FavoritesManager = ltjsEnvironment_1.createModule([50257, 50100], EventDispatcher_1.default);
    /**
     * Acquires the favorites and favorite groups for the given folder. If no folder is provided, then the root (My Favorites) folder is returned. Media: Folder. Warnings: RESOURCE_NOT_FOUND, SERVICE_FAILURE.
     * @param {Folder| null} folder
     * @return {Voucher| null}
     */
    FavoritesManager.prototype.getFavorites = function (folder) {
        //-- Convert abstract(transport::Folder) from js(Folder) to jni(size_t)
        var folder_jni = ClosetObject_1.default._getValidClosetAddress(folder);
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_FavoritesManager_getFavorites(this._getValidClosetAddress(), folder_jni);
        //-- Convert abstract(transport::Voucher) from jni(size_t) to js(Voucher)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::FavoritesManager)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "getFavorites", "(transport::Folder)", Module.deps['TraceUtil'].traceConversions.convertModel(folder), "-->", "(transport::Voucher)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * Adds the given report to the user's favorites. If a parent folder is provided, then it must either be a valid FavoritesGroup folder or the root favorites folder. Upon completion, the report's isFavorite status will be updated prior to the Voucher notification. Media: Folder. Warnings: RESOURCE_NOT_FOUND, SERVICE_FAILURE.
     * @param {BaseReport| null} baseReport
     * @param {Folder| null} parent
     * @return {Voucher| null}
     */
    FavoritesManager.prototype.addFavorite = function (baseReport, parent) {
        //-- Convert abstract(transport::BaseReport) from js(BaseReport) to jni(size_t)
        var baseReport_jni = ClosetObject_1.default._getValidClosetAddress(baseReport);
        //-- Convert abstract(transport::Folder) from js(Folder) to jni(size_t)
        var parent_jni = ClosetObject_1.default._getValidClosetAddress(parent);
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_FavoritesManager_addFavorite(this._getValidClosetAddress(), baseReport_jni, parent_jni);
        //-- Convert abstract(transport::Voucher) from jni(size_t) to js(Voucher)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::FavoritesManager)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "addFavorite", "(transport::BaseReport)", Module.deps['TraceUtil'].traceConversions.convertModel(baseReport), "(transport::Folder)", Module.deps['TraceUtil'].traceConversions.convertModel(parent), "-->", "(transport::Voucher)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * Adds the given report to the user's favorites. If a parent folder is provided, then it must either be a valid FavoritesGroup folder or the root favorites folder. Upon completion, the report's isFavorite status will be updated prior to the Voucher notification. Media: Folder. Warnings: RESOURCE_NOT_FOUND, SERVICE_FAILURE.
     * @param {Array.<BaseReport| null> | null} baseReports
     * @param {Folder| null} parent
     * @return {Voucher| null}
     */
    FavoritesManager.prototype.addFavorites = function (baseReports, parent) {
        //-- Convert abstract(<transport::BaseReport>) from js(BaseReport) to jni(size_t)
        var baseReports_jni = ltjsEnvironment_1.ltjsModule.convertObjectArrayToC(baseReports);
        //-- Convert abstract(transport::Folder) from js(Folder) to jni(size_t)
        var parent_jni = ClosetObject_1.default._getValidClosetAddress(parent);
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_FavoritesManager_addFavorites(this._getValidClosetAddress(), baseReports_jni, parent_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(baseReports_jni);
        //-- Convert abstract(transport::Voucher) from jni(size_t) to js(Voucher)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::FavoritesManager)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "addFavorites", "(ARRAY<transport::BaseReport>)", Module.deps['TraceUtil'].traceConversions.convertArray(baseReports, Module.deps['TraceUtil'].traceConversions.convertModel), "(transport::Folder)", Module.deps['TraceUtil'].traceConversions.convertModel(parent), "-->", "(transport::Voucher)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * Removes the given report from the user's favorites.  If a parent folder is provided, then only the favorite reference that exists within that group will be removed.  To remove a ANY/ALL favorite references, a null parent should be provided. The local favorite status for this report is only updated if the parent is null. Media: Report. Warnings: RESOURCE_NOT_FOUND, SERVICE_FAILURE.
     * @param {Report| null} report
     * @param {Folder| null} parent
     * @return {Voucher| null}
     */
    FavoritesManager.prototype.removeFavorite = function (report, parent) {
        //-- Convert abstract(transport::Report) from js(Report) to jni(size_t)
        var report_jni = ClosetObject_1.default._getValidClosetAddress(report);
        //-- Convert abstract(transport::Folder) from js(Folder) to jni(size_t)
        var parent_jni = ClosetObject_1.default._getValidClosetAddress(parent);
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_FavoritesManager_removeFavorite(this._getValidClosetAddress(), report_jni, parent_jni);
        //-- Convert abstract(transport::Voucher) from jni(size_t) to js(Voucher)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::FavoritesManager)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "removeFavorite", "(transport::Report)", Module.deps['TraceUtil'].traceConversions.convertModel(report), "(transport::Folder)", Module.deps['TraceUtil'].traceConversions.convertModel(parent), "-->", "(transport::Voucher)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * Removes the given report from the user's favorites.  If a parent folder is provided, then only the favorite reference that exists within that group will be removed.  To remove a ANY/ALL favorite references, a null parent should be provided. The local favorite status for this report is only updated if the parent is null. Media: Report. Warnings: RESOURCE_NOT_FOUND, SERVICE_FAILURE.
     * @param {Array.<Report| null> | null} report
     * @param {Folder| null} parent
     * @return {Voucher| null}
     */
    FavoritesManager.prototype.removeFavorites = function (report, parent) {
        //-- Convert abstract(<transport::Report>) from js(Report) to jni(size_t)
        var report_jni = ltjsEnvironment_1.ltjsModule.convertObjectArrayToC(report);
        //-- Convert abstract(transport::Folder) from js(Folder) to jni(size_t)
        var parent_jni = ClosetObject_1.default._getValidClosetAddress(parent);
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_FavoritesManager_removeFavorites(this._getValidClosetAddress(), report_jni, parent_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(report_jni);
        //-- Convert abstract(transport::Voucher) from jni(size_t) to js(Voucher)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::FavoritesManager)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "removeFavorites", "(ARRAY<transport::Report>)", Module.deps['TraceUtil'].traceConversions.convertArray(report, Module.deps['TraceUtil'].traceConversions.convertModel), "(transport::Folder)", Module.deps['TraceUtil'].traceConversions.convertModel(parent), "-->", "(transport::Voucher)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * Adds a new favorite group. Media: Folder. Warnings: RESOURCE_NOT_FOUND, SERVICE_FAILURE.
     * @param {string| null} name
     * @param {Folder| null} parent
     * @return {Voucher| null}
     */
    FavoritesManager.prototype.addFavoriteGroup = function (name, parent) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(name);
        //-- Convert abstract(transport::Folder) from js(Folder) to jni(size_t)
        var parent_jni = ClosetObject_1.default._getValidClosetAddress(parent);
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_FavoritesManager_addFavoriteGroup(this._getValidClosetAddress(), name_jni, parent_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(name_jni);
        //-- Convert abstract(transport::Voucher) from jni(size_t) to js(Voucher)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::FavoritesManager)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "addFavoriteGroup", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(name), "(transport::Folder)", Module.deps['TraceUtil'].traceConversions.convertModel(parent), "-->", "(transport::Voucher)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * Removes the provided favorite group. Media: Folder. Warnings: RESOURCE_NOT_FOUND, SERVICE_FAILURE.
     * @param {Folder| null} folder
     * @return {Voucher| null}
     */
    FavoritesManager.prototype.removeFavoriteGroup = function (folder) {
        //-- Convert abstract(transport::Folder) from js(Folder) to jni(size_t)
        var folder_jni = ClosetObject_1.default._getValidClosetAddress(folder);
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_FavoritesManager_removeFavoriteGroup(this._getValidClosetAddress(), folder_jni);
        //-- Convert abstract(transport::Voucher) from jni(size_t) to js(Voucher)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::FavoritesManager)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "removeFavoriteGroup", "(transport::Folder)", Module.deps['TraceUtil'].traceConversions.convertModel(folder), "-->", "(transport::Voucher)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * Renames the provided favorite group. Media: Folder. Warnings: RESOURCE_NOT_FOUND, SERVICE_FAILURE.
     * @param {string| null} name
     * @param {Folder| null} folder
     * @return {Voucher| null}
     */
    FavoritesManager.prototype.renameFavoriteGroup = function (name, folder) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(name);
        //-- Convert abstract(transport::Folder) from js(Folder) to jni(size_t)
        var folder_jni = ClosetObject_1.default._getValidClosetAddress(folder);
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_FavoritesManager_renameFavoriteGroup(this._getValidClosetAddress(), name_jni, folder_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(name_jni);
        //-- Convert abstract(transport::Voucher) from jni(size_t) to js(Voucher)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::FavoritesManager)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "renameFavoriteGroup", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(name), "(transport::Folder)", Module.deps['TraceUtil'].traceConversions.convertModel(folder), "-->", "(transport::Voucher)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * Refreshes the isFavorite() flag for all known reports. Warnings: SERVICE_FAILURE.
     * @return {Voucher| null}
     */
    FavoritesManager.prototype.updateFavoriteReportStatus = function () {
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_FavoritesManager_updateFavoriteReportStatus(this._getValidClosetAddress());
        //-- Convert abstract(transport::Voucher) from jni(size_t) to js(Voucher)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::FavoritesManager)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "updateFavoriteReportStatus", "-->", "(transport::Voucher)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * @param {string| null} name
     * @return {boolean}
     */
    FavoritesManager.prototype.isValidGroupName = function (name) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(name);
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_FavoritesManager_isValidGroupName(this._getValidClosetAddress(), name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(name_jni);
        //-- Convert abstract(commons::BOOLEAN) from jni(bool) to js(boolean)
        var rc = !!rc_jni;
        Module.deps['TraceUtil'].log("(transport::FavoritesManager)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "isValidGroupName", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(name), "-->", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(rc));
        return rc;
    };
    /**
     * @param {Report| null} report
     * @return {boolean}
     */
    FavoritesManager.prototype.isValidReport = function (report) {
        //-- Convert abstract(transport::Report) from js(Report) to jni(size_t)
        var report_jni = ClosetObject_1.default._getValidClosetAddress(report);
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_FavoritesManager_isValidReport(this._getValidClosetAddress(), report_jni);
        //-- Convert abstract(commons::BOOLEAN) from jni(bool) to js(boolean)
        var rc = !!rc_jni;
        Module.deps['TraceUtil'].log("(transport::FavoritesManager)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "isValidReport", "(transport::Report)", Module.deps['TraceUtil'].traceConversions.convertModel(report), "-->", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(rc));
        return rc;
    };
    /**
     * @param {Folder| null} folder
     * @return {boolean}
     */
    FavoritesManager.prototype.isValidFolder = function (folder) {
        //-- Convert abstract(transport::Folder) from js(Folder) to jni(size_t)
        var folder_jni = ClosetObject_1.default._getValidClosetAddress(folder);
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_FavoritesManager_isValidFolder(this._getValidClosetAddress(), folder_jni);
        //-- Convert abstract(commons::BOOLEAN) from jni(bool) to js(boolean)
        var rc = !!rc_jni;
        Module.deps['TraceUtil'].log("(transport::FavoritesManager)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "isValidFolder", "(transport::Folder)", Module.deps['TraceUtil'].traceConversions.convertModel(folder), "-->", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(rc));
        return rc;
    };
    /**
     * @param {BaseReport| null} baseReport
     * @return {boolean}
     */
    FavoritesManager.isFavorite = function (baseReport) {
        //-- Convert abstract(transport::BaseReport) from js(BaseReport) to jni(size_t)
        var baseReport_jni = ClosetObject_1.default._getValidClosetAddress(baseReport);
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_FavoritesManager_isFavorite(baseReport_jni);
        //-- Convert abstract(commons::BOOLEAN) from jni(bool) to js(boolean)
        var rc = !!rc_jni;
        Module.deps['TraceUtil'].log("(transport::FavoritesManager)", "static", "isFavorite", "(transport::BaseReport)", Module.deps['TraceUtil'].traceConversions.convertModel(baseReport), "-->", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(rc));
        return rc;
    };
    /**
     * @param {BaseReport| null} baseReport
     * @return {FavoriteState}
     */
    FavoritesManager.prototype.getFavoriteState = function (baseReport) {
        //-- Convert abstract(transport::BaseReport) from js(BaseReport) to jni(size_t)
        var baseReport_jni = ClosetObject_1.default._getValidClosetAddress(baseReport);
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_FavoritesManager_getFavoriteState(this._getValidClosetAddress(), baseReport_jni);
        //-- Convert abstract(transport::FavoriteState) from jni(int) to js(FavoriteState)
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::FavoritesManager)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "getFavoriteState", "(transport::BaseReport)", Module.deps['TraceUtil'].traceConversions.convertModel(baseReport), "-->", "(transport::FavoriteState::type)", Module.deps['TraceUtil'].traceConversions.convertEnum(rc));
        return rc;
    };
    /**
     * Returns the root favorites folder, if it exists locally (either from local cache restoration or from a prior call to getFavorites().
     * @return {Folder| null}
     */
    FavoritesManager.prototype.getRootFavoritesFolder = function () {
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_FavoritesManager_getRootFavoritesFolder(this._getValidClosetAddress());
        //-- Convert abstract(transport::Folder) from jni(size_t) to js(Folder)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::FavoritesManager)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "getRootFavoritesFolder", "-->", "(transport::Folder)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * @param {BaseReport| null} baseReport
     * @return {boolean}
     */
    FavoritesManager.prototype.isRootFavorite = function (baseReport) {
        //-- Convert abstract(transport::BaseReport) from js(BaseReport) to jni(size_t)
        var baseReport_jni = ClosetObject_1.default._getValidClosetAddress(baseReport);
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_FavoritesManager_isRootFavorite(this._getValidClosetAddress(), baseReport_jni);
        //-- Convert abstract(commons::BOOLEAN) from jni(bool) to js(boolean)
        var rc = !!rc_jni;
        Module.deps['TraceUtil'].log("(transport::FavoritesManager)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "isRootFavorite", "(transport::BaseReport)", Module.deps['TraceUtil'].traceConversions.convertModel(baseReport), "-->", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(rc));
        return rc;
    };
    /**
     * @param {BaseReport| null} baseReport
     * @param {Folder| null} folder
     * @return {boolean}
     */
    FavoritesManager.prototype.isFavoriteInFolder = function (baseReport, folder) {
        //-- Convert abstract(transport::BaseReport) from js(BaseReport) to jni(size_t)
        var baseReport_jni = ClosetObject_1.default._getValidClosetAddress(baseReport);
        //-- Convert abstract(transport::Folder) from js(Folder) to jni(size_t)
        var folder_jni = ClosetObject_1.default._getValidClosetAddress(folder);
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_FavoritesManager_isFavoriteInFolder(this._getValidClosetAddress(), baseReport_jni, folder_jni);
        //-- Convert abstract(commons::BOOLEAN) from jni(bool) to js(boolean)
        var rc = !!rc_jni;
        Module.deps['TraceUtil'].log("(transport::FavoritesManager)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "isFavoriteInFolder", "(transport::BaseReport)", Module.deps['TraceUtil'].traceConversions.convertModel(baseReport), "(transport::Folder)", Module.deps['TraceUtil'].traceConversions.convertModel(folder), "-->", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(rc));
        return rc;
    };
    exports.default = FavoritesManager;
});
