sas.ltjs.define(["require", "exports", "sas/ltjs/commons/ltjsEnvironment", "sas/ltjs/commons/events/EventDispatcher", "sas/ltjs/transport/lib", "sas/ltjs/transport/models/TransportModel"], function (require, exports, ltjsEnvironment_1, EventDispatcher_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var DeviceInfo = ltjsEnvironment_1.createModule([114, 13, 50265, 50084], EventDispatcher_1.default);
    /**
     *
     */
    DeviceInfo._create = function () {
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_DeviceInfo_create();
        //-- Convert abstract(commons::VOID) from jni(void) to js()
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::DeviceInfo)", "static", "new", "-->", "(transport::DeviceInfo)", rc);
        return rc;
    };
    /**
     * @return {string| null}
     */
    DeviceInfo.prototype.getDeviceType = function () {
        var deviceType_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("deviceType");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), deviceType_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::DeviceInfo)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#deviceType", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    DeviceInfo.prototype.setDeviceType = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var deviceType_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("deviceType");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, deviceType_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::DeviceInfo)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#deviceType", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    DeviceInfo.prototype.getDeviceModel = function () {
        var deviceModel_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("deviceModel");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), deviceModel_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::DeviceInfo)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#deviceModel", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    DeviceInfo.prototype.setDeviceModel = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var deviceModel_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("deviceModel");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, deviceModel_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::DeviceInfo)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#deviceModel", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    DeviceInfo.prototype.getDeviceId = function () {
        var deviceId_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("deviceId");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), deviceId_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::DeviceInfo)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#deviceId", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    DeviceInfo.prototype.setDeviceId = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var deviceId_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("deviceId");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, deviceId_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::DeviceInfo)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#deviceId", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    DeviceInfo.prototype.getOsVersion = function () {
        var osVersion_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("osVersion");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), osVersion_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::DeviceInfo)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#osVersion", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    DeviceInfo.prototype.setOsVersion = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var osVersion_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("osVersion");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, osVersion_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::DeviceInfo)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#osVersion", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    DeviceInfo.prototype.getMobileAppVersion = function () {
        var mobileAppVersion_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("mobileAppVersion");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), mobileAppVersion_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::DeviceInfo)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#mobileAppVersion", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    DeviceInfo.prototype.setMobileAppVersion = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var mobileAppVersion_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("mobileAppVersion");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, mobileAppVersion_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::DeviceInfo)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#mobileAppVersion", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    exports.default = DeviceInfo;
});
