sas.ltjs.define(["require", "exports", "sas/ltjs/commons/ltjsEnvironment", "sas/ltjs/commons/WrappableCloset", "sas/ltjs/commons/ClosetObject", "sas/ltjs/commons/events/EventDispatcher", "sas/ltjs/transport/lib", "./SubserviceManager", "./Voucher"], function (require, exports, ltjsEnvironment_1, WrappableCloset_1, ClosetObject_1, EventDispatcher_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var CommentManager = ltjsEnvironment_1.createModule([50257, 50066], EventDispatcher_1.default);
    /**
     * @return {boolean}
     */
    CommentManager.prototype.supportsObjectLevelComments = function () {
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_CommentManager_supportsObjectLevelComments(this._getValidClosetAddress());
        //-- Convert abstract(commons::BOOLEAN) from jni(bool) to js(boolean)
        var rc = !!rc_jni;
        Module.deps['TraceUtil'].log("(transport::CommentManager)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "supportsObjectLevelComments", "-->", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(rc));
        return rc;
    };
    /**
     * @return {boolean}
     */
    CommentManager.prototype.supportsReportLevelComments = function () {
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_CommentManager_supportsReportLevelComments(this._getValidClosetAddress());
        //-- Convert abstract(commons::BOOLEAN) from jni(bool) to js(boolean)
        var rc = !!rc_jni;
        Module.deps['TraceUtil'].log("(transport::CommentManager)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "supportsReportLevelComments", "-->", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(rc));
        return rc;
    };
    /**
     * Acquire the comments for the report (or a particular object within the report if a DUID is provided). Media: CommentTree. Warnings: .
     * @return {Voucher| null}
     */
    CommentManager.prototype._getComments_v = function () {
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_CommentManager_getComments_v(this._getValidClosetAddress());
        //-- Convert abstract(transport::Voucher) from jni(size_t) to js(Voucher)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::CommentManager)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "getComments", "-->", "(transport::Voucher)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * Acquire the comments for the report (or a particular object within the report if a DUID is provided). Media: CommentTree. Warnings: .
     * @param {string| null} duid
     * @return {Voucher| null}
     */
    CommentManager.prototype._getComments_s = function (duid) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var duid_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(duid);
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_CommentManager_getComments_s(this._getValidClosetAddress(), duid_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(duid_jni);
        //-- Convert abstract(transport::Voucher) from jni(size_t) to js(Voucher)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::CommentManager)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "getComments", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(duid), "-->", "(transport::Voucher)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * Add a comment to a report (or a particular object within the report if a DUID is provided). Media: Comment. Warnings: .
     * @param {Comment| null} comment
     * @return {Voucher| null}
     */
    CommentManager.prototype._addComment_o = function (comment) {
        //-- Convert abstract(transport::Comment) from js(Comment) to jni(size_t)
        var comment_jni = ClosetObject_1.default._getValidClosetAddress(comment);
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_CommentManager_addComment_o(this._getValidClosetAddress(), comment_jni);
        //-- Convert abstract(transport::Voucher) from jni(size_t) to js(Voucher)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::CommentManager)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "addComment", "(transport::Comment)", Module.deps['TraceUtil'].traceConversions.convertModel(comment), "-->", "(transport::Voucher)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * Add a comment to a report (or a particular object within the report if a DUID is provided). Media: Comment. Warnings: .
     * @param {Comment| null} comment
     * @param {string| null} duid
     * @return {Voucher| null}
     */
    CommentManager.prototype._addComment_os = function (comment, duid) {
        //-- Convert abstract(transport::Comment) from js(Comment) to jni(size_t)
        var comment_jni = ClosetObject_1.default._getValidClosetAddress(comment);
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var duid_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(duid);
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_CommentManager_addComment_os(this._getValidClosetAddress(), comment_jni, duid_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(duid_jni);
        //-- Convert abstract(transport::Voucher) from jni(size_t) to js(Voucher)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::CommentManager)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "addComment", "(transport::Comment)", Module.deps['TraceUtil'].traceConversions.convertModel(comment), "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(duid), "-->", "(transport::Voucher)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * @param {Comment| null} parent
     * @param {Comment| null} reply
     * @return {Voucher| null}
     */
    CommentManager.prototype.replyToComment = function (parent, reply) {
        //-- Convert abstract(transport::Comment) from js(Comment) to jni(size_t)
        var parent_jni = ClosetObject_1.default._getValidClosetAddress(parent);
        //-- Convert abstract(transport::Comment) from js(Comment) to jni(size_t)
        var reply_jni = ClosetObject_1.default._getValidClosetAddress(reply);
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_CommentManager_replyToComment(this._getValidClosetAddress(), parent_jni, reply_jni);
        //-- Convert abstract(transport::Voucher) from jni(size_t) to js(Voucher)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::CommentManager)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "replyToComment", "(transport::Comment)", Module.deps['TraceUtil'].traceConversions.convertModel(parent), "(transport::Comment)", Module.deps['TraceUtil'].traceConversions.convertModel(reply), "-->", "(transport::Voucher)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * @param {Comment| null} comment
     * @return {boolean}
     */
    CommentManager.prototype.canEdit = function (comment) {
        //-- Convert abstract(transport::Comment) from js(Comment) to jni(size_t)
        var comment_jni = ClosetObject_1.default._getValidClosetAddress(comment);
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_CommentManager_canEdit(this._getValidClosetAddress(), comment_jni);
        //-- Convert abstract(commons::BOOLEAN) from jni(bool) to js(boolean)
        var rc = !!rc_jni;
        Module.deps['TraceUtil'].log("(transport::CommentManager)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "canEdit", "(transport::Comment)", Module.deps['TraceUtil'].traceConversions.convertModel(comment), "-->", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(rc));
        return rc;
    };
    /**
     * @param {Comment| null} comment
     * @return {boolean}
     */
    CommentManager.prototype.canDelete = function (comment) {
        //-- Convert abstract(transport::Comment) from js(Comment) to jni(size_t)
        var comment_jni = ClosetObject_1.default._getValidClosetAddress(comment);
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_CommentManager_canDelete(this._getValidClosetAddress(), comment_jni);
        //-- Convert abstract(commons::BOOLEAN) from jni(bool) to js(boolean)
        var rc = !!rc_jni;
        Module.deps['TraceUtil'].log("(transport::CommentManager)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "canDelete", "(transport::Comment)", Module.deps['TraceUtil'].traceConversions.convertModel(comment), "-->", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(rc));
        return rc;
    };
    /**
     * @param {Comment| null} comment
     * @return {Voucher| null}
     */
    CommentManager.prototype._editComment_o = function (comment) {
        //-- Convert abstract(transport::Comment) from js(Comment) to jni(size_t)
        var comment_jni = ClosetObject_1.default._getValidClosetAddress(comment);
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_CommentManager_editComment_o(this._getValidClosetAddress(), comment_jni);
        //-- Convert abstract(transport::Voucher) from jni(size_t) to js(Voucher)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::CommentManager)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "editComment", "(transport::Comment)", Module.deps['TraceUtil'].traceConversions.convertModel(comment), "-->", "(transport::Voucher)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * @param {Comment| null} comment
     * @param {string| null} duid
     * @return {Voucher| null}
     */
    CommentManager.prototype._editComment_os = function (comment, duid) {
        //-- Convert abstract(transport::Comment) from js(Comment) to jni(size_t)
        var comment_jni = ClosetObject_1.default._getValidClosetAddress(comment);
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var duid_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(duid);
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_CommentManager_editComment_os(this._getValidClosetAddress(), comment_jni, duid_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(duid_jni);
        //-- Convert abstract(transport::Voucher) from jni(size_t) to js(Voucher)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::CommentManager)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "editComment", "(transport::Comment)", Module.deps['TraceUtil'].traceConversions.convertModel(comment), "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(duid), "-->", "(transport::Voucher)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * Remove this comment. Media: Comment. Warnings: .
     * @param {Comment| null} comment
     * @return {Voucher| null}
     */
    CommentManager.prototype.removeComment = function (comment) {
        //-- Convert abstract(transport::Comment) from js(Comment) to jni(size_t)
        var comment_jni = ClosetObject_1.default._getValidClosetAddress(comment);
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_CommentManager_removeComment(this._getValidClosetAddress(), comment_jni);
        //-- Convert abstract(transport::Voucher) from jni(size_t) to js(Voucher)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::CommentManager)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "removeComment", "(transport::Comment)", Module.deps['TraceUtil'].traceConversions.convertModel(comment), "-->", "(transport::Voucher)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * @param {CommentAttachmentInfo| null} info
     * @return {Voucher| null}
     */
    CommentManager.prototype.getCommentAttachment = function (info) {
        //-- Convert abstract(transport::CommentAttachmentInfo) from js(CommentAttachmentInfo) to jni(size_t)
        var info_jni = ClosetObject_1.default._getValidClosetAddress(info);
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_CommentManager_getCommentAttachment(this._getValidClosetAddress(), info_jni);
        //-- Convert abstract(transport::Voucher) from jni(size_t) to js(Voucher)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::CommentManager)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "getCommentAttachment", "(transport::CommentAttachmentInfo)", Module.deps['TraceUtil'].traceConversions.convertModel(info), "-->", "(transport::Voucher)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * @param {CommentAttachmentInfo| null} info
     * @return {boolean}
     */
    CommentManager.prototype.isCommentAttachmentDownloaded = function (info) {
        //-- Convert abstract(transport::CommentAttachmentInfo) from js(CommentAttachmentInfo) to jni(size_t)
        var info_jni = ClosetObject_1.default._getValidClosetAddress(info);
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_CommentManager_isCommentAttachmentDownloaded(this._getValidClosetAddress(), info_jni);
        //-- Convert abstract(commons::BOOLEAN) from jni(bool) to js(boolean)
        var rc = !!rc_jni;
        Module.deps['TraceUtil'].log("(transport::CommentManager)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "isCommentAttachmentDownloaded", "(transport::CommentAttachmentInfo)", Module.deps['TraceUtil'].traceConversions.convertModel(info), "-->", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(rc));
        return rc;
    };
    CommentManager.prototype.editComment = function ( /*arguments*/) {
        return ClosetObject_1.default.callOverloadedFunction(this, "_editComment", Array.prototype.slice.call(arguments));
    };
    CommentManager.prototype.getComments = function ( /*arguments*/) {
        return ClosetObject_1.default.callOverloadedFunction(this, "_getComments", Array.prototype.slice.call(arguments));
    };
    CommentManager.prototype.addComment = function ( /*arguments*/) {
        return ClosetObject_1.default.callOverloadedFunction(this, "_addComment", Array.prototype.slice.call(arguments));
    };
    exports.default = CommentManager;
});
