sas.ltjs.define(["require", "exports", "sas/ltjs/commons/ltjsEnvironment", "sas/ltjs/commons/WrappableCloset", "sas/ltjs/commons/ClosetObject", "sas/ltjs/commons/events/EventDispatcher", "sas/ltjs/transport/lib", "./SubserviceManager", "./Voucher"], function (require, exports, ltjsEnvironment_1, WrappableCloset_1, ClosetObject_1, EventDispatcher_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var CASManager = ltjsEnvironment_1.createModule([50257, 50039], EventDispatcher_1.default);
    /**
     * Gets all the servers in a CAS instance. RequestedResource is a CASInstance.
     * @return {Voucher| null}
     */
    CASManager.prototype.getServers = function () {
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_CASManager_getServers(this._getValidClosetAddress());
        //-- Convert abstract(transport::Voucher) from jni(size_t) to js(Voucher)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::CASManager)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "getServers", "-->", "(transport::Voucher)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * Get all the libraries in a CASServer and put them in the libs property.
     * @param {CASServer| null} server
     * @return {Voucher| null}
     */
    CASManager.prototype.expandServer = function (server) {
        //-- Convert abstract(transport::CASServer) from js(CASServer) to jni(size_t)
        var server_jni = ClosetObject_1.default._getValidClosetAddress(server);
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_CASManager_expandServer(this._getValidClosetAddress(), server_jni);
        //-- Convert abstract(transport::Voucher) from jni(size_t) to js(Voucher)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::CASManager)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "expandServer", "(transport::CASServer)", Module.deps['TraceUtil'].traceConversions.convertModel(server), "-->", "(transport::Voucher)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * Get all the tables in a CASLibrary and put them in the tables property.
     * @param {CASLibrary| null} library
     * @return {Voucher| null}
     */
    CASManager.prototype.expandLibrary = function (library) {
        //-- Convert abstract(transport::CASLibrary) from js(CASLibrary) to jni(size_t)
        var library_jni = ClosetObject_1.default._getValidClosetAddress(library);
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_CASManager_expandLibrary(this._getValidClosetAddress(), library_jni);
        //-- Convert abstract(transport::Voucher) from jni(size_t) to js(Voucher)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::CASManager)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "expandLibrary", "(transport::CASLibrary)", Module.deps['TraceUtil'].traceConversions.convertModel(library), "-->", "(transport::Voucher)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * Get all the columns in a CASTable and put them in the columns property.
     * @param {CASTable| null} table
     * @return {Voucher| null}
     */
    CASManager.prototype.expandTable = function (table) {
        //-- Convert abstract(transport::CASTable) from js(CASTable) to jni(size_t)
        var table_jni = ClosetObject_1.default._getValidClosetAddress(table);
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_CASManager_expandTable(this._getValidClosetAddress(), table_jni);
        //-- Convert abstract(transport::Voucher) from jni(size_t) to js(Voucher)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::CASManager)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "expandTable", "(transport::CASTable)", Module.deps['TraceUtil'].traceConversions.convertModel(table), "-->", "(transport::Voucher)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * Get information about a specific CAS table, including its columns. RequestedResource is a CASTable.
     * @param {string| null} server
     * @param {string| null} library
     * @param {string| null} table
     * @return {Voucher| null}
     */
    CASManager.prototype.getTable = function (server, library, table) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var server_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(server);
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var library_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(library);
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var table_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(table);
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_CASManager_getTable(this._getValidClosetAddress(), server_jni, library_jni, table_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(server_jni);
        ltjsEnvironment_1.ltjsModule.releasePrimitive(library_jni);
        ltjsEnvironment_1.ltjsModule.releasePrimitive(table_jni);
        //-- Convert abstract(transport::Voucher) from jni(size_t) to js(Voucher)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::CASManager)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "getTable", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(server), "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(library), "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(table), "-->", "(transport::Voucher)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    exports.default = CASManager;
});
