sas.ltjs.define(["require", "exports", "sas/ltjs/commons/ltjsEnvironment", "sas/ltjs/commons/WrappableCloset", "sas/ltjs/commons/ClosetObject", "sas/ltjs/transport/lib", "sas/ltjs/commons/events/PortableEvent", "./Collection", "./CollectionDelta"], function (require, exports, ltjsEnvironment_1, WrappableCloset_1, ClosetObject_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var CollectionDeltaEvent = ltjsEnvironment_1.createModule([110, 50059], ClosetObject_1.default);
    /**
     * @return {Collection| null}
     */
    CollectionDeltaEvent.prototype.getSourceCollection = function () {
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_CollectionDeltaEvent_getSourceCollection(this._getValidClosetAddress());
        //-- Convert abstract(transport::Collection) from jni(size_t) to js(Collection)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::CollectionDeltaEvent)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "getSourceCollection", "-->", "(transport::Collection)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * @return {CollectionDelta| null}
     */
    CollectionDeltaEvent.prototype.getDelta = function () {
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_CollectionDeltaEvent_getDelta(this._getValidClosetAddress());
        //-- Convert abstract(transport::CollectionDelta) from jni(size_t) to js(CollectionDelta)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::CollectionDeltaEvent)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "getDelta", "-->", "(transport::CollectionDelta)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    exports.default = CollectionDeltaEvent;
});
