sas.ltjs.define(["require", "exports", "sas/ltjs/commons/ltjsEnvironment", "sas/ltjs/commons/WrappableCloset", "sas/ltjs/commons/ClosetObject", "sas/ltjs/commons/events/EventDispatcher", "sas/ltjs/transport/lib", "sas/ltjs/transport/models/TransportModel", "sas/ltjs/transport/models/local/TransportModelReference"], function (require, exports, ltjsEnvironment_1, WrappableCloset_1, ClosetObject_1, EventDispatcher_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var Collection = ltjsEnvironment_1.createModule([114, 13, 50265, 50057], EventDispatcher_1.default);
    Collection.SORTED = 60038;
    Collection.UPDATE = 60039;
    Collection.DELETED = 60040;
    Collection.INSERTED = 60041;
    /**
     *
     */
    Collection._create = function () {
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_Collection_create();
        //-- Convert abstract(commons::VOID) from jni(void) to js()
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::Collection)", "static", "new", "-->", "(transport::Collection)", rc);
        return rc;
    };
    /**
     * @return {string| null}
     */
    Collection.prototype.getNickname = function () {
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_Collection_getNickname(this._getValidClosetAddress());
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::Collection)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "getNickname", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    Collection.prototype.setNickname = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_Collection_setNickname(this._getValidClosetAddress(), value_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::Collection)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "setNickname", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @param {number} index
     * @return {TransportModel| null}
     */
    Collection.prototype.at = function (index) {
        //-- Convert abstract(commons::UNSIGNED) from js(number) to jni(int)
        var index_jni = index;
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_Collection_at(this._getValidClosetAddress(), index_jni);
        //-- Convert abstract(transport::TransportModel) from jni(size_t) to js(TransportModel)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::Collection)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "at", "(commons::UNSIGNED)", Module.deps['TraceUtil'].traceConversions.convertUnsigned(index), "-->", "(transport::TransportModel)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * @param {number} index
     * @return {TransportModelReference| null}
     */
    Collection.prototype.referenceAt = function (index) {
        //-- Convert abstract(commons::UNSIGNED) from js(number) to jni(int)
        var index_jni = index;
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_Collection_referenceAt(this._getValidClosetAddress(), index_jni);
        //-- Convert abstract(transport::TransportModelReference) from jni(size_t) to js(TransportModelReference)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::Collection)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "referenceAt", "(commons::UNSIGNED)", Module.deps['TraceUtil'].traceConversions.convertUnsigned(index), "-->", "(transport::TransportModelReference)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * @param {TransportModel| null} objectToFind
     * @return {number}
     */
    Collection.prototype.index = function (objectToFind) {
        //-- Convert abstract(transport::TransportModel) from js(TransportModel) to jni(size_t)
        var objectToFind_jni = ClosetObject_1.default._getValidClosetAddress(objectToFind);
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_Collection_index(this._getValidClosetAddress(), objectToFind_jni);
        //-- Convert abstract(commons::INT) from jni(int) to js(number)
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::Collection)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "index", "(transport::TransportModel)", Module.deps['TraceUtil'].traceConversions.convertModel(objectToFind), "-->", "(commons::INT)", Module.deps['TraceUtil'].traceConversions.convertInt(rc));
        return rc;
    };
    /**
     * @param {TransportModelReference| null} objectToFind
     * @return {number}
     */
    Collection.prototype.referenceIndex = function (objectToFind) {
        //-- Convert abstract(transport::TransportModelReference) from js(TransportModelReference) to jni(size_t)
        var objectToFind_jni = ClosetObject_1.default._getValidClosetAddress(objectToFind);
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_Collection_referenceIndex(this._getValidClosetAddress(), objectToFind_jni);
        //-- Convert abstract(commons::INT) from jni(int) to js(number)
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::Collection)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "referenceIndex", "(transport::TransportModelReference)", Module.deps['TraceUtil'].traceConversions.convertModel(objectToFind), "-->", "(commons::INT)", Module.deps['TraceUtil'].traceConversions.convertInt(rc));
        return rc;
    };
    /**
     * @param {number} location
     * @param {number} length
     * @return {Array.<TransportModel| null> | null}
     */
    Collection.prototype.searchByRange = function (location, length) {
        //-- Convert abstract(commons::UNSIGNED) from js(number) to jni(int)
        var location_jni = location;
        //-- Convert abstract(commons::UNSIGNED) from js(number) to jni(int)
        var length_jni = length;
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_Collection_searchByRange(this._getValidClosetAddress(), location_jni, length_jni);
        //-- Convert abstract(<transport::TransportModel>) from jni(size_t) to js(TransportModel)
        var rc = WrappableCloset_1.getWrapperArray(rc_jni);
        Module.deps['TraceUtil'].log("(transport::Collection)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "searchByRange", "(commons::UNSIGNED)", Module.deps['TraceUtil'].traceConversions.convertUnsigned(location), "(commons::UNSIGNED)", Module.deps['TraceUtil'].traceConversions.convertUnsigned(length), "-->", "(ARRAY<transport::TransportModel>)", Module.deps['TraceUtil'].traceConversions.convertArray(rc, Module.deps['TraceUtil'].traceConversions.convertModel));
        return rc;
    };
    /**
     * @param {number} location
     * @param {number} length
     * @return {Array.<TransportModelReference| null> | null}
     */
    Collection.prototype.searchByRangeReference = function (location, length) {
        //-- Convert abstract(commons::UNSIGNED) from js(number) to jni(int)
        var location_jni = location;
        //-- Convert abstract(commons::UNSIGNED) from js(number) to jni(int)
        var length_jni = length;
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_Collection_searchByRangeReference(this._getValidClosetAddress(), location_jni, length_jni);
        //-- Convert abstract(<transport::TransportModelReference>) from jni(size_t) to js(TransportModelReference)
        var rc = WrappableCloset_1.getWrapperArray(rc_jni);
        Module.deps['TraceUtil'].log("(transport::Collection)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "searchByRangeReference", "(commons::UNSIGNED)", Module.deps['TraceUtil'].traceConversions.convertUnsigned(location), "(commons::UNSIGNED)", Module.deps['TraceUtil'].traceConversions.convertUnsigned(length), "-->", "(ARRAY<transport::TransportModelReference>)", Module.deps['TraceUtil'].traceConversions.convertArray(rc, Module.deps['TraceUtil'].traceConversions.convertModel));
        return rc;
    };
    /**
     * @return {number}
     */
    Collection.prototype.size = function () {
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_Collection_size(this._getValidClosetAddress());
        //-- Convert abstract(commons::UNSIGNED) from jni(int) to js(number)
        var rc = rc_jni >>> 0;
        Module.deps['TraceUtil'].log("(transport::Collection)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "size", "-->", "(commons::UNSIGNED)", Module.deps['TraceUtil'].traceConversions.convertUnsigned(rc));
        return rc;
    };
    /**
     * @return {boolean}
     */
    Collection.prototype.isEmpty = function () {
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_Collection_isEmpty(this._getValidClosetAddress());
        //-- Convert abstract(commons::BOOLEAN) from jni(bool) to js(boolean)
        var rc = !!rc_jni;
        Module.deps['TraceUtil'].log("(transport::Collection)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "isEmpty", "-->", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(rc));
        return rc;
    };
    /**
     * @param {any| null} otherCollection
     * @return {boolean}
     */
    Collection.prototype.isEqual = function (otherCollection) {
        //-- Convert abstract(transport::Collection) from js(Collection) to jni(size_t)
        var otherCollection_jni = ClosetObject_1.default._getValidClosetAddress(otherCollection);
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_Collection_isEqual(this._getValidClosetAddress(), otherCollection_jni);
        //-- Convert abstract(commons::BOOLEAN) from jni(bool) to js(boolean)
        var rc = !!rc_jni;
        Module.deps['TraceUtil'].log("(transport::Collection)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "isEqual", "(transport::Collection)", Module.deps['TraceUtil'].traceConversions.convertModel(otherCollection), "-->", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(rc));
        return rc;
    };
    /**
     * @param {string| null} properties
     * @return {Array.<any| null> | null}
     */
    Collection.prototype.groupBy = function (properties) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var properties_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(properties);
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_Collection_groupBy(this._getValidClosetAddress(), properties_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(properties_jni);
        //-- Convert abstract(<transport::Collection>) from jni(size_t) to js(Collection)
        var rc = WrappableCloset_1.getWrapperArray(rc_jni);
        Module.deps['TraceUtil'].log("(transport::Collection)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "groupBy", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(properties), "-->", "(ARRAY<transport::Collection>)", Module.deps['TraceUtil'].traceConversions.convertArray(rc, Module.deps['TraceUtil'].traceConversions.convertModel));
        return rc;
    };
    /**
     * @param {string| null} predicate
     * @return {any| null}
     */
    Collection.prototype.filterBy = function (predicate) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var predicate_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(predicate);
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_Collection_filterBy(this._getValidClosetAddress(), predicate_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(predicate_jni);
        //-- Convert abstract(transport::Collection) from jni(size_t) to js(Collection)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::Collection)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "filterBy", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(predicate), "-->", "(transport::Collection)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * @return {any| null}
     */
    Collection.prototype.copy = function () {
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_Collection_copy(this._getValidClosetAddress());
        //-- Convert abstract(transport::Collection) from jni(size_t) to js(Collection)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::Collection)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "copy", "-->", "(transport::Collection)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    exports.default = Collection;
});
