declare module "sas/ltjs/transport/TransportPackage" {
    import PortablePackage = require("sas/ltjs/commons/PortablePackage");
    class TransportPackage extends PortablePackage {
        static instance():PortablePackage;
    }
    
    export = TransportPackage;
}


declare module "sas/ltjs/transport/collection/Collection" {
    import TransportModel = require("sas/ltjs/transport/models/TransportModel");
    import TransportModelReference = require("sas/ltjs/transport/models/local/TransportModelReference");
    class Collection extends TransportModel {
        static SORTED:number;
        static UPDATE:number;
        static DELETED:number;
        static INSERTED:number;
        constructor();
        getNickname():string;
        setNickname(value:string):void;
        at(index:number):TransportModel;
        referenceAt(index:number):TransportModelReference;
        index(objectToFind:TransportModel):number;
        referenceIndex(objectToFind:TransportModelReference):number;
        searchByRange(location:number, length:number):Array<TransportModel>;
        searchByRangeReference(location:number, length:number):Array<TransportModelReference>;
        size():number;
        isEmpty():boolean;
        isEqual(otherCollection:Collection):boolean;
        groupBy(properties:string):Array<Collection>;
        filterBy(predicate:string):Collection;
        copy():Collection;
    }
    
    export = Collection;
}


declare module "sas/ltjs/transport/collection/CollectionDelta" {
    import TransportModel = require("sas/ltjs/transport/models/TransportModel");
    import Collection = require("sas/ltjs/transport/collection/Collection");
    class CollectionDelta extends TransportModel {
        constructor();
        getAddition():Collection;
        setAddition(value:Collection):void;
        getDeletion():Collection;
        setDeletion(value:Collection):void;
    }
    
    export = CollectionDelta;
}


declare module "sas/ltjs/transport/collection/CollectionDeltaEvent" {
    import PortableEvent = require("sas/ltjs/commons/events/PortableEvent");
    import Collection = require("sas/ltjs/transport/collection/Collection");
    import CollectionDelta = require("sas/ltjs/transport/collection/CollectionDelta");
    class CollectionDeltaEvent extends PortableEvent {
        getSourceCollection():Collection;
        getDelta():CollectionDelta;
    }
    
    export = CollectionDeltaEvent;
}


declare module "sas/ltjs/transport/collection/SortDescriptor" {
    import EventDispatcher = require("sas/ltjs/commons/events/EventDispatcher");
    class SortDescriptor extends EventDispatcher {
        constructor(property:string, ascending:boolean);
        getProperty():string;
        getAscending():boolean;
    }
    
    export = SortDescriptor;
}


declare module "sas/ltjs/transport/internal/ReportImageCacheEntry" {
    import MediaType = require("sas/ltjs/transport/models/media/MediaType");
    import ReportImageInfo = require("sas/ltjs/transport/models/media/ReportImageInfo");
    class ReportImageCacheEntry extends MediaType {
        constructor();
        getInfos():Array<ReportImageInfo>;
        setInfos(value:Array<ReportImageInfo>):void;
        getDownloadDatetime():number;
        setDownloadDatetime(value:number):void;
        getDownloadPath():string;
        setDownloadPath(value:string):void;
    }
    
    export = ReportImageCacheEntry;
}


declare module "sas/ltjs/transport/depot/CASManager" {
    import SubserviceManager = require("sas/ltjs/transport/depot/SubserviceManager");
    import Voucher = require("sas/ltjs/transport/depot/Voucher");
    import CASServer = require("sas/ltjs/transport/models/local/CASServer");
    import CASLibrary = require("sas/ltjs/transport/models/local/CASLibrary");
    import CASTable = require("sas/ltjs/transport/models/local/CASTable");
    class CASManager extends SubserviceManager {
        getServers():Voucher;
        expandServer(server:CASServer):Voucher;
        expandLibrary(library:CASLibrary):Voucher;
        expandTable(table:CASTable):Voucher;
        getTable(server:string, library:string, table:string):Voucher;
    }
    
    export = CASManager;
}


declare module "sas/ltjs/transport/depot/CollectionsManager" {
    import SubserviceManager = require("sas/ltjs/transport/depot/SubserviceManager");
    import Voucher = require("sas/ltjs/transport/depot/Voucher");
    import Folder = require("sas/ltjs/transport/models/local/Folder");
    import SubscribedCollection = require("sas/ltjs/transport/models/local/SubscribedCollection");
    class CollectionsManager extends SubserviceManager {
        getCollections():Voucher;
        getFolderContent(folder:Folder):Voucher;
        checkForUpdates(collection:SubscribedCollection):Voucher;
        isValidFolder(folder:Folder):boolean;
        getRootCollectionsFolder():Folder;
        subscribeToCollection(folder:Folder | string):Voucher;
    }
    
    export = CollectionsManager;
}


declare module "sas/ltjs/transport/depot/CommentManager" {
    import SubserviceManager = require("sas/ltjs/transport/depot/SubserviceManager");
    import Voucher = require("sas/ltjs/transport/depot/Voucher");
    import Comment = require("sas/ltjs/transport/models/media/Comment");
    import CommentAttachmentInfo = require("sas/ltjs/transport/models/media/particles/CommentAttachmentInfo");
    class CommentManager extends SubserviceManager {
        supportsObjectLevelComments():boolean;
        supportsReportLevelComments():boolean;
        replyToComment(parent:Comment, reply:Comment):Voucher;
        canEdit(comment:Comment):boolean;
        canDelete(comment:Comment):boolean;
        removeComment(comment:Comment):Voucher;
        getCommentAttachment(info:CommentAttachmentInfo):Voucher;
        isCommentAttachmentDownloaded(info:CommentAttachmentInfo):boolean;
        editComment(comment:Comment):Voucher;
        editComment(comment:Comment, duid:string):Voucher;
        getComments():Voucher;
        getComments(duid:string):Voucher;
        addComment(comment:Comment):Voucher;
        addComment(comment:Comment, duid:string):Voucher;
    }
    
    export = CommentManager;
}


declare module "sas/ltjs/transport/depot/ConnectionManager" {
    import SubserviceManager = require("sas/ltjs/transport/depot/SubserviceManager");
    import LogonStatus = require("sas/ltjs/transport/models/media/particles/LogonStatus");
    import EsriLogonStatus = require("sas/ltjs/transport/models/media/particles/EsriLogonStatus");
    import EsriPortalLogonStatus = require("sas/ltjs/transport/models/media/particles/EsriPortalLogonStatus");
    import Voucher = require("sas/ltjs/transport/depot/Voucher");
    import Capability = require("sas/ltjs/transport/models/media/particles/Capability");
    import MapConnectionInfo = require("sas/ltjs/commons/maps/MapConnectionInfo");
    class ConnectionManager extends SubserviceManager {
        getStoredPassword():string;
        getLogonStatus():LogonStatus;
        getEsriLogonStatus():EsriLogonStatus;
        getEsriPortalLogonStatus():EsriPortalLogonStatus;
        getServerConfig():Voucher;
        keepAlive():Voucher;
        logon():Voucher;
        logoff():Voucher;
        initializeSession(token:string):Voucher;
        clearSessionToken():void;
        getLogo():Voucher;
        hasCapability(capability:Capability):boolean;
        getAuthorizationHeaders():Array<string>;
        getCookieHeaders():Array<string>;
        isPersonalizationEnabled():boolean;
        getMapConnectionInfo():MapConnectionInfo;
        setEsriCredentials(userid:string, password:string):Voucher;
        getEsriCredentials():Voucher;
        setEsriPortalCredentials(userid:string, password:string):Voucher;
        getEsriPortalCredentials():Voucher;
        requestEsriPremiumToken():void;
        requestEsriPortalToken():void;
        getUserAvatar(userid:string):Voucher;
        downloadFile(url:string, destinationPath:string):Voucher;
        log(message:string | Array<string>):Voucher;
    }
    
    export = ConnectionManager;
}


declare module "sas/ltjs/transport/depot/Depot" {
    import EventDispatcher = require("sas/ltjs/commons/events/EventDispatcher");
    import DepotConfiguration = require("sas/ltjs/transport/depot/DepotConfiguration");
    import TransportWarning = require("sas/ltjs/transport/depot/warnings/TransportWarning");
    import DepotStatus = require("sas/ltjs/transport/models/local/DepotStatus");
    import CASManager = require("sas/ltjs/transport/depot/CASManager");
    import Connection = require("sas/ltjs/transport/models/local/Connection");
    import CollectionsManager = require("sas/ltjs/transport/depot/CollectionsManager");
    import ConnectionManager = require("sas/ltjs/transport/depot/ConnectionManager");
    import FolderManager = require("sas/ltjs/transport/depot/FolderManager");
    import FavoritesManager = require("sas/ltjs/transport/depot/FavoritesManager");
    import HistoryManager = require("sas/ltjs/transport/depot/HistoryManager");
    import ReportManager = require("sas/ltjs/transport/depot/ReportManager");
    import ReportViewerNLUManager = require("sas/ltjs/transport/depot/ReportViewerNLUManager");
    import SharedItemManager = require("sas/ltjs/transport/depot/SharedItemManager");
    import TextTemplatesManager = require("sas/ltjs/transport/depot/TextTemplatesManager");
    import ThumbnailManager = require("sas/ltjs/transport/depot/ThumbnailManager");
    import DownloadManager = require("sas/ltjs/transport/depot/DownloadManager");
    import MuxManager = require("sas/ltjs/transport/depot/MuxManager");
    import Report = require("sas/ltjs/transport/models/local/Report");
    import Voucher = require("sas/ltjs/transport/depot/Voucher");
    import BaseReport = require("sas/ltjs/transport/models/local/BaseReport");
    class Depot extends EventDispatcher {
        static DEPOT_CONNECTION_ESRI_PORTAL_NOT_AVAILABLE:number;
        static DEPOT_CONNECTION_ESRI_PORTAL_NOT_REQUIRED:number;
        static DEPOT_CONNECTION_ESRI_PORTAL_NO_CREDENTIALS:number;
        static DEPOT_CONNECTION_ESRI_PORTAL_BAD_CREDENTIALS:number;
        static DEPOT_CONNECTION_ESRI_PORTAL_HAS_TOKEN:number;
        static DEPOT_CONNECTION_ESRI_DISABLED:number;
        static DEPOT_CONNECTION_ESRI_NO_CREDENTIALS:number;
        static DEPOT_CONNECTION_ESRI_NO_CAPABILITY:number;
        static DEPOT_CONNECTION_ESRI_LOGIN_SUCCESS:number;
        static DEPOT_CONNECTION_ESRI_LOGIN_FAILURE:number;
        static DEPOT_CONNECTION_REQUIRES_AUTHENTICATION:number;
        static DEPOT_CONNECTION_KEEP_ALIVE_COMPLETE:number;
        static DEPOT_CONNECTION_BACKLIST_WHITELIST:number;
        static DEPOT_CONNECTION_OFFLINE_LIMIT_EXCEEDED:number;
        static DEPOT_CONNECTION_AUTHENTICATION_FAILED:number;
        static DEPOT_CONNECTION_CHANGED:number;
        static DEPOT_CONNECTION_REMOVED:number;
        static DEPOT_CONNECTION_ADDED:number;
        static DEPOT_RESUMED:number;
        static DEPOT_QUIESCED:number;
        static DEPOT_IDLE:number;
        static DEPOT_BUSY:number;
        constructor(configuration:DepotConfiguration);
        updateTimers():void;
        changeAutoUpdateFrequency(frequency:number):void;
        setUseHighContrastReportStyle(useHighContrastReportStyle:boolean):void;
        commit():TransportWarning;
        quiesce():TransportWarning;
        quiesceWhenDone():TransportWarning;
        resume():TransportWarning;
        shutdown():TransportWarning;
        getStatus():DepotStatus;
        setDebug(debug:boolean):void;
        isDebugEnabled():boolean;
        getCASManager(connection:Connection):CASManager;
        getCollectionsManager(connection:Connection):CollectionsManager;
        getConnectionManager(connection:Connection):ConnectionManager;
        getFolderManager(connection:Connection):FolderManager;
        getFavoritesManager(connection:Connection):FavoritesManager;
        getHistoryManager(connection:Connection):HistoryManager;
        getReportManager(connection:Connection):ReportManager;
        getReportViewerNLUManager(connection:Connection):ReportViewerNLUManager;
        getSharedItemManager(connection:Connection):SharedItemManager;
        getTextTemplatesManager(connection:Connection):TextTemplatesManager;
        getThumbnailManager(connection:Connection):ThumbnailManager;
        getDownloadManager():DownloadManager;
        getMuxManager():MuxManager;
        getAllConnections():Array<Connection>;
        getConnections(host:string, port:number):Array<Connection>;
        verifyConnection(connection:Connection):TransportWarning;
        addConnection(connection:Connection):TransportWarning;
        removeConnection(connection:Connection):TransportWarning;
        removeAllConnections():TransportWarning;
        editConnectionPassword(connection:Connection, newPassword:string):TransportWarning;
        editConnectionDescription(connection:Connection, newDescription:string):TransportWarning;
        isPasscodeRequired():boolean;
        getPasscodeTimeout():number;
        getPasscodeAttempts():number;
        removeReport(report:Report):TransportWarning;
        removeAllReports():TransportWarning;
        logEmailSent(report:BaseReport, sectionName:string):Voucher;
        refreshHistory(connection:Connection):Voucher;
        refreshRootFavorites(connection:Connection):Voucher;
        refreshAllFavorites(connection:Connection):Voucher;
        refreshReportFavoriteFlags(connection:Connection):Voucher;
        refreshCollections(connection:Connection):Voucher;
        getConnection(host:string, port:number, userId:string, useGuestCredentials:boolean):Connection;
        getConnection(uuid:string):Connection;
        getSubscribedReport(uuid:string):Report;
        getSubscribedReport(connection:Connection, location:string):Report;
        getAllSubscribedReports():Array<Report>;
        getAllSubscribedReports(connection:Connection):Array<Report>;
    }
    
    export = Depot;
}


declare module "sas/ltjs/transport/depot/DepotConfiguration" {
    import TransportModel = require("sas/ltjs/transport/models/TransportModel");
    import DeviceInfo = require("sas/ltjs/transport/depot/DeviceInfo");
    import ReportDataLevel = require("sas/ltjs/transport/models/media/particles/ReportDataLevel");
    import CSSAdapter = require("sas/ltjs/transport/models/media/particles/CSSAdapter");
    import ReportImageSize = require("sas/ltjs/transport/models/media/particles/ReportImageSize");
    import Capability = require("sas/ltjs/transport/models/media/particles/Capability");
    class DepotConfiguration extends TransportModel {
        constructor();
        getDeviceInfo():DeviceInfo;
        setDeviceInfo(value:DeviceInfo):void;
        getCacheDirectoryPath():string;
        setCacheDirectoryPath(value:string):void;
        getReportSubdirectory():string;
        setReportSubdirectory(value:string):void;
        getPrintFilesSubdirectory():string;
        setPrintFilesSubdirectory(value:string):void;
        getThumbnailSubdirectory():string;
        setThumbnailSubdirectory(value:string):void;
        getAvatarSubdirectory():string;
        setAvatarSubdirectory(value:string):void;
        getConnectionSubdirectory():string;
        setConnectionSubdirectory(value:string):void;
        getPersistentStorageDirectoryPath():string;
        setPersistentStorageDirectoryPath(value:string):void;
        getPasswordKeyChainGroup():string;
        setPasswordKeyChainGroup(value:string):void;
        getCredentialKeyChainGroup():string;
        setCredentialKeyChainGroup(value:string):void;
        getIncludeGuestAccountOnSecureStore():boolean;
        setIncludeGuestAccountOnSecureStore(value:boolean):void;
        getShouldAutoConnect():boolean;
        setShouldAutoConnect(value:boolean):void;
        getShouldPerformPeriodicDeviceChecks():boolean;
        setShouldPerformPeriodicDeviceChecks(value:boolean):void;
        getDeviceCheckFrequency():number;
        setDeviceCheckFrequency(value:number):void;
        getDeviceCheckStatusInterval():number;
        setDeviceCheckStatusInterval(value:number):void;
        getShouldPerformPeriodicReportUpdateChecks():boolean;
        setShouldPerformPeriodicReportUpdateChecks(value:boolean):void;
        getShouldAutoUpdateSubscribedReports():boolean;
        setShouldAutoUpdateSubscribedReports(value:boolean):void;
        getAutoUpdateFrequency():number;
        setAutoUpdateFrequency(value:number):void;
        getShouldAutoStartReportAssetDownloads():boolean;
        setShouldAutoStartReportAssetDownloads(value:boolean):void;
        getMaximumNumberOfConcurrentReportDownloads():number;
        setMaximumNumberOfConcurrentReportDownloads(value:number):void;
        getMaximumNumberOfConcurrentAssetDownloadsPerReport():number;
        setMaximumNumberOfConcurrentAssetDownloadsPerReport(value:number):void;
        getGenerateReportDataLevel():ReportDataLevel;
        setGenerateReportDataLevel(value:ReportDataLevel):void;
        getGenerateReportTimeout():number;
        setGenerateReportTimeout(value:number):void;
        getGenerateReportStatusInterval():number;
        setGenerateReportStatusInterval(value:number):void;
        getGenerateReportStatusTimeout():number;
        setGenerateReportStatusTimeout(value:number):void;
        getGenerateReportImagesInterval():number;
        setGenerateReportImagesInterval(value:number):void;
        getGenerateReportImagesTimeout():number;
        setGenerateReportImagesTimeout(value:number):void;
        getReportDataCreateWaitTime():number;
        setReportDataCreateWaitTime(value:number):void;
        getReportDataCheckWaitTime():number;
        setReportDataCheckWaitTime(value:number):void;
        getShouldAutoDownloadPrintedReports():boolean;
        setShouldAutoDownloadPrintedReports(value:boolean):void;
        getExpandedFolderReportCacheLimit():number;
        setExpandedFolderReportCacheLimit(value:number):void;
        getSupportsTethered():boolean;
        setSupportsTethered(value:boolean):void;
        getCssAdapter():CSSAdapter;
        setCssAdapter(value:CSSAdapter):void;
        getUseHighContrastReportStyle():boolean;
        setUseHighContrastReportStyle(value:boolean):void;
        getShouldAutoCleanupCollectionBasedReportSubscriptions():boolean;
        setShouldAutoCleanupCollectionBasedReportSubscriptions(value:boolean):void;
        getShouldEnforceOfflineLimit():boolean;
        setShouldEnforceOfflineLimit(value:boolean):void;
        getSupportsTransportServerLogging():boolean;
        setSupportsTransportServerLogging(value:boolean):void;
        getShouldAutoRefreshFavorites():boolean;
        setShouldAutoRefreshFavorites(value:boolean):void;
        getShouldAutoRefreshHistory():boolean;
        setShouldAutoRefreshHistory(value:boolean):void;
        getShouldAutoRefreshCollections():boolean;
        setShouldAutoRefreshCollections(value:boolean):void;
        getPortfolioRefreshFrequency():number;
        setPortfolioRefreshFrequency(value:number):void;
        getMaximumHistoryEntries():number;
        setMaximumHistoryEntries(value:number):void;
        getMaximumShareEntries():number;
        setMaximumShareEntries(value:number):void;
        getShouldDoConnectionKeepAlive():boolean;
        setShouldDoConnectionKeepAlive(value:boolean):void;
        getConnectionKeepAliveFrequency():number;
        setConnectionKeepAliveFrequency(value:number):void;
        getClientid():string;
        setClientid(value:string):void;
        getUserCacheSize():number;
        setUserCacheSize(value:number):void;
        getDownloadedReportImageSubdirectory():string;
        setDownloadedReportImageSubdirectory(value:string):void;
        getReportImageCacheMaxFileCount():number;
        setReportImageCacheMaxFileCount(value:number):void;
        getReportImageCacheMaxTotalSize():number;
        setReportImageCacheMaxTotalSize(value:number):void;
        getShouldGeneratePreviewsOnDownload():boolean;
        setShouldGeneratePreviewsOnDownload(value:boolean):void;
        getShouldDownloadReportImagesOnSubscribe():boolean;
        setShouldDownloadReportImagesOnSubscribe(value:boolean):void;
        getReportImageDefaultSize():ReportImageSize;
        setReportImageDefaultSize(value:ReportImageSize):void;
        getReportSectionImageDefaultSize():ReportImageSize;
        setReportSectionImageDefaultSize(value:ReportImageSize):void;
        getShouldDownloadAvatarsForComments():boolean;
        setShouldDownloadAvatarsForComments(value:boolean):void;
        getAvatarRefreshPeriod():number;
        setAvatarRefreshPeriod(value:number):void;
        getCapabilityToCheckForAccess():Capability;
        setCapabilityToCheckForAccess(value:Capability):void;
        getAllowFutureServers():boolean;
        setAllowFutureServers(value:boolean):void;
        getWipePasswords():boolean;
        setWipePasswords(value:boolean):void;
        getShouldGetTextSummaryOnSubscribe():boolean;
        setShouldGetTextSummaryOnSubscribe(value:boolean):void;
    }
    
    export = DepotConfiguration;
}


declare module "sas/ltjs/transport/depot/DepotEvent" {
    import PortableEvent = require("sas/ltjs/commons/events/PortableEvent");
    import BaseModel = require("sas/ltjs/commons/models/BaseModel");
    class DepotEvent extends PortableEvent {
        getAssociatedModel():BaseModel;
    }
    
    export = DepotEvent;
}


declare module "sas/ltjs/transport/depot/DeviceInfo" {
    import TransportModel = require("sas/ltjs/transport/models/TransportModel");
    class DeviceInfo extends TransportModel {
        constructor();
        getDeviceType():string;
        setDeviceType(value:string):void;
        getDeviceModel():string;
        setDeviceModel(value:string):void;
        getDeviceId():string;
        setDeviceId(value:string):void;
        getOsVersion():string;
        setOsVersion(value:string):void;
        getMobileAppVersion():string;
        setMobileAppVersion(value:string):void;
    }
    
    export = DeviceInfo;
}


declare module "sas/ltjs/transport/depot/DownloadManager" {
    import EventDispatcher = require("sas/ltjs/commons/events/EventDispatcher");
    import TransportWarning = require("sas/ltjs/transport/depot/warnings/TransportWarning");
    import Report = require("sas/ltjs/transport/models/local/Report");
    class DownloadManager extends EventDispatcher {
        static DOWNLOADS_FINISHED_ABNORMALLY:number;
        static DOWNLOAD_CANCELLED:number;
        static DOWNLOAD_FAILED:number;
        static DOWNLOAD_STARTED:number;
        static REPORT_DOWNLOAD_LIMIT_EXCEEDED:number;
        static DOWNLOAD_IN_PROGRESS:number;
        static INVALID_REPORT:number;
        start(report:Report):TransportWarning;
        pause(report:Report):TransportWarning;
        resume(report:Report):TransportWarning;
        cancel(report:Report):TransportWarning;
        pauseAll():TransportWarning;
        resumeAll():TransportWarning;
        cancelAll():TransportWarning;
    }
    
    export = DownloadManager;
}


declare module "sas/ltjs/transport/depot/FavoritesManager" {
    import SubserviceManager = require("sas/ltjs/transport/depot/SubserviceManager");
    import Voucher = require("sas/ltjs/transport/depot/Voucher");
    import Folder = require("sas/ltjs/transport/models/local/Folder");
    import BaseReport = require("sas/ltjs/transport/models/local/BaseReport");
    import Report = require("sas/ltjs/transport/models/local/Report");
    import FavoriteState = require("sas/ltjs/transport/models/media/particles/FavoriteState");
    class FavoritesManager extends SubserviceManager {
        getFavorites(folder:Folder):Voucher;
        addFavorite(baseReport:BaseReport, parent:Folder):Voucher;
        addFavorites(baseReports:Array<BaseReport>, parent:Folder):Voucher;
        removeFavorite(report:Report, parent:Folder):Voucher;
        removeFavorites(report:Array<Report>, parent:Folder):Voucher;
        addFavoriteGroup(name:string, parent:Folder):Voucher;
        removeFavoriteGroup(folder:Folder):Voucher;
        renameFavoriteGroup(name:string, folder:Folder):Voucher;
        updateFavoriteReportStatus():Voucher;
        isValidGroupName(name:string):boolean;
        isValidReport(report:Report):boolean;
        isValidFolder(folder:Folder):boolean;
        static isFavorite(baseReport:BaseReport):boolean;
        getFavoriteState(baseReport:BaseReport):FavoriteState;
        getRootFavoritesFolder():Folder;
        isRootFavorite(baseReport:BaseReport):boolean;
        isFavoriteInFolder(baseReport:BaseReport, folder:Folder):boolean;
    }
    
    export = FavoritesManager;
}


declare module "sas/ltjs/transport/depot/FolderManager" {
    import SubserviceManager = require("sas/ltjs/transport/depot/SubserviceManager");
    import Voucher = require("sas/ltjs/transport/depot/Voucher");
    import Folder = require("sas/ltjs/transport/models/local/Folder");
    class FolderManager extends SubserviceManager {
        getFolderContent(folder:Folder):Voucher;
    }
    
    export = FolderManager;
}


declare module "sas/ltjs/transport/depot/HistoryManager" {
    import SubserviceManager = require("sas/ltjs/transport/depot/SubserviceManager");
    import Voucher = require("sas/ltjs/transport/depot/Voucher");
    import Report = require("sas/ltjs/transport/models/local/Report");
    import Folder = require("sas/ltjs/transport/models/local/Folder");
    class HistoryManager extends SubserviceManager {
        getHistory():Voucher;
        addToHistory(report:Report):Voucher;
        removeFromHistory(report:Report):Voucher;
        clearHistory():Voucher;
        getRootHistoryFolder():Folder;
    }
    
    export = HistoryManager;
}


declare module "sas/ltjs/transport/depot/MobileBIClientURL" {
    import TransportModel = require("sas/ltjs/transport/models/TransportModel");
    import MobileBIClientURLAction = require("sas/ltjs/transport/depot/MobileBIClientURLAction");
    class MobileBIClientURL extends TransportModel {
        constructor();
        getScheme():string;
        setScheme(value:string):void;
        getHostname():string;
        setHostname(value:string):void;
        getPort():number;
        setPort(value:number):void;
        getDescription():string;
        setDescription(value:string):void;
        getReportLocation():string;
        setReportLocation(value:string):void;
        getSection():string;
        setSection(value:string):void;
        getAction():MobileBIClientURLAction;
        setAction(value:MobileBIClientURLAction):void;
        getGuest():boolean;
        setGuest(value:boolean):void;
        getUserid():string;
        setUserid(value:string):void;
        getPassword():string;
        setPassword(value:string):void;
    }
    
    export = MobileBIClientURL;
}


declare module "sas/ltjs/transport/depot/MobileBIClientURLAction" {
    enum MobileBIClientURLAction
    {
        REPORT,
        PORTFOLIO,
        LIBRARY
    }
    export = MobileBIClientURLAction
}


declare module "sas/ltjs/transport/depot/MuxManager" {
    import EventDispatcher = require("sas/ltjs/commons/events/EventDispatcher");
    import Voucher = require("sas/ltjs/transport/depot/Voucher");
    import BaseReport = require("sas/ltjs/transport/models/local/BaseReport");
    import Report = require("sas/ltjs/transport/models/local/Report");
    class MuxManager extends EventDispatcher {
        addFavorites(baseReports:Array<BaseReport>):Voucher;
        removeFavorites(reports:Array<Report>):Voucher;
    }
    
    export = MuxManager;
}


declare module "sas/ltjs/transport/depot/MuxUpdate" {
    import TransportModel = require("sas/ltjs/transport/models/TransportModel");
    import Connection = require("sas/ltjs/transport/models/local/Connection");
    class MuxUpdate extends TransportModel {
        constructor();
        getSource():TransportModel;
        setSource(value:TransportModel):void;
        getModel():TransportModel;
        setModel(value:TransportModel):void;
        getConnection():Connection;
        setConnection(value:Connection):void;
    }
    
    export = MuxUpdate;
}


declare module "sas/ltjs/transport/depot/MuxVoucherEvent" {
    import VoucherEvent = require("sas/ltjs/transport/depot/VoucherEvent");
    import TransportModel = require("sas/ltjs/transport/models/TransportModel");
    import TransportWarning = require("sas/ltjs/transport/depot/warnings/TransportWarning");
    class MuxVoucherEvent extends VoucherEvent {
        getRequestedResource():TransportModel;
        getWarning():TransportWarning;
    }
    
    export = MuxVoucherEvent;
}


declare module "sas/ltjs/transport/depot/ReportManager" {
    import SubserviceManager = require("sas/ltjs/transport/depot/SubserviceManager");
    import CommentManager = require("sas/ltjs/transport/depot/CommentManager");
    import Report = require("sas/ltjs/transport/models/local/Report");
    import Voucher = require("sas/ltjs/transport/depot/Voucher");
    import PrintSetup = require("sas/ltjs/transport/models/media/PrintSetup");
    import BaseReport = require("sas/ltjs/transport/models/local/BaseReport");
    import Depot = require("sas/ltjs/transport/depot/Depot");
    import ReportStatus = require("sas/ltjs/transport/depot/ReportStatus");
    import PortableEvent = require("sas/ltjs/commons/events/PortableEvent");
    import MobileBIClientURL = require("sas/ltjs/transport/depot/MobileBIClientURL");
    class ReportManager extends SubserviceManager {
        static REPORT_DELETED:number;
        static REPORT_UPDATED:number;
        static REPORT_CHANGED:number;
        static REPORT_READY:number;
        getCommentManager(report:Report):CommentManager;
        getReportByReposKey(reposKey:string):Voucher;
        getNewReportInstance(location:string, uuid:string):Voucher;
        getNewReportInstanceWithUserState(location:string, uuid:string):Voucher;
        reportOpened(report:Report):void;
        reportClosed(report:Report):void;
        checkForUpdates(reports:Array<Report>):Voucher;
        getThumbnail(report:Report):Voucher;
        getShareURL(report:BaseReport):string;
        getShareURLWithSection(report:BaseReport, section:string):string;
        getMobileBIClientURL(report:BaseReport):string;
        getMobileBIClientURLWithSection(report:BaseReport, section:string):string;
        getAlertableItems(report:Report):Voucher;
        subscribeToAlert(report:Report, alertName:string):Voucher;
        unsubscribeFromAlert(report:Report, alertName:string):Voucher;
        ensureUUID(depot:Depot, report:Report):void;
        buildUUID(depot:Depot, report:BaseReport):string;
        getReportSubdirectoryPath(report:Report):string;
        getThumbnailPath(report:Report):string;
        getReportStatus(baseReport:BaseReport):ReportStatus;
        getSubscriptionProgress(report:Report):number;
        lookUpReportsByPath(reportPaths:Array<string>):Voucher;
        isTethered(report:BaseReport):boolean;
        static isPrintable(report:BaseReport):boolean;
        static isRemovable(report:Report):boolean;
        static handleDataQuery(query:PortableEvent, report:Report):void;
        static parseMobileBIClientURL(clientURL:string):MobileBIClientURL;
        canSaveReportState(report:BaseReport):boolean;
        setThemeVersion(themeVersion:string):void;
        initializeTetheredReport(report:Report | string):Voucher;
        getReportMetadata(report:Report | string):Voucher;
        getReportWithUserState(report:Report | string):Voucher;
        printReport(printSetup:PrintSetup, location:string | Report):Voucher;
        printReport(printSetup:PrintSetup, location:string | Report, reportState:string):Voucher;
        printReport(printSetup:PrintSetup, location:string | Report, reportState:string, filename:string):Voucher;
        getReport(report:Report | string):Voucher;
    }
    
    export = ReportManager;
}


declare module "sas/ltjs/transport/depot/ReportStatus" {
    enum ReportStatus
    {
        UNSUBSCRIBED,
        SUBSCRIBING,
        DOWNLOADING,
        GENERATING_PREVIEWS,
        UNAVAILABLE,
        NORMAL,
        NEW,
        UPDATED
    }
    export = ReportStatus
}


declare module "sas/ltjs/transport/depot/ReportViewerNLUManager" {
    import SubserviceManager = require("sas/ltjs/transport/depot/SubserviceManager");
    import Voucher = require("sas/ltjs/transport/depot/Voucher");
    import AbstractReportViewerNLUParcel = require("sas/ltjs/transport/naturalLanguage/AbstractReportViewerNLUParcel");
    class ReportViewerNLUManager extends SubserviceManager {
        interpretations(parcel:AbstractReportViewerNLUParcel):Voucher;
    }
    
    export = ReportViewerNLUManager;
}


declare module "sas/ltjs/transport/depot/SearchLocations" {
    enum SearchLocations
    {
        LOCAL,
        REMOTE,
        ALL
    }
    export = SearchLocations
}


declare module "sas/ltjs/transport/depot/SharedItemManager" {
    import SubserviceManager = require("sas/ltjs/transport/depot/SubserviceManager");
    import Voucher = require("sas/ltjs/transport/depot/Voucher");
    import Folder = require("sas/ltjs/transport/models/local/Folder");
    class SharedItemManager extends SubserviceManager {
        getSharedWithMe():Voucher;
        getSharedByMe():Voucher;
        getSharedWithMeFolder():Folder;
        getSharedByMeFolder():Folder;
    }
    
    export = SharedItemManager;
}


declare module "sas/ltjs/transport/depot/SubserviceManager" {
    import EventDispatcher = require("sas/ltjs/commons/events/EventDispatcher");
    import Connection = require("sas/ltjs/transport/models/local/Connection");
    import TransportWarning = require("sas/ltjs/transport/depot/warnings/TransportWarning");
    import Voucher = require("sas/ltjs/transport/depot/Voucher");
    class SubserviceManager extends EventDispatcher {
        getConnection():Connection;
        cancel(voucher:Voucher):TransportWarning;
    }
    
    export = SubserviceManager;
}


declare module "sas/ltjs/transport/depot/TextTemplatesManager" {
    import SubserviceManager = require("sas/ltjs/transport/depot/SubserviceManager");
    import Voucher = require("sas/ltjs/transport/depot/Voucher");
    import Report = require("sas/ltjs/transport/models/local/Report");
    class TextTemplatesManager extends SubserviceManager {
        getSummaryMessage(report:Report, userStateEnabled:boolean):Voucher;
        getSummaryMessage(reportUri:string, reportStateUri:string):Voucher;
    }
    
    export = TextTemplatesManager;
}


declare module "sas/ltjs/transport/depot/ThumbnailManager" {
    import SubserviceManager = require("sas/ltjs/transport/depot/SubserviceManager");
    import Voucher = require("sas/ltjs/transport/depot/Voucher");
    import BaseReport = require("sas/ltjs/transport/models/local/BaseReport");
    import ReportImageSize = require("sas/ltjs/transport/models/media/particles/ReportImageSize");
    class ThumbnailManager extends SubserviceManager {
        static FAILED:number;
        static FINISHED:number;
        static STARTED:number;
        getPreviewThumbnail(report:BaseReport):Voucher;
        getSectionThumbnails(report:BaseReport):Array<string>;
        getSectionThumbnail(report:BaseReport, sectionName:string, fallbackWithServerThumbnailOnSectionNameNotFound:boolean):string;
        getReportImageLink(report:BaseReport, size:ReportImageSize):Voucher;
        getAllSectionImageLinks(report:BaseReport, size:ReportImageSize):Voucher;
        downloadReportImage(report:BaseReport, size:ReportImageSize):Voucher;
        downloadAllSectionImages(report:BaseReport, size:ReportImageSize):Voucher;
        getDownloadedSectionImagePath(report:BaseReport, sectionName:string, size:ReportImageSize):string;
        getDownloadedSectionImagePathByIndex(report:BaseReport, sectionIndex:number, size:ReportImageSize):string;
        getDownloadedReportImagePath(report:BaseReport, size:ReportImageSize):string;
        getGeneratedThumbnailDirectoryPath(report:BaseReport):string;
        getGeneratedThumbnailPath(report:BaseReport, section:number):string;
        hasPreviewForSection(report:BaseReport, section:number):boolean;
        notifyGenerationStarted(report:BaseReport):void;
        notifyThumbnailGenerated(report:BaseReport, section:number):void;
        notifyGenerationFinished(report:BaseReport):void;
        notifyGenerationFailed(report:BaseReport):void;
    }
    
    export = ThumbnailManager;
}


declare module "sas/ltjs/transport/depot/Voucher" {
    import EventDispatcher = require("sas/ltjs/commons/events/EventDispatcher");
    import TransportModel = require("sas/ltjs/transport/models/TransportModel");
    import TransportWarning = require("sas/ltjs/transport/depot/warnings/TransportWarning");
    class Voucher extends EventDispatcher {
        static WARNING:number;
        static FULFILLED:number;
        static CANCELLED:number;
        static ISSUED:number;
        getRequestedResource():TransportModel;
        getWarning():TransportWarning;
        getType():number;
        isCompleted():boolean;
        cancel():void;
    }
    
    export = Voucher;
}


declare module "sas/ltjs/transport/depot/VoucherEvent" {
    import PortableEvent = require("sas/ltjs/commons/events/PortableEvent");
    import TransportModel = require("sas/ltjs/transport/models/TransportModel");
    import TransportWarning = require("sas/ltjs/transport/depot/warnings/TransportWarning");
    import Voucher = require("sas/ltjs/transport/depot/Voucher");
    class VoucherEvent extends PortableEvent {
        getRequestedResource():TransportModel;
        getWarning():TransportWarning;
        getVoucher():Voucher;
    }
    
    export = VoucherEvent;
}


declare module "sas/ltjs/transport/models/TransportModel" {
    import BaseModel = require("sas/ltjs/commons/models/BaseModel");
    class TransportModel extends BaseModel {
        getDescription(maxRecursionDepth:number):string;
    }
    
    export = TransportModel;
}


declare module "sas/ltjs/transport/naturalLanguage/AbstractReportViewerNLUParcel" {
    import TransportModel = require("sas/ltjs/transport/models/TransportModel");
    class AbstractReportViewerNLUParcel extends TransportModel {
    }
    
    export = AbstractReportViewerNLUParcel;
}


declare module "sas/ltjs/transport/depot/warnings/TransportWarning" {
    import Warning = require("sas/ltjs/commons/models/warnings/Warning");
    class TransportWarning extends Warning {
        static LOCAL_OPERATION_FAILED:number;
        static STATUS_UNAVAILABLE:number;
        static COMPLETE_WITH_WARNINGS:number;
        static TIMEOUT:number;
        static CONFIGURATION_ERROR:number;
        static SYSTEM_QUIESCED:number;
        static UNABLE_TO_CANCEL_REQUEST_COMPLETE:number;
        static REQUEST_CANCELLED:number;
        static PASSWORD_LOOKUP_FAILED:number;
        static PASSWORD_STORAGE_FAILED:number;
        static SERVICE_FAILURE:number;
        static DUPLICATE_FOLDER:number;
        static DUPLICATE_COLLECTION:number;
        static DUPLICATE_REPORT:number;
        static DUPLICATE_CONNECTION_DESCRIPTION:number;
        static DUPLICATE_CONNECTION:number;
        static LOCAL_RESOURCE_EXPIRED:number;
        static INVALID_MEDIA:number;
        static RESOURCE_NOT_ACCESSIBLE:number;
        static RESOURCE_NOT_FOUND:number;
        static NOT_IN_WHITELIST:number;
        static BLACKLISTED:number;
        static UNAUTHORIZED:number;
        static INVALID_ARGUMENTS:number;
        static UNSUPPORTED_REQUEST:number;
        static CERTIFICATE_ERROR:number;
        static SERVER_VERSION_NOT_SUPPORTED:number;
        static SERVER_UNAVAILABLE:number;
        static NETWORK_UNAVAILABLE:number;
    }
    
    export = TransportWarning;
}


declare module "sas/ltjs/transport/models/response/ResponseStatus" {
    import TransportModel = require("sas/ltjs/transport/models/TransportModel");
    class ResponseStatus extends TransportModel {
        constructor();
        getMessage():string;
        setMessage(value:string):void;
        getReason():string;
        setReason(value:string):void;
        getReturnCode():number;
        setReturnCode(value:number):void;
    }
    
    export = ResponseStatus;
}


declare module "sas/ltjs/transport/models/local/Activity" {
    enum Activity
    {
        CHECK_FOR_UPDATES,
        GENERATE_REPORT,
        DOWNLOAD_REPORT,
        PRINT_REPORT
    }
    export = Activity
}


declare module "sas/ltjs/transport/models/local/ActivityStatus" {
    enum ActivityStatus
    {
        STARTED,
        COMPLETED,
        FAILED,
        CANCELLED
    }
    export = ActivityStatus
}


declare module "sas/ltjs/transport/models/local/BaseReport" {
    import TransportModel = require("sas/ltjs/transport/models/TransportModel");
    import ReportMetadata = require("sas/ltjs/transport/models/media/ReportMetadata");
    import Connection = require("sas/ltjs/transport/models/local/Connection");
    import UserNameContext = require("sas/ltjs/transport/models/local/UserNameContext");
    class BaseReport extends TransportModel {
        static UNSUBSCRIBED:number;
        static SUBSCRIBED:number;
        static PROMOTION:number;
        constructor();
        getUuid():string;
        getMeta():ReportMetadata;
        setMeta(value:ReportMetadata):void;
        getConnection():Connection;
        setConnection(value:Connection):void;
        getPromoted():string;
        setPromoted(value:string):void;
        getUserName(context:UserNameContext):string;
    }
    
    export = BaseReport;
}


declare module "sas/ltjs/transport/models/local/BaseReportCollectionOwner" {
    import TransportModel = require("sas/ltjs/transport/models/TransportModel");
    import BaseReport = require("sas/ltjs/transport/models/local/BaseReport");
    class BaseReportCollectionOwner extends TransportModel {
        constructor();
        getReports():Array<BaseReport>;
        setReports(value:Array<BaseReport>):void;
    }
    
    export = BaseReportCollectionOwner;
}


declare module "sas/ltjs/transport/models/local/BatchUpdateStatus" {
    import TransportModel = require("sas/ltjs/transport/models/TransportModel");
    class BatchUpdateStatus extends TransportModel {
        constructor();
        getInvalidCount():number;
        setInvalidCount(value:number):void;
        getPendingCount():number;
        setPendingCount(value:number):void;
        getSuccessfulCount():number;
        setSuccessfulCount(value:number):void;
        getUnsuccessfulCount():number;
        setUnsuccessfulCount(value:number):void;
        getInvalidModels():Array<TransportModel>;
        setInvalidModels(value:Array<TransportModel>):void;
        getUnsuccessfulModels():Array<TransportModel>;
        setUnsuccessfulModels(value:Array<TransportModel>):void;
    }
    
    export = BatchUpdateStatus;
}


declare module "sas/ltjs/transport/models/local/CASColumn" {
    import TransportModel = require("sas/ltjs/transport/models/TransportModel");
    import CASColumnItem = require("sas/ltjs/transport/models/media/cas/CASColumnItem");
    class CASColumn extends TransportModel {
        constructor();
        getDetails():CASColumnItem;
        setDetails(value:CASColumnItem):void;
    }
    
    export = CASColumn;
}


declare module "sas/ltjs/transport/models/local/CASInstance" {
    import TransportModel = require("sas/ltjs/transport/models/TransportModel");
    import CASServer = require("sas/ltjs/transport/models/local/CASServer");
    class CASInstance extends TransportModel {
        constructor();
        getServers():Array<CASServer>;
        setServers(value:Array<CASServer>):void;
    }
    
    export = CASInstance;
}


declare module "sas/ltjs/transport/models/local/CASLibrary" {
    import TransportModel = require("sas/ltjs/transport/models/TransportModel");
    import CASLibraryItem = require("sas/ltjs/transport/models/media/cas/CASLibraryItem");
    import CASTable = require("sas/ltjs/transport/models/local/CASTable");
    class CASLibrary extends TransportModel {
        constructor();
        getDetails():CASLibraryItem;
        setDetails(value:CASLibraryItem):void;
        getTables():Array<CASTable>;
        setTables(value:Array<CASTable>):void;
    }
    
    export = CASLibrary;
}


declare module "sas/ltjs/transport/models/local/CASServer" {
    import TransportModel = require("sas/ltjs/transport/models/TransportModel");
    import CASServerItem = require("sas/ltjs/transport/models/media/cas/CASServerItem");
    import CASLibrary = require("sas/ltjs/transport/models/local/CASLibrary");
    class CASServer extends TransportModel {
        constructor();
        getDetails():CASServerItem;
        setDetails(value:CASServerItem):void;
        getLibs():Array<CASLibrary>;
        setLibs(value:Array<CASLibrary>):void;
    }
    
    export = CASServer;
}


declare module "sas/ltjs/transport/models/local/CASTable" {
    import TransportModel = require("sas/ltjs/transport/models/TransportModel");
    import CASTableItem = require("sas/ltjs/transport/models/media/cas/CASTableItem");
    import CASColumn = require("sas/ltjs/transport/models/local/CASColumn");
    class CASTable extends TransportModel {
        constructor();
        getDetails():CASTableItem;
        setDetails(value:CASTableItem):void;
        getColumns():Array<CASColumn>;
        setColumns(value:Array<CASColumn>):void;
    }
    
    export = CASTable;
}


declare module "sas/ltjs/transport/models/local/Connection" {
    import TransportModel = require("sas/ltjs/transport/models/TransportModel");
    import Server = require("sas/ltjs/transport/models/local/Server");
    import UserInfo = require("sas/ltjs/transport/models/media/UserInfo");
    import LogonStatus = require("sas/ltjs/transport/models/media/particles/LogonStatus");
    import EsriLogonStatus = require("sas/ltjs/transport/models/media/particles/EsriLogonStatus");
    import EsriPortalLogonStatus = require("sas/ltjs/transport/models/media/particles/EsriPortalLogonStatus");
    import ReportImageSize = require("sas/ltjs/transport/models/media/particles/ReportImageSize");
    class Connection extends TransportModel {
        constructor();
        getUuid():string;
        setUuid(value:string):void;
        getServer():Server;
        setServer(value:Server):void;
        getUserId():string;
        setUserId(value:string):void;
        getPasswordKey():string;
        setPasswordKey(value:string):void;
        getPassword():string;
        setPassword(value:string):void;
        getAuthToken():string;
        setAuthToken(value:string):void;
        getUseGuestCredentials():boolean;
        setUseGuestCredentials(value:boolean):void;
        getShouldAutoConnect():boolean;
        setShouldAutoConnect(value:boolean):void;
        getDescription():string;
        setDescription(value:string):void;
        getUserInfo():UserInfo;
        setUserInfo(value:UserInfo):void;
        getSessionToken():string;
        setSessionToken(value:string):void;
        getLogonStatus():LogonStatus;
        setLogonStatus(value:LogonStatus):void;
        getEsriLogonStatus():EsriLogonStatus;
        setEsriLogonStatus(value:EsriLogonStatus):void;
        getEsriPortalLogonStatus():EsriPortalLogonStatus;
        setEsriPortalLogonStatus(value:EsriPortalLogonStatus):void;
        getLastSuccessfulLogon():number;
        setLastSuccessfulLogon(value:number):void;
        getLastSuccessfulServerCommunication():number;
        setLastSuccessfulServerCommunication(value:number):void;
        getUseEsriPremiumServices():boolean;
        setUseEsriPremiumServices(value:boolean):void;
        getCredentialStorageVersion():number;
        setCredentialStorageVersion(value:number):void;
        getOverrideReportImageSizes():boolean;
        setOverrideReportImageSizes(value:boolean):void;
        getReportImageDefaultSize():ReportImageSize;
        setReportImageDefaultSize(value:ReportImageSize):void;
        getReportSectionImageDefaultSize():ReportImageSize;
        setReportSectionImageDefaultSize(value:ReportImageSize):void;
    }
    
    export = Connection;
}


declare module "sas/ltjs/transport/models/local/DepotData" {
    import ReportCollectionOwner = require("sas/ltjs/transport/models/local/ReportCollectionOwner");
    import Report = require("sas/ltjs/transport/models/local/Report");
    import DepotConfiguration = require("sas/ltjs/transport/depot/DepotConfiguration");
    import Connection = require("sas/ltjs/transport/models/local/Connection");
    import SubscribedCollection = require("sas/ltjs/transport/models/local/SubscribedCollection");
    class DepotData extends ReportCollectionOwner {
        constructor();
        getLegacyReports():Array<Report>;
        setLegacyReports(value:Array<Report>):void;
        getLastUsedConfiguration():DepotConfiguration;
        setLastUsedConfiguration(value:DepotConfiguration):void;
        getConnections():Array<Connection>;
        setConnections(value:Array<Connection>):void;
        getCollections():Array<SubscribedCollection>;
        setCollections(value:Array<SubscribedCollection>):void;
        getLastUsedLocale():string;
        setLastUsedLocale(value:string):void;
    }
    
    export = DepotData;
}


declare module "sas/ltjs/transport/models/local/DepotStatus" {
    enum DepotStatus
    {
        QUIESCED,
        IDLE,
        BUSY
    }
    export = DepotStatus
}


declare module "sas/ltjs/transport/models/local/DisplayRecord" {
    import TransportModel = require("sas/ltjs/transport/models/TransportModel");
    import SubscribeMethod = require("sas/ltjs/transport/models/media/particles/SubscribeMethod");
    class DisplayRecord extends TransportModel {
        constructor();
        getIsDisplayed():boolean;
        setIsDisplayed(value:boolean):void;
        getDisplayedCount():number;
        setDisplayedCount(value:number):void;
        getIsGenerateInProgress():boolean;
        setIsGenerateInProgress(value:boolean):void;
        getDateCreated():number;
        setDateCreated(value:number):void;
        getDateUpdated():number;
        setDateUpdated(value:number):void;
        getDateLastViewed():number;
        setDateLastViewed(value:number):void;
        getSubscribeMethod():SubscribeMethod;
        setSubscribeMethod(value:SubscribeMethod):void;
    }
    
    export = DisplayRecord;
}


declare module "sas/ltjs/transport/models/local/DownloadStatus" {
    import TransportModel = require("sas/ltjs/transport/models/TransportModel");
    import ReportAsset = require("sas/ltjs/transport/models/local/ReportAsset");
    class DownloadStatus extends TransportModel {
        constructor();
        getAssets():Array<ReportAsset>;
        setAssets(value:Array<ReportAsset>):void;
        getNumberOfRequiredAssets():number;
        setNumberOfRequiredAssets(value:number):void;
        getNumberOfAvailableAssets():number;
        setNumberOfAvailableAssets(value:number):void;
        getNumberOfPendingDownloads():number;
        setNumberOfPendingDownloads(value:number):void;
        getNumberOfFailedDownloads():number;
        setNumberOfFailedDownloads(value:number):void;
        getNumberOfDownloadsInProgress():number;
        setNumberOfDownloadsInProgress(value:number):void;
        getIsPaused():boolean;
        setIsPaused(value:boolean):void;
        getNeedsPreviewsGenerated():boolean;
        setNeedsPreviewsGenerated(value:boolean):void;
        getNeedsThumbnailsDownloaded():boolean;
        setNeedsThumbnailsDownloaded(value:boolean):void;
    }
    
    export = DownloadStatus;
}


declare module "sas/ltjs/transport/models/local/FileData" {
    import TransportModel = require("sas/ltjs/transport/models/TransportModel");
    class FileData extends TransportModel {
        constructor();
        getPath():string;
        setPath(value:string):void;
        getEmbeddedBody():string;
        setEmbeddedBody(value:string):void;
    }
    
    export = FileData;
}


declare module "sas/ltjs/transport/models/local/Folder" {
    import ReportCollectionOwner = require("sas/ltjs/transport/models/local/ReportCollectionOwner");
    import FolderMetadata = require("sas/ltjs/transport/models/media/FolderMetadata");
    import TransportModelReference = require("sas/ltjs/transport/models/local/TransportModelReference");
    import Connection = require("sas/ltjs/transport/models/local/Connection");
    class Folder extends ReportCollectionOwner {
        constructor();
        getMeta():FolderMetadata;
        setMeta(value:FolderMetadata):void;
        getFolderReferences():Array<TransportModelReference>;
        setFolderReferences(value:Array<TransportModelReference>):void;
        getParent():Folder;
        setParent(value:Folder):void;
        getConnection():Connection;
        setConnection(value:Connection):void;
        getIsExpanded():boolean;
        setIsExpanded(value:boolean):void;
        getLastUpdated():number;
        setLastUpdated(value:number):void;
        getLastVisited():number;
        setLastVisited(value:number):void;
        getDepth():number;
        setDepth(value:number):void;
        getIsSubscribed():boolean;
        setIsSubscribed(value:boolean):void;
        toString2():string;
    }
    
    export = Folder;
}


declare module "sas/ltjs/transport/models/local/FolderCollection" {
    import TransportModel = require("sas/ltjs/transport/models/TransportModel");
    import Folder = require("sas/ltjs/transport/models/local/Folder");
    class FolderCollection extends TransportModel {
        constructor();
        getFolders():Array<Folder>;
        setFolders(value:Array<Folder>):void;
    }
    
    export = FolderCollection;
}


declare module "sas/ltjs/transport/models/local/LastAccessStatus" {
    enum LastAccessStatus
    {
        SUCCESS,
        AUTHENTICATION_FAILED,
        DEVICE_BLACKLISTED,
        DEVICE_NOT_IN_WHITELIST
    }
    export = LastAccessStatus
}


declare module "sas/ltjs/transport/models/local/Report" {
    import BaseReport = require("sas/ltjs/transport/models/local/BaseReport");
    import ReportManifest = require("sas/ltjs/transport/models/media/ReportManifest");
    import DownloadStatus = require("sas/ltjs/transport/models/local/DownloadStatus");
    import DisplayRecord = require("sas/ltjs/transport/models/local/DisplayRecord");
    import UpdateCharacteristic = require("sas/ltjs/transport/models/local/UpdateCharacteristic");
    import AlertableElement = require("sas/ltjs/transport/models/media/AlertableElement");
    import Duid = require("sas/ltjs/transport/models/media/particles/Duid");
    import ReportAuxiliary = require("sas/ltjs/transport/models/local/ReportAuxiliary");
    class Report extends BaseReport {
        static DOWNLOAD_COMPLETED:number;
        static DOWNLOAD_STARTED:number;
        static THUMBNAIL_GENERATED:number;
        constructor();
        getIsFavorite():boolean;
        setIsFavorite(value:boolean):void;
        getFavoritesCounter():number;
        setFavoritesCounter(value:number):void;
        getManifest():ReportManifest;
        setManifest(value:ReportManifest):void;
        getDownloadStatus():DownloadStatus;
        setDownloadStatus(value:DownloadStatus):void;
        getDisplayRecord():DisplayRecord;
        setDisplayRecord(value:DisplayRecord):void;
        getUpdateCharacteristic():UpdateCharacteristic;
        setUpdateCharacteristic(value:UpdateCharacteristic):void;
        getAlertableItems():Array<AlertableElement>;
        setAlertableItems(value:Array<AlertableElement>):void;
        getDuids():Array<Duid>;
        setDuids(value:Array<Duid>):void;
        getAuxiliary():ReportAuxiliary;
        setAuxiliary(value:ReportAuxiliary):void;
        getIsZombie():boolean;
        setIsZombie(value:boolean):void;
        getParentCollections():Array<string>;
        setParentCollections(value:Array<string>):void;
        getGlobalLastViewed():number;
        setGlobalLastViewed(value:number):void;
        getHasIgnoredChange():boolean;
        setHasIgnoredChange(value:boolean):void;
        getOriginReport():Report;
        setOriginReport(value:Report):void;
        saveManifest(destinationPath:string):boolean;
        restoreManifest(sourcePath:string):boolean;
    }
    
    export = Report;
}


declare module "sas/ltjs/transport/models/local/ReportAsset" {
    import TransportModel = require("sas/ltjs/transport/models/TransportModel");
    import ReportAssetURL = require("sas/ltjs/transport/models/media/particles/ReportAssetURL");
    import Report = require("sas/ltjs/transport/models/local/Report");
    class ReportAsset extends TransportModel {
        constructor();
        getUrl():ReportAssetURL;
        setUrl(value:ReportAssetURL):void;
        getLocalPath():string;
        setLocalPath(value:string):void;
        getNumberOfDownloadAttempts():number;
        setNumberOfDownloadAttempts(value:number):void;
        getIsDownloadInProgress():boolean;
        setIsDownloadInProgress(value:boolean):void;
        getDownloadSize():number;
        setDownloadSize(value:number):void;
        getDownloadedAmount():number;
        setDownloadedAmount(value:number):void;
        getLastContentKey():string;
        setLastContentKey(value:string):void;
        getLastAttemptTime():number;
        setLastAttemptTime(value:number):void;
        getReport():Report;
        setReport(value:Report):void;
    }
    
    export = ReportAsset;
}


declare module "sas/ltjs/transport/models/local/ReportAuxiliary" {
    import TransportModel = require("sas/ltjs/transport/models/TransportModel");
    class ReportAuxiliary extends TransportModel {
        constructor();
        getSectionCount():number;
        setSectionCount(value:number):void;
        getSectionNames():Array<string>;
        setSectionNames(value:Array<string>):void;
        getGeneratedPreviewCount():number;
        setGeneratedPreviewCount(value:number):void;
        getFinishedGeneratingPreviews():boolean;
        setFinishedGeneratingPreviews(value:boolean):void;
        getSerializeToFile():boolean;
        setSerializeToFile(value:boolean):void;
        getTextTemplateSummary():string;
        setTextTemplateSummary(value:string):void;
    }
    
    export = ReportAuxiliary;
}


declare module "sas/ltjs/transport/models/local/ReportCollectionOwner" {
    import TransportModel = require("sas/ltjs/transport/models/TransportModel");
    import TransportModelReference = require("sas/ltjs/transport/models/local/TransportModelReference");
    import Report = require("sas/ltjs/transport/models/local/Report");
    import BaseReport = require("sas/ltjs/transport/models/local/BaseReport");
    class ReportCollectionOwner extends TransportModel {
        constructor();
        getReportReferences():Array<TransportModelReference>;
        setReportReferences(value:Array<TransportModelReference>):void;
        getReferenceToReport(report:Report):TransportModelReference;
        getReferenceToBaseReport(report:BaseReport):TransportModelReference;
    }
    
    export = ReportCollectionOwner;
}


declare module "sas/ltjs/transport/models/local/ReportImages" {
    import TransportModel = require("sas/ltjs/transport/models/TransportModel");
    import ReportImageInfo = require("sas/ltjs/transport/models/media/ReportImageInfo");
    class ReportImages extends TransportModel {
        constructor();
        getImages():Array<ReportImageInfo>;
        setImages(value:Array<ReportImageInfo>):void;
    }
    
    export = ReportImages;
}


declare module "sas/ltjs/transport/models/local/ReportStateContainer" {
    import TransportModel = require("sas/ltjs/transport/models/TransportModel");
    import ReportStateInfo = require("sas/ltjs/transport/models/media/ReportStateInfo");
    class ReportStateContainer extends TransportModel {
        constructor();
        getState():string;
        setState(value:string):void;
        getStateInfo():ReportStateInfo;
        setStateInfo(value:ReportStateInfo):void;
        getStateUri():string;
        setStateUri(value:string):void;
    }
    
    export = ReportStateContainer;
}


declare module "sas/ltjs/transport/models/local/Server" {
    import TransportModel = require("sas/ltjs/transport/models/TransportModel");
    import ServerConfig = require("sas/ltjs/transport/models/media/ServerConfig");
    import URL = require("sas/ltjs/commons/resources/network/URL");
    class Server extends TransportModel {
        constructor();
        getVersionId():number;
        setVersionId(value:number):void;
        getVersionString():string;
        setVersionString(value:string):void;
        getMeta():ServerConfig;
        setMeta(value:ServerConfig):void;
        getUseSSL():boolean;
        setUseSSL(value:boolean):void;
        getScheme():string;
        setScheme(value:string):void;
        getHostName():string;
        setHostName(value:string):void;
        getPort():number;
        setPort(value:number):void;
        getBaseURL():URL;
    }
    
    export = Server;
}


declare module "sas/ltjs/transport/models/local/ServiceErrorCode" {
    enum ServiceErrorCode
    {
        DEVICE_BLACKLISTED,
        DEVICE_NOT_IN_WHITELIST,
        DEVICE_BLACKLISTED_V81,
        DEVICE_NOT_IN_WHITELIST_V81,
        EXECUTOR_NOT_FOUND,
        EXECUTOR_SESSION_IS_CLOSED
    }
    export = ServiceErrorCode
}


declare module "sas/ltjs/transport/models/local/SubscribedCollection" {
    import TransportModel = require("sas/ltjs/transport/models/TransportModel");
    import Connection = require("sas/ltjs/transport/models/local/Connection");
    class SubscribedCollection extends TransportModel {
        static COLLECTION_DELETED:number;
        static COLLECTION_UPDATED:number;
        constructor();
        getUuid():string;
        setUuid(value:string):void;
        getLocation():string;
        setLocation(value:string):void;
        getConnection():Connection;
        setConnection(value:Connection):void;
        getIsZombie():boolean;
        setIsZombie(value:boolean):void;
    }
    
    export = SubscribedCollection;
}


declare module "sas/ltjs/transport/models/local/TransportModelReference" {
    import TransportModel = require("sas/ltjs/transport/models/TransportModel");
    import Link = require("sas/ltjs/commons/models/particles/Link");
    import PortableEvent = require("sas/ltjs/commons/events/PortableEvent");
    class TransportModelReference extends TransportModel {
        constructor();
        getModel():TransportModel;
        setModel(value:TransportModel):void;
        getLinks():Array<Link>;
        setLinks(value:Array<Link>):void;
        getName():string;
        setName(value:string):void;
        getId():string;
        setId(value:string):void;
        getAdded():string;
        setAdded(value:string):void;
        getAddedDatetime():number;
        setAddedDatetime(value:number):void;
        getIsReference():boolean;
        setIsReference(value:boolean):void;
        addedUpdated(pEvent:PortableEvent):void;
    }
    
    export = TransportModelReference;
}


declare module "sas/ltjs/transport/models/local/UpdateCharacteristic" {
    enum UpdateCharacteristic
    {
        AUTO_UPDATE,
        TIME_SENSITIVE,
        VOLATILE_DATA,
        UNABLE_TO_DETECT_CHANGES
    }
    export = UpdateCharacteristic
}


declare module "sas/ltjs/transport/models/local/UserNameContext" {
    import TransportModel = require("sas/ltjs/transport/models/TransportModel");
    import UserNamePurpose = require("sas/ltjs/transport/models/local/UserNamePurpose");
    import UserNameFallback = require("sas/ltjs/transport/models/local/UserNameFallback");
    class UserNameContext extends TransportModel {
        constructor();
        getPurpose():UserNamePurpose;
        setPurpose(value:UserNamePurpose):void;
        getGuestFallback():UserNameFallback;
        setGuestFallback(value:UserNameFallback):void;
        getAuthenticatedFallback():UserNameFallback;
        setAuthenticatedFallback(value:UserNameFallback):void;
    }
    
    export = UserNameContext;
}


declare module "sas/ltjs/transport/models/local/UserNameFallback" {
    enum UserNameFallback
    {
        BLANK,
        UNAVAILABLE,
        SAS
    }
    export = UserNameFallback
}


declare module "sas/ltjs/transport/models/local/UserNamePurpose" {
    enum UserNamePurpose
    {
        CREATED_BY,
        MODIFIED_BY
    }
    export = UserNamePurpose
}


declare module "sas/ltjs/transport/util/reportcentral/OperationStatus" {
    enum OperationStatus
    {
        ADD,
        REMOVE,
        NONE,
        UNKNOWN
    }
    export = OperationStatus
}


declare module "sas/ltjs/transport/models/media/AlertSubscription" {
    import MediaType = require("sas/ltjs/transport/models/media/MediaType");
    import Link = require("sas/ltjs/commons/models/particles/Link");
    import AlertSubscriber = require("sas/ltjs/transport/models/media/particles/AlertSubscriber");
    import AlertReportReference = require("sas/ltjs/transport/models/media/particles/AlertReportReference");
    import AlertSubscriptionInterval = require("sas/ltjs/transport/models/media/particles/AlertSubscriptionInterval");
    class AlertSubscription extends MediaType {
        constructor();
        getId():string;
        setId(value:string):void;
        getLinks():Array<Link>;
        setLinks(value:Array<Link>):void;
        getCreatedBy():string;
        setCreatedBy(value:string):void;
        getCreationTimeStamp():string;
        setCreationTimeStamp(value:string):void;
        getModifiedBy():string;
        setModifiedBy(value:string):void;
        getModifiedTimeStamp():string;
        setModifiedTimeStamp(value:string):void;
        getLastQueriedTimeStamp():string;
        setLastQueriedTimeStamp(value:string):void;
        getSubscribers():Array<AlertSubscriber>;
        setSubscribers(value:Array<AlertSubscriber>):void;
        getReport():AlertReportReference;
        setReport(value:AlertReportReference):void;
        getAlertableConditionName():string;
        setAlertableConditionName(value:string):void;
        getEvaluation():AlertSubscriptionInterval;
        setEvaluation(value:AlertSubscriptionInterval):void;
        getNotification():AlertSubscriptionInterval;
        setNotification(value:AlertSubscriptionInterval):void;
    }
    
    export = AlertSubscription;
}


declare module "sas/ltjs/transport/models/media/AlertableElement" {
    import MediaType = require("sas/ltjs/transport/models/media/MediaType");
    import AlertStrategy = require("sas/ltjs/transport/models/media/particles/AlertStrategy");
    import AlertInterval = require("sas/ltjs/transport/models/media/particles/AlertInterval");
    import Link = require("sas/ltjs/commons/models/particles/Link");
    class AlertableElement extends MediaType {
        constructor();
        getAlertName():string;
        setAlertName(value:string):void;
        getLabel():string;
        setLabel(value:string):void;
        getClause():string;
        setClause(value:string):void;
        getEvaluationStrategy():AlertStrategy;
        setEvaluationStrategy(value:AlertStrategy):void;
        getEvaluationInterval():number;
        setEvaluationInterval(value:number):void;
        getIntervalUnit():AlertInterval;
        setIntervalUnit(value:AlertInterval):void;
        getVisualElement():string;
        setVisualElement(value:string):void;
        getSubscribed():boolean;
        setSubscribed(value:boolean):void;
        getId():string;
        setId(value:string):void;
        getLinks():Array<Link>;
        setLinks(value:Array<Link>):void;
    }
    
    export = AlertableElement;
}


declare module "sas/ltjs/transport/models/media/Ancestors" {
    import MediaType = require("sas/ltjs/transport/models/media/MediaType");
    import FolderItem = require("sas/ltjs/transport/models/media/FolderItem");
    class Ancestors extends MediaType {
        constructor();
        getChildUri():string;
        setChildUri(value:string):void;
        getAncestors():Array<FolderItem>;
        setAncestors(value:Array<FolderItem>):void;
    }
    
    export = Ancestors;
}


declare module "sas/ltjs/transport/models/media/AuthorizationContext" {
    import MediaType = require("sas/ltjs/transport/models/media/MediaType");
    class AuthorizationContext extends MediaType {
        constructor();
        getAccessComments():string;
        setAccessComments(value:string):void;
        getAccessEsriPremiumServices():string;
        setAccessEsriPremiumServices(value:string):void;
        getAccessMobileBI():string;
        setAccessMobileBI(value:string):void;
        getAccessVisualAnalyticsViewer():string;
        setAccessVisualAnalyticsViewer(value:string):void;
        getAccessVisualAnalytics():string;
        setAccessVisualAnalytics(value:string):void;
        getCacheMobileReportData():string;
        setCacheMobileReportData(value:string):void;
        getExemptFromOfflineTimeLimit():string;
        setExemptFromOfflineTimeLimit(value:string):void;
        getExemptFromPasscodeRequirements():string;
        setExemptFromPasscodeRequirements(value:string):void;
        getExportPDF():string;
        setExportPDF(value:string):void;
        getGetPreferences():string;
        setGetPreferences(value:string):void;
        getPutPreferences():string;
        setPutPreferences(value:string):void;
        getDeletePreferences():string;
        setDeletePreferences(value:string):void;
        getGetRecents():string;
        setGetRecents(value:string):void;
        getPostRecents():string;
        setPostRecents(value:string):void;
        getDeleteRecents():string;
        setDeleteRecents(value:string):void;
        getGetFavorites():string;
        setGetFavorites(value:string):void;
        getPostFavorites():string;
        setPostFavorites(value:string):void;
        getDeleteFavorites():string;
        setDeleteFavorites(value:string):void;
        getPostComments():string;
        setPostComments(value:string):void;
        getPostReportImages():string;
        setPostReportImages(value:string):void;
        getPostReportRenderer():string;
        setPostReportRenderer(value:string):void;
        getGetReportAlerts():string;
        setGetReportAlerts(value:string):void;
        getPostReportAlerts():string;
        setPostReportAlerts(value:string):void;
        getDeleteReportAlerts():string;
        setDeleteReportAlerts(value:string):void;
        getExportData():string;
        setExportData(value:string):void;
        getExportDetailData():string;
        setExportDetailData(value:string):void;
        getExportImages():string;
        setExportImages(value:string):void;
        getShareReport():string;
        setShareReport(value:string):void;
        getAllowWebContent():string;
        setAllowWebContent(value:string):void;
        getPostInterpretations():string;
        setPostInterpretations(value:string):void;
        getGetTextTemplatesOutput():string;
        setGetTextTemplatesOutput(value:string):void;
        getGetShares():string;
        setGetShares(value:string):void;
        getPostShares():string;
        setPostShares(value:string):void;
    }
    
    export = AuthorizationContext;
}


declare module "sas/ltjs/transport/models/media/AuthorizedLinks" {
    import MediaType = require("sas/ltjs/transport/models/media/MediaType");
    class AuthorizedLinks extends MediaType {
        constructor();
        getAccessComments():boolean;
        setAccessComments(value:boolean):void;
        getAccessEsriPremiumServices():boolean;
        setAccessEsriPremiumServices(value:boolean):void;
        getAccessMobileBI():boolean;
        setAccessMobileBI(value:boolean):void;
        getAccessVisualAnalyticsViewer():boolean;
        setAccessVisualAnalyticsViewer(value:boolean):void;
        getAccessVisualAnalytics():boolean;
        setAccessVisualAnalytics(value:boolean):void;
        getCacheMobileReportData():boolean;
        setCacheMobileReportData(value:boolean):void;
        getExemptFromOfflineTimeLimit():boolean;
        setExemptFromOfflineTimeLimit(value:boolean):void;
        getExemptFromPasscodeRequirements():boolean;
        setExemptFromPasscodeRequirements(value:boolean):void;
        getExportPDF():boolean;
        setExportPDF(value:boolean):void;
        getGetPreferences():boolean;
        setGetPreferences(value:boolean):void;
        getPutPreferences():boolean;
        setPutPreferences(value:boolean):void;
        getDeletePreferences():boolean;
        setDeletePreferences(value:boolean):void;
        getGetRecents():boolean;
        setGetRecents(value:boolean):void;
        getPostRecents():boolean;
        setPostRecents(value:boolean):void;
        getDeleteRecents():boolean;
        setDeleteRecents(value:boolean):void;
        getGetFavorites():boolean;
        setGetFavorites(value:boolean):void;
        getPostFavorites():boolean;
        setPostFavorites(value:boolean):void;
        getDeleteFavorites():boolean;
        setDeleteFavorites(value:boolean):void;
        getPostComments():boolean;
        setPostComments(value:boolean):void;
        getPostReportImages():boolean;
        setPostReportImages(value:boolean):void;
        getPostReportRenderer():boolean;
        setPostReportRenderer(value:boolean):void;
        getGetReportAlerts():boolean;
        setGetReportAlerts(value:boolean):void;
        getPostReportAlerts():boolean;
        setPostReportAlerts(value:boolean):void;
        getDeleteReportAlerts():boolean;
        setDeleteReportAlerts(value:boolean):void;
        getExportData():boolean;
        setExportData(value:boolean):void;
        getExportDetailData():boolean;
        setExportDetailData(value:boolean):void;
        getExportImages():boolean;
        setExportImages(value:boolean):void;
        getShareReport():boolean;
        setShareReport(value:boolean):void;
        getAllowWebContent():boolean;
        setAllowWebContent(value:boolean):void;
        getPostInterpretations():boolean;
        setPostInterpretations(value:boolean):void;
        getGetTextTemplatesOutput():boolean;
        setGetTextTemplatesOutput(value:boolean):void;
        getGetShares():boolean;
        setGetShares(value:boolean):void;
        getPostShares():boolean;
        setPostShares(value:boolean):void;
    }
    
    export = AuthorizedLinks;
}


declare module "sas/ltjs/transport/models/media/Avatar" {
    import MediaType = require("sas/ltjs/transport/models/media/MediaType");
    import Link = require("sas/ltjs/commons/models/particles/Link");
    class Avatar extends MediaType {
        constructor();
        getLinks():Array<Link>;
        setLinks(value:Array<Link>):void;
        getName():string;
        setName(value:string):void;
        getType():string;
        setType(value:string):void;
        getIsDefaultImage():boolean;
        setIsDefaultImage(value:boolean):void;
        getCreationTimeStamp():string;
        setCreationTimeStamp(value:string):void;
        getModifiedTimeStamp():string;
        setModifiedTimeStamp(value:string):void;
    }
    
    export = Avatar;
}


declare module "sas/ltjs/transport/models/media/Comment" {
    import MediaType = require("sas/ltjs/transport/models/media/MediaType");
    import CommentAttachment = require("sas/ltjs/transport/models/media/particles/CommentAttachment");
    import CommentAttachmentInfo = require("sas/ltjs/transport/models/media/particles/CommentAttachmentInfo");
    import Link = require("sas/ltjs/commons/models/particles/Link");
    import PortableEvent = require("sas/ltjs/commons/events/PortableEvent");
    class Comment extends MediaType {
        constructor();
        getXmlElementName():string;
        setXmlElementName(value:string):void;
        getAuthor():string;
        setAuthor(value:string):void;
        getCreatedOn():string;
        setCreatedOn(value:string):void;
        getCreatedOnDatetime():number;
        setCreatedOnDatetime(value:number):void;
        getElementId():string;
        setElementId(value:string):void;
        getCommentId():number;
        setCommentId(value:number):void;
        getObjectId():string;
        setObjectId(value:string):void;
        getObjectType():number;
        setObjectType(value:number):void;
        getParentId():number;
        setParentId(value:number):void;
        getPriority():number;
        setPriority(value:number):void;
        getSubject():string;
        setSubject(value:string):void;
        getText():string;
        setText(value:string):void;
        getAttachments():Array<CommentAttachment>;
        setAttachments(value:Array<CommentAttachment>):void;
        getInfos():Array<CommentAttachmentInfo>;
        setInfos(value:Array<CommentAttachmentInfo>):void;
        getModifiedBy():string;
        setModifiedBy(value:string):void;
        getCreatedBy():string;
        setCreatedBy(value:string):void;
        getLinks():Array<Link>;
        setLinks(value:Array<Link>):void;
        getCreationTimeStamp():string;
        setCreationTimeStamp(value:string):void;
        getModifiedTimeStamp():string;
        setModifiedTimeStamp(value:string):void;
        getModifiedOnDatetime():number;
        setModifiedOnDatetime(value:number):void;
        getCommentUUID():string;
        setCommentUUID(value:string):void;
        getParentUUID():string;
        setParentUUID(value:string):void;
        getResourceUri():string;
        setResourceUri(value:string):void;
        getAuthorAvatarPath():string;
        setAuthorAvatarPath(value:string):void;
        getAuthorAvatarIsDefault():boolean;
        setAuthorAvatarIsDefault(value:boolean):void;
        createdOnUpdated(pEvent:PortableEvent):void;
        modifiedTimeStampUpdated(pEvent:PortableEvent):void;
        creationTimeStampUpdated(pEvent:PortableEvent):void;
    }
    
    export = Comment;
}


declare module "sas/ltjs/transport/models/media/CommentThread" {
    import MediaType = require("sas/ltjs/transport/models/media/MediaType");
    import Comment = require("sas/ltjs/transport/models/media/Comment");
    class CommentThread extends MediaType {
        constructor();
        getComments():Array<Comment>;
        setComments(value:Array<Comment>):void;
        getDuid():string;
        setDuid(value:string):void;
        getSubject():string;
        setSubject(value:string):void;
        getThreadId():number;
        setThreadId(value:number):void;
    }
    
    export = CommentThread;
}


declare module "sas/ltjs/transport/models/media/CommentTree" {
    import MediaType = require("sas/ltjs/transport/models/media/MediaType");
    import CommentThread = require("sas/ltjs/transport/models/media/CommentThread");
    class CommentTree extends MediaType {
        constructor();
        getXmlElementName():string;
        setXmlElementName(value:string):void;
        getGuid():string;
        setGuid(value:string):void;
        getThreads():Array<CommentThread>;
        setThreads(value:Array<CommentThread>):void;
        getUserAdmin():boolean;
        setUserAdmin(value:boolean):void;
    }
    
    export = CommentTree;
}


declare module "sas/ltjs/transport/models/media/Credentials" {
    import MediaType = require("sas/ltjs/transport/models/media/MediaType");
    import CredentialProperties = require("sas/ltjs/transport/models/media/particles/CredentialProperties");
    import CredentialSecrets = require("sas/ltjs/transport/models/media/particles/CredentialSecrets");
    class Credentials extends MediaType {
        constructor();
        getDomainId():string;
        setDomainId(value:string):void;
        getDomainType():string;
        setDomainType(value:string):void;
        getIdentityType():string;
        setIdentityType(value:string):void;
        getIdentityId():string;
        setIdentityId(value:string):void;
        getCredentialType():string;
        setCredentialType(value:string):void;
        getProperties():CredentialProperties;
        setProperties(value:CredentialProperties):void;
        getSecrets():CredentialSecrets;
        setSecrets(value:CredentialSecrets):void;
    }
    
    export = Credentials;
}


declare module "sas/ltjs/transport/models/media/DeviceManagementProperties" {
    import MediaType = require("sas/ltjs/transport/models/media/MediaType");
    class DeviceManagementProperties extends MediaType {
        constructor();
        getPasscodeAttempts():number;
        setPasscodeAttempts(value:number):void;
        getPasscodeTimeoutMinutes():number;
        setPasscodeTimeoutMinutes(value:number):void;
        getOfflineLimitDays():number;
        setOfflineLimitDays(value:number):void;
    }
    
    export = DeviceManagementProperties;
}


declare module "sas/ltjs/transport/models/media/DeviceRep" {
    import MediaType = require("sas/ltjs/transport/models/media/MediaType");
    class DeviceRep extends MediaType {
        constructor();
        getId():string;
        setId(value:string):void;
    }
    
    export = DeviceRep;
}


declare module "sas/ltjs/transport/models/media/FileItem" {
    import MediaType = require("sas/ltjs/transport/models/media/MediaType");
    import Link = require("sas/ltjs/commons/models/particles/Link");
    import PortableEvent = require("sas/ltjs/commons/events/PortableEvent");
    class FileItem extends MediaType {
        constructor();
        getContentDisposition():string;
        setContentDisposition(value:string):void;
        getContentType():string;
        setContentType(value:string):void;
        getCreatedBy():string;
        setCreatedBy(value:string):void;
        getCreationTimeStamp():string;
        setCreationTimeStamp(value:string):void;
        getCreationDatetime():number;
        setCreationDatetime(value:number):void;
        getDocumentType():string;
        setDocumentType(value:string):void;
        getEncoding():string;
        setEncoding(value:string):void;
        getId():string;
        setId(value:string):void;
        getLinks():Array<Link>;
        setLinks(value:Array<Link>):void;
        getModifiedBy():string;
        setModifiedBy(value:string):void;
        getModifiedTimeStamp():string;
        setModifiedTimeStamp(value:string):void;
        getModifiedDatetime():number;
        setModifiedDatetime(value:number):void;
        getName():string;
        setName(value:string):void;
        getParentUri():string;
        setParentUri(value:string):void;
        getSize():number;
        setSize(value:number):void;
        modifiedUpdated(pEvent:PortableEvent):void;
        createdUpdated(pEvent:PortableEvent):void;
    }
    
    export = FileItem;
}


declare module "sas/ltjs/transport/models/media/FlatMembership" {
    import MediaType = require("sas/ltjs/transport/models/media/MediaType");
    import Link = require("sas/ltjs/commons/models/particles/Link");
    class FlatMembership extends MediaType {
        constructor();
        getId():string;
        setId(value:string):void;
        getName():string;
        setName(value:string):void;
        getIsImplicit():boolean;
        setIsImplicit(value:boolean):void;
        getTopLevel():boolean;
        setTopLevel(value:boolean):void;
        getLinks():Array<Link>;
        setLinks(value:Array<Link>):void;
    }
    
    export = FlatMembership;
}


declare module "sas/ltjs/transport/models/media/FolderItem" {
    import MediaType = require("sas/ltjs/transport/models/media/MediaType");
    import Link = require("sas/ltjs/commons/models/particles/Link");
    class FolderItem extends MediaType {
        constructor();
        getId():string;
        setId(value:string):void;
        getName():string;
        setName(value:string):void;
        getDescription():string;
        setDescription(value:string):void;
        getCreationTimeStamp():string;
        setCreationTimeStamp(value:string):void;
        getModifiedTimeStamp():string;
        setModifiedTimeStamp(value:string):void;
        getAdded():string;
        setAdded(value:string):void;
        getModifiedBy():string;
        setModifiedBy(value:string):void;
        getCreatedBy():string;
        setCreatedBy(value:string):void;
        getType():string;
        setType(value:string):void;
        getContentType():string;
        setContentType(value:string):void;
        getIconUri():string;
        setIconUri(value:string):void;
        getMemberCount():number;
        setMemberCount(value:number):void;
        getLinks():Array<Link>;
        setLinks(value:Array<Link>):void;
        getUri():string;
        setUri(value:string):void;
    }
    
    export = FolderItem;
}


declare module "sas/ltjs/transport/models/media/FolderMetadata" {
    import MediaType = require("sas/ltjs/transport/models/media/MediaType");
    import FolderType = require("sas/ltjs/transport/models/media/particles/FolderType");
    import PortableEvent = require("sas/ltjs/commons/events/PortableEvent");
    class FolderMetadata extends MediaType {
        constructor();
        getDescription():string;
        setDescription(value:string):void;
        getDisplayName():string;
        setDisplayName(value:string):void;
        getShortName():string;
        setShortName(value:string):void;
        getResourceId():string;
        setResourceId(value:string):void;
        getType():FolderType;
        setType(value:FolderType):void;
        getLastModified():string;
        setLastModified(value:string):void;
        getLastModifiedDatetime():number;
        setLastModifiedDatetime(value:number):void;
        getCreated():string;
        setCreated(value:string):void;
        getCreatedDatetime():number;
        setCreatedDatetime(value:number):void;
        lastModifiedUpdated(pEvent:PortableEvent):void;
        createdUpdated(pEvent:PortableEvent):void;
    }
    
    export = FolderMetadata;
}


declare module "sas/ltjs/transport/models/media/MapsSettings" {
    import TransportModel = require("sas/ltjs/transport/models/TransportModel");
    import MapsSettingsAttributes = require("sas/ltjs/transport/models/media/particles/MapsSettingsAttributes");
    import Link = require("sas/ltjs/commons/models/particles/Link");
    class MapsSettings extends TransportModel {
        constructor();
        getAttributes():MapsSettingsAttributes;
        setAttributes(value:MapsSettingsAttributes):void;
        getLinks():Array<Link>;
        setLinks(value:Array<Link>):void;
    }
    
    export = MapsSettings;
}


declare module "sas/ltjs/transport/models/media/MediaType" {
    import TransportModel = require("sas/ltjs/transport/models/TransportModel");
    class MediaType extends TransportModel {
        constructor();
        getVersion():number;
        setVersion(value:number):void;
    }
    
    export = MediaType;
}


declare module "sas/ltjs/transport/models/media/PrintSetup" {
    import MediaType = require("sas/ltjs/transport/models/media/MediaType");
    import PrintOrientation = require("sas/ltjs/transport/models/media/particles/PrintOrientation");
    import PaperType = require("sas/ltjs/transport/models/media/particles/PaperType");
    import PrintFitOption = require("sas/ltjs/transport/models/media/particles/PrintFitOption");
    import PrintTableOfContentsDisplayOption = require("sas/ltjs/transport/models/media/particles/PrintTableOfContentsDisplayOption");
    import PrintDestination = require("sas/ltjs/transport/models/media/particles/PrintDestination");
    class PrintSetup extends MediaType {
        constructor();
        getLocale():string;
        setLocale(value:string):void;
        getFormatterLocale():string;
        setFormatterLocale(value:string):void;
        getUtcOffsetInSeconds():number;
        setUtcOffsetInSeconds(value:number):void;
        getOrientation():PrintOrientation;
        setOrientation(value:PrintOrientation):void;
        getPaperType():PaperType;
        setPaperType(value:PaperType):void;
        getPaperHeight():string;
        setPaperHeight(value:string):void;
        getPaperWidth():string;
        setPaperWidth(value:string):void;
        getMarginTop():string;
        setMarginTop(value:string):void;
        getMarginBottom():string;
        setMarginBottom(value:string):void;
        getMarginLeft():string;
        setMarginLeft(value:string):void;
        getMarginRight():string;
        setMarginRight(value:string):void;
        getFitOption():PrintFitOption;
        setFitOption(value:PrintFitOption):void;
        getTableOfContentsDisplay():PrintTableOfContentsDisplayOption;
        setTableOfContentsDisplay(value:PrintTableOfContentsDisplayOption):void;
        getShowPageNumbers():boolean;
        setShowPageNumbers(value:boolean):void;
        getShowEmptyRowsAndColumns():boolean;
        setShowEmptyRowsAndColumns(value:boolean):void;
        getShowAppendix():boolean;
        setShowAppendix(value:boolean):void;
        getAppendixDisplay():string;
        setAppendixDisplay(value:string):void;
        getShowCoverPage():boolean;
        setShowCoverPage(value:boolean):void;
        getCoverPageText():string;
        setCoverPageText(value:string):void;
        getCoverPageDateTime():string;
        setCoverPageDateTime(value:string):void;
        getReportElements():string;
        setReportElements(value:string):void;
        getUseHighContrastReportStyle():boolean;
        setUseHighContrastReportStyle(value:boolean):void;
        getDpi():number;
        setDpi(value:number):void;
        getShowPrintedTableOfContents():boolean;
        setShowPrintedTableOfContents(value:boolean):void;
        getDestination():PrintDestination;
        setDestination(value:PrintDestination):void;
    }
    
    export = PrintSetup;
}


declare module "sas/ltjs/transport/models/media/ReportDataJob" {
    import MediaType = require("sas/ltjs/transport/models/media/MediaType");
    import MicroserviceJobState = require("sas/ltjs/transport/models/media/particles/MicroserviceJobState");
    import ServiceError = require("sas/ltjs/transport/models/media/particles/ServiceError");
    import ReportDataJobResults = require("sas/ltjs/transport/models/media/particles/ReportDataJobResults");
    import Link = require("sas/ltjs/commons/models/particles/Link");
    class ReportDataJob extends MediaType {
        constructor();
        getId():string;
        setId(value:string):void;
        getState():MicroserviceJobState;
        setState(value:MicroserviceJobState):void;
        getDuration():number;
        setDuration(value:number):void;
        getCreatedBy():string;
        setCreatedBy(value:string):void;
        getCreationTimeStamp():string;
        setCreationTimeStamp(value:string):void;
        getStartedTimeStamp():string;
        setStartedTimeStamp(value:string):void;
        getCompletedTimeStamp():string;
        setCompletedTimeStamp(value:string):void;
        getError():ServiceError;
        setError(value:ServiceError):void;
        getResults():ReportDataJobResults;
        setResults(value:ReportDataJobResults):void;
        getLinks():Array<Link>;
        setLinks(value:Array<Link>):void;
    }
    
    export = ReportDataJob;
}


declare module "sas/ltjs/transport/models/media/ReportDataProperties" {
    import MediaType = require("sas/ltjs/transport/models/media/MediaType");
    class ReportDataProperties extends MediaType {
        constructor();
        getComparisonEpsilon():number;
        setComparisonEpsilon(value:number):void;
        getEnableInteractiveData():boolean;
        setEnableInteractiveData(value:boolean):void;
    }
    
    export = ReportDataProperties;
}


declare module "sas/ltjs/transport/models/media/ReportImageDetail" {
    import MediaType = require("sas/ltjs/transport/models/media/MediaType");
    import ReportImageSize = require("sas/ltjs/transport/models/media/particles/ReportImageSize");
    import MicroserviceJobState = require("sas/ltjs/transport/models/media/particles/MicroserviceJobState");
    import ServiceError = require("sas/ltjs/transport/models/media/particles/ServiceError");
    import Link = require("sas/ltjs/commons/models/particles/Link");
    class ReportImageDetail extends MediaType {
        constructor();
        getReportImage():boolean;
        setReportImage(value:boolean):void;
        getSectionIndex():number;
        setSectionIndex(value:number):void;
        getSectionName():string;
        setSectionName(value:string):void;
        getSectionLabel():string;
        setSectionLabel(value:string):void;
        getElementName():string;
        setElementName(value:string):void;
        getVisualType():string;
        setVisualType(value:string):void;
        getSize():ReportImageSize;
        setSize(value:ReportImageSize):void;
        getState():MicroserviceJobState;
        setState(value:MicroserviceJobState):void;
        getError():ServiceError;
        setError(value:ServiceError):void;
        getLinks():Array<Link>;
        setLinks(value:Array<Link>):void;
    }
    
    export = ReportImageDetail;
}


declare module "sas/ltjs/transport/models/media/ReportImageInfo" {
    import MediaType = require("sas/ltjs/transport/models/media/MediaType");
    import ReportImageSize = require("sas/ltjs/transport/models/media/particles/ReportImageSize");
    class ReportImageInfo extends MediaType {
        constructor();
        getReportUrl():string;
        setReportUrl(value:string):void;
        getReportImage():boolean;
        setReportImage(value:boolean):void;
        getSectionIndex():number;
        setSectionIndex(value:number):void;
        getSectionName():string;
        setSectionName(value:string):void;
        getSectionLabel():string;
        setSectionLabel(value:string):void;
        getElementName():string;
        setElementName(value:string):void;
        getVisualType():string;
        setVisualType(value:string):void;
        getSize():ReportImageSize;
        setSize(value:ReportImageSize):void;
        getUrl():string;
        setUrl(value:string):void;
        getDownloadPath():string;
        setDownloadPath(value:string):void;
    }
    
    export = ReportImageInfo;
}


declare module "sas/ltjs/transport/models/media/ReportImageJob" {
    import MediaType = require("sas/ltjs/transport/models/media/MediaType");
    import MicroserviceJobState = require("sas/ltjs/transport/models/media/particles/MicroserviceJobState");
    import ServiceError = require("sas/ltjs/transport/models/media/particles/ServiceError");
    import ReportImageDetail = require("sas/ltjs/transport/models/media/ReportImageDetail");
    import Link = require("sas/ltjs/commons/models/particles/Link");
    class ReportImageJob extends MediaType {
        constructor();
        getId():string;
        setId(value:string):void;
        getState():MicroserviceJobState;
        setState(value:MicroserviceJobState):void;
        getDuration():number;
        setDuration(value:number):void;
        getCreationTimeStamp():string;
        setCreationTimeStamp(value:string):void;
        getCreationDatetime():number;
        setCreationDatetime(value:number):void;
        getError():ServiceError;
        setError(value:ServiceError):void;
        getImages():Array<ReportImageDetail>;
        setImages(value:Array<ReportImageDetail>):void;
        getLinks():Array<Link>;
        setLinks(value:Array<Link>):void;
    }
    
    export = ReportImageJob;
}


declare module "sas/ltjs/transport/models/media/ReportImageJobRequestDetails" {
    import MediaType = require("sas/ltjs/transport/models/media/MediaType");
    import ReportImageLayoutType = require("sas/ltjs/transport/models/media/particles/ReportImageLayoutType");
    import ReportImageSize = require("sas/ltjs/transport/models/media/particles/ReportImageSize");
    import ReportImageSelectionType = require("sas/ltjs/transport/models/media/particles/ReportImageSelectionType");
    class ReportImageJobRequestDetails extends MediaType {
        constructor();
        getReportUri():string;
        setReportUri(value:string):void;
        getLayoutType():ReportImageLayoutType;
        setLayoutType(value:ReportImageLayoutType):void;
        getSize():ReportImageSize;
        setSize(value:ReportImageSize):void;
        getSelectionType():ReportImageSelectionType;
        setSelectionType(value:ReportImageSelectionType):void;
        getVisualElementNames():string;
        setVisualElementNames(value:string):void;
        getSectionIndex():number;
        setSectionIndex(value:number):void;
        getRefresh():boolean;
        setRefresh(value:boolean):void;
        getRenderLimit():number;
        setRenderLimit(value:number):void;
    }
    
    export = ReportImageJobRequestDetails;
}


declare module "sas/ltjs/transport/models/media/ReportItem" {
    import MediaType = require("sas/ltjs/transport/models/media/MediaType");
    import Link = require("sas/ltjs/commons/models/particles/Link");
    class ReportItem extends MediaType {
        constructor();
        getId():string;
        setId(value:string):void;
        getName():string;
        setName(value:string):void;
        getDescription():string;
        setDescription(value:string):void;
        getCreationTimeStamp():string;
        setCreationTimeStamp(value:string):void;
        getCreatedBy():string;
        setCreatedBy(value:string):void;
        getModifiedTimeStamp():string;
        setModifiedTimeStamp(value:string):void;
        getModifiedBy():string;
        setModifiedBy(value:string):void;
        getLinks():Array<Link>;
        setLinks(value:Array<Link>):void;
    }
    
    export = ReportItem;
}


declare module "sas/ltjs/transport/models/media/ReportManifest" {
    import MediaType = require("sas/ltjs/transport/models/media/MediaType");
    import ReportDataLevel = require("sas/ltjs/transport/models/media/particles/ReportDataLevel");
    import ReportAssetURL = require("sas/ltjs/transport/models/media/particles/ReportAssetURL");
    import File = require("sas/ltjs/transport/models/media/particles/File");
    import Link = require("sas/ltjs/commons/models/particles/Link");
    import ReportPackageUpdateCharacteristic = require("sas/ltjs/transport/models/media/particles/ReportPackageUpdateCharacteristic");
    class ReportManifest extends MediaType {
        constructor();
        getXmlElementName():string;
        setXmlElementName(value:string):void;
        getCacheKey():string;
        setCacheKey(value:string):void;
        getDate():string;
        setDate(value:string):void;
        getDataLevel():ReportDataLevel;
        setDataLevel(value:ReportDataLevel):void;
        getTotalSize():number;
        setTotalSize(value:number):void;
        getUrls():Array<ReportAssetURL>;
        setUrls(value:Array<ReportAssetURL>):void;
        getLocale():string;
        setLocale(value:string):void;
        getSource():string;
        setSource(value:string):void;
        getWarnings():string;
        setWarnings(value:string):void;
        getFiles():Array<File>;
        setFiles(value:Array<File>):void;
        getLinks():Array<Link>;
        setLinks(value:Array<Link>):void;
        getModifiedTimeStamp():string;
        setModifiedTimeStamp(value:string):void;
        getUpdateCharacteristic():ReportPackageUpdateCharacteristic;
        setUpdateCharacteristic(value:ReportPackageUpdateCharacteristic):void;
        getFormatLocale():string;
        setFormatLocale(value:string):void;
        getReportElements():string;
        setReportElements(value:string):void;
        getReportStateUri():string;
        setReportStateUri(value:string):void;
    }
    
    export = ReportManifest;
}


declare module "sas/ltjs/transport/models/media/ReportMetadata" {
    import MediaType = require("sas/ltjs/transport/models/media/MediaType");
    import ReportManifest = require("sas/ltjs/transport/models/media/ReportManifest");
    import Link = require("sas/ltjs/commons/models/particles/Link");
    import PortableEvent = require("sas/ltjs/commons/events/PortableEvent");
    class ReportMetadata extends MediaType {
        constructor();
        getCachedReports():Array<ReportManifest>;
        setCachedReports(value:Array<ReportManifest>):void;
        getCreated():string;
        setCreated(value:string):void;
        getCreatedDatetime():number;
        setCreatedDatetime(value:number):void;
        getCreatedBy():string;
        setCreatedBy(value:string):void;
        getCreatedByUserId():string;
        setCreatedByUserId(value:string):void;
        getDescription():string;
        setDescription(value:string):void;
        getDisplayName():string;
        setDisplayName(value:string):void;
        getGUID():string;
        setGUID(value:string):void;
        getKeywords():Array<string>;
        setKeywords(value:Array<string>):void;
        getLastModified():string;
        setLastModified(value:string):void;
        getLastModifiedDatetime():number;
        setLastModifiedDatetime(value:number):void;
        getLocation():string;
        setLocation(value:string):void;
        getModifiedBy():string;
        setModifiedBy(value:string):void;
        getModifiedByUserId():string;
        setModifiedByUserId(value:string):void;
        getPrintReport():string;
        setPrintReport(value:string):void;
        getRegenerateDocument():string;
        setRegenerateDocument(value:string):void;
        getRegeneratePackage():string;
        setRegeneratePackage(value:string):void;
        getResourceId():string;
        setResourceId(value:string):void;
        getShareURL():string;
        setShareURL(value:string):void;
        getShortName():string;
        setShortName(value:string):void;
        getThumbnail():string;
        setThumbnail(value:string):void;
        getType():string;
        setType(value:string):void;
        getPath():string;
        setPath(value:string):void;
        getLinks():Array<Link>;
        setLinks(value:Array<Link>):void;
        lastModifiedUpdated(pEvent:PortableEvent):void;
        createdUpdated(pEvent:PortableEvent):void;
    }
    
    export = ReportMetadata;
}


declare module "sas/ltjs/transport/models/media/ReportPackageJob" {
    import MediaType = require("sas/ltjs/transport/models/media/MediaType");
    import MicroserviceJobState = require("sas/ltjs/transport/models/media/particles/MicroserviceJobState");
    import ServiceError = require("sas/ltjs/transport/models/media/particles/ServiceError");
    import Link = require("sas/ltjs/commons/models/particles/Link");
    class ReportPackageJob extends MediaType {
        constructor();
        getId():string;
        setId(value:string):void;
        getState():MicroserviceJobState;
        setState(value:MicroserviceJobState):void;
        getSource():string;
        setSource(value:string):void;
        getCreatedBy():string;
        setCreatedBy(value:string):void;
        getCreationTimeStamp():string;
        setCreationTimeStamp(value:string):void;
        getStartTimeStamp():string;
        setStartTimeStamp(value:string):void;
        getCompletionTimeStamp():string;
        setCompletionTimeStamp(value:string):void;
        getError():ServiceError;
        setError(value:ServiceError):void;
        getLinks():Array<Link>;
        setLinks(value:Array<Link>):void;
    }
    
    export = ReportPackageJob;
}


declare module "sas/ltjs/transport/models/media/ReportPackagesConfigProperties" {
    import MediaType = require("sas/ltjs/transport/models/media/MediaType");
    class ReportPackagesConfigProperties extends MediaType {
        constructor();
        getServerVersion():string;
        setServerVersion(value:string):void;
    }
    
    export = ReportPackagesConfigProperties;
}


declare module "sas/ltjs/transport/models/media/ReportRendered" {
    import MediaType = require("sas/ltjs/transport/models/media/MediaType");
    import Link = require("sas/ltjs/commons/models/particles/Link");
    class ReportRendered extends MediaType {
        constructor();
        getId():string;
        setId(value:string):void;
        getOwner():string;
        setOwner(value:string):void;
        getLinks():Array<Link>;
        setLinks(value:Array<Link>):void;
    }
    
    export = ReportRendered;
}


declare module "sas/ltjs/transport/models/media/ReportStateInfo" {
    import MediaType = require("sas/ltjs/transport/models/media/MediaType");
    import Link = require("sas/ltjs/commons/models/particles/Link");
    import PortableEvent = require("sas/ltjs/commons/events/PortableEvent");
    class ReportStateInfo extends MediaType {
        constructor();
        getId():string;
        setId(value:string):void;
        getUserId():string;
        setUserId(value:string):void;
        getLabel():string;
        setLabel(value:string):void;
        getPrimary():boolean;
        setPrimary(value:boolean):void;
        getReportModifiedTimeStamp():string;
        setReportModifiedTimeStamp(value:string):void;
        getCreatedBy():string;
        setCreatedBy(value:string):void;
        getCreationTimeStamp():string;
        setCreationTimeStamp(value:string):void;
        getCreationDatetime():number;
        setCreationDatetime(value:number):void;
        getModifiedBy():string;
        setModifiedBy(value:string):void;
        getModifiedTimeStamp():string;
        setModifiedTimeStamp(value:string):void;
        getModifiedDatetime():number;
        setModifiedDatetime(value:number):void;
        getLinks():Array<Link>;
        setLinks(value:Array<Link>):void;
        modifiedUpdated(pEvent:PortableEvent):void;
        createdUpdated(pEvent:PortableEvent):void;
    }
    
    export = ReportStateInfo;
}


declare module "sas/ltjs/transport/models/media/ReportWarning" {
    import MediaType = require("sas/ltjs/transport/models/media/MediaType");
    class ReportWarning extends MediaType {
        constructor();
        getLocation():string;
        setLocation(value:string):void;
        getReturnCode():number;
        setReturnCode(value:number):void;
        getReason():string;
        setReason(value:string):void;
        getMessage():string;
        setMessage(value:string):void;
    }
    
    export = ReportWarning;
}


declare module "sas/ltjs/transport/models/media/SearchItem" {
    import MediaType = require("sas/ltjs/transport/models/media/MediaType");
    class SearchItem extends MediaType {
        constructor();
        getResourceUri():string;
        setResourceUri(value:string):void;
        getCreationTimeStamp():string;
        setCreationTimeStamp(value:string):void;
        getModifiedTimeStamp():string;
        setModifiedTimeStamp(value:string):void;
        getModifiedBy():string;
        setModifiedBy(value:string):void;
        getCreatedBy():string;
        setCreatedBy(value:string):void;
        getModifiedByLabel():string;
        setModifiedByLabel(value:string):void;
        getCreatedByLabel():string;
        setCreatedByLabel(value:string):void;
        getSasType():string;
        setSasType(value:string):void;
        getTitle():string;
        setTitle(value:string):void;
        getDescription():string;
        setDescription(value:string):void;
    }
    
    export = SearchItem;
}


declare module "sas/ltjs/transport/models/media/SearchMetadata" {
    import MediaType = require("sas/ltjs/transport/models/media/MediaType");
    import ReportMetadata = require("sas/ltjs/transport/models/media/ReportMetadata");
    class SearchMetadata extends MediaType {
        constructor();
        getMatchingFields():string;
        setMatchingFields(value:string):void;
        getReportMetadata():ReportMetadata;
        setReportMetadata(value:ReportMetadata):void;
    }
    
    export = SearchMetadata;
}


declare module "sas/ltjs/transport/models/media/SelectionById" {
    import MediaType = require("sas/ltjs/transport/models/media/MediaType");
    import IdResources = require("sas/ltjs/transport/models/media/particles/IdResources");
    class SelectionById extends MediaType {
        constructor();
        getResources():IdResources;
        setResources(value:IdResources):void;
        getMatchTemplate():string;
        setMatchTemplate(value:string):void;
        getType():string;
        setType(value:string):void;
    }
    
    export = SelectionById;
}


declare module "sas/ltjs/transport/models/media/ServerConfig" {
    import MediaType = require("sas/ltjs/transport/models/media/MediaType");
    import SupportedType = require("sas/ltjs/transport/models/media/particles/SupportedType");
    import URL = require("sas/ltjs/commons/resources/network/URL");
    class ServerConfig extends MediaType {
        constructor();
        getBannerMessage():string;
        setBannerMessage(value:string):void;
        getComparisonEpsilon():number;
        setComparisonEpsilon(value:number):void;
        getLogoUrl():string;
        setLogoUrl(value:string):void;
        getPasscodeAttempts():number;
        setPasscodeAttempts(value:number):void;
        getPasscodeTimeout():number;
        setPasscodeTimeout(value:number):void;
        getSearchAvailable():boolean;
        setSearchAvailable(value:boolean):void;
        getSupportedTypes():Array<SupportedType>;
        setSupportedTypes(value:Array<SupportedType>):void;
        getTitle():string;
        setTitle(value:string):void;
        getTransportServicesVersion():string;
        setTransportServicesVersion(value:string):void;
        getAllowGuest():boolean;
        setAllowGuest(value:boolean):void;
        getPrintAvailable():boolean;
        setPrintAvailable(value:boolean):void;
        getOfflineLimit():number;
        setOfflineLimit(value:number):void;
        getHomePageUrl():URL;
        setHomePageUrl(value:URL):void;
        getEnvironmentManagerUrl():URL;
        setEnvironmentManagerUrl(value:URL):void;
        getReportImagesAvailable():boolean;
        setReportImagesAvailable(value:boolean):void;
        getReportImagesJobCreationUrl():string;
        setReportImagesJobCreationUrl(value:string):void;
        getEnableInteractiveData():boolean;
        setEnableInteractiveData(value:boolean):void;
        getAllowWebContentForMobile():boolean;
        setAllowWebContentForMobile(value:boolean):void;
        getIframeSandbox():string;
        setIframeSandbox(value:string):void;
    }
    
    export = ServerConfig;
}


declare module "sas/ltjs/transport/models/media/SharedItem" {
    import MediaType = require("sas/ltjs/transport/models/media/MediaType");
    import SharedWithType = require("sas/ltjs/transport/models/media/particles/SharedWithType");
    import ShareAccessType = require("sas/ltjs/transport/models/media/particles/ShareAccessType");
    import Link = require("sas/ltjs/commons/models/particles/Link");
    class SharedItem extends MediaType {
        constructor();
        getSharedWith():string;
        setSharedWith(value:string):void;
        getResourceUri():string;
        setResourceUri(value:string):void;
        getName():string;
        setName(value:string):void;
        getSharedWithType():SharedWithType;
        setSharedWithType(value:SharedWithType):void;
        getShareAccessType():ShareAccessType;
        setShareAccessType(value:ShareAccessType):void;
        getId():string;
        setId(value:string):void;
        getCreatedBy():string;
        setCreatedBy(value:string):void;
        getModifiedBy():string;
        setModifiedBy(value:string):void;
        getCreationTimeStamp():string;
        setCreationTimeStamp(value:string):void;
        getModifiedTimeStamp():string;
        setModifiedTimeStamp(value:string):void;
        getLinks():Array<Link>;
        setLinks(value:Array<Link>):void;
    }
    
    export = SharedItem;
}


declare module "sas/ltjs/transport/models/media/UserInfo" {
    import MediaType = require("sas/ltjs/transport/models/media/MediaType");
    import Capability = require("sas/ltjs/transport/models/media/particles/Capability");
    import Link = require("sas/ltjs/commons/models/particles/Link");
    class UserInfo extends MediaType {
        constructor();
        getCapabilities():Array<Capability>;
        setCapabilities(value:Array<Capability>):void;
        getUserDisplayName():string;
        setUserDisplayName(value:string):void;
        getUserId():string;
        setUserId(value:string):void;
        getMemberships():Array<string>;
        setMemberships(value:Array<string>):void;
        getLinks():Array<Link>;
        setLinks(value:Array<Link>):void;
    }
    
    export = UserInfo;
}


declare module "sas/ltjs/transport/models/media/UserSummary" {
    import MediaType = require("sas/ltjs/transport/models/media/MediaType");
    import Link = require("sas/ltjs/commons/models/particles/Link");
    class UserSummary extends MediaType {
        constructor();
        getLinks():Array<Link>;
        setLinks(value:Array<Link>):void;
        getId():string;
        setId(value:string):void;
        getName():string;
        setName(value:string):void;
        getDescription():string;
        setDescription(value:string):void;
        getProviderId():string;
        setProviderId(value:string):void;
        getState():string;
        setState(value:string):void;
        getUserType():string;
        setUserType(value:string):void;
    }
    
    export = UserSummary;
}


declare module "sas/ltjs/transport/util/trackers/AbstractTracker" {
    import EventDispatcher = require("sas/ltjs/commons/events/EventDispatcher");
    class AbstractTracker extends EventDispatcher {
        static TRACKED_ITEM_DID_CHANGE:number;
        static TRACKED_ITEM_WILL_CHANGE:number;
        startTracking():void;
        stopTracking():void;
        isTracking():boolean;
    }
    
    export = AbstractTracker;
}


declare module "sas/ltjs/transport/util/trackers/ReportStatusTracker" {
    import AbstractTracker = require("sas/ltjs/transport/util/trackers/AbstractTracker");
    import Depot = require("sas/ltjs/transport/depot/Depot");
    import BaseReport = require("sas/ltjs/transport/models/local/BaseReport");
    import ReportStatus = require("sas/ltjs/transport/depot/ReportStatus");
    class ReportStatusTracker extends AbstractTracker {
        constructor(depot:Depot, baseReport:BaseReport);
        getCurrentValue():ReportStatus;
    }
    
    export = ReportStatusTracker;
}


declare module "sas/ltjs/transport/util/reportcentral/operations/AbstractOperation" {
    import EventDispatcher = require("sas/ltjs/commons/events/EventDispatcher");
    import Depot = require("sas/ltjs/transport/depot/Depot");
    import Report = require("sas/ltjs/transport/models/local/Report");
    import Connection = require("sas/ltjs/transport/models/local/Connection");
    import BaseReport = require("sas/ltjs/transport/models/local/BaseReport");
    import GetReportOperationContext = require("sas/ltjs/transport/util/reportcentral/operations/GetReportOperationContext");
    import Collection = require("sas/ltjs/transport/collection/Collection");
    import SearchLocations = require("sas/ltjs/transport/depot/SearchLocations");
    class AbstractOperation extends EventDispatcher {
        static REMOVE_FROM_FAVORITES_FAILED:number;
        static REMOVE_FROM_FAVORITES_COMPLETED:number;
        static ADD_TO_FAVORITES_FAILED:number;
        static ADD_TO_FAVORITES_COMPLETED:number;
        static SEARCH_FINISHED:number;
        static SUB_SEARCH_FINISHED_ERROR:number;
        static SUB_SEARCH_FINISHED_NO_RESULTS:number;
        static SUB_SEARCH_NOT_SUPPORTED:number;
        static SUB_SEARCH_FINISHED:number;
        static SUB_SEARCH_WILL_FINISH:number;
        static SEARCH_STARTED:number;
        static DOWNLOAD_FAILED:number;
        static DOWNLOAD_CANCELLED:number;
        static DOWNLOAD_WILL_RETRY:number;
        static DOWNLOAD_COMPLETED:number;
        static PREVIEW_GENERATION_COMPLETED:number;
        static PREVIEW_GENERATED:number;
        static START_GENERATING_PREVIEWS:number;
        static DOWNLOADING_IMAGES:number;
        static DOWNLOADING_ASSETS_COMPLETED:number;
        static DOWNLOADING_ASSETS:number;
        static DOWNLOADING_ASSETS_STARTED:number;
        static NOTHING_TO_DOWNLOAD:number;
        static WAITING_TO_DOWNLOAD:number;
        static SUBSCRIPTION_FAILED:number;
        static SUBSCRIPTION_CANCELLED:number;
        static SUBSCRIPTION_COMPLETED:number;
        static REPORT_META_UPDATED:number;
        static REPORT_INITIALIZED:number;
        static INITIALIZING_REPORT:number;
        static ROLLED_BACK:number;
        static COMMITTED:number;
        static APPLIED:number;
        static createAddToHistoryOperation(depot:Depot, report:Report):AbstractOperation;
        static createClearHistoryOperation(depot:Depot, connection:Connection):AbstractOperation;
        static createAddToFavoritesOperation(depot:Depot, report:Report):AbstractOperation;
        static createAddToFavoritesOperations(depot:Depot, report:Array<Report>):Array<AbstractOperation>;
        static createRemoveFromFavoritesOperation(depot:Depot, report:Report):AbstractOperation;
        static createRemoveFromFavoritesOperations(depot:Depot, report:Array<Report>):Array<AbstractOperation>;
        static createUnsubscribeOperation(depot:Depot, report:Report):AbstractOperation;
        static createUnsubscribeManyOperation(depot:Depot, reports:Array<Report>):AbstractOperation;
        static createUnsubscribeAllOperation(depot:Depot):AbstractOperation;
        apply():void;
        cancel():void;
        isEqual(operation:AbstractOperation):boolean;
        isPending():boolean;
        static createSubscribeOperation(depot:Depot, report:BaseReport):AbstractOperation;
        static createSubscribeOperation(depot:Depot, report:BaseReport, skipPreviewGeneration:boolean | GetReportOperationContext):AbstractOperation;
        static createSubscribeOperation(depot:Depot, connection:Connection, sbip:string):AbstractOperation;
        static createSubscribeOperation(depot:Depot, connection:Connection, sbip:string, skipPreviewGeneration:boolean | GetReportOperationContext):AbstractOperation;
        static createSearchOperation(depot:Depot, query:string, resultsContainer:Collection):AbstractOperation;
        static createSearchOperation(depot:Depot, connection:Connection, query:string, resultsContainer:Collection):AbstractOperation;
        static createSearchOperation(depot:Depot, query:string, locations:SearchLocations, resultsContainer:Collection):AbstractOperation;
        static createDownloadOperation(depot:Depot, report:Report):AbstractOperation;
        static createDownloadOperation(depot:Depot, report:Report, skipPreviewGeneration:boolean | GetReportOperationContext):AbstractOperation;
        static createSubscribeOperations(depot:Depot, report:Array<BaseReport>):Array<AbstractOperation>;
        static createSubscribeOperations(depot:Depot, report:Array<BaseReport>, skipPreviewGeneration:boolean | GetReportOperationContext):Array<AbstractOperation>;
    }
    
    export = AbstractOperation;
}


declare module "sas/ltjs/transport/util/reportcentral/operations/GetReportOperationContext" {
    import TransportModel = require("sas/ltjs/transport/models/TransportModel");
    class GetReportOperationContext extends TransportModel {
        constructor();
        getSkipPreviewGeneration():boolean;
        setSkipPreviewGeneration(value:boolean):void;
        getWithUserState():boolean;
        setWithUserState(value:boolean):void;
    }
    
    export = GetReportOperationContext;
}


declare module "sas/ltjs/transport/models/media/particles/AlertInterval" {
    enum AlertInterval
    {
        SECOND,
        MINUTE,
        HOUR,
        DAY
    }
    export = AlertInterval
}


declare module "sas/ltjs/transport/models/media/particles/AlertIntervalControl" {
    enum AlertIntervalControl
    {
        SYSTEM_CONTROLLED,
        FIXED_INTERVAL
    }
    export = AlertIntervalControl
}


declare module "sas/ltjs/transport/models/media/particles/AlertReportReference" {
    import TransportModel = require("sas/ltjs/transport/models/TransportModel");
    class AlertReportReference extends TransportModel {
        constructor();
        getUri():string;
        setUri(value:string):void;
        getName():string;
        setName(value:string):void;
    }
    
    export = AlertReportReference;
}


declare module "sas/ltjs/transport/models/media/particles/AlertStrategy" {
    enum AlertStrategy
    {
        SYSTEMCONTROLLED,
        FIXEDINTERVAL
    }
    export = AlertStrategy
}


declare module "sas/ltjs/transport/models/media/particles/AlertSubscriber" {
    import TransportModel = require("sas/ltjs/transport/models/TransportModel");
    class AlertSubscriber extends TransportModel {
        constructor();
        getUserId():string;
        setUserId(value:string):void;
        getGroup():boolean;
        setGroup(value:boolean):void;
        getSendEmail():boolean;
        setSendEmail(value:boolean):void;
        getSendSMS():boolean;
        setSendSMS(value:boolean):void;
        getRetainNotification():boolean;
        setRetainNotification(value:boolean):void;
        getOverrideEmail():string;
        setOverrideEmail(value:string):void;
        getOverrideSMS():string;
        setOverrideSMS(value:string):void;
    }
    
    export = AlertSubscriber;
}


declare module "sas/ltjs/transport/models/media/particles/AlertSubscriptionInterval" {
    import TransportModel = require("sas/ltjs/transport/models/TransportModel");
    import AlertIntervalControl = require("sas/ltjs/transport/models/media/particles/AlertIntervalControl");
    import AlertInterval = require("sas/ltjs/transport/models/media/particles/AlertInterval");
    class AlertSubscriptionInterval extends TransportModel {
        constructor();
        getIntervalControl():AlertIntervalControl;
        setIntervalControl(value:AlertIntervalControl):void;
        getIntervalUnit():AlertInterval;
        setIntervalUnit(value:AlertInterval):void;
        getIntervalValue():number;
        setIntervalValue(value:number):void;
    }
    
    export = AlertSubscriptionInterval;
}


declare module "sas/ltjs/transport/models/media/particles/CSSAdapter" {
    enum CSSAdapter
    {
        NONE,
        UI5
    }
    export = CSSAdapter
}


declare module "sas/ltjs/transport/models/media/particles/Capability" {
    enum Capability
    {
        UNKNOWN,
        ACCESS_ESRI_PREMIUM_SERVICES,
        ACCESS_MOBILE_BI,
        ACCESS_RECENTS,
        ACCESS_SETTINGS,
        ACCESS_VISUAL_ANALYTICS,
        ACCESS_VISUAL_ANALYTICS_VIEWER,
        ADD_SHARE,
        ALLOW_WEB_CONTENT,
        ADD_COMMENTS,
        BROWSE_HDFS,
        BUILD_CUSTOM_GRAPH,
        COMMENTS,
        CREATE_COLLECTIONS,
        CREATE_EXPLORATION,
        CREATE_REPORT,
        EMAIL,
        EXPORT_DATA,
        EXPORT_DETAIL_DATA,
        EXPORT_IMAGE,
        EXPORT_PDF,
        EXPORT_REPORT,
        IMPORT_AND_LOAD_DATA,
        INTERPRET_REPORT_VIEWER_NATURAL_LANGUAGE,
        LIMIT_OFFLINE_ACCESS,
        MANAGE_CUSTOM_LISTS,
        MANAGE_ENVIRONMENT,
        MANAGE_FAVORITES,
        MANAGE_LASR_SERVER,
        MANAGE_MOBILE_DEVICES,
        MONITOR_LASR,
        PERSONALIZATION,
        PREPARE_DATA,
        PURGE_MOBILE_REPORT_DATA,
        REFRESH_DATA,
        RENDER_REPORT_IMAGES,
        REQUIRE_APPLICATION_PASSCODE,
        SUBSCRIBE_TO_REPORT_ALERTS,
        TEXT_TEMPLATES,
        VAA_TABLE_AUTHORIZATION,
        VIEW_COMMENTS,
        VIEW_FAVORITES,
        VIEW_REPORT,
        VIEW_SHARES
    }
    export = Capability
}


declare module "sas/ltjs/transport/models/media/particles/CommentAttachment" {
    import TransportModel = require("sas/ltjs/transport/models/TransportModel");
    import FileData = require("sas/ltjs/transport/models/local/FileData");
    class CommentAttachment extends TransportModel {
        constructor();
        getXmlElementName():string;
        setXmlElementName(value:string):void;
        getAttachmentId():number;
        setAttachmentId(value:number):void;
        getName():string;
        setName(value:string):void;
        getDocType():string;
        setDocType(value:string):void;
        getObjectType():number;
        setObjectType(value:number):void;
        getSize():number;
        setSize(value:number):void;
        getUrlString():string;
        setUrlString(value:string):void;
        getData():FileData;
        setData(value:FileData):void;
        getXmlSchemaInstance():string;
        setXmlSchemaInstance(value:string):void;
        getXsiType():string;
        setXsiType(value:string):void;
    }
    
    export = CommentAttachment;
}


declare module "sas/ltjs/transport/models/media/particles/CommentAttachmentInfo" {
    import TransportModel = require("sas/ltjs/transport/models/TransportModel");
    import Comment = require("sas/ltjs/transport/models/media/Comment");
    import FileItem = require("sas/ltjs/transport/models/media/FileItem");
    class CommentAttachmentInfo extends TransportModel {
        constructor();
        getAttachmentId():number;
        setAttachmentId(value:number):void;
        getName():string;
        setName(value:string):void;
        getDocType():string;
        setDocType(value:string):void;
        getSize():number;
        setSize(value:number):void;
        getUrlString():string;
        setUrlString(value:string):void;
        getComment():Comment;
        setComment(value:Comment):void;
        getUuid():string;
        setUuid(value:string):void;
        getFileItem():FileItem;
        setFileItem(value:FileItem):void;
    }
    
    export = CommentAttachmentInfo;
}


declare module "sas/ltjs/transport/models/media/particles/CredentialProperties" {
    import TransportModel = require("sas/ltjs/transport/models/TransportModel");
    class CredentialProperties extends TransportModel {
        constructor();
        getUserId():string;
        setUserId(value:string):void;
    }
    
    export = CredentialProperties;
}


declare module "sas/ltjs/transport/models/media/particles/CredentialSecrets" {
    import TransportModel = require("sas/ltjs/transport/models/TransportModel");
    class CredentialSecrets extends TransportModel {
        constructor();
        getPassword():string;
        setPassword(value:string):void;
    }
    
    export = CredentialSecrets;
}


declare module "sas/ltjs/transport/models/media/particles/Duid" {
    import TransportModel = require("sas/ltjs/transport/models/TransportModel");
    class Duid extends TransportModel {
        constructor();
        getType():string;
        setType(value:string):void;
        getName():string;
        setName(value:string):void;
        getLabel():string;
        setLabel(value:string):void;
    }
    
    export = Duid;
}


declare module "sas/ltjs/transport/models/media/particles/EsriLogonStatus" {
    enum EsriLogonStatus
    {
        CONNECTION_ESRI_UNKNOWN,
        CONNECTION_ESRI_DISABLED,
        CONNECTION_ESRI_NO_CREDENTIALS,
        CONNECTION_ESRI_NO_CAPABILITY,
        CONNECTION_ESRI_LOGIN_SUCCESS,
        CONNECTION_ESRI_LOGIN_FAILURE
    }
    export = EsriLogonStatus
}


declare module "sas/ltjs/transport/models/media/particles/EsriPortalLogonStatus" {
    enum EsriPortalLogonStatus
    {
        CONNECTION_ESRI_PORTAL_UNKNOWN,
        CONNECTION_ESRI_PORTAL_NOT_AVAILABLE,
        CONNECTION_ESRI_PORTAL_NOT_REQUIRED,
        CONNECTION_ESRI_PORTAL_NO_CREDENTIALS,
        CONNECTION_ESRI_PORTAL_LOGIN_SUCCESS,
        CONNECTION_ESRI_PORTAL_LOGIN_FAILURE
    }
    export = EsriPortalLogonStatus
}


declare module "sas/ltjs/transport/models/media/particles/FailureReasonCode" {
    enum FailureReasonCode
    {
        INVALID_REQUEST,
        AUTHENTICATION_ERROR,
        UNAUTHORIZED,
        UNSUPPORTED,
        UNSUPPORTED_TYPE,
        READ_ERROR,
        PARSE_ERROR,
        EXECUTION_FAILURE,
        REPORT_ALREADY_EXISTS,
        FOLDER_ALREADY_EXISTS,
        FOLDER_NOT_FOUND,
        UNKNOWN
    }
    export = FailureReasonCode
}


declare module "sas/ltjs/transport/models/media/particles/Favorite" {
    import TransportModel = require("sas/ltjs/transport/models/TransportModel");
    class Favorite extends TransportModel {
        constructor();
        getLocation():string;
        setLocation(value:string):void;
        getCount():number;
        setCount(value:number):void;
    }
    
    export = Favorite;
}


declare module "sas/ltjs/transport/models/media/particles/FavoriteState" {
    enum FavoriteState
    {
        FALSE_EDITABLE,
        TRUE_EDITABLE,
        FALSE_NON_EDITABLE,
        TRUE_NON_EDITABLE
    }
    export = FavoriteState
}


declare module "sas/ltjs/transport/models/media/particles/File" {
    import TransportModel = require("sas/ltjs/transport/models/TransportModel");
    import FileType = require("sas/ltjs/transport/models/media/particles/FileType");
    import Link = require("sas/ltjs/commons/models/particles/Link");
    class File extends TransportModel {
        constructor();
        getContentKey():string;
        setContentKey(value:string):void;
        getName():string;
        setName(value:string):void;
        getType():FileType;
        setType(value:FileType):void;
        getLinks():Array<Link>;
        setLinks(value:Array<Link>):void;
        getServerFile():string;
        setServerFile(value:string):void;
    }
    
    export = File;
}


declare module "sas/ltjs/transport/models/media/particles/FileLocation" {
    import TransportModel = require("sas/ltjs/transport/models/TransportModel");
    class FileLocation extends TransportModel {
        constructor();
        getPath():string;
        setPath(value:string):void;
    }
    
    export = FileLocation;
}


declare module "sas/ltjs/transport/models/media/particles/FileType" {
    enum FileType
    {
        REPORT,
        DATA,
        IMAGE,
        XML,
        CSS,
        REPORTSTATE,
        RESOURCE
    }
    export = FileType
}


declare module "sas/ltjs/transport/models/media/particles/FolderMemberType" {
    enum FolderMemberType
    {
        CHILD,
        REFERENCE
    }
    export = FolderMemberType
}


declare module "sas/ltjs/transport/models/media/particles/FolderType" {
    enum FolderType
    {
        UNKNOWN,
        FOLDER,
        SEARCH_FOLDER,
        FAVORITES_FOLDER,
        FAVORITES_GROUP,
        MY_FOLDER,
        HIDDEN_FOLDER,
        USER_FOLDER,
        USERS_FOLDER
    }
    export = FolderType
}


declare module "sas/ltjs/transport/models/media/particles/IdResources" {
    import TransportModel = require("sas/ltjs/transport/models/TransportModel");
    class IdResources extends TransportModel {
        constructor();
        getId():Array<string>;
        setId(value:Array<string>):void;
    }
    
    export = IdResources;
}


declare module "sas/ltjs/transport/models/media/particles/LogMessage" {
    import TransportModel = require("sas/ltjs/transport/models/TransportModel");
    class LogMessage extends TransportModel {
        constructor();
        getMessage():string;
        setMessage(value:string):void;
    }
    
    export = LogMessage;
}


declare module "sas/ltjs/transport/models/media/particles/LogonStatus" {
    enum LogonStatus
    {
        LOGGEDON,
        LOGGEDOFF,
        LOGON_PENDING,
        LOGOFF_PENDING,
        AUTHENTICATION_FAILED,
        BLACKLISTED,
        NOT_IN_WHITELIST,
        OFFLINE_LIMIT_EXCEEDED,
        APP_ACCESS_DENIED
    }
    export = LogonStatus
}


declare module "sas/ltjs/transport/models/media/particles/MapsSettingsAttributes" {
    import TransportModel = require("sas/ltjs/transport/models/TransportModel");
    class MapsSettingsAttributes extends TransportModel {
        constructor();
        getDefaultOSMCommunicationProtocol():string;
        setDefaultOSMCommunicationProtocol(value:string):void;
        getLocalEsriServicesUrl():string;
        setLocalEsriServicesUrl(value:string):void;
        getLocalEsriServicesRequiresAuthentication():boolean;
        setLocalEsriServicesRequiresAuthentication(value:boolean):void;
        getUseArcGISOnlineMaps():boolean;
        setUseArcGISOnlineMaps(value:boolean):void;
    }
    
    export = MapsSettingsAttributes;
}


declare module "sas/ltjs/transport/models/media/particles/MicroserviceJobState" {
    enum MicroserviceJobState
    {
        PENDING,
        RUNNING,
        COMPLETED,
        FAILED,
        IGNORED,
        NOT_MODIFIED,
        CANCELED,
        CANCELING
    }
    export = MicroserviceJobState
}


declare module "sas/ltjs/transport/models/media/particles/PaperType" {
    enum PaperType
    {
        LETTER,
        A3,
        A4,
        A5,
        B4,
        B5,
        CSHEET,
        DSHEET,
        ESHEET,
        ENV_DL,
        EXECUTIVE,
        FOLIO,
        LEGAL,
        LEDGER,
        JPOST,
        CUSTOM
    }
    export = PaperType
}


declare module "sas/ltjs/transport/models/media/particles/PrintAppendixDisplayOption" {
    enum PrintAppendixDisplayOption
    {
        NOCOMMENTS,
        COMMENTS
    }
    export = PrintAppendixDisplayOption
}


declare module "sas/ltjs/transport/models/media/particles/PrintDestination" {
    enum PrintDestination
    {
        URI,
        PDF
    }
    export = PrintDestination
}


declare module "sas/ltjs/transport/models/media/particles/PrintFitOption" {
    enum PrintFitOption
    {
        NONE,
        EXPAND_CLIPPED_CONTENT_IN_APPENDIX
    }
    export = PrintFitOption
}


declare module "sas/ltjs/transport/models/media/particles/PrintOrientation" {
    enum PrintOrientation
    {
        LANDSCAPE,
        PORTRAIT
    }
    export = PrintOrientation
}


declare module "sas/ltjs/transport/models/media/particles/PrintTableOfContentsDisplayOption" {
    enum PrintTableOfContentsDisplayOption
    {
        READERDEFAULT,
        NONE,
        BOOKMARKS,
        THUMBNAILS
    }
    export = PrintTableOfContentsDisplayOption
}


declare module "sas/ltjs/transport/models/media/particles/ReportAssetURL" {
    import TransportModel = require("sas/ltjs/transport/models/TransportModel");
    import ReportAssetURLType = require("sas/ltjs/transport/models/media/particles/ReportAssetURLType");
    class ReportAssetURL extends TransportModel {
        constructor();
        getName():string;
        setName(value:string):void;
        getType():ReportAssetURLType;
        setType(value:ReportAssetURLType):void;
        getContentKey():string;
        setContentKey(value:string):void;
        getServerFile():string;
        setServerFile(value:string):void;
        getUsageVersion():string;
        setUsageVersion(value:string):void;
        getUrlString():string;
        setUrlString(value:string):void;
        getAcceptType():string;
        setAcceptType(value:string):void;
    }
    
    export = ReportAssetURL;
}


declare module "sas/ltjs/transport/models/media/particles/ReportAssetURLType" {
    enum ReportAssetURLType
    {
        REPORT,
        DATA,
        IMAGE,
        XML,
        CSS,
        STP,
        PACKAGE,
        REQUERY,
        REPORTSTATE,
        RESOURCE
    }
    export = ReportAssetURLType
}


declare module "sas/ltjs/transport/models/media/particles/ReportDataJobResults" {
    import MediaType = require("sas/ltjs/transport/models/media/MediaType");
    class ReportDataJobResults extends MediaType {
        constructor();
        getContent():string;
        setContent(value:string):void;
        getContentType():string;
        setContentType(value:string):void;
    }
    
    export = ReportDataJobResults;
}


declare module "sas/ltjs/transport/models/media/particles/ReportDataLevel" {
    enum ReportDataLevel
    {
        BASELINE,
        INTERACTIVE,
        NODATA,
        CUSTOM
    }
    export = ReportDataLevel
}


declare module "sas/ltjs/transport/models/media/particles/ReportImageLayoutType" {
    enum ReportImageLayoutType
    {
        THUMBNAIL,
        NORMAL,
        ENTIRE_SECTION
    }
    export = ReportImageLayoutType
}


declare module "sas/ltjs/transport/models/media/particles/ReportImageSelectionType" {
    enum ReportImageSelectionType
    {
        REPORT,
        PER_SECTION,
        VISUAL_ELEMENTS
    }
    export = ReportImageSelectionType
}


declare module "sas/ltjs/transport/models/media/particles/ReportImageSize" {
    enum ReportImageSize
    {
        SMALL_SQUARE,
        LARGE_SQUARE,
        SMALL_4X3,
        MEDIUM_4X3,
        LARGE_4X3,
        LARGE_WIDE,
        TINY_CINEMA,
        SMALL_CINEMA,
        MEDIUM_CINEMA,
        LARGE_CINEMA
    }
    export = ReportImageSize
}


declare module "sas/ltjs/transport/models/media/particles/ReportLocationPair" {
    import TransportModel = require("sas/ltjs/transport/models/TransportModel");
    import Report = require("sas/ltjs/transport/models/local/Report");
    class ReportLocationPair extends TransportModel {
        constructor();
        getReportPath():string;
        setReportPath(value:string):void;
        getServerLocation():string;
        setServerLocation(value:string):void;
        getReport():Report;
        setReport(value:Report):void;
    }
    
    export = ReportLocationPair;
}


declare module "sas/ltjs/transport/models/media/particles/ReportLocationPairs" {
    import TransportModel = require("sas/ltjs/transport/models/TransportModel");
    import ReportLocationPair = require("sas/ltjs/transport/models/media/particles/ReportLocationPair");
    class ReportLocationPairs extends TransportModel {
        constructor();
        getPairs():Array<ReportLocationPair>;
        setPairs(value:Array<ReportLocationPair>):void;
    }
    
    export = ReportLocationPairs;
}


declare module "sas/ltjs/transport/models/media/particles/ReportPackageUpdateCharacteristic" {
    enum ReportPackageUpdateCharacteristic
    {
        TIME_SENSITIVE,
        VOLATILE
    }
    export = ReportPackageUpdateCharacteristic
}


declare module "sas/ltjs/transport/models/media/particles/ServiceError" {
    import TransportModel = require("sas/ltjs/transport/models/TransportModel");
    import Link = require("sas/ltjs/commons/models/particles/Link");
    class ServiceError extends TransportModel {
        constructor();
        getId():string;
        setId(value:string):void;
        getErrorCode():number;
        setErrorCode(value:number):void;
        getHttpStatusCode():number;
        setHttpStatusCode(value:number):void;
        getMessage():string;
        setMessage(value:string):void;
        getDetails():Array<string>;
        setDetails(value:Array<string>):void;
        getRemediation():string;
        setRemediation(value:string):void;
        getLinks():Array<Link>;
        setLinks(value:Array<Link>):void;
    }
    
    export = ServiceError;
}


declare module "sas/ltjs/transport/models/media/particles/ShareAccessType" {
    enum ShareAccessType
    {
        READ,
        READ_EDIT,
        READ_SHARE,
        READ_EDIT_SHARE
    }
    export = ShareAccessType
}


declare module "sas/ltjs/transport/models/media/particles/SharedWithType" {
    enum SharedWithType
    {
        USER,
        GROUP,
        AUTHENTICATED_USERS,
        EVERYONE,
        GUEST
    }
    export = SharedWithType
}


declare module "sas/ltjs/transport/models/media/particles/SubscribeMethod" {
    enum SubscribeMethod
    {
        MANUAL,
        AUTO
    }
    export = SubscribeMethod
}


declare module "sas/ltjs/transport/models/media/particles/SupportedType" {
    import TransportModel = require("sas/ltjs/transport/models/TransportModel");
    class SupportedType extends TransportModel {
        constructor();
        getName():string;
        setName(value:string):void;
        getSupportsReportLevelComments():boolean;
        setSupportsReportLevelComments(value:boolean):void;
        getSupportsObjectLevelComments():boolean;
        setSupportsObjectLevelComments(value:boolean):void;
        getSupportsPrinting():boolean;
        setSupportsPrinting(value:boolean):void;
    }
    
    export = SupportedType;
}


declare module "sas/ltjs/transport/models/media/cas/CASColumnItem" {
    import MediaType = require("sas/ltjs/transport/models/media/MediaType");
    class CASColumnItem extends MediaType {
        constructor();
        getIndex():number;
        setIndex(value:number):void;
        getFormat():string;
        setFormat(value:string):void;
        getFormattedLength():number;
        setFormattedLength(value:number):void;
        getLabel():string;
        setLabel(value:string):void;
        getName():string;
        setName(value:string):void;
        getNumberFormatDecimals():number;
        setNumberFormatDecimals(value:number):void;
        getNumberFormatLength():number;
        setNumberFormatLength(value:number):void;
        getRawLength():number;
        setRawLength(value:number):void;
        getType():string;
        setType(value:string):void;
        getIndexed():boolean;
        setIndexed(value:boolean):void;
    }
    
    export = CASColumnItem;
}


declare module "sas/ltjs/transport/models/media/cas/CASLibraryItem" {
    import MediaType = require("sas/ltjs/transport/models/media/MediaType");
    import Link = require("sas/ltjs/commons/models/particles/Link");
    class CASLibraryItem extends MediaType {
        constructor();
        getDescription():string;
        setDescription(value:string):void;
        getName():string;
        setName(value:string):void;
        getPath():string;
        setPath(value:string):void;
        getScope():string;
        setScope(value:string):void;
        getHidden():boolean;
        setHidden(value:boolean):void;
        getIsTransient():boolean;
        setIsTransient(value:boolean):void;
        getType():string;
        setType(value:string):void;
        getLinks():Array<Link>;
        setLinks(value:Array<Link>):void;
    }
    
    export = CASLibraryItem;
}


declare module "sas/ltjs/transport/models/media/cas/CASServerItem" {
    import MediaType = require("sas/ltjs/transport/models/media/MediaType");
    import Link = require("sas/ltjs/commons/models/particles/Link");
    class CASServerItem extends MediaType {
        constructor();
        getDescription():string;
        setDescription(value:string):void;
        getHost():string;
        setHost(value:string):void;
        getLinks():Array<Link>;
        setLinks(value:Array<Link>):void;
        getName():string;
        setName(value:string):void;
        getPort():number;
        setPort(value:number):void;
        getRestPort():number;
        setRestPort(value:number):void;
        getRestProtocol():string;
        setRestProtocol(value:string):void;
        getTags():Array<string>;
        setTags(value:Array<string>):void;
    }
    
    export = CASServerItem;
}


declare module "sas/ltjs/transport/models/media/cas/CASTableAttributes" {
    import TransportModel = require("sas/ltjs/transport/models/TransportModel");
    class CASTableAttributes extends TransportModel {
        constructor();
        getOwner():string;
        setOwner(value:string):void;
        getSize():number;
        setSize(value:number):void;
        getEncryption():string;
        setEncryption(value:string):void;
        getTime():string;
        setTime(value:string):void;
        getGroup():string;
        setGroup(value:string):void;
    }
    
    export = CASTableAttributes;
}


declare module "sas/ltjs/transport/models/media/cas/CASTableItem" {
    import MediaType = require("sas/ltjs/transport/models/media/MediaType");
    import CASTableAttributes = require("sas/ltjs/transport/models/media/cas/CASTableAttributes");
    import CASTableReference = require("sas/ltjs/transport/models/media/cas/CASTableReference");
    import Link = require("sas/ltjs/commons/models/particles/Link");
    class CASTableItem extends MediaType {
        constructor();
        getAttributes():CASTableAttributes;
        setAttributes(value:CASTableAttributes):void;
        getCharacterSet():string;
        setCharacterSet(value:string):void;
        getColumnCount():number;
        setColumnCount(value:number):void;
        getCreated():string;
        setCreated(value:string):void;
        getCreatedBy():string;
        setCreatedBy(value:string):void;
        getEncoding():string;
        setEncoding(value:string):void;
        getLastModified():string;
        setLastModified(value:string):void;
        getLastModifiedBy():string;
        setLastModifiedBy(value:string):void;
        getLastAccessed():string;
        setLastAccessed(value:string):void;
        getSourceLastModified():string;
        setSourceLastModified(value:string):void;
        getLabel():string;
        setLabel(value:string):void;
        getName():string;
        setName(value:string):void;
        getRepeated():boolean;
        setRepeated(value:boolean):void;
        getRowCount():number;
        setRowCount(value:number):void;
        getScope():string;
        setScope(value:string):void;
        getState():string;
        setState(value:string):void;
        getTableReference():CASTableReference;
        setTableReference(value:CASTableReference):void;
        getLinks():Array<Link>;
        setLinks(value:Array<Link>):void;
    }
    
    export = CASTableItem;
}


declare module "sas/ltjs/transport/models/media/cas/CASTableReference" {
    import TransportModel = require("sas/ltjs/transport/models/TransportModel");
    class CASTableReference extends TransportModel {
        constructor();
        getSessionId():string;
        setSessionId(value:string):void;
        getSourceCaslibName():string;
        setSourceCaslibName(value:string):void;
        getSourceTableName():string;
        setSourceTableName(value:string):void;
        getTableUri():string;
        setTableUri(value:string):void;
    }
    
    export = CASTableReference;
}


declare module "sas/ltjs/transport/models/media/naturalLanguage/request/NLUInterpretationsRequestBody" {
    import MediaType = require("sas/ltjs/transport/models/media/MediaType");
    class NLUInterpretationsRequestBody extends MediaType {
        constructor();
        getText():string;
        setText(value:string):void;
    }
    
    export = NLUInterpretationsRequestBody;
}


declare module "sas/ltjs/transport/models/media/naturalLanguage/request/NLUStringSetContext" {
    import MediaType = require("sas/ltjs/transport/models/media/MediaType");
    class NLUStringSetContext extends MediaType {
        constructor();
    }
    
    export = NLUStringSetContext;
}


declare module "sas/ltjs/transport/models/media/naturalLanguage/request/ReportViewerNLUInterpretationsRequestBody" {
    import NLUInterpretationsRequestBody = require("sas/ltjs/transport/models/media/naturalLanguage/request/NLUInterpretationsRequestBody");
    import ReportViewerNLUStringSetContext = require("sas/ltjs/transport/models/media/naturalLanguage/request/ReportViewerNLUStringSetContext");
    class ReportViewerNLUInterpretationsRequestBody extends NLUInterpretationsRequestBody {
        constructor();
        getId():number;
        setId(value:number):void;
        getGuid():string;
        setGuid(value:string):void;
        getDuid():string;
        setDuid(value:string):void;
        getLocation():string;
        setLocation(value:string):void;
        getAuthor():string;
        setAuthor(value:string):void;
        getCreatedOn():string;
        setCreatedOn(value:string):void;
        getStringSetContext():ReportViewerNLUStringSetContext;
        setStringSetContext(value:ReportViewerNLUStringSetContext):void;
    }
    
    export = ReportViewerNLUInterpretationsRequestBody;
}


declare module "sas/ltjs/transport/models/media/naturalLanguage/request/ReportViewerNLUStringSetContext" {
    import NLUStringSetContext = require("sas/ltjs/transport/models/media/naturalLanguage/request/NLUStringSetContext");
    class ReportViewerNLUStringSetContext extends NLUStringSetContext {
        constructor();
        getPageLabels():Array<string>;
        setPageLabels(value:Array<string>):void;
        getSubscribedReportLabels():Array<string>;
        setSubscribedReportLabels(value:Array<string>):void;
        getVisualLabels():Array<string>;
        setVisualLabels(value:Array<string>):void;
        getPromptLabels():Array<string>;
        setPromptLabels(value:Array<string>):void;
        getPrompt0Label():Array<string>;
        setPrompt0Label(value:Array<string>):void;
        getPrompt1Label():Array<string>;
        setPrompt1Label(value:Array<string>):void;
        getPrompt2Label():Array<string>;
        setPrompt2Label(value:Array<string>):void;
        getPrompt3Label():Array<string>;
        setPrompt3Label(value:Array<string>):void;
        getPrompt4Label():Array<string>;
        setPrompt4Label(value:Array<string>):void;
        getPrompt5Label():Array<string>;
        setPrompt5Label(value:Array<string>):void;
        getPrompt6Label():Array<string>;
        setPrompt6Label(value:Array<string>):void;
        getPrompt7Label():Array<string>;
        setPrompt7Label(value:Array<string>):void;
        getPrompt8Label():Array<string>;
        setPrompt8Label(value:Array<string>):void;
        getPrompt9Label():Array<string>;
        setPrompt9Label(value:Array<string>):void;
        getPrompt0Values():Array<string>;
        setPrompt0Values(value:Array<string>):void;
        getPrompt1Values():Array<string>;
        setPrompt1Values(value:Array<string>):void;
        getPrompt2Values():Array<string>;
        setPrompt2Values(value:Array<string>):void;
        getPrompt3Values():Array<string>;
        setPrompt3Values(value:Array<string>):void;
        getPrompt4Values():Array<string>;
        setPrompt4Values(value:Array<string>):void;
        getPrompt5Values():Array<string>;
        setPrompt5Values(value:Array<string>):void;
        getPrompt6Values():Array<string>;
        setPrompt6Values(value:Array<string>):void;
        getPrompt7Values():Array<string>;
        setPrompt7Values(value:Array<string>):void;
        getPrompt8Values():Array<string>;
        setPrompt8Values(value:Array<string>):void;
        getPrompt9Values():Array<string>;
        setPrompt9Values(value:Array<string>):void;
    }
    
    export = ReportViewerNLUStringSetContext;
}


declare module "sas/ltjs/transport/models/media/naturalLanguage/response/NLUDataSourceMetadata" {
    import TransportModel = require("sas/ltjs/transport/models/TransportModel");
    class NLUDataSourceMetadata extends TransportModel {
        constructor();
        getContextKey():string;
        setContextKey(value:string):void;
        getContextValue():string;
        setContextValue(value:string):void;
    }
    
    export = NLUDataSourceMetadata;
}


declare module "sas/ltjs/transport/models/media/naturalLanguage/response/NLUDomainTerm" {
    import TransportModel = require("sas/ltjs/transport/models/TransportModel");
    import NLUMatcherMetadata = require("sas/ltjs/transport/models/media/naturalLanguage/response/NLUMatcherMetadata");
    import NLUDataSourceMetadata = require("sas/ltjs/transport/models/media/naturalLanguage/response/NLUDataSourceMetadata");
    class NLUDomainTerm extends TransportModel {
        constructor();
        getVersion():number;
        setVersion(value:number):void;
        getScore():number;
        setScore(value:number):void;
        getLexeme():string;
        setLexeme(value:string):void;
        getMatchedInputText():string;
        setMatchedInputText(value:string):void;
        getMatchedDataSourceText():string;
        setMatchedDataSourceText(value:string):void;
        getMatcherMetadata():NLUMatcherMetadata;
        setMatcherMetadata(value:NLUMatcherMetadata):void;
        getDataSourceMetadata():NLUDataSourceMetadata;
        setDataSourceMetadata(value:NLUDataSourceMetadata):void;
    }
    
    export = NLUDomainTerm;
}


declare module "sas/ltjs/transport/models/media/naturalLanguage/response/NLUExpression" {
    import TransportModel = require("sas/ltjs/transport/models/TransportModel");
    import NLUInterpretationNode = require("sas/ltjs/transport/models/media/naturalLanguage/response/NLUInterpretationNode");
    class NLUExpression extends TransportModel {
        constructor();
        getVersion():number;
        setVersion(value:number):void;
        getRuleName():string;
        setRuleName(value:string):void;
        getInterpretationNodes():Array<NLUInterpretationNode>;
        setInterpretationNodes(value:Array<NLUInterpretationNode>):void;
    }
    
    export = NLUExpression;
}


declare module "sas/ltjs/transport/models/media/naturalLanguage/response/NLUInterpretation" {
    import TransportModel = require("sas/ltjs/transport/models/TransportModel");
    import NLUPartition = require("sas/ltjs/transport/models/media/naturalLanguage/response/NLUPartition");
    class NLUInterpretation extends TransportModel {
        constructor();
        getVersion():number;
        setVersion(value:number):void;
        getPartitions():Array<NLUPartition>;
        setPartitions(value:Array<NLUPartition>):void;
    }
    
    export = NLUInterpretation;
}


declare module "sas/ltjs/transport/models/media/naturalLanguage/response/NLUInterpretationNode" {
    import TransportModel = require("sas/ltjs/transport/models/TransportModel");
    import NLUDomainTerm = require("sas/ltjs/transport/models/media/naturalLanguage/response/NLUDomainTerm");
    class NLUInterpretationNode extends TransportModel {
        constructor();
        getVersion():number;
        setVersion(value:number):void;
        getNodeId():string;
        setNodeId(value:string):void;
        getArgs():Array<string>;
        setArgs(value:Array<string>):void;
        getDomainTerm():NLUDomainTerm;
        setDomainTerm(value:NLUDomainTerm):void;
    }
    
    export = NLUInterpretationNode;
}


declare module "sas/ltjs/transport/models/media/naturalLanguage/response/NLUInterpretationsResponseBody" {
    import MediaType = require("sas/ltjs/transport/models/media/MediaType");
    import NLUExpression = require("sas/ltjs/transport/models/media/naturalLanguage/response/NLUExpression");
    import NLUInterpretation = require("sas/ltjs/transport/models/media/naturalLanguage/response/NLUInterpretation");
    import Link = require("sas/ltjs/commons/models/particles/Link");
    class NLUInterpretationsResponseBody extends MediaType {
        constructor();
        getCreatedBy():string;
        setCreatedBy(value:string):void;
        getCreationTimeStamp():string;
        setCreationTimeStamp(value:string):void;
        getId():string;
        setId(value:string):void;
        getDomainId():string;
        setDomainId(value:string):void;
        getText():string;
        setText(value:string):void;
        getExpressions():Array<NLUExpression>;
        setExpressions(value:Array<NLUExpression>):void;
        getInterpretation():NLUInterpretation;
        setInterpretation(value:NLUInterpretation):void;
        getAlternatives():Array<NLUInterpretation>;
        setAlternatives(value:Array<NLUInterpretation>):void;
        getLinks():Array<Link>;
        setLinks(value:Array<Link>):void;
        getErrorCode():number;
        setErrorCode(value:number):void;
        getHttpStatusCode():number;
        setHttpStatusCode(value:number):void;
        getMessage():string;
        setMessage(value:string):void;
        getDetails():Array<string>;
        setDetails(value:Array<string>):void;
    }
    
    export = NLUInterpretationsResponseBody;
}


declare module "sas/ltjs/transport/models/media/naturalLanguage/response/NLUMatch" {
    import TransportModel = require("sas/ltjs/transport/models/TransportModel");
    class NLUMatch extends TransportModel {
        constructor();
        getScore():number;
        setScore(value:number):void;
        getOriginText():string;
        setOriginText(value:string):void;
        getMatchedText():string;
        setMatchedText(value:string):void;
    }
    
    export = NLUMatch;
}


declare module "sas/ltjs/transport/models/media/naturalLanguage/response/NLUMatcherMetadata" {
    import TransportModel = require("sas/ltjs/transport/models/TransportModel");
    import NLUMatcherMetadataAttributes = require("sas/ltjs/transport/models/media/naturalLanguage/response/NLUMatcherMetadataAttributes");
    class NLUMatcherMetadata extends TransportModel {
        constructor();
        getVersion():number;
        setVersion(value:number):void;
        getAttributes():NLUMatcherMetadataAttributes;
        setAttributes(value:NLUMatcherMetadataAttributes):void;
    }
    
    export = NLUMatcherMetadata;
}


declare module "sas/ltjs/transport/models/media/naturalLanguage/response/NLUMatcherMetadataAttributes" {
    import TransportModel = require("sas/ltjs/transport/models/TransportModel");
    import NLUMatch = require("sas/ltjs/transport/models/media/naturalLanguage/response/NLUMatch");
    class NLUMatcherMetadataAttributes extends TransportModel {
        constructor();
        getScoreDistribution():string;
        setScoreDistribution(value:string):void;
        getNumberValue():number;
        setNumberValue(value:number):void;
        getNormalizedNumberString():string;
        setNormalizedNumberString(value:string):void;
        getMatches():Array<NLUMatch>;
        setMatches(value:Array<NLUMatch>):void;
    }
    
    export = NLUMatcherMetadataAttributes;
}


declare module "sas/ltjs/transport/models/media/naturalLanguage/response/NLUPartition" {
    import TransportModel = require("sas/ltjs/transport/models/TransportModel");
    import NLUExpression = require("sas/ltjs/transport/models/media/naturalLanguage/response/NLUExpression");
    class NLUPartition extends TransportModel {
        constructor();
        getVersion():number;
        setVersion(value:number):void;
        getExpressions():Array<NLUExpression>;
        setExpressions(value:Array<NLUExpression>):void;
    }
    
    export = NLUPartition;
}


declare module "sas/ltjs/transport/models/media/naturalLanguage/response/ReportViewerNLUInterpretationsResponseBody" {
    import NLUInterpretationsResponseBody = require("sas/ltjs/transport/models/media/naturalLanguage/response/NLUInterpretationsResponseBody");
    import NLUStringSetContext = require("sas/ltjs/transport/models/media/naturalLanguage/request/NLUStringSetContext");
    class ReportViewerNLUInterpretationsResponseBody extends NLUInterpretationsResponseBody {
        constructor();
        getStringSetContext():NLUStringSetContext;
        setStringSetContext(value:NLUStringSetContext):void;
    }
    
    export = ReportViewerNLUInterpretationsResponseBody;
}


declare module "sas/ltjs/transport/models/media/textTemplates/response/TextTemplatesOutputResponseBody" {
    import MediaType = require("sas/ltjs/transport/models/media/MediaType");
    class TextTemplatesOutputResponseBody extends MediaType {
        constructor();
        getText():string;
        setText(value:string):void;
    }
    
    export = TextTemplatesOutputResponseBody;
}

