sas.ltjs.define(["require", "exports", "sas/ltjs/commons/ltjsEnvironment", "sas/ltjs/commons/events/EventDispatcher", "sas/ltjs/transport/lib", "sas/ltjs/transport/models/TransportModel"], function (require, exports, ltjsEnvironment_1, EventDispatcher_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var SupportedType = ltjsEnvironment_1.createModule([114, 13, 50265, 50258], EventDispatcher_1.default);
    /**
     *
     */
    SupportedType._create = function () {
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_SupportedType_create();
        //-- Convert abstract(commons::VOID) from jni(void) to js()
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::SupportedType)", "static", "new", "-->", "(transport::SupportedType)", rc);
        return rc;
    };
    /**
     * @return {string| null}
     */
    SupportedType.prototype.getName = function () {
        var name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("name");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), name_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::SupportedType)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#name", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    SupportedType.prototype.setName = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var name_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("name");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, name_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::SupportedType)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#name", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {boolean}
     */
    SupportedType.prototype.getSupportsReportLevelComments = function () {
        var supportsReportLevelComments_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("supportsReportLevelComments");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getBooleanProperty(this._getValidClosetAddress(), supportsReportLevelComments_jni);
        //-- Convert abstract(commons::BOOLEAN) from jni(bool) to js(boolean)
        var rc = !!rc_jni;
        Module.deps['TraceUtil'].log("(transport::SupportedType)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#supportsReportLevelComments", "-->", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(rc));
        return rc;
    };
    /**
     * @param {boolean} value
     *
     */
    SupportedType.prototype.setSupportsReportLevelComments = function (value) {
        //-- Convert abstract(commons::BOOLEAN) from js(boolean) to jni(bool)
        var value_jni = !!value;
        var supportsReportLevelComments_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("supportsReportLevelComments");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setBooleanProperty(this._getValidClosetAddress(), value_jni, supportsReportLevelComments_name_jni);
        Module.deps['TraceUtil'].log("(transport::SupportedType)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#supportsReportLevelComments", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(value));
        return this;
    };
    /**
     * @return {boolean}
     */
    SupportedType.prototype.getSupportsObjectLevelComments = function () {
        var supportsObjectLevelComments_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("supportsObjectLevelComments");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getBooleanProperty(this._getValidClosetAddress(), supportsObjectLevelComments_jni);
        //-- Convert abstract(commons::BOOLEAN) from jni(bool) to js(boolean)
        var rc = !!rc_jni;
        Module.deps['TraceUtil'].log("(transport::SupportedType)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#supportsObjectLevelComments", "-->", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(rc));
        return rc;
    };
    /**
     * @param {boolean} value
     *
     */
    SupportedType.prototype.setSupportsObjectLevelComments = function (value) {
        //-- Convert abstract(commons::BOOLEAN) from js(boolean) to jni(bool)
        var value_jni = !!value;
        var supportsObjectLevelComments_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("supportsObjectLevelComments");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setBooleanProperty(this._getValidClosetAddress(), value_jni, supportsObjectLevelComments_name_jni);
        Module.deps['TraceUtil'].log("(transport::SupportedType)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#supportsObjectLevelComments", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(value));
        return this;
    };
    /**
     * @return {boolean}
     */
    SupportedType.prototype.getSupportsPrinting = function () {
        var supportsPrinting_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("supportsPrinting");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getBooleanProperty(this._getValidClosetAddress(), supportsPrinting_jni);
        //-- Convert abstract(commons::BOOLEAN) from jni(bool) to js(boolean)
        var rc = !!rc_jni;
        Module.deps['TraceUtil'].log("(transport::SupportedType)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#supportsPrinting", "-->", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(rc));
        return rc;
    };
    /**
     * @param {boolean} value
     *
     */
    SupportedType.prototype.setSupportsPrinting = function (value) {
        //-- Convert abstract(commons::BOOLEAN) from js(boolean) to jni(bool)
        var value_jni = !!value;
        var supportsPrinting_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("supportsPrinting");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setBooleanProperty(this._getValidClosetAddress(), value_jni, supportsPrinting_name_jni);
        Module.deps['TraceUtil'].log("(transport::SupportedType)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#supportsPrinting", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(value));
        return this;
    };
    exports.default = SupportedType;
});
