sas.ltjs.define(["require", "exports", "sas/ltjs/commons/ltjsEnvironment", "sas/ltjs/commons/WrappableCloset", "sas/ltjs/commons/events/EventDispatcher", "sas/ltjs/transport/lib", "sas/ltjs/transport/models/TransportModel", "./ReportLocationPair"], function (require, exports, ltjsEnvironment_1, WrappableCloset_1, EventDispatcher_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var ReportLocationPairs = ltjsEnvironment_1.createModule([114, 13, 50265, 50208], EventDispatcher_1.default);
    /**
     *
     */
    ReportLocationPairs._create = function () {
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_ReportLocationPairs_create();
        //-- Convert abstract(commons::VOID) from jni(void) to js()
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::ReportLocationPairs)", "static", "new", "-->", "(transport::ReportLocationPairs)", rc);
        return rc;
    };
    /**
     * @return {Array.<ReportLocationPair| null> | null}
     */
    ReportLocationPairs.prototype.getPairs = function () {
        var pairs_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("pairs");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getWrappableVectorProperty(this._getValidClosetAddress(), pairs_jni);
        //-- Convert abstract(<transport::ReportLocationPair>) from jni(size_t) to js(ReportLocationPair)
        var rc = WrappableCloset_1.getWrapperArray(rc_jni);
        Module.deps['TraceUtil'].log("(transport::ReportLocationPairs)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#pairs", "-->", "(MONITORED_VECTOR<transport::ReportLocationPair>)", Module.deps['TraceUtil'].traceConversions.convertArray(rc, Module.deps['TraceUtil'].traceConversions.convertModel));
        return rc;
    };
    /**
     * @param {Array.<ReportLocationPair| null> | null} value
     *
     */
    ReportLocationPairs.prototype.setPairs = function (value) {
        //-- Convert abstract(<transport::ReportLocationPair>) from js(ReportLocationPair) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertObjectArrayToC(value);
        var pairs_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("pairs");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setWrappableVectorProperty(this._getValidClosetAddress(), value_jni, pairs_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::ReportLocationPairs)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#pairs", "(MONITORED_VECTOR<transport::ReportLocationPair>)", Module.deps['TraceUtil'].traceConversions.convertArray(value, Module.deps['TraceUtil'].traceConversions.convertModel));
        return this;
    };
    exports.default = ReportLocationPairs;
});
