sas.ltjs.define(["require", "exports", "sas/ltjs/commons/ltjsEnvironment", "sas/ltjs/commons/WrappableCloset", "sas/ltjs/commons/ClosetObject", "sas/ltjs/commons/events/EventDispatcher", "sas/ltjs/transport/lib", "sas/ltjs/transport/models/TransportModel", "sas/ltjs/transport/models/local/Report"], function (require, exports, ltjsEnvironment_1, WrappableCloset_1, ClosetObject_1, EventDispatcher_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var ReportLocationPair = ltjsEnvironment_1.createModule([114, 13, 50265, 50207], EventDispatcher_1.default);
    /**
     *
     */
    ReportLocationPair._create = function () {
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_ReportLocationPair_create();
        //-- Convert abstract(commons::VOID) from jni(void) to js()
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::ReportLocationPair)", "static", "new", "-->", "(transport::ReportLocationPair)", rc);
        return rc;
    };
    /**
     * @return {string| null}
     */
    ReportLocationPair.prototype.getReportPath = function () {
        var reportPath_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("reportPath");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), reportPath_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::ReportLocationPair)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#reportPath", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    ReportLocationPair.prototype.setReportPath = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var reportPath_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("reportPath");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, reportPath_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::ReportLocationPair)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#reportPath", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    ReportLocationPair.prototype.getServerLocation = function () {
        var serverLocation_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("serverLocation");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), serverLocation_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::ReportLocationPair)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#serverLocation", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    ReportLocationPair.prototype.setServerLocation = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var serverLocation_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("serverLocation");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, serverLocation_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::ReportLocationPair)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#serverLocation", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {Report| null}
     */
    ReportLocationPair.prototype.getReport = function () {
        var report_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("report");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getWrappableProperty(this._getValidClosetAddress(), report_jni);
        //-- Convert abstract(transport::Report) from jni(size_t) to js(Report)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::ReportLocationPair)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#report", "-->", "(transport::Report)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * @param {Report| null} value
     *
     */
    ReportLocationPair.prototype.setReport = function (value) {
        //-- Convert abstract(transport::Report) from js(Report) to jni(size_t)
        var value_jni = ClosetObject_1.default._getValidClosetAddress(value);
        var report_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("report");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setWrappableProperty(this._getValidClosetAddress(), value_jni, report_name_jni);
        Module.deps['TraceUtil'].log("(transport::ReportLocationPair)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#report", "(transport::Report)", Module.deps['TraceUtil'].traceConversions.convertModel(value));
        return this;
    };
    exports.default = ReportLocationPair;
});
