sas.ltjs.define(["require", "exports", "sas/ltjs/commons/ltjsEnvironment", "sas/ltjs/commons/events/EventDispatcher", "sas/ltjs/transport/lib", "sas/ltjs/transport/models/TransportModel"], function (require, exports, ltjsEnvironment_1, EventDispatcher_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var IdResources = ltjsEnvironment_1.createModule([114, 13, 50265, 50149], EventDispatcher_1.default);
    /**
     *
     */
    IdResources._create = function () {
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_IdResources_create();
        //-- Convert abstract(commons::VOID) from jni(void) to js()
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::IdResources)", "static", "new", "-->", "(transport::IdResources)", rc);
        return rc;
    };
    /**
     * @return {Array.<string| null> | null}
     */
    IdResources.prototype.getId = function () {
        var id_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("id");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringVectorProperty(this._getValidClosetAddress(), id_jni);
        //-- Convert abstract(<commons::STRING>) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringArrayFromC(rc_jni);
        Module.deps['TraceUtil'].log("(transport::IdResources)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#id", "-->", "(MONITORED_VECTOR<commons::STRING>)", Module.deps['TraceUtil'].traceConversions.convertArray(rc, Module.deps['TraceUtil'].traceConversions.convertString));
        return rc;
    };
    /**
     * @param {Array.<string| null> | null} value
     *
     */
    IdResources.prototype.setId = function (value) {
        //-- Convert abstract(<commons::STRING>) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringArrayToC(value);
        var id_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("id");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringVectorProperty(this._getValidClosetAddress(), value_jni, id_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releaseAllPrimitives(value_jni);
        Module.deps['TraceUtil'].log("(transport::IdResources)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#id", "(MONITORED_VECTOR<commons::STRING>)", Module.deps['TraceUtil'].traceConversions.convertArray(value, Module.deps['TraceUtil'].traceConversions.convertString));
        return this;
    };
    exports.default = IdResources;
});
