sas.ltjs.define(["require", "exports", "sas/ltjs/commons/ltjsEnvironment", "sas/ltjs/commons/WrappableCloset", "sas/ltjs/commons/ClosetObject", "sas/ltjs/commons/events/EventDispatcher", "sas/ltjs/transport/lib", "sas/ltjs/transport/models/TransportModel", "sas/ltjs/transport/models/media/Comment", "sas/ltjs/transport/models/media/FileItem"], function (require, exports, ltjsEnvironment_1, WrappableCloset_1, ClosetObject_1, EventDispatcher_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var CommentAttachmentInfo = ltjsEnvironment_1.createModule([114, 13, 50265, 50063], EventDispatcher_1.default);
    /**
     *
     */
    CommentAttachmentInfo._create = function () {
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_CommentAttachmentInfo_create();
        //-- Convert abstract(commons::VOID) from jni(void) to js()
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::CommentAttachmentInfo)", "static", "new", "-->", "(transport::CommentAttachmentInfo)", rc);
        return rc;
    };
    /**
     * @return {number}
     */
    CommentAttachmentInfo.prototype.getAttachmentId = function () {
        var attachmentId_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("attachmentId");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getIntProperty(this._getValidClosetAddress(), attachmentId_jni);
        //-- Convert abstract(commons::INT) from jni(int) to js(number)
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::CommentAttachmentInfo)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#attachmentId", "-->", "(commons::INT)", Module.deps['TraceUtil'].traceConversions.convertInt(rc));
        return rc;
    };
    /**
     * @param {number} value
     *
     */
    CommentAttachmentInfo.prototype.setAttachmentId = function (value) {
        //-- Convert abstract(commons::INT) from js(number) to jni(int)
        var value_jni = value;
        var attachmentId_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("attachmentId");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setIntProperty(this._getValidClosetAddress(), value_jni, attachmentId_name_jni);
        Module.deps['TraceUtil'].log("(transport::CommentAttachmentInfo)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#attachmentId", "(commons::INT)", Module.deps['TraceUtil'].traceConversions.convertInt(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    CommentAttachmentInfo.prototype.getName = function () {
        var name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("name");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), name_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::CommentAttachmentInfo)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#name", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    CommentAttachmentInfo.prototype.setName = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var name_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("name");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, name_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::CommentAttachmentInfo)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#name", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    CommentAttachmentInfo.prototype.getDocType = function () {
        var docType_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("docType");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), docType_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::CommentAttachmentInfo)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#docType", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    CommentAttachmentInfo.prototype.setDocType = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var docType_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("docType");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, docType_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::CommentAttachmentInfo)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#docType", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {number}
     */
    CommentAttachmentInfo.prototype.getSize = function () {
        var size_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("size");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getIntProperty(this._getValidClosetAddress(), size_jni);
        //-- Convert abstract(commons::INT) from jni(int) to js(number)
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::CommentAttachmentInfo)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#size", "-->", "(commons::INT)", Module.deps['TraceUtil'].traceConversions.convertInt(rc));
        return rc;
    };
    /**
     * @param {number} value
     *
     */
    CommentAttachmentInfo.prototype.setSize = function (value) {
        //-- Convert abstract(commons::INT) from js(number) to jni(int)
        var value_jni = value;
        var size_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("size");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setIntProperty(this._getValidClosetAddress(), value_jni, size_name_jni);
        Module.deps['TraceUtil'].log("(transport::CommentAttachmentInfo)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#size", "(commons::INT)", Module.deps['TraceUtil'].traceConversions.convertInt(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    CommentAttachmentInfo.prototype.getUrlString = function () {
        var urlString_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("urlString");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), urlString_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::CommentAttachmentInfo)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#urlString", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    CommentAttachmentInfo.prototype.setUrlString = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var urlString_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("urlString");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, urlString_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::CommentAttachmentInfo)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#urlString", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {Comment| null}
     */
    CommentAttachmentInfo.prototype.getComment = function () {
        var comment_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("comment");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getWrappableProperty(this._getValidClosetAddress(), comment_jni);
        //-- Convert abstract(transport::Comment) from jni(size_t) to js(Comment)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::CommentAttachmentInfo)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#comment", "-->", "(transport::Comment)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * @param {Comment| null} value
     *
     */
    CommentAttachmentInfo.prototype.setComment = function (value) {
        //-- Convert abstract(transport::Comment) from js(Comment) to jni(size_t)
        var value_jni = ClosetObject_1.default._getValidClosetAddress(value);
        var comment_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("comment");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setWrappableProperty(this._getValidClosetAddress(), value_jni, comment_name_jni);
        Module.deps['TraceUtil'].log("(transport::CommentAttachmentInfo)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#comment", "(transport::Comment)", Module.deps['TraceUtil'].traceConversions.convertModel(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    CommentAttachmentInfo.prototype.getUuid = function () {
        var uuid_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("uuid");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), uuid_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::CommentAttachmentInfo)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#uuid", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    CommentAttachmentInfo.prototype.setUuid = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var uuid_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("uuid");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, uuid_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::CommentAttachmentInfo)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#uuid", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {FileItem| null}
     */
    CommentAttachmentInfo.prototype.getFileItem = function () {
        var fileItem_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("fileItem");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getWrappableProperty(this._getValidClosetAddress(), fileItem_jni);
        //-- Convert abstract(transport::FileItem) from jni(size_t) to js(FileItem)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::CommentAttachmentInfo)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#fileItem", "-->", "(transport::FileItem)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * @param {FileItem| null} value
     *
     */
    CommentAttachmentInfo.prototype.setFileItem = function (value) {
        //-- Convert abstract(transport::FileItem) from js(FileItem) to jni(size_t)
        var value_jni = ClosetObject_1.default._getValidClosetAddress(value);
        var fileItem_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("fileItem");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setWrappableProperty(this._getValidClosetAddress(), value_jni, fileItem_name_jni);
        Module.deps['TraceUtil'].log("(transport::CommentAttachmentInfo)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#fileItem", "(transport::FileItem)", Module.deps['TraceUtil'].traceConversions.convertModel(value));
        return this;
    };
    exports.default = CommentAttachmentInfo;
});
