sas.ltjs.define(["require", "exports", "sas/ltjs/commons/ltjsEnvironment", "sas/ltjs/commons/WrappableCloset", "sas/ltjs/commons/ClosetObject", "sas/ltjs/commons/events/EventDispatcher", "sas/ltjs/transport/lib", "sas/ltjs/transport/models/TransportModel", "sas/ltjs/transport/models/local/FileData"], function (require, exports, ltjsEnvironment_1, WrappableCloset_1, ClosetObject_1, EventDispatcher_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var CommentAttachment = ltjsEnvironment_1.createModule([114, 13, 50265, 50062], EventDispatcher_1.default);
    /**
     *
     */
    CommentAttachment._create = function () {
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_CommentAttachment_create();
        //-- Convert abstract(commons::VOID) from jni(void) to js()
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::CommentAttachment)", "static", "new", "-->", "(transport::CommentAttachment)", rc);
        return rc;
    };
    /**
     * @return {string| null}
     */
    CommentAttachment.prototype.getXmlElementName = function () {
        var xmlElementName_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("xmlElementName");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), xmlElementName_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::CommentAttachment)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#xmlElementName", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    CommentAttachment.prototype.setXmlElementName = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var xmlElementName_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("xmlElementName");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, xmlElementName_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::CommentAttachment)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#xmlElementName", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {number}
     */
    CommentAttachment.prototype.getAttachmentId = function () {
        var attachmentId_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("attachmentId");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getIntProperty(this._getValidClosetAddress(), attachmentId_jni);
        //-- Convert abstract(commons::INT) from jni(int) to js(number)
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::CommentAttachment)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#attachmentId", "-->", "(commons::INT)", Module.deps['TraceUtil'].traceConversions.convertInt(rc));
        return rc;
    };
    /**
     * @param {number} value
     *
     */
    CommentAttachment.prototype.setAttachmentId = function (value) {
        //-- Convert abstract(commons::INT) from js(number) to jni(int)
        var value_jni = value;
        var attachmentId_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("attachmentId");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setIntProperty(this._getValidClosetAddress(), value_jni, attachmentId_name_jni);
        Module.deps['TraceUtil'].log("(transport::CommentAttachment)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#attachmentId", "(commons::INT)", Module.deps['TraceUtil'].traceConversions.convertInt(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    CommentAttachment.prototype.getName = function () {
        var name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("name");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), name_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::CommentAttachment)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#name", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    CommentAttachment.prototype.setName = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var name_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("name");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, name_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::CommentAttachment)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#name", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    CommentAttachment.prototype.getDocType = function () {
        var docType_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("docType");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), docType_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::CommentAttachment)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#docType", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    CommentAttachment.prototype.setDocType = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var docType_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("docType");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, docType_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::CommentAttachment)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#docType", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {number}
     */
    CommentAttachment.prototype.getObjectType = function () {
        var objectType_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("objectType");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getIntProperty(this._getValidClosetAddress(), objectType_jni);
        //-- Convert abstract(commons::INT) from jni(int) to js(number)
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::CommentAttachment)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#objectType", "-->", "(commons::INT)", Module.deps['TraceUtil'].traceConversions.convertInt(rc));
        return rc;
    };
    /**
     * @param {number} value
     *
     */
    CommentAttachment.prototype.setObjectType = function (value) {
        //-- Convert abstract(commons::INT) from js(number) to jni(int)
        var value_jni = value;
        var objectType_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("objectType");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setIntProperty(this._getValidClosetAddress(), value_jni, objectType_name_jni);
        Module.deps['TraceUtil'].log("(transport::CommentAttachment)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#objectType", "(commons::INT)", Module.deps['TraceUtil'].traceConversions.convertInt(value));
        return this;
    };
    /**
     * @return {number}
     */
    CommentAttachment.prototype.getSize = function () {
        var size_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("size");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getIntProperty(this._getValidClosetAddress(), size_jni);
        //-- Convert abstract(commons::INT) from jni(int) to js(number)
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::CommentAttachment)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#size", "-->", "(commons::INT)", Module.deps['TraceUtil'].traceConversions.convertInt(rc));
        return rc;
    };
    /**
     * @param {number} value
     *
     */
    CommentAttachment.prototype.setSize = function (value) {
        //-- Convert abstract(commons::INT) from js(number) to jni(int)
        var value_jni = value;
        var size_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("size");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setIntProperty(this._getValidClosetAddress(), value_jni, size_name_jni);
        Module.deps['TraceUtil'].log("(transport::CommentAttachment)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#size", "(commons::INT)", Module.deps['TraceUtil'].traceConversions.convertInt(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    CommentAttachment.prototype.getUrlString = function () {
        var urlString_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("urlString");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), urlString_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::CommentAttachment)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#urlString", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    CommentAttachment.prototype.setUrlString = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var urlString_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("urlString");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, urlString_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::CommentAttachment)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#urlString", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {FileData| null}
     */
    CommentAttachment.prototype.getData = function () {
        var data_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("data");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getWrappableProperty(this._getValidClosetAddress(), data_jni);
        //-- Convert abstract(transport::FileData) from jni(size_t) to js(FileData)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::CommentAttachment)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#data", "-->", "(transport::FileData)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * @param {FileData| null} value
     *
     */
    CommentAttachment.prototype.setData = function (value) {
        //-- Convert abstract(transport::FileData) from js(FileData) to jni(size_t)
        var value_jni = ClosetObject_1.default._getValidClosetAddress(value);
        var data_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("data");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setWrappableProperty(this._getValidClosetAddress(), value_jni, data_name_jni);
        Module.deps['TraceUtil'].log("(transport::CommentAttachment)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#data", "(transport::FileData)", Module.deps['TraceUtil'].traceConversions.convertModel(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    CommentAttachment.prototype.getXmlSchemaInstance = function () {
        var xmlSchemaInstance_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("xmlSchemaInstance");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), xmlSchemaInstance_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::CommentAttachment)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#xmlSchemaInstance", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    CommentAttachment.prototype.setXmlSchemaInstance = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var xmlSchemaInstance_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("xmlSchemaInstance");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, xmlSchemaInstance_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::CommentAttachment)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#xmlSchemaInstance", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    CommentAttachment.prototype.getXsiType = function () {
        var xsiType_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("xsiType");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), xsiType_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::CommentAttachment)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#xsiType", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    CommentAttachment.prototype.setXsiType = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var xsiType_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("xsiType");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, xsiType_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::CommentAttachment)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#xsiType", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    exports.default = CommentAttachment;
});
