sas.ltjs.define(["require", "exports", "sas/ltjs/commons/ltjsEnvironment", "sas/ltjs/commons/events/EventDispatcher", "sas/ltjs/transport/lib", "sas/ltjs/transport/models/TransportModel", "./AlertIntervalControl", "./AlertInterval"], function (require, exports, ltjsEnvironment_1, EventDispatcher_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var AlertSubscriptionInterval = ltjsEnvironment_1.createModule([114, 13, 50265, 50017], EventDispatcher_1.default);
    /**
     *
     */
    AlertSubscriptionInterval._create = function () {
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_AlertSubscriptionInterval_create();
        //-- Convert abstract(commons::VOID) from jni(void) to js()
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::AlertSubscriptionInterval)", "static", "new", "-->", "(transport::AlertSubscriptionInterval)", rc);
        return rc;
    };
    /**
     * @return {AlertIntervalControl}
     */
    AlertSubscriptionInterval.prototype.getIntervalControl = function () {
        var intervalControl_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("intervalControl");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getIntProperty(this._getValidClosetAddress(), intervalControl_jni);
        //-- Convert abstract(transport::AlertIntervalControl) from jni(int) to js(AlertIntervalControl)
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::AlertSubscriptionInterval)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#intervalControl", "-->", "(transport::AlertIntervalControl::type)", Module.deps['TraceUtil'].traceConversions.convertEnum(rc));
        return rc;
    };
    /**
     * @param {AlertIntervalControl} value
     *
     */
    AlertSubscriptionInterval.prototype.setIntervalControl = function (value) {
        //-- Convert abstract(transport::AlertIntervalControl) from js(AlertIntervalControl) to jni(int)
        var value_jni = value;
        var intervalControl_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("intervalControl");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setIntProperty(this._getValidClosetAddress(), value_jni, intervalControl_name_jni);
        Module.deps['TraceUtil'].log("(transport::AlertSubscriptionInterval)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#intervalControl", "(transport::AlertIntervalControl::type)", Module.deps['TraceUtil'].traceConversions.convertEnum(value));
        return this;
    };
    /**
     * @return {AlertInterval}
     */
    AlertSubscriptionInterval.prototype.getIntervalUnit = function () {
        var intervalUnit_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("intervalUnit");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getIntProperty(this._getValidClosetAddress(), intervalUnit_jni);
        //-- Convert abstract(transport::AlertInterval) from jni(int) to js(AlertInterval)
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::AlertSubscriptionInterval)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#intervalUnit", "-->", "(transport::AlertInterval::type)", Module.deps['TraceUtil'].traceConversions.convertEnum(rc));
        return rc;
    };
    /**
     * @param {AlertInterval} value
     *
     */
    AlertSubscriptionInterval.prototype.setIntervalUnit = function (value) {
        //-- Convert abstract(transport::AlertInterval) from js(AlertInterval) to jni(int)
        var value_jni = value;
        var intervalUnit_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("intervalUnit");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setIntProperty(this._getValidClosetAddress(), value_jni, intervalUnit_name_jni);
        Module.deps['TraceUtil'].log("(transport::AlertSubscriptionInterval)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#intervalUnit", "(transport::AlertInterval::type)", Module.deps['TraceUtil'].traceConversions.convertEnum(value));
        return this;
    };
    /**
     * @return {number}
     */
    AlertSubscriptionInterval.prototype.getIntervalValue = function () {
        var intervalValue_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("intervalValue");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getIntProperty(this._getValidClosetAddress(), intervalValue_jni);
        //-- Convert abstract(commons::INT) from jni(int) to js(number)
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::AlertSubscriptionInterval)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#intervalValue", "-->", "(commons::INT)", Module.deps['TraceUtil'].traceConversions.convertInt(rc));
        return rc;
    };
    /**
     * @param {number} value
     *
     */
    AlertSubscriptionInterval.prototype.setIntervalValue = function (value) {
        //-- Convert abstract(commons::INT) from js(number) to jni(int)
        var value_jni = value;
        var intervalValue_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("intervalValue");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setIntProperty(this._getValidClosetAddress(), value_jni, intervalValue_name_jni);
        Module.deps['TraceUtil'].log("(transport::AlertSubscriptionInterval)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#intervalValue", "(commons::INT)", Module.deps['TraceUtil'].traceConversions.convertInt(value));
        return this;
    };
    exports.default = AlertSubscriptionInterval;
});
