sas.ltjs.define(["require", "exports", "sas/ltjs/commons/ltjsEnvironment", "sas/ltjs/commons/events/EventDispatcher", "sas/ltjs/transport/lib", "sas/ltjs/transport/models/TransportModel"], function (require, exports, ltjsEnvironment_1, EventDispatcher_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var AlertSubscriber = ltjsEnvironment_1.createModule([114, 13, 50265, 50015], EventDispatcher_1.default);
    /**
     *
     */
    AlertSubscriber._create = function () {
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_AlertSubscriber_create();
        //-- Convert abstract(commons::VOID) from jni(void) to js()
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::AlertSubscriber)", "static", "new", "-->", "(transport::AlertSubscriber)", rc);
        return rc;
    };
    /**
     * @return {string| null}
     */
    AlertSubscriber.prototype.getUserId = function () {
        var userId_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("userId");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), userId_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::AlertSubscriber)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#userId", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    AlertSubscriber.prototype.setUserId = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var userId_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("userId");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, userId_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::AlertSubscriber)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#userId", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {boolean}
     */
    AlertSubscriber.prototype.getGroup = function () {
        var group_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("group");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getBooleanProperty(this._getValidClosetAddress(), group_jni);
        //-- Convert abstract(commons::BOOLEAN) from jni(bool) to js(boolean)
        var rc = !!rc_jni;
        Module.deps['TraceUtil'].log("(transport::AlertSubscriber)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#group", "-->", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(rc));
        return rc;
    };
    /**
     * @param {boolean} value
     *
     */
    AlertSubscriber.prototype.setGroup = function (value) {
        //-- Convert abstract(commons::BOOLEAN) from js(boolean) to jni(bool)
        var value_jni = !!value;
        var group_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("group");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setBooleanProperty(this._getValidClosetAddress(), value_jni, group_name_jni);
        Module.deps['TraceUtil'].log("(transport::AlertSubscriber)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#group", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(value));
        return this;
    };
    /**
     * @return {boolean}
     */
    AlertSubscriber.prototype.getSendEmail = function () {
        var sendEmail_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("sendEmail");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getBooleanProperty(this._getValidClosetAddress(), sendEmail_jni);
        //-- Convert abstract(commons::BOOLEAN) from jni(bool) to js(boolean)
        var rc = !!rc_jni;
        Module.deps['TraceUtil'].log("(transport::AlertSubscriber)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#sendEmail", "-->", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(rc));
        return rc;
    };
    /**
     * @param {boolean} value
     *
     */
    AlertSubscriber.prototype.setSendEmail = function (value) {
        //-- Convert abstract(commons::BOOLEAN) from js(boolean) to jni(bool)
        var value_jni = !!value;
        var sendEmail_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("sendEmail");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setBooleanProperty(this._getValidClosetAddress(), value_jni, sendEmail_name_jni);
        Module.deps['TraceUtil'].log("(transport::AlertSubscriber)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#sendEmail", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(value));
        return this;
    };
    /**
     * @return {boolean}
     */
    AlertSubscriber.prototype.getSendSMS = function () {
        var sendSMS_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("sendSMS");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getBooleanProperty(this._getValidClosetAddress(), sendSMS_jni);
        //-- Convert abstract(commons::BOOLEAN) from jni(bool) to js(boolean)
        var rc = !!rc_jni;
        Module.deps['TraceUtil'].log("(transport::AlertSubscriber)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#sendSMS", "-->", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(rc));
        return rc;
    };
    /**
     * @param {boolean} value
     *
     */
    AlertSubscriber.prototype.setSendSMS = function (value) {
        //-- Convert abstract(commons::BOOLEAN) from js(boolean) to jni(bool)
        var value_jni = !!value;
        var sendSMS_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("sendSMS");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setBooleanProperty(this._getValidClosetAddress(), value_jni, sendSMS_name_jni);
        Module.deps['TraceUtil'].log("(transport::AlertSubscriber)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#sendSMS", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(value));
        return this;
    };
    /**
     * @return {boolean}
     */
    AlertSubscriber.prototype.getRetainNotification = function () {
        var retainNotification_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("retainNotification");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getBooleanProperty(this._getValidClosetAddress(), retainNotification_jni);
        //-- Convert abstract(commons::BOOLEAN) from jni(bool) to js(boolean)
        var rc = !!rc_jni;
        Module.deps['TraceUtil'].log("(transport::AlertSubscriber)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#retainNotification", "-->", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(rc));
        return rc;
    };
    /**
     * @param {boolean} value
     *
     */
    AlertSubscriber.prototype.setRetainNotification = function (value) {
        //-- Convert abstract(commons::BOOLEAN) from js(boolean) to jni(bool)
        var value_jni = !!value;
        var retainNotification_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("retainNotification");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setBooleanProperty(this._getValidClosetAddress(), value_jni, retainNotification_name_jni);
        Module.deps['TraceUtil'].log("(transport::AlertSubscriber)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#retainNotification", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    AlertSubscriber.prototype.getOverrideEmail = function () {
        var overrideEmail_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("overrideEmail");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), overrideEmail_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::AlertSubscriber)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#overrideEmail", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    AlertSubscriber.prototype.setOverrideEmail = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var overrideEmail_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("overrideEmail");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, overrideEmail_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::AlertSubscriber)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#overrideEmail", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    AlertSubscriber.prototype.getOverrideSMS = function () {
        var overrideSMS_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("overrideSMS");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), overrideSMS_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::AlertSubscriber)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#overrideSMS", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    AlertSubscriber.prototype.setOverrideSMS = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var overrideSMS_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("overrideSMS");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, overrideSMS_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::AlertSubscriber)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#overrideSMS", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    exports.default = AlertSubscriber;
});
