sas.ltjs.define(["require", "exports", "sas/ltjs/commons/ltjsEnvironment", "sas/ltjs/commons/WrappableCloset", "sas/ltjs/commons/ClosetObject", "sas/ltjs/commons/events/EventDispatcher", "sas/ltjs/transport/lib", "sas/ltjs/transport/models/TransportModel", "./NLUMatcherMetadataAttributes"], function (require, exports, ltjsEnvironment_1, WrappableCloset_1, ClosetObject_1, EventDispatcher_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var NLUMatcherMetadata = ltjsEnvironment_1.createModule([114, 13, 50265, 50174], EventDispatcher_1.default);
    /**
     *
     */
    NLUMatcherMetadata._create = function () {
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_NLUMatcherMetadata_create();
        //-- Convert abstract(commons::VOID) from jni(void) to js()
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::NLUMatcherMetadata)", "static", "new", "-->", "(transport::NLUMatcherMetadata)", rc);
        return rc;
    };
    /**
     * @return {number}
     */
    NLUMatcherMetadata.prototype.getVersion = function () {
        var version_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("version");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getIntProperty(this._getValidClosetAddress(), version_jni);
        //-- Convert abstract(commons::INT) from jni(int) to js(number)
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::NLUMatcherMetadata)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#version", "-->", "(commons::INT)", Module.deps['TraceUtil'].traceConversions.convertInt(rc));
        return rc;
    };
    /**
     * @param {number} value
     *
     */
    NLUMatcherMetadata.prototype.setVersion = function (value) {
        //-- Convert abstract(commons::INT) from js(number) to jni(int)
        var value_jni = value;
        var version_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("version");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setIntProperty(this._getValidClosetAddress(), value_jni, version_name_jni);
        Module.deps['TraceUtil'].log("(transport::NLUMatcherMetadata)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#version", "(commons::INT)", Module.deps['TraceUtil'].traceConversions.convertInt(value));
        return this;
    };
    /**
     * @return {NLUMatcherMetadataAttributes| null}
     */
    NLUMatcherMetadata.prototype.getAttributes = function () {
        var attributes_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("attributes");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getWrappableProperty(this._getValidClosetAddress(), attributes_jni);
        //-- Convert abstract(transport::NLUMatcherMetadataAttributes) from jni(size_t) to js(NLUMatcherMetadataAttributes)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::NLUMatcherMetadata)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#attributes", "-->", "(transport::NLUMatcherMetadataAttributes)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * @param {NLUMatcherMetadataAttributes| null} value
     *
     */
    NLUMatcherMetadata.prototype.setAttributes = function (value) {
        //-- Convert abstract(transport::NLUMatcherMetadataAttributes) from js(NLUMatcherMetadataAttributes) to jni(size_t)
        var value_jni = ClosetObject_1.default._getValidClosetAddress(value);
        var attributes_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("attributes");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setWrappableProperty(this._getValidClosetAddress(), value_jni, attributes_name_jni);
        Module.deps['TraceUtil'].log("(transport::NLUMatcherMetadata)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#attributes", "(transport::NLUMatcherMetadataAttributes)", Module.deps['TraceUtil'].traceConversions.convertModel(value));
        return this;
    };
    exports.default = NLUMatcherMetadata;
});
