sas.ltjs.define(["require", "exports", "sas/ltjs/commons/ltjsEnvironment", "sas/ltjs/commons/events/EventDispatcher", "sas/ltjs/transport/lib", "sas/ltjs/transport/models/TransportModel"], function (require, exports, ltjsEnvironment_1, EventDispatcher_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var NLUDataSourceMetadata = ltjsEnvironment_1.createModule([114, 13, 50265, 50166], EventDispatcher_1.default);
    /**
     *
     */
    NLUDataSourceMetadata._create = function () {
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_NLUDataSourceMetadata_create();
        //-- Convert abstract(commons::VOID) from jni(void) to js()
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::NLUDataSourceMetadata)", "static", "new", "-->", "(transport::NLUDataSourceMetadata)", rc);
        return rc;
    };
    /**
     * @return {string| null}
     */
    NLUDataSourceMetadata.prototype.getContextKey = function () {
        var contextKey_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("contextKey");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), contextKey_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::NLUDataSourceMetadata)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#contextKey", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    NLUDataSourceMetadata.prototype.setContextKey = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var contextKey_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("contextKey");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, contextKey_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::NLUDataSourceMetadata)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#contextKey", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    NLUDataSourceMetadata.prototype.getContextValue = function () {
        var contextValue_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("contextValue");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), contextValue_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::NLUDataSourceMetadata)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#contextValue", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    NLUDataSourceMetadata.prototype.setContextValue = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var contextValue_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("contextValue");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, contextValue_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::NLUDataSourceMetadata)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#contextValue", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    exports.default = NLUDataSourceMetadata;
});
