sas.ltjs.define(["require", "exports", "sas/ltjs/commons/ltjsEnvironment", "sas/ltjs/commons/events/EventDispatcher", "sas/ltjs/transport/lib", "./NLUStringSetContext"], function (require, exports, ltjsEnvironment_1, EventDispatcher_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var ReportViewerNLUStringSetContext = ltjsEnvironment_1.createModule([114, 13, 50265, 50161, 50177, 50228], EventDispatcher_1.default);
    /**
     *
     */
    ReportViewerNLUStringSetContext._create = function () {
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_ReportViewerNLUStringSetContext_create();
        //-- Convert abstract(commons::VOID) from jni(void) to js()
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::ReportViewerNLUStringSetContext)", "static", "new", "-->", "(transport::ReportViewerNLUStringSetContext)", rc);
        return rc;
    };
    /**
     * @return {Array.<string| null> | null}
     */
    ReportViewerNLUStringSetContext.prototype.getPageLabels = function () {
        var pageLabels_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("pageLabels");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringVectorProperty(this._getValidClosetAddress(), pageLabels_jni);
        //-- Convert abstract(<commons::STRING>) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringArrayFromC(rc_jni);
        Module.deps['TraceUtil'].log("(transport::ReportViewerNLUStringSetContext)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#pageLabels", "-->", "(MONITORED_VECTOR<commons::STRING>)", Module.deps['TraceUtil'].traceConversions.convertArray(rc, Module.deps['TraceUtil'].traceConversions.convertString));
        return rc;
    };
    /**
     * @param {Array.<string| null> | null} value
     *
     */
    ReportViewerNLUStringSetContext.prototype.setPageLabels = function (value) {
        //-- Convert abstract(<commons::STRING>) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringArrayToC(value);
        var pageLabels_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("pageLabels");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringVectorProperty(this._getValidClosetAddress(), value_jni, pageLabels_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releaseAllPrimitives(value_jni);
        Module.deps['TraceUtil'].log("(transport::ReportViewerNLUStringSetContext)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#pageLabels", "(MONITORED_VECTOR<commons::STRING>)", Module.deps['TraceUtil'].traceConversions.convertArray(value, Module.deps['TraceUtil'].traceConversions.convertString));
        return this;
    };
    /**
     * @return {Array.<string| null> | null}
     */
    ReportViewerNLUStringSetContext.prototype.getSubscribedReportLabels = function () {
        var subscribedReportLabels_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("subscribedReportLabels");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringVectorProperty(this._getValidClosetAddress(), subscribedReportLabels_jni);
        //-- Convert abstract(<commons::STRING>) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringArrayFromC(rc_jni);
        Module.deps['TraceUtil'].log("(transport::ReportViewerNLUStringSetContext)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#subscribedReportLabels", "-->", "(MONITORED_VECTOR<commons::STRING>)", Module.deps['TraceUtil'].traceConversions.convertArray(rc, Module.deps['TraceUtil'].traceConversions.convertString));
        return rc;
    };
    /**
     * @param {Array.<string| null> | null} value
     *
     */
    ReportViewerNLUStringSetContext.prototype.setSubscribedReportLabels = function (value) {
        //-- Convert abstract(<commons::STRING>) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringArrayToC(value);
        var subscribedReportLabels_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("subscribedReportLabels");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringVectorProperty(this._getValidClosetAddress(), value_jni, subscribedReportLabels_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releaseAllPrimitives(value_jni);
        Module.deps['TraceUtil'].log("(transport::ReportViewerNLUStringSetContext)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#subscribedReportLabels", "(MONITORED_VECTOR<commons::STRING>)", Module.deps['TraceUtil'].traceConversions.convertArray(value, Module.deps['TraceUtil'].traceConversions.convertString));
        return this;
    };
    /**
     * @return {Array.<string| null> | null}
     */
    ReportViewerNLUStringSetContext.prototype.getVisualLabels = function () {
        var visualLabels_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("visualLabels");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringVectorProperty(this._getValidClosetAddress(), visualLabels_jni);
        //-- Convert abstract(<commons::STRING>) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringArrayFromC(rc_jni);
        Module.deps['TraceUtil'].log("(transport::ReportViewerNLUStringSetContext)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#visualLabels", "-->", "(MONITORED_VECTOR<commons::STRING>)", Module.deps['TraceUtil'].traceConversions.convertArray(rc, Module.deps['TraceUtil'].traceConversions.convertString));
        return rc;
    };
    /**
     * @param {Array.<string| null> | null} value
     *
     */
    ReportViewerNLUStringSetContext.prototype.setVisualLabels = function (value) {
        //-- Convert abstract(<commons::STRING>) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringArrayToC(value);
        var visualLabels_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("visualLabels");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringVectorProperty(this._getValidClosetAddress(), value_jni, visualLabels_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releaseAllPrimitives(value_jni);
        Module.deps['TraceUtil'].log("(transport::ReportViewerNLUStringSetContext)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#visualLabels", "(MONITORED_VECTOR<commons::STRING>)", Module.deps['TraceUtil'].traceConversions.convertArray(value, Module.deps['TraceUtil'].traceConversions.convertString));
        return this;
    };
    /**
     * @return {Array.<string| null> | null}
     */
    ReportViewerNLUStringSetContext.prototype.getPromptLabels = function () {
        var promptLabels_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("promptLabels");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringVectorProperty(this._getValidClosetAddress(), promptLabels_jni);
        //-- Convert abstract(<commons::STRING>) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringArrayFromC(rc_jni);
        Module.deps['TraceUtil'].log("(transport::ReportViewerNLUStringSetContext)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#promptLabels", "-->", "(MONITORED_VECTOR<commons::STRING>)", Module.deps['TraceUtil'].traceConversions.convertArray(rc, Module.deps['TraceUtil'].traceConversions.convertString));
        return rc;
    };
    /**
     * @param {Array.<string| null> | null} value
     *
     */
    ReportViewerNLUStringSetContext.prototype.setPromptLabels = function (value) {
        //-- Convert abstract(<commons::STRING>) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringArrayToC(value);
        var promptLabels_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("promptLabels");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringVectorProperty(this._getValidClosetAddress(), value_jni, promptLabels_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releaseAllPrimitives(value_jni);
        Module.deps['TraceUtil'].log("(transport::ReportViewerNLUStringSetContext)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#promptLabels", "(MONITORED_VECTOR<commons::STRING>)", Module.deps['TraceUtil'].traceConversions.convertArray(value, Module.deps['TraceUtil'].traceConversions.convertString));
        return this;
    };
    /**
     * @return {Array.<string| null> | null}
     */
    ReportViewerNLUStringSetContext.prototype.getPrompt0Label = function () {
        var prompt0Label_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("prompt0Label");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringVectorProperty(this._getValidClosetAddress(), prompt0Label_jni);
        //-- Convert abstract(<commons::STRING>) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringArrayFromC(rc_jni);
        Module.deps['TraceUtil'].log("(transport::ReportViewerNLUStringSetContext)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#prompt0Label", "-->", "(MONITORED_VECTOR<commons::STRING>)", Module.deps['TraceUtil'].traceConversions.convertArray(rc, Module.deps['TraceUtil'].traceConversions.convertString));
        return rc;
    };
    /**
     * @param {Array.<string| null> | null} value
     *
     */
    ReportViewerNLUStringSetContext.prototype.setPrompt0Label = function (value) {
        //-- Convert abstract(<commons::STRING>) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringArrayToC(value);
        var prompt0Label_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("prompt0Label");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringVectorProperty(this._getValidClosetAddress(), value_jni, prompt0Label_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releaseAllPrimitives(value_jni);
        Module.deps['TraceUtil'].log("(transport::ReportViewerNLUStringSetContext)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#prompt0Label", "(MONITORED_VECTOR<commons::STRING>)", Module.deps['TraceUtil'].traceConversions.convertArray(value, Module.deps['TraceUtil'].traceConversions.convertString));
        return this;
    };
    /**
     * @return {Array.<string| null> | null}
     */
    ReportViewerNLUStringSetContext.prototype.getPrompt1Label = function () {
        var prompt1Label_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("prompt1Label");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringVectorProperty(this._getValidClosetAddress(), prompt1Label_jni);
        //-- Convert abstract(<commons::STRING>) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringArrayFromC(rc_jni);
        Module.deps['TraceUtil'].log("(transport::ReportViewerNLUStringSetContext)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#prompt1Label", "-->", "(MONITORED_VECTOR<commons::STRING>)", Module.deps['TraceUtil'].traceConversions.convertArray(rc, Module.deps['TraceUtil'].traceConversions.convertString));
        return rc;
    };
    /**
     * @param {Array.<string| null> | null} value
     *
     */
    ReportViewerNLUStringSetContext.prototype.setPrompt1Label = function (value) {
        //-- Convert abstract(<commons::STRING>) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringArrayToC(value);
        var prompt1Label_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("prompt1Label");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringVectorProperty(this._getValidClosetAddress(), value_jni, prompt1Label_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releaseAllPrimitives(value_jni);
        Module.deps['TraceUtil'].log("(transport::ReportViewerNLUStringSetContext)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#prompt1Label", "(MONITORED_VECTOR<commons::STRING>)", Module.deps['TraceUtil'].traceConversions.convertArray(value, Module.deps['TraceUtil'].traceConversions.convertString));
        return this;
    };
    /**
     * @return {Array.<string| null> | null}
     */
    ReportViewerNLUStringSetContext.prototype.getPrompt2Label = function () {
        var prompt2Label_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("prompt2Label");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringVectorProperty(this._getValidClosetAddress(), prompt2Label_jni);
        //-- Convert abstract(<commons::STRING>) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringArrayFromC(rc_jni);
        Module.deps['TraceUtil'].log("(transport::ReportViewerNLUStringSetContext)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#prompt2Label", "-->", "(MONITORED_VECTOR<commons::STRING>)", Module.deps['TraceUtil'].traceConversions.convertArray(rc, Module.deps['TraceUtil'].traceConversions.convertString));
        return rc;
    };
    /**
     * @param {Array.<string| null> | null} value
     *
     */
    ReportViewerNLUStringSetContext.prototype.setPrompt2Label = function (value) {
        //-- Convert abstract(<commons::STRING>) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringArrayToC(value);
        var prompt2Label_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("prompt2Label");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringVectorProperty(this._getValidClosetAddress(), value_jni, prompt2Label_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releaseAllPrimitives(value_jni);
        Module.deps['TraceUtil'].log("(transport::ReportViewerNLUStringSetContext)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#prompt2Label", "(MONITORED_VECTOR<commons::STRING>)", Module.deps['TraceUtil'].traceConversions.convertArray(value, Module.deps['TraceUtil'].traceConversions.convertString));
        return this;
    };
    /**
     * @return {Array.<string| null> | null}
     */
    ReportViewerNLUStringSetContext.prototype.getPrompt3Label = function () {
        var prompt3Label_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("prompt3Label");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringVectorProperty(this._getValidClosetAddress(), prompt3Label_jni);
        //-- Convert abstract(<commons::STRING>) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringArrayFromC(rc_jni);
        Module.deps['TraceUtil'].log("(transport::ReportViewerNLUStringSetContext)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#prompt3Label", "-->", "(MONITORED_VECTOR<commons::STRING>)", Module.deps['TraceUtil'].traceConversions.convertArray(rc, Module.deps['TraceUtil'].traceConversions.convertString));
        return rc;
    };
    /**
     * @param {Array.<string| null> | null} value
     *
     */
    ReportViewerNLUStringSetContext.prototype.setPrompt3Label = function (value) {
        //-- Convert abstract(<commons::STRING>) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringArrayToC(value);
        var prompt3Label_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("prompt3Label");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringVectorProperty(this._getValidClosetAddress(), value_jni, prompt3Label_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releaseAllPrimitives(value_jni);
        Module.deps['TraceUtil'].log("(transport::ReportViewerNLUStringSetContext)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#prompt3Label", "(MONITORED_VECTOR<commons::STRING>)", Module.deps['TraceUtil'].traceConversions.convertArray(value, Module.deps['TraceUtil'].traceConversions.convertString));
        return this;
    };
    /**
     * @return {Array.<string| null> | null}
     */
    ReportViewerNLUStringSetContext.prototype.getPrompt4Label = function () {
        var prompt4Label_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("prompt4Label");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringVectorProperty(this._getValidClosetAddress(), prompt4Label_jni);
        //-- Convert abstract(<commons::STRING>) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringArrayFromC(rc_jni);
        Module.deps['TraceUtil'].log("(transport::ReportViewerNLUStringSetContext)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#prompt4Label", "-->", "(MONITORED_VECTOR<commons::STRING>)", Module.deps['TraceUtil'].traceConversions.convertArray(rc, Module.deps['TraceUtil'].traceConversions.convertString));
        return rc;
    };
    /**
     * @param {Array.<string| null> | null} value
     *
     */
    ReportViewerNLUStringSetContext.prototype.setPrompt4Label = function (value) {
        //-- Convert abstract(<commons::STRING>) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringArrayToC(value);
        var prompt4Label_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("prompt4Label");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringVectorProperty(this._getValidClosetAddress(), value_jni, prompt4Label_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releaseAllPrimitives(value_jni);
        Module.deps['TraceUtil'].log("(transport::ReportViewerNLUStringSetContext)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#prompt4Label", "(MONITORED_VECTOR<commons::STRING>)", Module.deps['TraceUtil'].traceConversions.convertArray(value, Module.deps['TraceUtil'].traceConversions.convertString));
        return this;
    };
    /**
     * @return {Array.<string| null> | null}
     */
    ReportViewerNLUStringSetContext.prototype.getPrompt5Label = function () {
        var prompt5Label_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("prompt5Label");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringVectorProperty(this._getValidClosetAddress(), prompt5Label_jni);
        //-- Convert abstract(<commons::STRING>) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringArrayFromC(rc_jni);
        Module.deps['TraceUtil'].log("(transport::ReportViewerNLUStringSetContext)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#prompt5Label", "-->", "(MONITORED_VECTOR<commons::STRING>)", Module.deps['TraceUtil'].traceConversions.convertArray(rc, Module.deps['TraceUtil'].traceConversions.convertString));
        return rc;
    };
    /**
     * @param {Array.<string| null> | null} value
     *
     */
    ReportViewerNLUStringSetContext.prototype.setPrompt5Label = function (value) {
        //-- Convert abstract(<commons::STRING>) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringArrayToC(value);
        var prompt5Label_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("prompt5Label");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringVectorProperty(this._getValidClosetAddress(), value_jni, prompt5Label_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releaseAllPrimitives(value_jni);
        Module.deps['TraceUtil'].log("(transport::ReportViewerNLUStringSetContext)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#prompt5Label", "(MONITORED_VECTOR<commons::STRING>)", Module.deps['TraceUtil'].traceConversions.convertArray(value, Module.deps['TraceUtil'].traceConversions.convertString));
        return this;
    };
    /**
     * @return {Array.<string| null> | null}
     */
    ReportViewerNLUStringSetContext.prototype.getPrompt6Label = function () {
        var prompt6Label_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("prompt6Label");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringVectorProperty(this._getValidClosetAddress(), prompt6Label_jni);
        //-- Convert abstract(<commons::STRING>) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringArrayFromC(rc_jni);
        Module.deps['TraceUtil'].log("(transport::ReportViewerNLUStringSetContext)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#prompt6Label", "-->", "(MONITORED_VECTOR<commons::STRING>)", Module.deps['TraceUtil'].traceConversions.convertArray(rc, Module.deps['TraceUtil'].traceConversions.convertString));
        return rc;
    };
    /**
     * @param {Array.<string| null> | null} value
     *
     */
    ReportViewerNLUStringSetContext.prototype.setPrompt6Label = function (value) {
        //-- Convert abstract(<commons::STRING>) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringArrayToC(value);
        var prompt6Label_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("prompt6Label");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringVectorProperty(this._getValidClosetAddress(), value_jni, prompt6Label_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releaseAllPrimitives(value_jni);
        Module.deps['TraceUtil'].log("(transport::ReportViewerNLUStringSetContext)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#prompt6Label", "(MONITORED_VECTOR<commons::STRING>)", Module.deps['TraceUtil'].traceConversions.convertArray(value, Module.deps['TraceUtil'].traceConversions.convertString));
        return this;
    };
    /**
     * @return {Array.<string| null> | null}
     */
    ReportViewerNLUStringSetContext.prototype.getPrompt7Label = function () {
        var prompt7Label_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("prompt7Label");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringVectorProperty(this._getValidClosetAddress(), prompt7Label_jni);
        //-- Convert abstract(<commons::STRING>) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringArrayFromC(rc_jni);
        Module.deps['TraceUtil'].log("(transport::ReportViewerNLUStringSetContext)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#prompt7Label", "-->", "(MONITORED_VECTOR<commons::STRING>)", Module.deps['TraceUtil'].traceConversions.convertArray(rc, Module.deps['TraceUtil'].traceConversions.convertString));
        return rc;
    };
    /**
     * @param {Array.<string| null> | null} value
     *
     */
    ReportViewerNLUStringSetContext.prototype.setPrompt7Label = function (value) {
        //-- Convert abstract(<commons::STRING>) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringArrayToC(value);
        var prompt7Label_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("prompt7Label");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringVectorProperty(this._getValidClosetAddress(), value_jni, prompt7Label_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releaseAllPrimitives(value_jni);
        Module.deps['TraceUtil'].log("(transport::ReportViewerNLUStringSetContext)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#prompt7Label", "(MONITORED_VECTOR<commons::STRING>)", Module.deps['TraceUtil'].traceConversions.convertArray(value, Module.deps['TraceUtil'].traceConversions.convertString));
        return this;
    };
    /**
     * @return {Array.<string| null> | null}
     */
    ReportViewerNLUStringSetContext.prototype.getPrompt8Label = function () {
        var prompt8Label_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("prompt8Label");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringVectorProperty(this._getValidClosetAddress(), prompt8Label_jni);
        //-- Convert abstract(<commons::STRING>) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringArrayFromC(rc_jni);
        Module.deps['TraceUtil'].log("(transport::ReportViewerNLUStringSetContext)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#prompt8Label", "-->", "(MONITORED_VECTOR<commons::STRING>)", Module.deps['TraceUtil'].traceConversions.convertArray(rc, Module.deps['TraceUtil'].traceConversions.convertString));
        return rc;
    };
    /**
     * @param {Array.<string| null> | null} value
     *
     */
    ReportViewerNLUStringSetContext.prototype.setPrompt8Label = function (value) {
        //-- Convert abstract(<commons::STRING>) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringArrayToC(value);
        var prompt8Label_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("prompt8Label");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringVectorProperty(this._getValidClosetAddress(), value_jni, prompt8Label_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releaseAllPrimitives(value_jni);
        Module.deps['TraceUtil'].log("(transport::ReportViewerNLUStringSetContext)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#prompt8Label", "(MONITORED_VECTOR<commons::STRING>)", Module.deps['TraceUtil'].traceConversions.convertArray(value, Module.deps['TraceUtil'].traceConversions.convertString));
        return this;
    };
    /**
     * @return {Array.<string| null> | null}
     */
    ReportViewerNLUStringSetContext.prototype.getPrompt9Label = function () {
        var prompt9Label_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("prompt9Label");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringVectorProperty(this._getValidClosetAddress(), prompt9Label_jni);
        //-- Convert abstract(<commons::STRING>) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringArrayFromC(rc_jni);
        Module.deps['TraceUtil'].log("(transport::ReportViewerNLUStringSetContext)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#prompt9Label", "-->", "(MONITORED_VECTOR<commons::STRING>)", Module.deps['TraceUtil'].traceConversions.convertArray(rc, Module.deps['TraceUtil'].traceConversions.convertString));
        return rc;
    };
    /**
     * @param {Array.<string| null> | null} value
     *
     */
    ReportViewerNLUStringSetContext.prototype.setPrompt9Label = function (value) {
        //-- Convert abstract(<commons::STRING>) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringArrayToC(value);
        var prompt9Label_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("prompt9Label");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringVectorProperty(this._getValidClosetAddress(), value_jni, prompt9Label_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releaseAllPrimitives(value_jni);
        Module.deps['TraceUtil'].log("(transport::ReportViewerNLUStringSetContext)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#prompt9Label", "(MONITORED_VECTOR<commons::STRING>)", Module.deps['TraceUtil'].traceConversions.convertArray(value, Module.deps['TraceUtil'].traceConversions.convertString));
        return this;
    };
    /**
     * @return {Array.<string| null> | null}
     */
    ReportViewerNLUStringSetContext.prototype.getPrompt0Values = function () {
        var prompt0Values_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("prompt0Values");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringVectorProperty(this._getValidClosetAddress(), prompt0Values_jni);
        //-- Convert abstract(<commons::STRING>) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringArrayFromC(rc_jni);
        Module.deps['TraceUtil'].log("(transport::ReportViewerNLUStringSetContext)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#prompt0Values", "-->", "(MONITORED_VECTOR<commons::STRING>)", Module.deps['TraceUtil'].traceConversions.convertArray(rc, Module.deps['TraceUtil'].traceConversions.convertString));
        return rc;
    };
    /**
     * @param {Array.<string| null> | null} value
     *
     */
    ReportViewerNLUStringSetContext.prototype.setPrompt0Values = function (value) {
        //-- Convert abstract(<commons::STRING>) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringArrayToC(value);
        var prompt0Values_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("prompt0Values");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringVectorProperty(this._getValidClosetAddress(), value_jni, prompt0Values_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releaseAllPrimitives(value_jni);
        Module.deps['TraceUtil'].log("(transport::ReportViewerNLUStringSetContext)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#prompt0Values", "(MONITORED_VECTOR<commons::STRING>)", Module.deps['TraceUtil'].traceConversions.convertArray(value, Module.deps['TraceUtil'].traceConversions.convertString));
        return this;
    };
    /**
     * @return {Array.<string| null> | null}
     */
    ReportViewerNLUStringSetContext.prototype.getPrompt1Values = function () {
        var prompt1Values_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("prompt1Values");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringVectorProperty(this._getValidClosetAddress(), prompt1Values_jni);
        //-- Convert abstract(<commons::STRING>) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringArrayFromC(rc_jni);
        Module.deps['TraceUtil'].log("(transport::ReportViewerNLUStringSetContext)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#prompt1Values", "-->", "(MONITORED_VECTOR<commons::STRING>)", Module.deps['TraceUtil'].traceConversions.convertArray(rc, Module.deps['TraceUtil'].traceConversions.convertString));
        return rc;
    };
    /**
     * @param {Array.<string| null> | null} value
     *
     */
    ReportViewerNLUStringSetContext.prototype.setPrompt1Values = function (value) {
        //-- Convert abstract(<commons::STRING>) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringArrayToC(value);
        var prompt1Values_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("prompt1Values");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringVectorProperty(this._getValidClosetAddress(), value_jni, prompt1Values_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releaseAllPrimitives(value_jni);
        Module.deps['TraceUtil'].log("(transport::ReportViewerNLUStringSetContext)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#prompt1Values", "(MONITORED_VECTOR<commons::STRING>)", Module.deps['TraceUtil'].traceConversions.convertArray(value, Module.deps['TraceUtil'].traceConversions.convertString));
        return this;
    };
    /**
     * @return {Array.<string| null> | null}
     */
    ReportViewerNLUStringSetContext.prototype.getPrompt2Values = function () {
        var prompt2Values_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("prompt2Values");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringVectorProperty(this._getValidClosetAddress(), prompt2Values_jni);
        //-- Convert abstract(<commons::STRING>) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringArrayFromC(rc_jni);
        Module.deps['TraceUtil'].log("(transport::ReportViewerNLUStringSetContext)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#prompt2Values", "-->", "(MONITORED_VECTOR<commons::STRING>)", Module.deps['TraceUtil'].traceConversions.convertArray(rc, Module.deps['TraceUtil'].traceConversions.convertString));
        return rc;
    };
    /**
     * @param {Array.<string| null> | null} value
     *
     */
    ReportViewerNLUStringSetContext.prototype.setPrompt2Values = function (value) {
        //-- Convert abstract(<commons::STRING>) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringArrayToC(value);
        var prompt2Values_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("prompt2Values");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringVectorProperty(this._getValidClosetAddress(), value_jni, prompt2Values_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releaseAllPrimitives(value_jni);
        Module.deps['TraceUtil'].log("(transport::ReportViewerNLUStringSetContext)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#prompt2Values", "(MONITORED_VECTOR<commons::STRING>)", Module.deps['TraceUtil'].traceConversions.convertArray(value, Module.deps['TraceUtil'].traceConversions.convertString));
        return this;
    };
    /**
     * @return {Array.<string| null> | null}
     */
    ReportViewerNLUStringSetContext.prototype.getPrompt3Values = function () {
        var prompt3Values_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("prompt3Values");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringVectorProperty(this._getValidClosetAddress(), prompt3Values_jni);
        //-- Convert abstract(<commons::STRING>) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringArrayFromC(rc_jni);
        Module.deps['TraceUtil'].log("(transport::ReportViewerNLUStringSetContext)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#prompt3Values", "-->", "(MONITORED_VECTOR<commons::STRING>)", Module.deps['TraceUtil'].traceConversions.convertArray(rc, Module.deps['TraceUtil'].traceConversions.convertString));
        return rc;
    };
    /**
     * @param {Array.<string| null> | null} value
     *
     */
    ReportViewerNLUStringSetContext.prototype.setPrompt3Values = function (value) {
        //-- Convert abstract(<commons::STRING>) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringArrayToC(value);
        var prompt3Values_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("prompt3Values");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringVectorProperty(this._getValidClosetAddress(), value_jni, prompt3Values_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releaseAllPrimitives(value_jni);
        Module.deps['TraceUtil'].log("(transport::ReportViewerNLUStringSetContext)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#prompt3Values", "(MONITORED_VECTOR<commons::STRING>)", Module.deps['TraceUtil'].traceConversions.convertArray(value, Module.deps['TraceUtil'].traceConversions.convertString));
        return this;
    };
    /**
     * @return {Array.<string| null> | null}
     */
    ReportViewerNLUStringSetContext.prototype.getPrompt4Values = function () {
        var prompt4Values_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("prompt4Values");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringVectorProperty(this._getValidClosetAddress(), prompt4Values_jni);
        //-- Convert abstract(<commons::STRING>) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringArrayFromC(rc_jni);
        Module.deps['TraceUtil'].log("(transport::ReportViewerNLUStringSetContext)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#prompt4Values", "-->", "(MONITORED_VECTOR<commons::STRING>)", Module.deps['TraceUtil'].traceConversions.convertArray(rc, Module.deps['TraceUtil'].traceConversions.convertString));
        return rc;
    };
    /**
     * @param {Array.<string| null> | null} value
     *
     */
    ReportViewerNLUStringSetContext.prototype.setPrompt4Values = function (value) {
        //-- Convert abstract(<commons::STRING>) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringArrayToC(value);
        var prompt4Values_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("prompt4Values");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringVectorProperty(this._getValidClosetAddress(), value_jni, prompt4Values_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releaseAllPrimitives(value_jni);
        Module.deps['TraceUtil'].log("(transport::ReportViewerNLUStringSetContext)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#prompt4Values", "(MONITORED_VECTOR<commons::STRING>)", Module.deps['TraceUtil'].traceConversions.convertArray(value, Module.deps['TraceUtil'].traceConversions.convertString));
        return this;
    };
    /**
     * @return {Array.<string| null> | null}
     */
    ReportViewerNLUStringSetContext.prototype.getPrompt5Values = function () {
        var prompt5Values_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("prompt5Values");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringVectorProperty(this._getValidClosetAddress(), prompt5Values_jni);
        //-- Convert abstract(<commons::STRING>) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringArrayFromC(rc_jni);
        Module.deps['TraceUtil'].log("(transport::ReportViewerNLUStringSetContext)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#prompt5Values", "-->", "(MONITORED_VECTOR<commons::STRING>)", Module.deps['TraceUtil'].traceConversions.convertArray(rc, Module.deps['TraceUtil'].traceConversions.convertString));
        return rc;
    };
    /**
     * @param {Array.<string| null> | null} value
     *
     */
    ReportViewerNLUStringSetContext.prototype.setPrompt5Values = function (value) {
        //-- Convert abstract(<commons::STRING>) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringArrayToC(value);
        var prompt5Values_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("prompt5Values");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringVectorProperty(this._getValidClosetAddress(), value_jni, prompt5Values_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releaseAllPrimitives(value_jni);
        Module.deps['TraceUtil'].log("(transport::ReportViewerNLUStringSetContext)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#prompt5Values", "(MONITORED_VECTOR<commons::STRING>)", Module.deps['TraceUtil'].traceConversions.convertArray(value, Module.deps['TraceUtil'].traceConversions.convertString));
        return this;
    };
    /**
     * @return {Array.<string| null> | null}
     */
    ReportViewerNLUStringSetContext.prototype.getPrompt6Values = function () {
        var prompt6Values_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("prompt6Values");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringVectorProperty(this._getValidClosetAddress(), prompt6Values_jni);
        //-- Convert abstract(<commons::STRING>) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringArrayFromC(rc_jni);
        Module.deps['TraceUtil'].log("(transport::ReportViewerNLUStringSetContext)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#prompt6Values", "-->", "(MONITORED_VECTOR<commons::STRING>)", Module.deps['TraceUtil'].traceConversions.convertArray(rc, Module.deps['TraceUtil'].traceConversions.convertString));
        return rc;
    };
    /**
     * @param {Array.<string| null> | null} value
     *
     */
    ReportViewerNLUStringSetContext.prototype.setPrompt6Values = function (value) {
        //-- Convert abstract(<commons::STRING>) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringArrayToC(value);
        var prompt6Values_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("prompt6Values");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringVectorProperty(this._getValidClosetAddress(), value_jni, prompt6Values_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releaseAllPrimitives(value_jni);
        Module.deps['TraceUtil'].log("(transport::ReportViewerNLUStringSetContext)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#prompt6Values", "(MONITORED_VECTOR<commons::STRING>)", Module.deps['TraceUtil'].traceConversions.convertArray(value, Module.deps['TraceUtil'].traceConversions.convertString));
        return this;
    };
    /**
     * @return {Array.<string| null> | null}
     */
    ReportViewerNLUStringSetContext.prototype.getPrompt7Values = function () {
        var prompt7Values_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("prompt7Values");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringVectorProperty(this._getValidClosetAddress(), prompt7Values_jni);
        //-- Convert abstract(<commons::STRING>) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringArrayFromC(rc_jni);
        Module.deps['TraceUtil'].log("(transport::ReportViewerNLUStringSetContext)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#prompt7Values", "-->", "(MONITORED_VECTOR<commons::STRING>)", Module.deps['TraceUtil'].traceConversions.convertArray(rc, Module.deps['TraceUtil'].traceConversions.convertString));
        return rc;
    };
    /**
     * @param {Array.<string| null> | null} value
     *
     */
    ReportViewerNLUStringSetContext.prototype.setPrompt7Values = function (value) {
        //-- Convert abstract(<commons::STRING>) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringArrayToC(value);
        var prompt7Values_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("prompt7Values");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringVectorProperty(this._getValidClosetAddress(), value_jni, prompt7Values_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releaseAllPrimitives(value_jni);
        Module.deps['TraceUtil'].log("(transport::ReportViewerNLUStringSetContext)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#prompt7Values", "(MONITORED_VECTOR<commons::STRING>)", Module.deps['TraceUtil'].traceConversions.convertArray(value, Module.deps['TraceUtil'].traceConversions.convertString));
        return this;
    };
    /**
     * @return {Array.<string| null> | null}
     */
    ReportViewerNLUStringSetContext.prototype.getPrompt8Values = function () {
        var prompt8Values_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("prompt8Values");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringVectorProperty(this._getValidClosetAddress(), prompt8Values_jni);
        //-- Convert abstract(<commons::STRING>) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringArrayFromC(rc_jni);
        Module.deps['TraceUtil'].log("(transport::ReportViewerNLUStringSetContext)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#prompt8Values", "-->", "(MONITORED_VECTOR<commons::STRING>)", Module.deps['TraceUtil'].traceConversions.convertArray(rc, Module.deps['TraceUtil'].traceConversions.convertString));
        return rc;
    };
    /**
     * @param {Array.<string| null> | null} value
     *
     */
    ReportViewerNLUStringSetContext.prototype.setPrompt8Values = function (value) {
        //-- Convert abstract(<commons::STRING>) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringArrayToC(value);
        var prompt8Values_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("prompt8Values");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringVectorProperty(this._getValidClosetAddress(), value_jni, prompt8Values_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releaseAllPrimitives(value_jni);
        Module.deps['TraceUtil'].log("(transport::ReportViewerNLUStringSetContext)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#prompt8Values", "(MONITORED_VECTOR<commons::STRING>)", Module.deps['TraceUtil'].traceConversions.convertArray(value, Module.deps['TraceUtil'].traceConversions.convertString));
        return this;
    };
    /**
     * @return {Array.<string| null> | null}
     */
    ReportViewerNLUStringSetContext.prototype.getPrompt9Values = function () {
        var prompt9Values_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("prompt9Values");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringVectorProperty(this._getValidClosetAddress(), prompt9Values_jni);
        //-- Convert abstract(<commons::STRING>) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringArrayFromC(rc_jni);
        Module.deps['TraceUtil'].log("(transport::ReportViewerNLUStringSetContext)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#prompt9Values", "-->", "(MONITORED_VECTOR<commons::STRING>)", Module.deps['TraceUtil'].traceConversions.convertArray(rc, Module.deps['TraceUtil'].traceConversions.convertString));
        return rc;
    };
    /**
     * @param {Array.<string| null> | null} value
     *
     */
    ReportViewerNLUStringSetContext.prototype.setPrompt9Values = function (value) {
        //-- Convert abstract(<commons::STRING>) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringArrayToC(value);
        var prompt9Values_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("prompt9Values");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringVectorProperty(this._getValidClosetAddress(), value_jni, prompt9Values_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releaseAllPrimitives(value_jni);
        Module.deps['TraceUtil'].log("(transport::ReportViewerNLUStringSetContext)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#prompt9Values", "(MONITORED_VECTOR<commons::STRING>)", Module.deps['TraceUtil'].traceConversions.convertArray(value, Module.deps['TraceUtil'].traceConversions.convertString));
        return this;
    };
    exports.default = ReportViewerNLUStringSetContext;
});
