sas.ltjs.define(["require", "exports", "sas/ltjs/commons/ltjsEnvironment", "sas/ltjs/commons/WrappableCloset", "sas/ltjs/commons/ClosetObject", "sas/ltjs/commons/events/EventDispatcher", "sas/ltjs/transport/lib", "./NLUInterpretationsRequestBody", "./ReportViewerNLUStringSetContext"], function (require, exports, ltjsEnvironment_1, WrappableCloset_1, ClosetObject_1, EventDispatcher_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var ReportViewerNLUInterpretationsRequestBody = ltjsEnvironment_1.createModule([114, 13, 50265, 50161, 50171, 50224], EventDispatcher_1.default);
    /**
     *
     */
    ReportViewerNLUInterpretationsRequestBody._create = function () {
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_ReportViewerNLUInterpretationsRequestBody_create();
        //-- Convert abstract(commons::VOID) from jni(void) to js()
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::ReportViewerNLUInterpretationsRequestBody)", "static", "new", "-->", "(transport::ReportViewerNLUInterpretationsRequestBody)", rc);
        return rc;
    };
    /**
     * @return {number}
     */
    ReportViewerNLUInterpretationsRequestBody.prototype.getId = function () {
        var id_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("id");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getIntProperty(this._getValidClosetAddress(), id_jni);
        //-- Convert abstract(commons::INT) from jni(int) to js(number)
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::ReportViewerNLUInterpretationsRequestBody)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#id", "-->", "(commons::INT)", Module.deps['TraceUtil'].traceConversions.convertInt(rc));
        return rc;
    };
    /**
     * @param {number} value
     *
     */
    ReportViewerNLUInterpretationsRequestBody.prototype.setId = function (value) {
        //-- Convert abstract(commons::INT) from js(number) to jni(int)
        var value_jni = value;
        var id_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("id");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setIntProperty(this._getValidClosetAddress(), value_jni, id_name_jni);
        Module.deps['TraceUtil'].log("(transport::ReportViewerNLUInterpretationsRequestBody)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#id", "(commons::INT)", Module.deps['TraceUtil'].traceConversions.convertInt(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    ReportViewerNLUInterpretationsRequestBody.prototype.getGuid = function () {
        var guid_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("guid");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), guid_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::ReportViewerNLUInterpretationsRequestBody)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#guid", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    ReportViewerNLUInterpretationsRequestBody.prototype.setGuid = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var guid_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("guid");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, guid_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::ReportViewerNLUInterpretationsRequestBody)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#guid", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    ReportViewerNLUInterpretationsRequestBody.prototype.getDuid = function () {
        var duid_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("duid");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), duid_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::ReportViewerNLUInterpretationsRequestBody)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#duid", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    ReportViewerNLUInterpretationsRequestBody.prototype.setDuid = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var duid_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("duid");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, duid_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::ReportViewerNLUInterpretationsRequestBody)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#duid", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    ReportViewerNLUInterpretationsRequestBody.prototype.getLocation = function () {
        var location_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("location");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), location_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::ReportViewerNLUInterpretationsRequestBody)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#location", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    ReportViewerNLUInterpretationsRequestBody.prototype.setLocation = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var location_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("location");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, location_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::ReportViewerNLUInterpretationsRequestBody)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#location", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    ReportViewerNLUInterpretationsRequestBody.prototype.getAuthor = function () {
        var author_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("author");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), author_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::ReportViewerNLUInterpretationsRequestBody)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#author", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    ReportViewerNLUInterpretationsRequestBody.prototype.setAuthor = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var author_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("author");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, author_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::ReportViewerNLUInterpretationsRequestBody)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#author", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    ReportViewerNLUInterpretationsRequestBody.prototype.getCreatedOn = function () {
        var createdOn_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("createdOn");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), createdOn_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::ReportViewerNLUInterpretationsRequestBody)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#createdOn", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    ReportViewerNLUInterpretationsRequestBody.prototype.setCreatedOn = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var createdOn_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("createdOn");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, createdOn_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::ReportViewerNLUInterpretationsRequestBody)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#createdOn", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {ReportViewerNLUStringSetContext| null}
     */
    ReportViewerNLUInterpretationsRequestBody.prototype.getStringSetContext = function () {
        var stringSetContext_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("stringSetContext");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getWrappableProperty(this._getValidClosetAddress(), stringSetContext_jni);
        //-- Convert abstract(transport::ReportViewerNLUStringSetContext) from jni(size_t) to js(ReportViewerNLUStringSetContext)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::ReportViewerNLUInterpretationsRequestBody)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#stringSetContext", "-->", "(transport::ReportViewerNLUStringSetContext)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * @param {ReportViewerNLUStringSetContext| null} value
     *
     */
    ReportViewerNLUInterpretationsRequestBody.prototype.setStringSetContext = function (value) {
        //-- Convert abstract(transport::ReportViewerNLUStringSetContext) from js(ReportViewerNLUStringSetContext) to jni(size_t)
        var value_jni = ClosetObject_1.default._getValidClosetAddress(value);
        var stringSetContext_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("stringSetContext");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setWrappableProperty(this._getValidClosetAddress(), value_jni, stringSetContext_name_jni);
        Module.deps['TraceUtil'].log("(transport::ReportViewerNLUInterpretationsRequestBody)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#stringSetContext", "(transport::ReportViewerNLUStringSetContext)", Module.deps['TraceUtil'].traceConversions.convertModel(value));
        return this;
    };
    exports.default = ReportViewerNLUInterpretationsRequestBody;
});
