sas.ltjs.define(["require", "exports", "sas/ltjs/commons/ltjsEnvironment", "sas/ltjs/commons/events/EventDispatcher", "sas/ltjs/transport/lib", "sas/ltjs/transport/models/media/MediaType"], function (require, exports, ltjsEnvironment_1, EventDispatcher_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var NLUInterpretationsRequestBody = ltjsEnvironment_1.createModule([114, 13, 50265, 50161, 50171], EventDispatcher_1.default);
    /**
     *
     */
    NLUInterpretationsRequestBody._create = function () {
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_NLUInterpretationsRequestBody_create();
        //-- Convert abstract(commons::VOID) from jni(void) to js()
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::NLUInterpretationsRequestBody)", "static", "new", "-->", "(transport::NLUInterpretationsRequestBody)", rc);
        return rc;
    };
    /**
     * @return {string| null}
     */
    NLUInterpretationsRequestBody.prototype.getText = function () {
        var text_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("text");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), text_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::NLUInterpretationsRequestBody)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#text", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    NLUInterpretationsRequestBody.prototype.setText = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var text_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("text");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, text_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::NLUInterpretationsRequestBody)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#text", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    exports.default = NLUInterpretationsRequestBody;
});
