sas.ltjs.define(["require", "exports", "sas/ltjs/commons/ltjsEnvironment", "sas/ltjs/commons/WrappableCloset", "sas/ltjs/commons/events/EventDispatcher", "sas/ltjs/transport/lib", "./MediaType", "./particles/Capability", "sas/ltjs/commons/models/particles/Link"], function (require, exports, ltjsEnvironment_1, WrappableCloset_1, EventDispatcher_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var UserInfo = ltjsEnvironment_1.createModule([114, 13, 50265, 50161, 50276], EventDispatcher_1.default);
    /**
     *
     */
    UserInfo._create = function () {
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_UserInfo_create();
        //-- Convert abstract(commons::VOID) from jni(void) to js()
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::UserInfo)", "static", "new", "-->", "(transport::UserInfo)", rc);
        return rc;
    };
    /**
     * @return {Array.<Capability> | null}
     */
    UserInfo.prototype.getCapabilities = function () {
        var capabilities_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("capabilities");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getIntVectorProperty(this._getValidClosetAddress(), capabilities_jni);
        //-- Convert abstract(<transport::Capability>) from jni(size_t) to js(Capability)
        var rc = ltjsEnvironment_1.ltjsModule.convertIntMVectorFromC(rc_jni);
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::UserInfo)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#capabilities", "-->", "(MONITORED_VECTOR<transport::Capability>)", Module.deps['TraceUtil'].traceConversions.convertArray(rc, Module.deps['TraceUtil'].traceConversions.convertEnum));
        return rc;
    };
    /**
     * @param {Array.<Capability> | null} value
     *
     */
    UserInfo.prototype.setCapabilities = function (value) {
        //-- Convert abstract(<transport::Capability>) from js(Capability) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertIntArrayToC(value);
        var capabilities_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("capabilities");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setIntVectorProperty(this._getValidClosetAddress(), value_jni, capabilities_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::UserInfo)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#capabilities", "(MONITORED_VECTOR<transport::Capability>)", Module.deps['TraceUtil'].traceConversions.convertArray(value, Module.deps['TraceUtil'].traceConversions.convertEnum));
        return this;
    };
    /**
     * @return {string| null}
     */
    UserInfo.prototype.getUserDisplayName = function () {
        var userDisplayName_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("userDisplayName");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), userDisplayName_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::UserInfo)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#userDisplayName", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    UserInfo.prototype.setUserDisplayName = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var userDisplayName_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("userDisplayName");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, userDisplayName_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::UserInfo)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#userDisplayName", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    UserInfo.prototype.getUserId = function () {
        var userId_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("userId");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), userId_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::UserInfo)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#userId", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    UserInfo.prototype.setUserId = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var userId_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("userId");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, userId_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::UserInfo)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#userId", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {Array.<string| null> | null}
     */
    UserInfo.prototype.getMemberships = function () {
        var memberships_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("memberships");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringVectorProperty(this._getValidClosetAddress(), memberships_jni);
        //-- Convert abstract(<commons::STRING>) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringArrayFromC(rc_jni);
        Module.deps['TraceUtil'].log("(transport::UserInfo)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#memberships", "-->", "(MONITORED_VECTOR<commons::STRING>)", Module.deps['TraceUtil'].traceConversions.convertArray(rc, Module.deps['TraceUtil'].traceConversions.convertString));
        return rc;
    };
    /**
     * @param {Array.<string| null> | null} value
     *
     */
    UserInfo.prototype.setMemberships = function (value) {
        //-- Convert abstract(<commons::STRING>) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringArrayToC(value);
        var memberships_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("memberships");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringVectorProperty(this._getValidClosetAddress(), value_jni, memberships_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releaseAllPrimitives(value_jni);
        Module.deps['TraceUtil'].log("(transport::UserInfo)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#memberships", "(MONITORED_VECTOR<commons::STRING>)", Module.deps['TraceUtil'].traceConversions.convertArray(value, Module.deps['TraceUtil'].traceConversions.convertString));
        return this;
    };
    /**
     * @return {Array.<Link| null> | null}
     */
    UserInfo.prototype.getLinks = function () {
        var links_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("links");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getWrappableVectorProperty(this._getValidClosetAddress(), links_jni);
        //-- Convert abstract(<commons::Link>) from jni(size_t) to js(Link)
        var rc = WrappableCloset_1.getWrapperArray(rc_jni);
        Module.deps['TraceUtil'].log("(transport::UserInfo)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#links", "-->", "(MONITORED_VECTOR<commons::Link>)", Module.deps['TraceUtil'].traceConversions.convertArray(rc, Module.deps['TraceUtil'].traceConversions.convertModel));
        return rc;
    };
    /**
     * @param {Array.<Link| null> | null} value
     *
     */
    UserInfo.prototype.setLinks = function (value) {
        //-- Convert abstract(<commons::Link>) from js(Link) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertObjectArrayToC(value);
        var links_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("links");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setWrappableVectorProperty(this._getValidClosetAddress(), value_jni, links_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::UserInfo)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#links", "(MONITORED_VECTOR<commons::Link>)", Module.deps['TraceUtil'].traceConversions.convertArray(value, Module.deps['TraceUtil'].traceConversions.convertModel));
        return this;
    };
    exports.default = UserInfo;
});
