sas.ltjs.define(["require", "exports", "sas/ltjs/commons/ltjsEnvironment", "sas/ltjs/commons/WrappableCloset", "sas/ltjs/commons/ClosetObject", "sas/ltjs/commons/events/EventDispatcher", "sas/ltjs/transport/lib", "./MediaType", "./particles/SupportedType", "sas/ltjs/commons/resources/network/URL"], function (require, exports, ltjsEnvironment_1, WrappableCloset_1, ClosetObject_1, EventDispatcher_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var ServerConfig = ltjsEnvironment_1.createModule([114, 13, 50265, 50161, 50242], EventDispatcher_1.default);
    /**
     *
     */
    ServerConfig._create = function () {
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_ServerConfig_create();
        //-- Convert abstract(commons::VOID) from jni(void) to js()
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::ServerConfig)", "static", "new", "-->", "(transport::ServerConfig)", rc);
        return rc;
    };
    /**
     * @return {string| null}
     */
    ServerConfig.prototype.getBannerMessage = function () {
        var bannerMessage_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("bannerMessage");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), bannerMessage_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::ServerConfig)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#bannerMessage", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    ServerConfig.prototype.setBannerMessage = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var bannerMessage_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("bannerMessage");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, bannerMessage_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::ServerConfig)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#bannerMessage", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {number}
     */
    ServerConfig.prototype.getComparisonEpsilon = function () {
        var comparisonEpsilon_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("comparisonEpsilon");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getDoubleProperty(this._getValidClosetAddress(), comparisonEpsilon_jni);
        //-- Convert abstract(commons::DOUBLE) from jni(double) to js(number)
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::ServerConfig)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#comparisonEpsilon", "-->", "(commons::DOUBLE)", Module.deps['TraceUtil'].traceConversions.convertDouble(rc));
        return rc;
    };
    /**
     * @param {number} value
     *
     */
    ServerConfig.prototype.setComparisonEpsilon = function (value) {
        //-- Convert abstract(commons::DOUBLE) from js(number) to jni(double)
        var value_jni = value;
        var comparisonEpsilon_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("comparisonEpsilon");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setDoubleProperty(this._getValidClosetAddress(), value_jni, comparisonEpsilon_name_jni);
        Module.deps['TraceUtil'].log("(transport::ServerConfig)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#comparisonEpsilon", "(commons::DOUBLE)", Module.deps['TraceUtil'].traceConversions.convertDouble(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    ServerConfig.prototype.getLogoUrl = function () {
        var logoUrl_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("logoUrl");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), logoUrl_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::ServerConfig)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#logoUrl", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    ServerConfig.prototype.setLogoUrl = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var logoUrl_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("logoUrl");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, logoUrl_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::ServerConfig)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#logoUrl", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {number}
     */
    ServerConfig.prototype.getPasscodeAttempts = function () {
        var passcodeAttempts_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("passcodeAttempts");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getIntProperty(this._getValidClosetAddress(), passcodeAttempts_jni);
        //-- Convert abstract(commons::INT) from jni(int) to js(number)
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::ServerConfig)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#passcodeAttempts", "-->", "(commons::INT)", Module.deps['TraceUtil'].traceConversions.convertInt(rc));
        return rc;
    };
    /**
     * @param {number} value
     *
     */
    ServerConfig.prototype.setPasscodeAttempts = function (value) {
        //-- Convert abstract(commons::INT) from js(number) to jni(int)
        var value_jni = value;
        var passcodeAttempts_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("passcodeAttempts");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setIntProperty(this._getValidClosetAddress(), value_jni, passcodeAttempts_name_jni);
        Module.deps['TraceUtil'].log("(transport::ServerConfig)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#passcodeAttempts", "(commons::INT)", Module.deps['TraceUtil'].traceConversions.convertInt(value));
        return this;
    };
    /**
     * @return {number}
     */
    ServerConfig.prototype.getPasscodeTimeout = function () {
        var passcodeTimeout_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("passcodeTimeout");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getFloatProperty(this._getValidClosetAddress(), passcodeTimeout_jni);
        //-- Convert abstract(commons::FLOAT) from jni(double) to js(number)
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::ServerConfig)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#passcodeTimeout", "-->", "(commons::FLOAT)", Module.deps['TraceUtil'].traceConversions.convertFloat(rc));
        return rc;
    };
    /**
     * @param {number} value
     *
     */
    ServerConfig.prototype.setPasscodeTimeout = function (value) {
        //-- Convert abstract(commons::FLOAT) from js(number) to jni(double)
        var value_jni = value;
        var passcodeTimeout_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("passcodeTimeout");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setFloatProperty(this._getValidClosetAddress(), value_jni, passcodeTimeout_name_jni);
        Module.deps['TraceUtil'].log("(transport::ServerConfig)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#passcodeTimeout", "(commons::FLOAT)", Module.deps['TraceUtil'].traceConversions.convertFloat(value));
        return this;
    };
    /**
     * @return {boolean}
     */
    ServerConfig.prototype.getSearchAvailable = function () {
        var searchAvailable_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("searchAvailable");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getBooleanProperty(this._getValidClosetAddress(), searchAvailable_jni);
        //-- Convert abstract(commons::BOOLEAN) from jni(bool) to js(boolean)
        var rc = !!rc_jni;
        Module.deps['TraceUtil'].log("(transport::ServerConfig)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#searchAvailable", "-->", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(rc));
        return rc;
    };
    /**
     * @param {boolean} value
     *
     */
    ServerConfig.prototype.setSearchAvailable = function (value) {
        //-- Convert abstract(commons::BOOLEAN) from js(boolean) to jni(bool)
        var value_jni = !!value;
        var searchAvailable_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("searchAvailable");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setBooleanProperty(this._getValidClosetAddress(), value_jni, searchAvailable_name_jni);
        Module.deps['TraceUtil'].log("(transport::ServerConfig)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#searchAvailable", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(value));
        return this;
    };
    /**
     * @return {Array.<SupportedType| null> | null}
     */
    ServerConfig.prototype.getSupportedTypes = function () {
        var supportedTypes_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("supportedTypes");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getWrappableVectorProperty(this._getValidClosetAddress(), supportedTypes_jni);
        //-- Convert abstract(<transport::SupportedType>) from jni(size_t) to js(SupportedType)
        var rc = WrappableCloset_1.getWrapperArray(rc_jni);
        Module.deps['TraceUtil'].log("(transport::ServerConfig)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#supportedTypes", "-->", "(MONITORED_VECTOR<transport::SupportedType>)", Module.deps['TraceUtil'].traceConversions.convertArray(rc, Module.deps['TraceUtil'].traceConversions.convertModel));
        return rc;
    };
    /**
     * @param {Array.<SupportedType| null> | null} value
     *
     */
    ServerConfig.prototype.setSupportedTypes = function (value) {
        //-- Convert abstract(<transport::SupportedType>) from js(SupportedType) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertObjectArrayToC(value);
        var supportedTypes_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("supportedTypes");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setWrappableVectorProperty(this._getValidClosetAddress(), value_jni, supportedTypes_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::ServerConfig)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#supportedTypes", "(MONITORED_VECTOR<transport::SupportedType>)", Module.deps['TraceUtil'].traceConversions.convertArray(value, Module.deps['TraceUtil'].traceConversions.convertModel));
        return this;
    };
    /**
     * @return {string| null}
     */
    ServerConfig.prototype.getTitle = function () {
        var title_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("title");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), title_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::ServerConfig)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#title", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    ServerConfig.prototype.setTitle = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var title_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("title");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, title_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::ServerConfig)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#title", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    ServerConfig.prototype.getTransportServicesVersion = function () {
        var transportServicesVersion_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("transportServicesVersion");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), transportServicesVersion_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::ServerConfig)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#transportServicesVersion", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    ServerConfig.prototype.setTransportServicesVersion = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var transportServicesVersion_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("transportServicesVersion");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, transportServicesVersion_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::ServerConfig)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#transportServicesVersion", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {boolean}
     */
    ServerConfig.prototype.getAllowGuest = function () {
        var allowGuest_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("allowGuest");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getBooleanProperty(this._getValidClosetAddress(), allowGuest_jni);
        //-- Convert abstract(commons::BOOLEAN) from jni(bool) to js(boolean)
        var rc = !!rc_jni;
        Module.deps['TraceUtil'].log("(transport::ServerConfig)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#allowGuest", "-->", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(rc));
        return rc;
    };
    /**
     * @param {boolean} value
     *
     */
    ServerConfig.prototype.setAllowGuest = function (value) {
        //-- Convert abstract(commons::BOOLEAN) from js(boolean) to jni(bool)
        var value_jni = !!value;
        var allowGuest_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("allowGuest");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setBooleanProperty(this._getValidClosetAddress(), value_jni, allowGuest_name_jni);
        Module.deps['TraceUtil'].log("(transport::ServerConfig)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#allowGuest", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(value));
        return this;
    };
    /**
     * @return {boolean}
     */
    ServerConfig.prototype.getPrintAvailable = function () {
        var printAvailable_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("printAvailable");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getBooleanProperty(this._getValidClosetAddress(), printAvailable_jni);
        //-- Convert abstract(commons::BOOLEAN) from jni(bool) to js(boolean)
        var rc = !!rc_jni;
        Module.deps['TraceUtil'].log("(transport::ServerConfig)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#printAvailable", "-->", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(rc));
        return rc;
    };
    /**
     * @param {boolean} value
     *
     */
    ServerConfig.prototype.setPrintAvailable = function (value) {
        //-- Convert abstract(commons::BOOLEAN) from js(boolean) to jni(bool)
        var value_jni = !!value;
        var printAvailable_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("printAvailable");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setBooleanProperty(this._getValidClosetAddress(), value_jni, printAvailable_name_jni);
        Module.deps['TraceUtil'].log("(transport::ServerConfig)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#printAvailable", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(value));
        return this;
    };
    /**
     * @return {number}
     */
    ServerConfig.prototype.getOfflineLimit = function () {
        var offlineLimit_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("offlineLimit");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getFloatProperty(this._getValidClosetAddress(), offlineLimit_jni);
        //-- Convert abstract(commons::FLOAT) from jni(double) to js(number)
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::ServerConfig)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#offlineLimit", "-->", "(commons::FLOAT)", Module.deps['TraceUtil'].traceConversions.convertFloat(rc));
        return rc;
    };
    /**
     * @param {number} value
     *
     */
    ServerConfig.prototype.setOfflineLimit = function (value) {
        //-- Convert abstract(commons::FLOAT) from js(number) to jni(double)
        var value_jni = value;
        var offlineLimit_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("offlineLimit");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setFloatProperty(this._getValidClosetAddress(), value_jni, offlineLimit_name_jni);
        Module.deps['TraceUtil'].log("(transport::ServerConfig)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#offlineLimit", "(commons::FLOAT)", Module.deps['TraceUtil'].traceConversions.convertFloat(value));
        return this;
    };
    /**
     * @return {URL| null}
     */
    ServerConfig.prototype.getHomePageUrl = function () {
        var homePageUrl_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("homePageUrl");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getWrappableProperty(this._getValidClosetAddress(), homePageUrl_jni);
        //-- Convert abstract(commons::URL) from jni(size_t) to js(URL)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::ServerConfig)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#homePageUrl", "-->", "(commons::URL)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * @param {URL| null} value
     *
     */
    ServerConfig.prototype.setHomePageUrl = function (value) {
        //-- Convert abstract(commons::URL) from js(URL) to jni(size_t)
        var value_jni = ClosetObject_1.default._getValidClosetAddress(value);
        var homePageUrl_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("homePageUrl");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setWrappableProperty(this._getValidClosetAddress(), value_jni, homePageUrl_name_jni);
        Module.deps['TraceUtil'].log("(transport::ServerConfig)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#homePageUrl", "(commons::URL)", Module.deps['TraceUtil'].traceConversions.convertModel(value));
        return this;
    };
    /**
     * @return {URL| null}
     */
    ServerConfig.prototype.getEnvironmentManagerUrl = function () {
        var environmentManagerUrl_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("environmentManagerUrl");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getWrappableProperty(this._getValidClosetAddress(), environmentManagerUrl_jni);
        //-- Convert abstract(commons::URL) from jni(size_t) to js(URL)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::ServerConfig)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#environmentManagerUrl", "-->", "(commons::URL)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * @param {URL| null} value
     *
     */
    ServerConfig.prototype.setEnvironmentManagerUrl = function (value) {
        //-- Convert abstract(commons::URL) from js(URL) to jni(size_t)
        var value_jni = ClosetObject_1.default._getValidClosetAddress(value);
        var environmentManagerUrl_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("environmentManagerUrl");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setWrappableProperty(this._getValidClosetAddress(), value_jni, environmentManagerUrl_name_jni);
        Module.deps['TraceUtil'].log("(transport::ServerConfig)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#environmentManagerUrl", "(commons::URL)", Module.deps['TraceUtil'].traceConversions.convertModel(value));
        return this;
    };
    /**
     * @return {boolean}
     */
    ServerConfig.prototype.getReportImagesAvailable = function () {
        var reportImagesAvailable_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("reportImagesAvailable");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getBooleanProperty(this._getValidClosetAddress(), reportImagesAvailable_jni);
        //-- Convert abstract(commons::BOOLEAN) from jni(bool) to js(boolean)
        var rc = !!rc_jni;
        Module.deps['TraceUtil'].log("(transport::ServerConfig)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#reportImagesAvailable", "-->", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(rc));
        return rc;
    };
    /**
     * @param {boolean} value
     *
     */
    ServerConfig.prototype.setReportImagesAvailable = function (value) {
        //-- Convert abstract(commons::BOOLEAN) from js(boolean) to jni(bool)
        var value_jni = !!value;
        var reportImagesAvailable_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("reportImagesAvailable");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setBooleanProperty(this._getValidClosetAddress(), value_jni, reportImagesAvailable_name_jni);
        Module.deps['TraceUtil'].log("(transport::ServerConfig)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#reportImagesAvailable", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    ServerConfig.prototype.getReportImagesJobCreationUrl = function () {
        var reportImagesJobCreationUrl_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("reportImagesJobCreationUrl");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), reportImagesJobCreationUrl_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::ServerConfig)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#reportImagesJobCreationUrl", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    ServerConfig.prototype.setReportImagesJobCreationUrl = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var reportImagesJobCreationUrl_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("reportImagesJobCreationUrl");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, reportImagesJobCreationUrl_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::ServerConfig)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#reportImagesJobCreationUrl", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {boolean}
     */
    ServerConfig.prototype.getEnableInteractiveData = function () {
        var enableInteractiveData_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("enableInteractiveData");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getBooleanProperty(this._getValidClosetAddress(), enableInteractiveData_jni);
        //-- Convert abstract(commons::BOOLEAN) from jni(bool) to js(boolean)
        var rc = !!rc_jni;
        Module.deps['TraceUtil'].log("(transport::ServerConfig)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#enableInteractiveData", "-->", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(rc));
        return rc;
    };
    /**
     * @param {boolean} value
     *
     */
    ServerConfig.prototype.setEnableInteractiveData = function (value) {
        //-- Convert abstract(commons::BOOLEAN) from js(boolean) to jni(bool)
        var value_jni = !!value;
        var enableInteractiveData_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("enableInteractiveData");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setBooleanProperty(this._getValidClosetAddress(), value_jni, enableInteractiveData_name_jni);
        Module.deps['TraceUtil'].log("(transport::ServerConfig)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#enableInteractiveData", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(value));
        return this;
    };
    /**
     * @return {boolean}
     */
    ServerConfig.prototype.getAllowWebContentForMobile = function () {
        var allowWebContentForMobile_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("allowWebContentForMobile");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getBooleanProperty(this._getValidClosetAddress(), allowWebContentForMobile_jni);
        //-- Convert abstract(commons::BOOLEAN) from jni(bool) to js(boolean)
        var rc = !!rc_jni;
        Module.deps['TraceUtil'].log("(transport::ServerConfig)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#allowWebContentForMobile", "-->", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(rc));
        return rc;
    };
    /**
     * @param {boolean} value
     *
     */
    ServerConfig.prototype.setAllowWebContentForMobile = function (value) {
        //-- Convert abstract(commons::BOOLEAN) from js(boolean) to jni(bool)
        var value_jni = !!value;
        var allowWebContentForMobile_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("allowWebContentForMobile");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setBooleanProperty(this._getValidClosetAddress(), value_jni, allowWebContentForMobile_name_jni);
        Module.deps['TraceUtil'].log("(transport::ServerConfig)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#allowWebContentForMobile", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    ServerConfig.prototype.getIframeSandbox = function () {
        var iframeSandbox_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("iframeSandbox");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), iframeSandbox_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::ServerConfig)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#iframeSandbox", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    ServerConfig.prototype.setIframeSandbox = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var iframeSandbox_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("iframeSandbox");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, iframeSandbox_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::ServerConfig)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#iframeSandbox", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    exports.default = ServerConfig;
});
