sas.ltjs.define(["require", "exports", "sas/ltjs/commons/ltjsEnvironment", "sas/ltjs/commons/WrappableCloset", "sas/ltjs/commons/events/EventDispatcher", "sas/ltjs/transport/lib", "./MediaType", "sas/ltjs/commons/models/particles/Link"], function (require, exports, ltjsEnvironment_1, WrappableCloset_1, EventDispatcher_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var ReportRendered = ltjsEnvironment_1.createModule([114, 13, 50265, 50161, 50217], EventDispatcher_1.default);
    /**
     *
     */
    ReportRendered._create = function () {
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_ReportRendered_create();
        //-- Convert abstract(commons::VOID) from jni(void) to js()
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::ReportRendered)", "static", "new", "-->", "(transport::ReportRendered)", rc);
        return rc;
    };
    /**
     * @return {string| null}
     */
    ReportRendered.prototype.getId = function () {
        var id_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("id");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), id_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::ReportRendered)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#id", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    ReportRendered.prototype.setId = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var id_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("id");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, id_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::ReportRendered)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#id", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    ReportRendered.prototype.getOwner = function () {
        var owner_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("owner");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), owner_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::ReportRendered)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#owner", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    ReportRendered.prototype.setOwner = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var owner_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("owner");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, owner_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::ReportRendered)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#owner", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {Array.<Link| null> | null}
     */
    ReportRendered.prototype.getLinks = function () {
        var links_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("links");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getWrappableVectorProperty(this._getValidClosetAddress(), links_jni);
        //-- Convert abstract(<commons::Link>) from jni(size_t) to js(Link)
        var rc = WrappableCloset_1.getWrapperArray(rc_jni);
        Module.deps['TraceUtil'].log("(transport::ReportRendered)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#links", "-->", "(MONITORED_VECTOR<commons::Link>)", Module.deps['TraceUtil'].traceConversions.convertArray(rc, Module.deps['TraceUtil'].traceConversions.convertModel));
        return rc;
    };
    /**
     * @param {Array.<Link| null> | null} value
     *
     */
    ReportRendered.prototype.setLinks = function (value) {
        //-- Convert abstract(<commons::Link>) from js(Link) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertObjectArrayToC(value);
        var links_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("links");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setWrappableVectorProperty(this._getValidClosetAddress(), value_jni, links_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::ReportRendered)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#links", "(MONITORED_VECTOR<commons::Link>)", Module.deps['TraceUtil'].traceConversions.convertArray(value, Module.deps['TraceUtil'].traceConversions.convertModel));
        return this;
    };
    exports.default = ReportRendered;
});
