sas.ltjs.define(["require", "exports", "sas/ltjs/commons/ltjsEnvironment", "sas/ltjs/commons/WrappableCloset", "sas/ltjs/commons/events/EventDispatcher", "sas/ltjs/transport/lib", "./MediaType", "./particles/ReportDataLevel", "./particles/ReportAssetURL", "./particles/File", "sas/ltjs/commons/models/particles/Link", "./particles/ReportPackageUpdateCharacteristic"], function (require, exports, ltjsEnvironment_1, WrappableCloset_1, EventDispatcher_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var ReportManifest = ltjsEnvironment_1.createModule([114, 13, 50265, 50161, 50210], EventDispatcher_1.default);
    /**
     *
     */
    ReportManifest._create = function () {
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_ReportManifest_create();
        //-- Convert abstract(commons::VOID) from jni(void) to js()
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::ReportManifest)", "static", "new", "-->", "(transport::ReportManifest)", rc);
        return rc;
    };
    /**
     * @return {string| null}
     */
    ReportManifest.prototype.getXmlElementName = function () {
        var xmlElementName_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("xmlElementName");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), xmlElementName_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::ReportManifest)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#xmlElementName", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    ReportManifest.prototype.setXmlElementName = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var xmlElementName_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("xmlElementName");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, xmlElementName_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::ReportManifest)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#xmlElementName", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    ReportManifest.prototype.getCacheKey = function () {
        var cacheKey_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("cacheKey");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), cacheKey_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::ReportManifest)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#cacheKey", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    ReportManifest.prototype.setCacheKey = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var cacheKey_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("cacheKey");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, cacheKey_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::ReportManifest)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#cacheKey", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    ReportManifest.prototype.getDate = function () {
        var date_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("date");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), date_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::ReportManifest)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#date", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    ReportManifest.prototype.setDate = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var date_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("date");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, date_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::ReportManifest)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#date", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {ReportDataLevel}
     */
    ReportManifest.prototype.getDataLevel = function () {
        var dataLevel_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("dataLevel");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getIntProperty(this._getValidClosetAddress(), dataLevel_jni);
        //-- Convert abstract(transport::ReportDataLevel) from jni(int) to js(ReportDataLevel)
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::ReportManifest)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#dataLevel", "-->", "(transport::ReportDataLevel::type)", Module.deps['TraceUtil'].traceConversions.convertEnum(rc));
        return rc;
    };
    /**
     * @param {ReportDataLevel} value
     *
     */
    ReportManifest.prototype.setDataLevel = function (value) {
        //-- Convert abstract(transport::ReportDataLevel) from js(ReportDataLevel) to jni(int)
        var value_jni = value;
        var dataLevel_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("dataLevel");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setIntProperty(this._getValidClosetAddress(), value_jni, dataLevel_name_jni);
        Module.deps['TraceUtil'].log("(transport::ReportManifest)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#dataLevel", "(transport::ReportDataLevel::type)", Module.deps['TraceUtil'].traceConversions.convertEnum(value));
        return this;
    };
    /**
     * @return {number}
     */
    ReportManifest.prototype.getTotalSize = function () {
        var totalSize_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("totalSize");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getIntProperty(this._getValidClosetAddress(), totalSize_jni);
        //-- Convert abstract(commons::INT) from jni(int) to js(number)
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::ReportManifest)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#totalSize", "-->", "(commons::INT)", Module.deps['TraceUtil'].traceConversions.convertInt(rc));
        return rc;
    };
    /**
     * @param {number} value
     *
     */
    ReportManifest.prototype.setTotalSize = function (value) {
        //-- Convert abstract(commons::INT) from js(number) to jni(int)
        var value_jni = value;
        var totalSize_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("totalSize");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setIntProperty(this._getValidClosetAddress(), value_jni, totalSize_name_jni);
        Module.deps['TraceUtil'].log("(transport::ReportManifest)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#totalSize", "(commons::INT)", Module.deps['TraceUtil'].traceConversions.convertInt(value));
        return this;
    };
    /**
     * @return {Array.<ReportAssetURL| null> | null}
     */
    ReportManifest.prototype.getUrls = function () {
        var urls_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("urls");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getWrappableVectorProperty(this._getValidClosetAddress(), urls_jni);
        //-- Convert abstract(<transport::ReportAssetURL>) from jni(size_t) to js(ReportAssetURL)
        var rc = WrappableCloset_1.getWrapperArray(rc_jni);
        Module.deps['TraceUtil'].log("(transport::ReportManifest)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#urls", "-->", "(MONITORED_VECTOR<transport::ReportAssetURL>)", Module.deps['TraceUtil'].traceConversions.convertArray(rc, Module.deps['TraceUtil'].traceConversions.convertModel));
        return rc;
    };
    /**
     * @param {Array.<ReportAssetURL| null> | null} value
     *
     */
    ReportManifest.prototype.setUrls = function (value) {
        //-- Convert abstract(<transport::ReportAssetURL>) from js(ReportAssetURL) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertObjectArrayToC(value);
        var urls_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("urls");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setWrappableVectorProperty(this._getValidClosetAddress(), value_jni, urls_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::ReportManifest)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#urls", "(MONITORED_VECTOR<transport::ReportAssetURL>)", Module.deps['TraceUtil'].traceConversions.convertArray(value, Module.deps['TraceUtil'].traceConversions.convertModel));
        return this;
    };
    /**
     * @return {string| null}
     */
    ReportManifest.prototype.getLocale = function () {
        var locale_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("locale");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), locale_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::ReportManifest)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#locale", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    ReportManifest.prototype.setLocale = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var locale_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("locale");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, locale_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::ReportManifest)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#locale", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    ReportManifest.prototype.getSource = function () {
        var source_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("source");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), source_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::ReportManifest)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#source", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    ReportManifest.prototype.setSource = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var source_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("source");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, source_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::ReportManifest)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#source", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    ReportManifest.prototype.getWarnings = function () {
        var warnings_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("warnings");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), warnings_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::ReportManifest)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#warnings", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    ReportManifest.prototype.setWarnings = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var warnings_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("warnings");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, warnings_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::ReportManifest)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#warnings", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {Array.<File| null> | null}
     */
    ReportManifest.prototype.getFiles = function () {
        var files_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("files");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getWrappableVectorProperty(this._getValidClosetAddress(), files_jni);
        //-- Convert abstract(<transport::File>) from jni(size_t) to js(File)
        var rc = WrappableCloset_1.getWrapperArray(rc_jni);
        Module.deps['TraceUtil'].log("(transport::ReportManifest)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#files", "-->", "(MONITORED_VECTOR<transport::File>)", Module.deps['TraceUtil'].traceConversions.convertArray(rc, Module.deps['TraceUtil'].traceConversions.convertModel));
        return rc;
    };
    /**
     * @param {Array.<File| null> | null} value
     *
     */
    ReportManifest.prototype.setFiles = function (value) {
        //-- Convert abstract(<transport::File>) from js(File) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertObjectArrayToC(value);
        var files_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("files");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setWrappableVectorProperty(this._getValidClosetAddress(), value_jni, files_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::ReportManifest)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#files", "(MONITORED_VECTOR<transport::File>)", Module.deps['TraceUtil'].traceConversions.convertArray(value, Module.deps['TraceUtil'].traceConversions.convertModel));
        return this;
    };
    /**
     * @return {Array.<Link| null> | null}
     */
    ReportManifest.prototype.getLinks = function () {
        var links_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("links");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getWrappableVectorProperty(this._getValidClosetAddress(), links_jni);
        //-- Convert abstract(<commons::Link>) from jni(size_t) to js(Link)
        var rc = WrappableCloset_1.getWrapperArray(rc_jni);
        Module.deps['TraceUtil'].log("(transport::ReportManifest)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#links", "-->", "(MONITORED_VECTOR<commons::Link>)", Module.deps['TraceUtil'].traceConversions.convertArray(rc, Module.deps['TraceUtil'].traceConversions.convertModel));
        return rc;
    };
    /**
     * @param {Array.<Link| null> | null} value
     *
     */
    ReportManifest.prototype.setLinks = function (value) {
        //-- Convert abstract(<commons::Link>) from js(Link) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertObjectArrayToC(value);
        var links_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("links");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setWrappableVectorProperty(this._getValidClosetAddress(), value_jni, links_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::ReportManifest)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#links", "(MONITORED_VECTOR<commons::Link>)", Module.deps['TraceUtil'].traceConversions.convertArray(value, Module.deps['TraceUtil'].traceConversions.convertModel));
        return this;
    };
    /**
     * @return {string| null}
     */
    ReportManifest.prototype.getModifiedTimeStamp = function () {
        var modifiedTimeStamp_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("modifiedTimeStamp");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), modifiedTimeStamp_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::ReportManifest)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#modifiedTimeStamp", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    ReportManifest.prototype.setModifiedTimeStamp = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var modifiedTimeStamp_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("modifiedTimeStamp");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, modifiedTimeStamp_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::ReportManifest)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#modifiedTimeStamp", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {ReportPackageUpdateCharacteristic}
     */
    ReportManifest.prototype.getUpdateCharacteristic = function () {
        var updateCharacteristic_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("updateCharacteristic");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getIntProperty(this._getValidClosetAddress(), updateCharacteristic_jni);
        //-- Convert abstract(transport::ReportPackageUpdateCharacteristic) from jni(int) to js(ReportPackageUpdateCharacteristic)
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::ReportManifest)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#updateCharacteristic", "-->", "(transport::ReportPackageUpdateCharacteristic::type)", Module.deps['TraceUtil'].traceConversions.convertEnum(rc));
        return rc;
    };
    /**
     * @param {ReportPackageUpdateCharacteristic} value
     *
     */
    ReportManifest.prototype.setUpdateCharacteristic = function (value) {
        //-- Convert abstract(transport::ReportPackageUpdateCharacteristic) from js(ReportPackageUpdateCharacteristic) to jni(int)
        var value_jni = value;
        var updateCharacteristic_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("updateCharacteristic");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setIntProperty(this._getValidClosetAddress(), value_jni, updateCharacteristic_name_jni);
        Module.deps['TraceUtil'].log("(transport::ReportManifest)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#updateCharacteristic", "(transport::ReportPackageUpdateCharacteristic::type)", Module.deps['TraceUtil'].traceConversions.convertEnum(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    ReportManifest.prototype.getFormatLocale = function () {
        var formatLocale_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("formatLocale");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), formatLocale_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::ReportManifest)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#formatLocale", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    ReportManifest.prototype.setFormatLocale = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var formatLocale_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("formatLocale");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, formatLocale_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::ReportManifest)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#formatLocale", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    ReportManifest.prototype.getReportElements = function () {
        var reportElements_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("reportElements");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), reportElements_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::ReportManifest)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#reportElements", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    ReportManifest.prototype.setReportElements = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var reportElements_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("reportElements");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, reportElements_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::ReportManifest)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#reportElements", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    ReportManifest.prototype.getReportStateUri = function () {
        var reportStateUri_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("reportStateUri");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), reportStateUri_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::ReportManifest)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#reportStateUri", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    ReportManifest.prototype.setReportStateUri = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var reportStateUri_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("reportStateUri");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, reportStateUri_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::ReportManifest)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#reportStateUri", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    exports.default = ReportManifest;
});
