sas.ltjs.define(["require", "exports", "sas/ltjs/commons/ltjsEnvironment", "sas/ltjs/commons/events/EventDispatcher", "sas/ltjs/transport/lib", "./MediaType", "./particles/ReportImageLayoutType", "./particles/ReportImageSize", "./particles/ReportImageSelectionType"], function (require, exports, ltjsEnvironment_1, EventDispatcher_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var ReportImageJobRequestDetails = ltjsEnvironment_1.createModule([114, 13, 50265, 50161, 50203], EventDispatcher_1.default);
    /**
     *
     */
    ReportImageJobRequestDetails._create = function () {
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_ReportImageJobRequestDetails_create();
        //-- Convert abstract(commons::VOID) from jni(void) to js()
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::ReportImageJobRequestDetails)", "static", "new", "-->", "(transport::ReportImageJobRequestDetails)", rc);
        return rc;
    };
    /**
     * @return {string| null}
     */
    ReportImageJobRequestDetails.prototype.getReportUri = function () {
        var reportUri_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("reportUri");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), reportUri_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::ReportImageJobRequestDetails)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#reportUri", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    ReportImageJobRequestDetails.prototype.setReportUri = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var reportUri_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("reportUri");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, reportUri_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::ReportImageJobRequestDetails)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#reportUri", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {ReportImageLayoutType}
     */
    ReportImageJobRequestDetails.prototype.getLayoutType = function () {
        var layoutType_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("layoutType");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getIntProperty(this._getValidClosetAddress(), layoutType_jni);
        //-- Convert abstract(transport::ReportImageLayoutType) from jni(int) to js(ReportImageLayoutType)
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::ReportImageJobRequestDetails)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#layoutType", "-->", "(transport::ReportImageLayoutType::type)", Module.deps['TraceUtil'].traceConversions.convertEnum(rc));
        return rc;
    };
    /**
     * @param {ReportImageLayoutType} value
     *
     */
    ReportImageJobRequestDetails.prototype.setLayoutType = function (value) {
        //-- Convert abstract(transport::ReportImageLayoutType) from js(ReportImageLayoutType) to jni(int)
        var value_jni = value;
        var layoutType_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("layoutType");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setIntProperty(this._getValidClosetAddress(), value_jni, layoutType_name_jni);
        Module.deps['TraceUtil'].log("(transport::ReportImageJobRequestDetails)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#layoutType", "(transport::ReportImageLayoutType::type)", Module.deps['TraceUtil'].traceConversions.convertEnum(value));
        return this;
    };
    /**
     * @return {ReportImageSize}
     */
    ReportImageJobRequestDetails.prototype.getSize = function () {
        var size_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("size");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getIntProperty(this._getValidClosetAddress(), size_jni);
        //-- Convert abstract(transport::ReportImageSize) from jni(int) to js(ReportImageSize)
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::ReportImageJobRequestDetails)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#size", "-->", "(transport::ReportImageSize::type)", Module.deps['TraceUtil'].traceConversions.convertEnum(rc));
        return rc;
    };
    /**
     * @param {ReportImageSize} value
     *
     */
    ReportImageJobRequestDetails.prototype.setSize = function (value) {
        //-- Convert abstract(transport::ReportImageSize) from js(ReportImageSize) to jni(int)
        var value_jni = value;
        var size_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("size");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setIntProperty(this._getValidClosetAddress(), value_jni, size_name_jni);
        Module.deps['TraceUtil'].log("(transport::ReportImageJobRequestDetails)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#size", "(transport::ReportImageSize::type)", Module.deps['TraceUtil'].traceConversions.convertEnum(value));
        return this;
    };
    /**
     * @return {ReportImageSelectionType}
     */
    ReportImageJobRequestDetails.prototype.getSelectionType = function () {
        var selectionType_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("selectionType");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getIntProperty(this._getValidClosetAddress(), selectionType_jni);
        //-- Convert abstract(transport::ReportImageSelectionType) from jni(int) to js(ReportImageSelectionType)
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::ReportImageJobRequestDetails)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#selectionType", "-->", "(transport::ReportImageSelectionType::type)", Module.deps['TraceUtil'].traceConversions.convertEnum(rc));
        return rc;
    };
    /**
     * @param {ReportImageSelectionType} value
     *
     */
    ReportImageJobRequestDetails.prototype.setSelectionType = function (value) {
        //-- Convert abstract(transport::ReportImageSelectionType) from js(ReportImageSelectionType) to jni(int)
        var value_jni = value;
        var selectionType_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("selectionType");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setIntProperty(this._getValidClosetAddress(), value_jni, selectionType_name_jni);
        Module.deps['TraceUtil'].log("(transport::ReportImageJobRequestDetails)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#selectionType", "(transport::ReportImageSelectionType::type)", Module.deps['TraceUtil'].traceConversions.convertEnum(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    ReportImageJobRequestDetails.prototype.getVisualElementNames = function () {
        var visualElementNames_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("visualElementNames");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), visualElementNames_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::ReportImageJobRequestDetails)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#visualElementNames", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    ReportImageJobRequestDetails.prototype.setVisualElementNames = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var visualElementNames_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("visualElementNames");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, visualElementNames_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::ReportImageJobRequestDetails)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#visualElementNames", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {number}
     */
    ReportImageJobRequestDetails.prototype.getSectionIndex = function () {
        var sectionIndex_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("sectionIndex");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getIntProperty(this._getValidClosetAddress(), sectionIndex_jni);
        //-- Convert abstract(commons::INT) from jni(int) to js(number)
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::ReportImageJobRequestDetails)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#sectionIndex", "-->", "(commons::INT)", Module.deps['TraceUtil'].traceConversions.convertInt(rc));
        return rc;
    };
    /**
     * @param {number} value
     *
     */
    ReportImageJobRequestDetails.prototype.setSectionIndex = function (value) {
        //-- Convert abstract(commons::INT) from js(number) to jni(int)
        var value_jni = value;
        var sectionIndex_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("sectionIndex");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setIntProperty(this._getValidClosetAddress(), value_jni, sectionIndex_name_jni);
        Module.deps['TraceUtil'].log("(transport::ReportImageJobRequestDetails)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#sectionIndex", "(commons::INT)", Module.deps['TraceUtil'].traceConversions.convertInt(value));
        return this;
    };
    /**
     * @return {boolean}
     */
    ReportImageJobRequestDetails.prototype.getRefresh = function () {
        var refresh_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("refresh");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getBooleanProperty(this._getValidClosetAddress(), refresh_jni);
        //-- Convert abstract(commons::BOOLEAN) from jni(bool) to js(boolean)
        var rc = !!rc_jni;
        Module.deps['TraceUtil'].log("(transport::ReportImageJobRequestDetails)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#refresh", "-->", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(rc));
        return rc;
    };
    /**
     * @param {boolean} value
     *
     */
    ReportImageJobRequestDetails.prototype.setRefresh = function (value) {
        //-- Convert abstract(commons::BOOLEAN) from js(boolean) to jni(bool)
        var value_jni = !!value;
        var refresh_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("refresh");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setBooleanProperty(this._getValidClosetAddress(), value_jni, refresh_name_jni);
        Module.deps['TraceUtil'].log("(transport::ReportImageJobRequestDetails)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#refresh", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(value));
        return this;
    };
    /**
     * @return {number}
     */
    ReportImageJobRequestDetails.prototype.getRenderLimit = function () {
        var renderLimit_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("renderLimit");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getIntProperty(this._getValidClosetAddress(), renderLimit_jni);
        //-- Convert abstract(commons::INT) from jni(int) to js(number)
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::ReportImageJobRequestDetails)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#renderLimit", "-->", "(commons::INT)", Module.deps['TraceUtil'].traceConversions.convertInt(rc));
        return rc;
    };
    /**
     * @param {number} value
     *
     */
    ReportImageJobRequestDetails.prototype.setRenderLimit = function (value) {
        //-- Convert abstract(commons::INT) from js(number) to jni(int)
        var value_jni = value;
        var renderLimit_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("renderLimit");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setIntProperty(this._getValidClosetAddress(), value_jni, renderLimit_name_jni);
        Module.deps['TraceUtil'].log("(transport::ReportImageJobRequestDetails)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#renderLimit", "(commons::INT)", Module.deps['TraceUtil'].traceConversions.convertInt(value));
        return this;
    };
    exports.default = ReportImageJobRequestDetails;
});
