sas.ltjs.define(["require", "exports", "sas/ltjs/commons/ltjsEnvironment", "sas/ltjs/commons/events/EventDispatcher", "sas/ltjs/transport/lib", "./MediaType"], function (require, exports, ltjsEnvironment_1, EventDispatcher_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var ReportDataProperties = ltjsEnvironment_1.createModule([114, 13, 50265, 50161, 50196], EventDispatcher_1.default);
    /**
     *
     */
    ReportDataProperties._create = function () {
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_ReportDataProperties_create();
        //-- Convert abstract(commons::VOID) from jni(void) to js()
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::ReportDataProperties)", "static", "new", "-->", "(transport::ReportDataProperties)", rc);
        return rc;
    };
    /**
     * @return {number}
     */
    ReportDataProperties.prototype.getComparisonEpsilon = function () {
        var comparisonEpsilon_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("comparisonEpsilon");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getFloatProperty(this._getValidClosetAddress(), comparisonEpsilon_jni);
        //-- Convert abstract(commons::FLOAT) from jni(double) to js(number)
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::ReportDataProperties)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#comparisonEpsilon", "-->", "(commons::FLOAT)", Module.deps['TraceUtil'].traceConversions.convertFloat(rc));
        return rc;
    };
    /**
     * @param {number} value
     *
     */
    ReportDataProperties.prototype.setComparisonEpsilon = function (value) {
        //-- Convert abstract(commons::FLOAT) from js(number) to jni(double)
        var value_jni = value;
        var comparisonEpsilon_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("comparisonEpsilon");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setFloatProperty(this._getValidClosetAddress(), value_jni, comparisonEpsilon_name_jni);
        Module.deps['TraceUtil'].log("(transport::ReportDataProperties)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#comparisonEpsilon", "(commons::FLOAT)", Module.deps['TraceUtil'].traceConversions.convertFloat(value));
        return this;
    };
    /**
     * @return {boolean}
     */
    ReportDataProperties.prototype.getEnableInteractiveData = function () {
        var enableInteractiveData_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("enableInteractiveData");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getBooleanProperty(this._getValidClosetAddress(), enableInteractiveData_jni);
        //-- Convert abstract(commons::BOOLEAN) from jni(bool) to js(boolean)
        var rc = !!rc_jni;
        Module.deps['TraceUtil'].log("(transport::ReportDataProperties)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#enableInteractiveData", "-->", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(rc));
        return rc;
    };
    /**
     * @param {boolean} value
     *
     */
    ReportDataProperties.prototype.setEnableInteractiveData = function (value) {
        //-- Convert abstract(commons::BOOLEAN) from js(boolean) to jni(bool)
        var value_jni = !!value;
        var enableInteractiveData_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("enableInteractiveData");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setBooleanProperty(this._getValidClosetAddress(), value_jni, enableInteractiveData_name_jni);
        Module.deps['TraceUtil'].log("(transport::ReportDataProperties)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#enableInteractiveData", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(value));
        return this;
    };
    exports.default = ReportDataProperties;
});
