sas.ltjs.define(["require", "exports", "sas/ltjs/commons/ltjsEnvironment", "sas/ltjs/commons/WrappableCloset", "sas/ltjs/commons/ClosetObject", "sas/ltjs/commons/events/EventDispatcher", "sas/ltjs/transport/lib", "./MediaType", "./particles/MicroserviceJobState", "./particles/ServiceError", "./particles/ReportDataJobResults", "sas/ltjs/commons/models/particles/Link"], function (require, exports, ltjsEnvironment_1, WrappableCloset_1, ClosetObject_1, EventDispatcher_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var ReportDataJob = ltjsEnvironment_1.createModule([114, 13, 50265, 50161, 50193], EventDispatcher_1.default);
    /**
     *
     */
    ReportDataJob._create = function () {
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_ReportDataJob_create();
        //-- Convert abstract(commons::VOID) from jni(void) to js()
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::ReportDataJob)", "static", "new", "-->", "(transport::ReportDataJob)", rc);
        return rc;
    };
    /**
     * @return {string| null}
     */
    ReportDataJob.prototype.getId = function () {
        var id_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("id");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), id_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::ReportDataJob)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#id", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    ReportDataJob.prototype.setId = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var id_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("id");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, id_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::ReportDataJob)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#id", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {MicroserviceJobState}
     */
    ReportDataJob.prototype.getState = function () {
        var state_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("state");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getIntProperty(this._getValidClosetAddress(), state_jni);
        //-- Convert abstract(transport::MicroserviceJobState) from jni(int) to js(MicroserviceJobState)
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::ReportDataJob)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#state", "-->", "(transport::MicroserviceJobState::type)", Module.deps['TraceUtil'].traceConversions.convertEnum(rc));
        return rc;
    };
    /**
     * @param {MicroserviceJobState} value
     *
     */
    ReportDataJob.prototype.setState = function (value) {
        //-- Convert abstract(transport::MicroserviceJobState) from js(MicroserviceJobState) to jni(int)
        var value_jni = value;
        var state_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("state");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setIntProperty(this._getValidClosetAddress(), value_jni, state_name_jni);
        Module.deps['TraceUtil'].log("(transport::ReportDataJob)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#state", "(transport::MicroserviceJobState::type)", Module.deps['TraceUtil'].traceConversions.convertEnum(value));
        return this;
    };
    /**
     * @return {number}
     */
    ReportDataJob.prototype.getDuration = function () {
        var duration_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("duration");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getFloatProperty(this._getValidClosetAddress(), duration_jni);
        //-- Convert abstract(commons::FLOAT) from jni(double) to js(number)
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::ReportDataJob)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#duration", "-->", "(commons::FLOAT)", Module.deps['TraceUtil'].traceConversions.convertFloat(rc));
        return rc;
    };
    /**
     * @param {number} value
     *
     */
    ReportDataJob.prototype.setDuration = function (value) {
        //-- Convert abstract(commons::FLOAT) from js(number) to jni(double)
        var value_jni = value;
        var duration_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("duration");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setFloatProperty(this._getValidClosetAddress(), value_jni, duration_name_jni);
        Module.deps['TraceUtil'].log("(transport::ReportDataJob)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#duration", "(commons::FLOAT)", Module.deps['TraceUtil'].traceConversions.convertFloat(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    ReportDataJob.prototype.getCreatedBy = function () {
        var createdBy_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("createdBy");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), createdBy_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::ReportDataJob)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#createdBy", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    ReportDataJob.prototype.setCreatedBy = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var createdBy_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("createdBy");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, createdBy_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::ReportDataJob)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#createdBy", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    ReportDataJob.prototype.getCreationTimeStamp = function () {
        var creationTimeStamp_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("creationTimeStamp");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), creationTimeStamp_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::ReportDataJob)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#creationTimeStamp", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    ReportDataJob.prototype.setCreationTimeStamp = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var creationTimeStamp_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("creationTimeStamp");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, creationTimeStamp_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::ReportDataJob)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#creationTimeStamp", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    ReportDataJob.prototype.getStartedTimeStamp = function () {
        var startedTimeStamp_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("startedTimeStamp");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), startedTimeStamp_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::ReportDataJob)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#startedTimeStamp", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    ReportDataJob.prototype.setStartedTimeStamp = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var startedTimeStamp_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("startedTimeStamp");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, startedTimeStamp_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::ReportDataJob)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#startedTimeStamp", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    ReportDataJob.prototype.getCompletedTimeStamp = function () {
        var completedTimeStamp_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("completedTimeStamp");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), completedTimeStamp_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::ReportDataJob)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#completedTimeStamp", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    ReportDataJob.prototype.setCompletedTimeStamp = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var completedTimeStamp_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("completedTimeStamp");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, completedTimeStamp_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::ReportDataJob)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#completedTimeStamp", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {ServiceError| null}
     */
    ReportDataJob.prototype.getError = function () {
        var error_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("error");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getWrappableProperty(this._getValidClosetAddress(), error_jni);
        //-- Convert abstract(transport::ServiceError) from jni(size_t) to js(ServiceError)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::ReportDataJob)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#error", "-->", "(transport::ServiceError)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * @param {ServiceError| null} value
     *
     */
    ReportDataJob.prototype.setError = function (value) {
        //-- Convert abstract(transport::ServiceError) from js(ServiceError) to jni(size_t)
        var value_jni = ClosetObject_1.default._getValidClosetAddress(value);
        var error_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("error");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setWrappableProperty(this._getValidClosetAddress(), value_jni, error_name_jni);
        Module.deps['TraceUtil'].log("(transport::ReportDataJob)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#error", "(transport::ServiceError)", Module.deps['TraceUtil'].traceConversions.convertModel(value));
        return this;
    };
    /**
     * @return {ReportDataJobResults| null}
     */
    ReportDataJob.prototype.getResults = function () {
        var results_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("results");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getWrappableProperty(this._getValidClosetAddress(), results_jni);
        //-- Convert abstract(transport::ReportDataJobResults) from jni(size_t) to js(ReportDataJobResults)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::ReportDataJob)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#results", "-->", "(transport::ReportDataJobResults)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * @param {ReportDataJobResults| null} value
     *
     */
    ReportDataJob.prototype.setResults = function (value) {
        //-- Convert abstract(transport::ReportDataJobResults) from js(ReportDataJobResults) to jni(size_t)
        var value_jni = ClosetObject_1.default._getValidClosetAddress(value);
        var results_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("results");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setWrappableProperty(this._getValidClosetAddress(), value_jni, results_name_jni);
        Module.deps['TraceUtil'].log("(transport::ReportDataJob)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#results", "(transport::ReportDataJobResults)", Module.deps['TraceUtil'].traceConversions.convertModel(value));
        return this;
    };
    /**
     * @return {Array.<Link| null> | null}
     */
    ReportDataJob.prototype.getLinks = function () {
        var links_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("links");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getWrappableVectorProperty(this._getValidClosetAddress(), links_jni);
        //-- Convert abstract(<commons::Link>) from jni(size_t) to js(Link)
        var rc = WrappableCloset_1.getWrapperArray(rc_jni);
        Module.deps['TraceUtil'].log("(transport::ReportDataJob)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#links", "-->", "(MONITORED_VECTOR<commons::Link>)", Module.deps['TraceUtil'].traceConversions.convertArray(rc, Module.deps['TraceUtil'].traceConversions.convertModel));
        return rc;
    };
    /**
     * @param {Array.<Link| null> | null} value
     *
     */
    ReportDataJob.prototype.setLinks = function (value) {
        //-- Convert abstract(<commons::Link>) from js(Link) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertObjectArrayToC(value);
        var links_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("links");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setWrappableVectorProperty(this._getValidClosetAddress(), value_jni, links_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::ReportDataJob)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#links", "(MONITORED_VECTOR<commons::Link>)", Module.deps['TraceUtil'].traceConversions.convertArray(value, Module.deps['TraceUtil'].traceConversions.convertModel));
        return this;
    };
    exports.default = ReportDataJob;
});
