sas.ltjs.define(["require", "exports", "sas/ltjs/commons/ltjsEnvironment", "sas/ltjs/commons/events/EventDispatcher", "sas/ltjs/transport/lib", "sas/ltjs/transport/models/TransportModel"], function (require, exports, ltjsEnvironment_1, EventDispatcher_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var MediaType = ltjsEnvironment_1.createModule([114, 13, 50265, 50161], EventDispatcher_1.default);
    /**
     *
     */
    MediaType._create = function () {
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_MediaType_create();
        //-- Convert abstract(commons::VOID) from jni(void) to js()
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::MediaType)", "static", "new", "-->", "(transport::MediaType)", rc);
        return rc;
    };
    /**
     * @return {number}
     */
    MediaType.prototype.getVersion = function () {
        var version_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("version");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getIntProperty(this._getValidClosetAddress(), version_jni);
        //-- Convert abstract(commons::INT) from jni(int) to js(number)
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::MediaType)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#version", "-->", "(commons::INT)", Module.deps['TraceUtil'].traceConversions.convertInt(rc));
        return rc;
    };
    /**
     * @param {number} value
     *
     */
    MediaType.prototype.setVersion = function (value) {
        //-- Convert abstract(commons::INT) from js(number) to jni(int)
        var value_jni = value;
        var version_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("version");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setIntProperty(this._getValidClosetAddress(), value_jni, version_name_jni);
        Module.deps['TraceUtil'].log("(transport::MediaType)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#version", "(commons::INT)", Module.deps['TraceUtil'].traceConversions.convertInt(value));
        return this;
    };
    exports.default = MediaType;
});
