sas.ltjs.define(["require", "exports", "sas/ltjs/commons/ltjsEnvironment", "sas/ltjs/commons/events/EventDispatcher", "sas/ltjs/transport/lib", "./MediaType"], function (require, exports, ltjsEnvironment_1, EventDispatcher_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var DeviceRep = ltjsEnvironment_1.createModule([114, 13, 50265, 50161, 50088], EventDispatcher_1.default);
    /**
     *
     */
    DeviceRep._create = function () {
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_DeviceRep_create();
        //-- Convert abstract(commons::VOID) from jni(void) to js()
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::DeviceRep)", "static", "new", "-->", "(transport::DeviceRep)", rc);
        return rc;
    };
    /**
     * @return {string| null}
     */
    DeviceRep.prototype.getId = function () {
        var id_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("id");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), id_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::DeviceRep)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#id", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    DeviceRep.prototype.setId = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var id_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("id");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, id_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::DeviceRep)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#id", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    exports.default = DeviceRep;
});
