sas.ltjs.define(["require", "exports", "sas/ltjs/commons/ltjsEnvironment", "sas/ltjs/commons/events/EventDispatcher", "sas/ltjs/transport/lib", "./MediaType"], function (require, exports, ltjsEnvironment_1, EventDispatcher_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var AuthorizedLinks = ltjsEnvironment_1.createModule([114, 13, 50265, 50161, 50026], EventDispatcher_1.default);
    /**
     *
     */
    AuthorizedLinks._create = function () {
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_AuthorizedLinks_create();
        //-- Convert abstract(commons::VOID) from jni(void) to js()
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::AuthorizedLinks)", "static", "new", "-->", "(transport::AuthorizedLinks)", rc);
        return rc;
    };
    /**
     * @return {boolean}
     */
    AuthorizedLinks.prototype.getAccessComments = function () {
        var accessComments_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("accessComments");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getBooleanProperty(this._getValidClosetAddress(), accessComments_jni);
        //-- Convert abstract(commons::BOOLEAN) from jni(bool) to js(boolean)
        var rc = !!rc_jni;
        Module.deps['TraceUtil'].log("(transport::AuthorizedLinks)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#accessComments", "-->", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(rc));
        return rc;
    };
    /**
     * @param {boolean} value
     *
     */
    AuthorizedLinks.prototype.setAccessComments = function (value) {
        //-- Convert abstract(commons::BOOLEAN) from js(boolean) to jni(bool)
        var value_jni = !!value;
        var accessComments_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("accessComments");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setBooleanProperty(this._getValidClosetAddress(), value_jni, accessComments_name_jni);
        Module.deps['TraceUtil'].log("(transport::AuthorizedLinks)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#accessComments", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(value));
        return this;
    };
    /**
     * @return {boolean}
     */
    AuthorizedLinks.prototype.getAccessEsriPremiumServices = function () {
        var accessEsriPremiumServices_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("accessEsriPremiumServices");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getBooleanProperty(this._getValidClosetAddress(), accessEsriPremiumServices_jni);
        //-- Convert abstract(commons::BOOLEAN) from jni(bool) to js(boolean)
        var rc = !!rc_jni;
        Module.deps['TraceUtil'].log("(transport::AuthorizedLinks)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#accessEsriPremiumServices", "-->", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(rc));
        return rc;
    };
    /**
     * @param {boolean} value
     *
     */
    AuthorizedLinks.prototype.setAccessEsriPremiumServices = function (value) {
        //-- Convert abstract(commons::BOOLEAN) from js(boolean) to jni(bool)
        var value_jni = !!value;
        var accessEsriPremiumServices_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("accessEsriPremiumServices");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setBooleanProperty(this._getValidClosetAddress(), value_jni, accessEsriPremiumServices_name_jni);
        Module.deps['TraceUtil'].log("(transport::AuthorizedLinks)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#accessEsriPremiumServices", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(value));
        return this;
    };
    /**
     * @return {boolean}
     */
    AuthorizedLinks.prototype.getAccessMobileBI = function () {
        var accessMobileBI_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("accessMobileBI");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getBooleanProperty(this._getValidClosetAddress(), accessMobileBI_jni);
        //-- Convert abstract(commons::BOOLEAN) from jni(bool) to js(boolean)
        var rc = !!rc_jni;
        Module.deps['TraceUtil'].log("(transport::AuthorizedLinks)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#accessMobileBI", "-->", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(rc));
        return rc;
    };
    /**
     * @param {boolean} value
     *
     */
    AuthorizedLinks.prototype.setAccessMobileBI = function (value) {
        //-- Convert abstract(commons::BOOLEAN) from js(boolean) to jni(bool)
        var value_jni = !!value;
        var accessMobileBI_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("accessMobileBI");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setBooleanProperty(this._getValidClosetAddress(), value_jni, accessMobileBI_name_jni);
        Module.deps['TraceUtil'].log("(transport::AuthorizedLinks)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#accessMobileBI", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(value));
        return this;
    };
    /**
     * @return {boolean}
     */
    AuthorizedLinks.prototype.getAccessVisualAnalyticsViewer = function () {
        var accessVisualAnalyticsViewer_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("accessVisualAnalyticsViewer");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getBooleanProperty(this._getValidClosetAddress(), accessVisualAnalyticsViewer_jni);
        //-- Convert abstract(commons::BOOLEAN) from jni(bool) to js(boolean)
        var rc = !!rc_jni;
        Module.deps['TraceUtil'].log("(transport::AuthorizedLinks)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#accessVisualAnalyticsViewer", "-->", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(rc));
        return rc;
    };
    /**
     * @param {boolean} value
     *
     */
    AuthorizedLinks.prototype.setAccessVisualAnalyticsViewer = function (value) {
        //-- Convert abstract(commons::BOOLEAN) from js(boolean) to jni(bool)
        var value_jni = !!value;
        var accessVisualAnalyticsViewer_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("accessVisualAnalyticsViewer");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setBooleanProperty(this._getValidClosetAddress(), value_jni, accessVisualAnalyticsViewer_name_jni);
        Module.deps['TraceUtil'].log("(transport::AuthorizedLinks)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#accessVisualAnalyticsViewer", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(value));
        return this;
    };
    /**
     * @return {boolean}
     */
    AuthorizedLinks.prototype.getAccessVisualAnalytics = function () {
        var accessVisualAnalytics_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("accessVisualAnalytics");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getBooleanProperty(this._getValidClosetAddress(), accessVisualAnalytics_jni);
        //-- Convert abstract(commons::BOOLEAN) from jni(bool) to js(boolean)
        var rc = !!rc_jni;
        Module.deps['TraceUtil'].log("(transport::AuthorizedLinks)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#accessVisualAnalytics", "-->", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(rc));
        return rc;
    };
    /**
     * @param {boolean} value
     *
     */
    AuthorizedLinks.prototype.setAccessVisualAnalytics = function (value) {
        //-- Convert abstract(commons::BOOLEAN) from js(boolean) to jni(bool)
        var value_jni = !!value;
        var accessVisualAnalytics_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("accessVisualAnalytics");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setBooleanProperty(this._getValidClosetAddress(), value_jni, accessVisualAnalytics_name_jni);
        Module.deps['TraceUtil'].log("(transport::AuthorizedLinks)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#accessVisualAnalytics", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(value));
        return this;
    };
    /**
     * @return {boolean}
     */
    AuthorizedLinks.prototype.getCacheMobileReportData = function () {
        var cacheMobileReportData_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("cacheMobileReportData");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getBooleanProperty(this._getValidClosetAddress(), cacheMobileReportData_jni);
        //-- Convert abstract(commons::BOOLEAN) from jni(bool) to js(boolean)
        var rc = !!rc_jni;
        Module.deps['TraceUtil'].log("(transport::AuthorizedLinks)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#cacheMobileReportData", "-->", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(rc));
        return rc;
    };
    /**
     * @param {boolean} value
     *
     */
    AuthorizedLinks.prototype.setCacheMobileReportData = function (value) {
        //-- Convert abstract(commons::BOOLEAN) from js(boolean) to jni(bool)
        var value_jni = !!value;
        var cacheMobileReportData_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("cacheMobileReportData");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setBooleanProperty(this._getValidClosetAddress(), value_jni, cacheMobileReportData_name_jni);
        Module.deps['TraceUtil'].log("(transport::AuthorizedLinks)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#cacheMobileReportData", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(value));
        return this;
    };
    /**
     * @return {boolean}
     */
    AuthorizedLinks.prototype.getExemptFromOfflineTimeLimit = function () {
        var exemptFromOfflineTimeLimit_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("exemptFromOfflineTimeLimit");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getBooleanProperty(this._getValidClosetAddress(), exemptFromOfflineTimeLimit_jni);
        //-- Convert abstract(commons::BOOLEAN) from jni(bool) to js(boolean)
        var rc = !!rc_jni;
        Module.deps['TraceUtil'].log("(transport::AuthorizedLinks)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#exemptFromOfflineTimeLimit", "-->", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(rc));
        return rc;
    };
    /**
     * @param {boolean} value
     *
     */
    AuthorizedLinks.prototype.setExemptFromOfflineTimeLimit = function (value) {
        //-- Convert abstract(commons::BOOLEAN) from js(boolean) to jni(bool)
        var value_jni = !!value;
        var exemptFromOfflineTimeLimit_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("exemptFromOfflineTimeLimit");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setBooleanProperty(this._getValidClosetAddress(), value_jni, exemptFromOfflineTimeLimit_name_jni);
        Module.deps['TraceUtil'].log("(transport::AuthorizedLinks)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#exemptFromOfflineTimeLimit", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(value));
        return this;
    };
    /**
     * @return {boolean}
     */
    AuthorizedLinks.prototype.getExemptFromPasscodeRequirements = function () {
        var exemptFromPasscodeRequirements_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("exemptFromPasscodeRequirements");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getBooleanProperty(this._getValidClosetAddress(), exemptFromPasscodeRequirements_jni);
        //-- Convert abstract(commons::BOOLEAN) from jni(bool) to js(boolean)
        var rc = !!rc_jni;
        Module.deps['TraceUtil'].log("(transport::AuthorizedLinks)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#exemptFromPasscodeRequirements", "-->", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(rc));
        return rc;
    };
    /**
     * @param {boolean} value
     *
     */
    AuthorizedLinks.prototype.setExemptFromPasscodeRequirements = function (value) {
        //-- Convert abstract(commons::BOOLEAN) from js(boolean) to jni(bool)
        var value_jni = !!value;
        var exemptFromPasscodeRequirements_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("exemptFromPasscodeRequirements");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setBooleanProperty(this._getValidClosetAddress(), value_jni, exemptFromPasscodeRequirements_name_jni);
        Module.deps['TraceUtil'].log("(transport::AuthorizedLinks)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#exemptFromPasscodeRequirements", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(value));
        return this;
    };
    /**
     * @return {boolean}
     */
    AuthorizedLinks.prototype.getExportPDF = function () {
        var exportPDF_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("exportPDF");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getBooleanProperty(this._getValidClosetAddress(), exportPDF_jni);
        //-- Convert abstract(commons::BOOLEAN) from jni(bool) to js(boolean)
        var rc = !!rc_jni;
        Module.deps['TraceUtil'].log("(transport::AuthorizedLinks)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#exportPDF", "-->", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(rc));
        return rc;
    };
    /**
     * @param {boolean} value
     *
     */
    AuthorizedLinks.prototype.setExportPDF = function (value) {
        //-- Convert abstract(commons::BOOLEAN) from js(boolean) to jni(bool)
        var value_jni = !!value;
        var exportPDF_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("exportPDF");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setBooleanProperty(this._getValidClosetAddress(), value_jni, exportPDF_name_jni);
        Module.deps['TraceUtil'].log("(transport::AuthorizedLinks)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#exportPDF", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(value));
        return this;
    };
    /**
     * @return {boolean}
     */
    AuthorizedLinks.prototype.getGetPreferences = function () {
        var getPreferences_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("getPreferences");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getBooleanProperty(this._getValidClosetAddress(), getPreferences_jni);
        //-- Convert abstract(commons::BOOLEAN) from jni(bool) to js(boolean)
        var rc = !!rc_jni;
        Module.deps['TraceUtil'].log("(transport::AuthorizedLinks)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#getPreferences", "-->", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(rc));
        return rc;
    };
    /**
     * @param {boolean} value
     *
     */
    AuthorizedLinks.prototype.setGetPreferences = function (value) {
        //-- Convert abstract(commons::BOOLEAN) from js(boolean) to jni(bool)
        var value_jni = !!value;
        var getPreferences_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("getPreferences");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setBooleanProperty(this._getValidClosetAddress(), value_jni, getPreferences_name_jni);
        Module.deps['TraceUtil'].log("(transport::AuthorizedLinks)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#getPreferences", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(value));
        return this;
    };
    /**
     * @return {boolean}
     */
    AuthorizedLinks.prototype.getPutPreferences = function () {
        var putPreferences_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("putPreferences");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getBooleanProperty(this._getValidClosetAddress(), putPreferences_jni);
        //-- Convert abstract(commons::BOOLEAN) from jni(bool) to js(boolean)
        var rc = !!rc_jni;
        Module.deps['TraceUtil'].log("(transport::AuthorizedLinks)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#putPreferences", "-->", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(rc));
        return rc;
    };
    /**
     * @param {boolean} value
     *
     */
    AuthorizedLinks.prototype.setPutPreferences = function (value) {
        //-- Convert abstract(commons::BOOLEAN) from js(boolean) to jni(bool)
        var value_jni = !!value;
        var putPreferences_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("putPreferences");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setBooleanProperty(this._getValidClosetAddress(), value_jni, putPreferences_name_jni);
        Module.deps['TraceUtil'].log("(transport::AuthorizedLinks)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#putPreferences", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(value));
        return this;
    };
    /**
     * @return {boolean}
     */
    AuthorizedLinks.prototype.getDeletePreferences = function () {
        var deletePreferences_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("deletePreferences");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getBooleanProperty(this._getValidClosetAddress(), deletePreferences_jni);
        //-- Convert abstract(commons::BOOLEAN) from jni(bool) to js(boolean)
        var rc = !!rc_jni;
        Module.deps['TraceUtil'].log("(transport::AuthorizedLinks)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#deletePreferences", "-->", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(rc));
        return rc;
    };
    /**
     * @param {boolean} value
     *
     */
    AuthorizedLinks.prototype.setDeletePreferences = function (value) {
        //-- Convert abstract(commons::BOOLEAN) from js(boolean) to jni(bool)
        var value_jni = !!value;
        var deletePreferences_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("deletePreferences");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setBooleanProperty(this._getValidClosetAddress(), value_jni, deletePreferences_name_jni);
        Module.deps['TraceUtil'].log("(transport::AuthorizedLinks)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#deletePreferences", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(value));
        return this;
    };
    /**
     * @return {boolean}
     */
    AuthorizedLinks.prototype.getGetRecents = function () {
        var getRecents_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("getRecents");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getBooleanProperty(this._getValidClosetAddress(), getRecents_jni);
        //-- Convert abstract(commons::BOOLEAN) from jni(bool) to js(boolean)
        var rc = !!rc_jni;
        Module.deps['TraceUtil'].log("(transport::AuthorizedLinks)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#getRecents", "-->", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(rc));
        return rc;
    };
    /**
     * @param {boolean} value
     *
     */
    AuthorizedLinks.prototype.setGetRecents = function (value) {
        //-- Convert abstract(commons::BOOLEAN) from js(boolean) to jni(bool)
        var value_jni = !!value;
        var getRecents_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("getRecents");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setBooleanProperty(this._getValidClosetAddress(), value_jni, getRecents_name_jni);
        Module.deps['TraceUtil'].log("(transport::AuthorizedLinks)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#getRecents", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(value));
        return this;
    };
    /**
     * @return {boolean}
     */
    AuthorizedLinks.prototype.getPostRecents = function () {
        var postRecents_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("postRecents");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getBooleanProperty(this._getValidClosetAddress(), postRecents_jni);
        //-- Convert abstract(commons::BOOLEAN) from jni(bool) to js(boolean)
        var rc = !!rc_jni;
        Module.deps['TraceUtil'].log("(transport::AuthorizedLinks)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#postRecents", "-->", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(rc));
        return rc;
    };
    /**
     * @param {boolean} value
     *
     */
    AuthorizedLinks.prototype.setPostRecents = function (value) {
        //-- Convert abstract(commons::BOOLEAN) from js(boolean) to jni(bool)
        var value_jni = !!value;
        var postRecents_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("postRecents");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setBooleanProperty(this._getValidClosetAddress(), value_jni, postRecents_name_jni);
        Module.deps['TraceUtil'].log("(transport::AuthorizedLinks)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#postRecents", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(value));
        return this;
    };
    /**
     * @return {boolean}
     */
    AuthorizedLinks.prototype.getDeleteRecents = function () {
        var deleteRecents_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("deleteRecents");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getBooleanProperty(this._getValidClosetAddress(), deleteRecents_jni);
        //-- Convert abstract(commons::BOOLEAN) from jni(bool) to js(boolean)
        var rc = !!rc_jni;
        Module.deps['TraceUtil'].log("(transport::AuthorizedLinks)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#deleteRecents", "-->", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(rc));
        return rc;
    };
    /**
     * @param {boolean} value
     *
     */
    AuthorizedLinks.prototype.setDeleteRecents = function (value) {
        //-- Convert abstract(commons::BOOLEAN) from js(boolean) to jni(bool)
        var value_jni = !!value;
        var deleteRecents_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("deleteRecents");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setBooleanProperty(this._getValidClosetAddress(), value_jni, deleteRecents_name_jni);
        Module.deps['TraceUtil'].log("(transport::AuthorizedLinks)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#deleteRecents", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(value));
        return this;
    };
    /**
     * @return {boolean}
     */
    AuthorizedLinks.prototype.getGetFavorites = function () {
        var getFavorites_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("getFavorites");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getBooleanProperty(this._getValidClosetAddress(), getFavorites_jni);
        //-- Convert abstract(commons::BOOLEAN) from jni(bool) to js(boolean)
        var rc = !!rc_jni;
        Module.deps['TraceUtil'].log("(transport::AuthorizedLinks)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#getFavorites", "-->", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(rc));
        return rc;
    };
    /**
     * @param {boolean} value
     *
     */
    AuthorizedLinks.prototype.setGetFavorites = function (value) {
        //-- Convert abstract(commons::BOOLEAN) from js(boolean) to jni(bool)
        var value_jni = !!value;
        var getFavorites_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("getFavorites");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setBooleanProperty(this._getValidClosetAddress(), value_jni, getFavorites_name_jni);
        Module.deps['TraceUtil'].log("(transport::AuthorizedLinks)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#getFavorites", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(value));
        return this;
    };
    /**
     * @return {boolean}
     */
    AuthorizedLinks.prototype.getPostFavorites = function () {
        var postFavorites_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("postFavorites");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getBooleanProperty(this._getValidClosetAddress(), postFavorites_jni);
        //-- Convert abstract(commons::BOOLEAN) from jni(bool) to js(boolean)
        var rc = !!rc_jni;
        Module.deps['TraceUtil'].log("(transport::AuthorizedLinks)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#postFavorites", "-->", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(rc));
        return rc;
    };
    /**
     * @param {boolean} value
     *
     */
    AuthorizedLinks.prototype.setPostFavorites = function (value) {
        //-- Convert abstract(commons::BOOLEAN) from js(boolean) to jni(bool)
        var value_jni = !!value;
        var postFavorites_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("postFavorites");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setBooleanProperty(this._getValidClosetAddress(), value_jni, postFavorites_name_jni);
        Module.deps['TraceUtil'].log("(transport::AuthorizedLinks)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#postFavorites", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(value));
        return this;
    };
    /**
     * @return {boolean}
     */
    AuthorizedLinks.prototype.getDeleteFavorites = function () {
        var deleteFavorites_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("deleteFavorites");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getBooleanProperty(this._getValidClosetAddress(), deleteFavorites_jni);
        //-- Convert abstract(commons::BOOLEAN) from jni(bool) to js(boolean)
        var rc = !!rc_jni;
        Module.deps['TraceUtil'].log("(transport::AuthorizedLinks)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#deleteFavorites", "-->", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(rc));
        return rc;
    };
    /**
     * @param {boolean} value
     *
     */
    AuthorizedLinks.prototype.setDeleteFavorites = function (value) {
        //-- Convert abstract(commons::BOOLEAN) from js(boolean) to jni(bool)
        var value_jni = !!value;
        var deleteFavorites_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("deleteFavorites");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setBooleanProperty(this._getValidClosetAddress(), value_jni, deleteFavorites_name_jni);
        Module.deps['TraceUtil'].log("(transport::AuthorizedLinks)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#deleteFavorites", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(value));
        return this;
    };
    /**
     * @return {boolean}
     */
    AuthorizedLinks.prototype.getPostComments = function () {
        var postComments_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("postComments");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getBooleanProperty(this._getValidClosetAddress(), postComments_jni);
        //-- Convert abstract(commons::BOOLEAN) from jni(bool) to js(boolean)
        var rc = !!rc_jni;
        Module.deps['TraceUtil'].log("(transport::AuthorizedLinks)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#postComments", "-->", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(rc));
        return rc;
    };
    /**
     * @param {boolean} value
     *
     */
    AuthorizedLinks.prototype.setPostComments = function (value) {
        //-- Convert abstract(commons::BOOLEAN) from js(boolean) to jni(bool)
        var value_jni = !!value;
        var postComments_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("postComments");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setBooleanProperty(this._getValidClosetAddress(), value_jni, postComments_name_jni);
        Module.deps['TraceUtil'].log("(transport::AuthorizedLinks)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#postComments", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(value));
        return this;
    };
    /**
     * @return {boolean}
     */
    AuthorizedLinks.prototype.getPostReportImages = function () {
        var postReportImages_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("postReportImages");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getBooleanProperty(this._getValidClosetAddress(), postReportImages_jni);
        //-- Convert abstract(commons::BOOLEAN) from jni(bool) to js(boolean)
        var rc = !!rc_jni;
        Module.deps['TraceUtil'].log("(transport::AuthorizedLinks)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#postReportImages", "-->", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(rc));
        return rc;
    };
    /**
     * @param {boolean} value
     *
     */
    AuthorizedLinks.prototype.setPostReportImages = function (value) {
        //-- Convert abstract(commons::BOOLEAN) from js(boolean) to jni(bool)
        var value_jni = !!value;
        var postReportImages_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("postReportImages");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setBooleanProperty(this._getValidClosetAddress(), value_jni, postReportImages_name_jni);
        Module.deps['TraceUtil'].log("(transport::AuthorizedLinks)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#postReportImages", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(value));
        return this;
    };
    /**
     * @return {boolean}
     */
    AuthorizedLinks.prototype.getPostReportRenderer = function () {
        var postReportRenderer_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("postReportRenderer");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getBooleanProperty(this._getValidClosetAddress(), postReportRenderer_jni);
        //-- Convert abstract(commons::BOOLEAN) from jni(bool) to js(boolean)
        var rc = !!rc_jni;
        Module.deps['TraceUtil'].log("(transport::AuthorizedLinks)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#postReportRenderer", "-->", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(rc));
        return rc;
    };
    /**
     * @param {boolean} value
     *
     */
    AuthorizedLinks.prototype.setPostReportRenderer = function (value) {
        //-- Convert abstract(commons::BOOLEAN) from js(boolean) to jni(bool)
        var value_jni = !!value;
        var postReportRenderer_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("postReportRenderer");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setBooleanProperty(this._getValidClosetAddress(), value_jni, postReportRenderer_name_jni);
        Module.deps['TraceUtil'].log("(transport::AuthorizedLinks)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#postReportRenderer", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(value));
        return this;
    };
    /**
     * @return {boolean}
     */
    AuthorizedLinks.prototype.getGetReportAlerts = function () {
        var getReportAlerts_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("getReportAlerts");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getBooleanProperty(this._getValidClosetAddress(), getReportAlerts_jni);
        //-- Convert abstract(commons::BOOLEAN) from jni(bool) to js(boolean)
        var rc = !!rc_jni;
        Module.deps['TraceUtil'].log("(transport::AuthorizedLinks)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#getReportAlerts", "-->", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(rc));
        return rc;
    };
    /**
     * @param {boolean} value
     *
     */
    AuthorizedLinks.prototype.setGetReportAlerts = function (value) {
        //-- Convert abstract(commons::BOOLEAN) from js(boolean) to jni(bool)
        var value_jni = !!value;
        var getReportAlerts_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("getReportAlerts");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setBooleanProperty(this._getValidClosetAddress(), value_jni, getReportAlerts_name_jni);
        Module.deps['TraceUtil'].log("(transport::AuthorizedLinks)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#getReportAlerts", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(value));
        return this;
    };
    /**
     * @return {boolean}
     */
    AuthorizedLinks.prototype.getPostReportAlerts = function () {
        var postReportAlerts_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("postReportAlerts");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getBooleanProperty(this._getValidClosetAddress(), postReportAlerts_jni);
        //-- Convert abstract(commons::BOOLEAN) from jni(bool) to js(boolean)
        var rc = !!rc_jni;
        Module.deps['TraceUtil'].log("(transport::AuthorizedLinks)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#postReportAlerts", "-->", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(rc));
        return rc;
    };
    /**
     * @param {boolean} value
     *
     */
    AuthorizedLinks.prototype.setPostReportAlerts = function (value) {
        //-- Convert abstract(commons::BOOLEAN) from js(boolean) to jni(bool)
        var value_jni = !!value;
        var postReportAlerts_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("postReportAlerts");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setBooleanProperty(this._getValidClosetAddress(), value_jni, postReportAlerts_name_jni);
        Module.deps['TraceUtil'].log("(transport::AuthorizedLinks)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#postReportAlerts", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(value));
        return this;
    };
    /**
     * @return {boolean}
     */
    AuthorizedLinks.prototype.getDeleteReportAlerts = function () {
        var deleteReportAlerts_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("deleteReportAlerts");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getBooleanProperty(this._getValidClosetAddress(), deleteReportAlerts_jni);
        //-- Convert abstract(commons::BOOLEAN) from jni(bool) to js(boolean)
        var rc = !!rc_jni;
        Module.deps['TraceUtil'].log("(transport::AuthorizedLinks)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#deleteReportAlerts", "-->", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(rc));
        return rc;
    };
    /**
     * @param {boolean} value
     *
     */
    AuthorizedLinks.prototype.setDeleteReportAlerts = function (value) {
        //-- Convert abstract(commons::BOOLEAN) from js(boolean) to jni(bool)
        var value_jni = !!value;
        var deleteReportAlerts_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("deleteReportAlerts");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setBooleanProperty(this._getValidClosetAddress(), value_jni, deleteReportAlerts_name_jni);
        Module.deps['TraceUtil'].log("(transport::AuthorizedLinks)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#deleteReportAlerts", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(value));
        return this;
    };
    /**
     * @return {boolean}
     */
    AuthorizedLinks.prototype.getExportData = function () {
        var exportData_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("exportData");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getBooleanProperty(this._getValidClosetAddress(), exportData_jni);
        //-- Convert abstract(commons::BOOLEAN) from jni(bool) to js(boolean)
        var rc = !!rc_jni;
        Module.deps['TraceUtil'].log("(transport::AuthorizedLinks)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#exportData", "-->", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(rc));
        return rc;
    };
    /**
     * @param {boolean} value
     *
     */
    AuthorizedLinks.prototype.setExportData = function (value) {
        //-- Convert abstract(commons::BOOLEAN) from js(boolean) to jni(bool)
        var value_jni = !!value;
        var exportData_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("exportData");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setBooleanProperty(this._getValidClosetAddress(), value_jni, exportData_name_jni);
        Module.deps['TraceUtil'].log("(transport::AuthorizedLinks)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#exportData", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(value));
        return this;
    };
    /**
     * @return {boolean}
     */
    AuthorizedLinks.prototype.getExportDetailData = function () {
        var exportDetailData_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("exportDetailData");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getBooleanProperty(this._getValidClosetAddress(), exportDetailData_jni);
        //-- Convert abstract(commons::BOOLEAN) from jni(bool) to js(boolean)
        var rc = !!rc_jni;
        Module.deps['TraceUtil'].log("(transport::AuthorizedLinks)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#exportDetailData", "-->", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(rc));
        return rc;
    };
    /**
     * @param {boolean} value
     *
     */
    AuthorizedLinks.prototype.setExportDetailData = function (value) {
        //-- Convert abstract(commons::BOOLEAN) from js(boolean) to jni(bool)
        var value_jni = !!value;
        var exportDetailData_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("exportDetailData");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setBooleanProperty(this._getValidClosetAddress(), value_jni, exportDetailData_name_jni);
        Module.deps['TraceUtil'].log("(transport::AuthorizedLinks)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#exportDetailData", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(value));
        return this;
    };
    /**
     * @return {boolean}
     */
    AuthorizedLinks.prototype.getExportImages = function () {
        var exportImages_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("exportImages");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getBooleanProperty(this._getValidClosetAddress(), exportImages_jni);
        //-- Convert abstract(commons::BOOLEAN) from jni(bool) to js(boolean)
        var rc = !!rc_jni;
        Module.deps['TraceUtil'].log("(transport::AuthorizedLinks)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#exportImages", "-->", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(rc));
        return rc;
    };
    /**
     * @param {boolean} value
     *
     */
    AuthorizedLinks.prototype.setExportImages = function (value) {
        //-- Convert abstract(commons::BOOLEAN) from js(boolean) to jni(bool)
        var value_jni = !!value;
        var exportImages_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("exportImages");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setBooleanProperty(this._getValidClosetAddress(), value_jni, exportImages_name_jni);
        Module.deps['TraceUtil'].log("(transport::AuthorizedLinks)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#exportImages", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(value));
        return this;
    };
    /**
     * @return {boolean}
     */
    AuthorizedLinks.prototype.getShareReport = function () {
        var shareReport_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("shareReport");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getBooleanProperty(this._getValidClosetAddress(), shareReport_jni);
        //-- Convert abstract(commons::BOOLEAN) from jni(bool) to js(boolean)
        var rc = !!rc_jni;
        Module.deps['TraceUtil'].log("(transport::AuthorizedLinks)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#shareReport", "-->", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(rc));
        return rc;
    };
    /**
     * @param {boolean} value
     *
     */
    AuthorizedLinks.prototype.setShareReport = function (value) {
        //-- Convert abstract(commons::BOOLEAN) from js(boolean) to jni(bool)
        var value_jni = !!value;
        var shareReport_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("shareReport");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setBooleanProperty(this._getValidClosetAddress(), value_jni, shareReport_name_jni);
        Module.deps['TraceUtil'].log("(transport::AuthorizedLinks)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#shareReport", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(value));
        return this;
    };
    /**
     * @return {boolean}
     */
    AuthorizedLinks.prototype.getAllowWebContent = function () {
        var allowWebContent_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("allowWebContent");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getBooleanProperty(this._getValidClosetAddress(), allowWebContent_jni);
        //-- Convert abstract(commons::BOOLEAN) from jni(bool) to js(boolean)
        var rc = !!rc_jni;
        Module.deps['TraceUtil'].log("(transport::AuthorizedLinks)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#allowWebContent", "-->", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(rc));
        return rc;
    };
    /**
     * @param {boolean} value
     *
     */
    AuthorizedLinks.prototype.setAllowWebContent = function (value) {
        //-- Convert abstract(commons::BOOLEAN) from js(boolean) to jni(bool)
        var value_jni = !!value;
        var allowWebContent_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("allowWebContent");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setBooleanProperty(this._getValidClosetAddress(), value_jni, allowWebContent_name_jni);
        Module.deps['TraceUtil'].log("(transport::AuthorizedLinks)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#allowWebContent", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(value));
        return this;
    };
    /**
     * @return {boolean}
     */
    AuthorizedLinks.prototype.getPostInterpretations = function () {
        var postInterpretations_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("postInterpretations");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getBooleanProperty(this._getValidClosetAddress(), postInterpretations_jni);
        //-- Convert abstract(commons::BOOLEAN) from jni(bool) to js(boolean)
        var rc = !!rc_jni;
        Module.deps['TraceUtil'].log("(transport::AuthorizedLinks)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#postInterpretations", "-->", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(rc));
        return rc;
    };
    /**
     * @param {boolean} value
     *
     */
    AuthorizedLinks.prototype.setPostInterpretations = function (value) {
        //-- Convert abstract(commons::BOOLEAN) from js(boolean) to jni(bool)
        var value_jni = !!value;
        var postInterpretations_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("postInterpretations");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setBooleanProperty(this._getValidClosetAddress(), value_jni, postInterpretations_name_jni);
        Module.deps['TraceUtil'].log("(transport::AuthorizedLinks)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#postInterpretations", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(value));
        return this;
    };
    /**
     * @return {boolean}
     */
    AuthorizedLinks.prototype.getGetTextTemplatesOutput = function () {
        var getTextTemplatesOutput_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("getTextTemplatesOutput");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getBooleanProperty(this._getValidClosetAddress(), getTextTemplatesOutput_jni);
        //-- Convert abstract(commons::BOOLEAN) from jni(bool) to js(boolean)
        var rc = !!rc_jni;
        Module.deps['TraceUtil'].log("(transport::AuthorizedLinks)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#getTextTemplatesOutput", "-->", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(rc));
        return rc;
    };
    /**
     * @param {boolean} value
     *
     */
    AuthorizedLinks.prototype.setGetTextTemplatesOutput = function (value) {
        //-- Convert abstract(commons::BOOLEAN) from js(boolean) to jni(bool)
        var value_jni = !!value;
        var getTextTemplatesOutput_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("getTextTemplatesOutput");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setBooleanProperty(this._getValidClosetAddress(), value_jni, getTextTemplatesOutput_name_jni);
        Module.deps['TraceUtil'].log("(transport::AuthorizedLinks)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#getTextTemplatesOutput", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(value));
        return this;
    };
    /**
     * @return {boolean}
     */
    AuthorizedLinks.prototype.getGetShares = function () {
        var getShares_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("getShares");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getBooleanProperty(this._getValidClosetAddress(), getShares_jni);
        //-- Convert abstract(commons::BOOLEAN) from jni(bool) to js(boolean)
        var rc = !!rc_jni;
        Module.deps['TraceUtil'].log("(transport::AuthorizedLinks)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#getShares", "-->", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(rc));
        return rc;
    };
    /**
     * @param {boolean} value
     *
     */
    AuthorizedLinks.prototype.setGetShares = function (value) {
        //-- Convert abstract(commons::BOOLEAN) from js(boolean) to jni(bool)
        var value_jni = !!value;
        var getShares_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("getShares");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setBooleanProperty(this._getValidClosetAddress(), value_jni, getShares_name_jni);
        Module.deps['TraceUtil'].log("(transport::AuthorizedLinks)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#getShares", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(value));
        return this;
    };
    /**
     * @return {boolean}
     */
    AuthorizedLinks.prototype.getPostShares = function () {
        var postShares_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("postShares");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getBooleanProperty(this._getValidClosetAddress(), postShares_jni);
        //-- Convert abstract(commons::BOOLEAN) from jni(bool) to js(boolean)
        var rc = !!rc_jni;
        Module.deps['TraceUtil'].log("(transport::AuthorizedLinks)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#postShares", "-->", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(rc));
        return rc;
    };
    /**
     * @param {boolean} value
     *
     */
    AuthorizedLinks.prototype.setPostShares = function (value) {
        //-- Convert abstract(commons::BOOLEAN) from js(boolean) to jni(bool)
        var value_jni = !!value;
        var postShares_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("postShares");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setBooleanProperty(this._getValidClosetAddress(), value_jni, postShares_name_jni);
        Module.deps['TraceUtil'].log("(transport::AuthorizedLinks)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#postShares", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(value));
        return this;
    };
    exports.default = AuthorizedLinks;
});
