sas.ltjs.define(["require", "exports", "sas/ltjs/commons/ltjsEnvironment", "sas/ltjs/commons/WrappableCloset", "sas/ltjs/commons/events/EventDispatcher", "sas/ltjs/transport/lib", "./MediaType", "./FolderItem"], function (require, exports, ltjsEnvironment_1, WrappableCloset_1, EventDispatcher_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var Ancestors = ltjsEnvironment_1.createModule([114, 13, 50265, 50161, 50022], EventDispatcher_1.default);
    /**
     *
     */
    Ancestors._create = function () {
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_Ancestors_create();
        //-- Convert abstract(commons::VOID) from jni(void) to js()
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::Ancestors)", "static", "new", "-->", "(transport::Ancestors)", rc);
        return rc;
    };
    /**
     * @return {string| null}
     */
    Ancestors.prototype.getChildUri = function () {
        var childUri_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("childUri");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), childUri_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::Ancestors)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#childUri", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    Ancestors.prototype.setChildUri = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var childUri_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("childUri");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, childUri_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::Ancestors)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#childUri", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {Array.<FolderItem| null> | null}
     */
    Ancestors.prototype.getAncestors = function () {
        var ancestors_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("ancestors");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getWrappableVectorProperty(this._getValidClosetAddress(), ancestors_jni);
        //-- Convert abstract(<transport::FolderItem>) from jni(size_t) to js(FolderItem)
        var rc = WrappableCloset_1.getWrapperArray(rc_jni);
        Module.deps['TraceUtil'].log("(transport::Ancestors)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#ancestors", "-->", "(MONITORED_VECTOR<transport::FolderItem>)", Module.deps['TraceUtil'].traceConversions.convertArray(rc, Module.deps['TraceUtil'].traceConversions.convertModel));
        return rc;
    };
    /**
     * @param {Array.<FolderItem| null> | null} value
     *
     */
    Ancestors.prototype.setAncestors = function (value) {
        //-- Convert abstract(<transport::FolderItem>) from js(FolderItem) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertObjectArrayToC(value);
        var ancestors_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("ancestors");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setWrappableVectorProperty(this._getValidClosetAddress(), value_jni, ancestors_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::Ancestors)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#ancestors", "(MONITORED_VECTOR<transport::FolderItem>)", Module.deps['TraceUtil'].traceConversions.convertArray(value, Module.deps['TraceUtil'].traceConversions.convertModel));
        return this;
    };
    exports.default = Ancestors;
});
