sas.ltjs.define(["require", "exports", "sas/ltjs/commons/ltjsEnvironment", "sas/ltjs/commons/WrappableCloset", "sas/ltjs/commons/events/EventDispatcher", "sas/ltjs/transport/lib", "./MediaType", "./particles/AlertStrategy", "./particles/AlertInterval", "sas/ltjs/commons/models/particles/Link"], function (require, exports, ltjsEnvironment_1, WrappableCloset_1, EventDispatcher_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var AlertableElement = ltjsEnvironment_1.createModule([114, 13, 50265, 50161, 50020], EventDispatcher_1.default);
    /**
     *
     */
    AlertableElement._create = function () {
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_AlertableElement_create();
        //-- Convert abstract(commons::VOID) from jni(void) to js()
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::AlertableElement)", "static", "new", "-->", "(transport::AlertableElement)", rc);
        return rc;
    };
    /**
     * @return {string| null}
     */
    AlertableElement.prototype.getAlertName = function () {
        var alertName_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("alertName");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), alertName_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::AlertableElement)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#alertName", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    AlertableElement.prototype.setAlertName = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var alertName_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("alertName");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, alertName_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::AlertableElement)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#alertName", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    AlertableElement.prototype.getLabel = function () {
        var label_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("label");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), label_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::AlertableElement)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#label", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    AlertableElement.prototype.setLabel = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var label_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("label");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, label_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::AlertableElement)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#label", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    AlertableElement.prototype.getClause = function () {
        var clause_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("clause");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), clause_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::AlertableElement)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#clause", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    AlertableElement.prototype.setClause = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var clause_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("clause");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, clause_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::AlertableElement)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#clause", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {AlertStrategy}
     */
    AlertableElement.prototype.getEvaluationStrategy = function () {
        var evaluationStrategy_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("evaluationStrategy");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getIntProperty(this._getValidClosetAddress(), evaluationStrategy_jni);
        //-- Convert abstract(transport::AlertStrategy) from jni(int) to js(AlertStrategy)
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::AlertableElement)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#evaluationStrategy", "-->", "(transport::AlertStrategy::type)", Module.deps['TraceUtil'].traceConversions.convertEnum(rc));
        return rc;
    };
    /**
     * @param {AlertStrategy} value
     *
     */
    AlertableElement.prototype.setEvaluationStrategy = function (value) {
        //-- Convert abstract(transport::AlertStrategy) from js(AlertStrategy) to jni(int)
        var value_jni = value;
        var evaluationStrategy_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("evaluationStrategy");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setIntProperty(this._getValidClosetAddress(), value_jni, evaluationStrategy_name_jni);
        Module.deps['TraceUtil'].log("(transport::AlertableElement)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#evaluationStrategy", "(transport::AlertStrategy::type)", Module.deps['TraceUtil'].traceConversions.convertEnum(value));
        return this;
    };
    /**
     * @return {number}
     */
    AlertableElement.prototype.getEvaluationInterval = function () {
        var evaluationInterval_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("evaluationInterval");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getIntProperty(this._getValidClosetAddress(), evaluationInterval_jni);
        //-- Convert abstract(commons::INT) from jni(int) to js(number)
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::AlertableElement)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#evaluationInterval", "-->", "(commons::INT)", Module.deps['TraceUtil'].traceConversions.convertInt(rc));
        return rc;
    };
    /**
     * @param {number} value
     *
     */
    AlertableElement.prototype.setEvaluationInterval = function (value) {
        //-- Convert abstract(commons::INT) from js(number) to jni(int)
        var value_jni = value;
        var evaluationInterval_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("evaluationInterval");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setIntProperty(this._getValidClosetAddress(), value_jni, evaluationInterval_name_jni);
        Module.deps['TraceUtil'].log("(transport::AlertableElement)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#evaluationInterval", "(commons::INT)", Module.deps['TraceUtil'].traceConversions.convertInt(value));
        return this;
    };
    /**
     * @return {AlertInterval}
     */
    AlertableElement.prototype.getIntervalUnit = function () {
        var intervalUnit_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("intervalUnit");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getIntProperty(this._getValidClosetAddress(), intervalUnit_jni);
        //-- Convert abstract(transport::AlertInterval) from jni(int) to js(AlertInterval)
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::AlertableElement)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#intervalUnit", "-->", "(transport::AlertInterval::type)", Module.deps['TraceUtil'].traceConversions.convertEnum(rc));
        return rc;
    };
    /**
     * @param {AlertInterval} value
     *
     */
    AlertableElement.prototype.setIntervalUnit = function (value) {
        //-- Convert abstract(transport::AlertInterval) from js(AlertInterval) to jni(int)
        var value_jni = value;
        var intervalUnit_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("intervalUnit");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setIntProperty(this._getValidClosetAddress(), value_jni, intervalUnit_name_jni);
        Module.deps['TraceUtil'].log("(transport::AlertableElement)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#intervalUnit", "(transport::AlertInterval::type)", Module.deps['TraceUtil'].traceConversions.convertEnum(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    AlertableElement.prototype.getVisualElement = function () {
        var visualElement_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("visualElement");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), visualElement_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::AlertableElement)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#visualElement", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    AlertableElement.prototype.setVisualElement = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var visualElement_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("visualElement");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, visualElement_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::AlertableElement)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#visualElement", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {boolean}
     */
    AlertableElement.prototype.getSubscribed = function () {
        var subscribed_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("subscribed");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getBooleanProperty(this._getValidClosetAddress(), subscribed_jni);
        //-- Convert abstract(commons::BOOLEAN) from jni(bool) to js(boolean)
        var rc = !!rc_jni;
        Module.deps['TraceUtil'].log("(transport::AlertableElement)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#subscribed", "-->", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(rc));
        return rc;
    };
    /**
     * @param {boolean} value
     *
     */
    AlertableElement.prototype.setSubscribed = function (value) {
        //-- Convert abstract(commons::BOOLEAN) from js(boolean) to jni(bool)
        var value_jni = !!value;
        var subscribed_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("subscribed");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setBooleanProperty(this._getValidClosetAddress(), value_jni, subscribed_name_jni);
        Module.deps['TraceUtil'].log("(transport::AlertableElement)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#subscribed", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    AlertableElement.prototype.getId = function () {
        var id_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("id");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), id_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::AlertableElement)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#id", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    AlertableElement.prototype.setId = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var id_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("id");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, id_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::AlertableElement)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#id", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {Array.<Link| null> | null}
     */
    AlertableElement.prototype.getLinks = function () {
        var links_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("links");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getWrappableVectorProperty(this._getValidClosetAddress(), links_jni);
        //-- Convert abstract(<commons::Link>) from jni(size_t) to js(Link)
        var rc = WrappableCloset_1.getWrapperArray(rc_jni);
        Module.deps['TraceUtil'].log("(transport::AlertableElement)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#links", "-->", "(MONITORED_VECTOR<commons::Link>)", Module.deps['TraceUtil'].traceConversions.convertArray(rc, Module.deps['TraceUtil'].traceConversions.convertModel));
        return rc;
    };
    /**
     * @param {Array.<Link| null> | null} value
     *
     */
    AlertableElement.prototype.setLinks = function (value) {
        //-- Convert abstract(<commons::Link>) from js(Link) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertObjectArrayToC(value);
        var links_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("links");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setWrappableVectorProperty(this._getValidClosetAddress(), value_jni, links_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::AlertableElement)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#links", "(MONITORED_VECTOR<commons::Link>)", Module.deps['TraceUtil'].traceConversions.convertArray(value, Module.deps['TraceUtil'].traceConversions.convertModel));
        return this;
    };
    exports.default = AlertableElement;
});
