sas.ltjs.define(["require", "exports", "sas/ltjs/commons/ltjsEnvironment", "sas/ltjs/commons/events/EventDispatcher", "sas/ltjs/transport/lib", "sas/ltjs/transport/models/TransportModel", "./UserNamePurpose", "./UserNameFallback"], function (require, exports, ltjsEnvironment_1, EventDispatcher_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var UserNameContext = ltjsEnvironment_1.createModule([114, 13, 50265, 50277], EventDispatcher_1.default);
    /**
     *
     */
    UserNameContext._create = function () {
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_UserNameContext_create();
        //-- Convert abstract(commons::VOID) from jni(void) to js()
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::UserNameContext)", "static", "new", "-->", "(transport::UserNameContext)", rc);
        return rc;
    };
    /**
     * @return {UserNamePurpose}
     */
    UserNameContext.prototype.getPurpose = function () {
        var purpose_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("purpose");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getIntProperty(this._getValidClosetAddress(), purpose_jni);
        //-- Convert abstract(transport::UserNamePurpose) from jni(int) to js(UserNamePurpose)
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::UserNameContext)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#purpose", "-->", "(transport::UserNamePurpose::type)", Module.deps['TraceUtil'].traceConversions.convertEnum(rc));
        return rc;
    };
    /**
     * @param {UserNamePurpose} value
     *
     */
    UserNameContext.prototype.setPurpose = function (value) {
        //-- Convert abstract(transport::UserNamePurpose) from js(UserNamePurpose) to jni(int)
        var value_jni = value;
        var purpose_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("purpose");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setIntProperty(this._getValidClosetAddress(), value_jni, purpose_name_jni);
        Module.deps['TraceUtil'].log("(transport::UserNameContext)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#purpose", "(transport::UserNamePurpose::type)", Module.deps['TraceUtil'].traceConversions.convertEnum(value));
        return this;
    };
    /**
     * @return {UserNameFallback}
     */
    UserNameContext.prototype.getGuestFallback = function () {
        var guestFallback_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("guestFallback");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getIntProperty(this._getValidClosetAddress(), guestFallback_jni);
        //-- Convert abstract(transport::UserNameFallback) from jni(int) to js(UserNameFallback)
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::UserNameContext)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#guestFallback", "-->", "(transport::UserNameFallback::type)", Module.deps['TraceUtil'].traceConversions.convertEnum(rc));
        return rc;
    };
    /**
     * @param {UserNameFallback} value
     *
     */
    UserNameContext.prototype.setGuestFallback = function (value) {
        //-- Convert abstract(transport::UserNameFallback) from js(UserNameFallback) to jni(int)
        var value_jni = value;
        var guestFallback_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("guestFallback");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setIntProperty(this._getValidClosetAddress(), value_jni, guestFallback_name_jni);
        Module.deps['TraceUtil'].log("(transport::UserNameContext)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#guestFallback", "(transport::UserNameFallback::type)", Module.deps['TraceUtil'].traceConversions.convertEnum(value));
        return this;
    };
    /**
     * @return {UserNameFallback}
     */
    UserNameContext.prototype.getAuthenticatedFallback = function () {
        var authenticatedFallback_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("authenticatedFallback");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getIntProperty(this._getValidClosetAddress(), authenticatedFallback_jni);
        //-- Convert abstract(transport::UserNameFallback) from jni(int) to js(UserNameFallback)
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::UserNameContext)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#authenticatedFallback", "-->", "(transport::UserNameFallback::type)", Module.deps['TraceUtil'].traceConversions.convertEnum(rc));
        return rc;
    };
    /**
     * @param {UserNameFallback} value
     *
     */
    UserNameContext.prototype.setAuthenticatedFallback = function (value) {
        //-- Convert abstract(transport::UserNameFallback) from js(UserNameFallback) to jni(int)
        var value_jni = value;
        var authenticatedFallback_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("authenticatedFallback");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setIntProperty(this._getValidClosetAddress(), value_jni, authenticatedFallback_name_jni);
        Module.deps['TraceUtil'].log("(transport::UserNameContext)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#authenticatedFallback", "(transport::UserNameFallback::type)", Module.deps['TraceUtil'].traceConversions.convertEnum(value));
        return this;
    };
    exports.default = UserNameContext;
});
