sas.ltjs.define(["require", "exports", "sas/ltjs/commons/ltjsEnvironment", "sas/ltjs/commons/WrappableCloset", "sas/ltjs/commons/ClosetObject", "sas/ltjs/commons/events/EventDispatcher", "sas/ltjs/transport/lib", "sas/ltjs/transport/models/TransportModel", "sas/ltjs/commons/models/particles/Link"], function (require, exports, ltjsEnvironment_1, WrappableCloset_1, ClosetObject_1, EventDispatcher_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var TransportModelReference = ltjsEnvironment_1.createModule([114, 13, 50265, 50266], EventDispatcher_1.default);
    /**
     *
     */
    TransportModelReference._create = function () {
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_TransportModelReference_create();
        //-- Convert abstract(commons::VOID) from jni(void) to js()
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::TransportModelReference)", "static", "new", "-->", "(transport::TransportModelReference)", rc);
        return rc;
    };
    /**
     * @return {TransportModel| null}
     */
    TransportModelReference.prototype.getModel = function () {
        var model_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("model");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getWrappableProperty(this._getValidClosetAddress(), model_jni);
        //-- Convert abstract(transport::TransportModel) from jni(size_t) to js(TransportModel)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::TransportModelReference)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#model", "-->", "(transport::TransportModel)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * @param {TransportModel| null} value
     *
     */
    TransportModelReference.prototype.setModel = function (value) {
        //-- Convert abstract(transport::TransportModel) from js(TransportModel) to jni(size_t)
        var value_jni = ClosetObject_1.default._getValidClosetAddress(value);
        var model_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("model");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setWrappableProperty(this._getValidClosetAddress(), value_jni, model_name_jni);
        Module.deps['TraceUtil'].log("(transport::TransportModelReference)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#model", "(transport::TransportModel)", Module.deps['TraceUtil'].traceConversions.convertModel(value));
        return this;
    };
    /**
     * @return {Array.<Link| null> | null}
     */
    TransportModelReference.prototype.getLinks = function () {
        var links_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("links");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getWrappableVectorProperty(this._getValidClosetAddress(), links_jni);
        //-- Convert abstract(<commons::Link>) from jni(size_t) to js(Link)
        var rc = WrappableCloset_1.getWrapperArray(rc_jni);
        Module.deps['TraceUtil'].log("(transport::TransportModelReference)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#links", "-->", "(MONITORED_VECTOR<commons::Link>)", Module.deps['TraceUtil'].traceConversions.convertArray(rc, Module.deps['TraceUtil'].traceConversions.convertModel));
        return rc;
    };
    /**
     * @param {Array.<Link| null> | null} value
     *
     */
    TransportModelReference.prototype.setLinks = function (value) {
        //-- Convert abstract(<commons::Link>) from js(Link) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertObjectArrayToC(value);
        var links_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("links");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setWrappableVectorProperty(this._getValidClosetAddress(), value_jni, links_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::TransportModelReference)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#links", "(MONITORED_VECTOR<commons::Link>)", Module.deps['TraceUtil'].traceConversions.convertArray(value, Module.deps['TraceUtil'].traceConversions.convertModel));
        return this;
    };
    /**
     * @return {string| null}
     */
    TransportModelReference.prototype.getName = function () {
        var name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("name");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), name_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::TransportModelReference)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#name", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    TransportModelReference.prototype.setName = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var name_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("name");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, name_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::TransportModelReference)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#name", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    TransportModelReference.prototype.getId = function () {
        var id_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("id");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), id_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::TransportModelReference)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#id", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    TransportModelReference.prototype.setId = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var id_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("id");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, id_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::TransportModelReference)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#id", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    TransportModelReference.prototype.getAdded = function () {
        var added_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("added");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), added_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::TransportModelReference)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#added", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    TransportModelReference.prototype.setAdded = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var added_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("added");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, added_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::TransportModelReference)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#added", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {number}
     */
    TransportModelReference.prototype.getAddedDatetime = function () {
        var addedDatetime_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("addedDatetime");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getSASDatetimeProperty(this._getValidClosetAddress(), addedDatetime_jni);
        //-- Convert abstract(commons::SASDATETIME) from jni(double) to js(number)
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::TransportModelReference)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#addedDatetime", "-->", "(commons::SASDATETIME)", Module.deps['TraceUtil'].traceConversions.convertDouble(rc));
        return rc;
    };
    /**
     * @param {number} value
     *
     */
    TransportModelReference.prototype.setAddedDatetime = function (value) {
        //-- Convert abstract(commons::SASDATETIME) from js(number) to jni(double)
        var value_jni = value;
        var addedDatetime_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("addedDatetime");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setSASDatetimeProperty(this._getValidClosetAddress(), value_jni, addedDatetime_name_jni);
        Module.deps['TraceUtil'].log("(transport::TransportModelReference)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#addedDatetime", "(commons::SASDATETIME)", Module.deps['TraceUtil'].traceConversions.convertDouble(value));
        return this;
    };
    /**
     * @return {boolean}
     */
    TransportModelReference.prototype.getIsReference = function () {
        var isReference_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("isReference");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getBooleanProperty(this._getValidClosetAddress(), isReference_jni);
        //-- Convert abstract(commons::BOOLEAN) from jni(bool) to js(boolean)
        var rc = !!rc_jni;
        Module.deps['TraceUtil'].log("(transport::TransportModelReference)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#isReference", "-->", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(rc));
        return rc;
    };
    /**
     * @param {boolean} value
     *
     */
    TransportModelReference.prototype.setIsReference = function (value) {
        //-- Convert abstract(commons::BOOLEAN) from js(boolean) to jni(bool)
        var value_jni = !!value;
        var isReference_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("isReference");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setBooleanProperty(this._getValidClosetAddress(), value_jni, isReference_name_jni);
        Module.deps['TraceUtil'].log("(transport::TransportModelReference)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#isReference", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(value));
        return this;
    };
    /**
     * @param {PortableEvent| null} pEvent
     *
     */
    TransportModelReference.prototype.addedUpdated = function (pEvent) {
        //-- Convert abstract(commons::PortableEvent) from js(PortableEvent) to jni(size_t)
        var pEvent_jni = ClosetObject_1.default._getValidClosetAddress(pEvent);
        ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_TransportModelReference_addedUpdated(this._getValidClosetAddress(), pEvent_jni);
        Module.deps['TraceUtil'].log("(transport::TransportModelReference)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "addedUpdated", "(commons::PortableEvent)", Module.deps['TraceUtil'].traceConversions.convertModel(pEvent));
        return this;
    };
    exports.default = TransportModelReference;
});
