sas.ltjs.define(["require", "exports", "sas/ltjs/commons/ltjsEnvironment", "sas/ltjs/commons/WrappableCloset", "sas/ltjs/commons/ClosetObject", "sas/ltjs/commons/events/EventDispatcher", "sas/ltjs/transport/lib", "sas/ltjs/transport/models/TransportModel", "sas/ltjs/transport/models/media/ServerConfig", "sas/ltjs/commons/resources/network/URL"], function (require, exports, ltjsEnvironment_1, WrappableCloset_1, ClosetObject_1, EventDispatcher_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var Server = ltjsEnvironment_1.createModule([114, 13, 50265, 50241], EventDispatcher_1.default);
    /**
     *
     */
    Server._create = function () {
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_Server_create();
        //-- Convert abstract(commons::VOID) from jni(void) to js()
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::Server)", "static", "new", "-->", "(transport::Server)", rc);
        return rc;
    };
    /**
     * @return {number}
     */
    Server.prototype.getVersionId = function () {
        var versionId_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("versionId");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getIntProperty(this._getValidClosetAddress(), versionId_jni);
        //-- Convert abstract(commons::INT) from jni(int) to js(number)
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::Server)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#versionId", "-->", "(commons::INT)", Module.deps['TraceUtil'].traceConversions.convertInt(rc));
        return rc;
    };
    /**
     * @param {number} value
     *
     */
    Server.prototype.setVersionId = function (value) {
        //-- Convert abstract(commons::INT) from js(number) to jni(int)
        var value_jni = value;
        var versionId_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("versionId");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setIntProperty(this._getValidClosetAddress(), value_jni, versionId_name_jni);
        Module.deps['TraceUtil'].log("(transport::Server)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#versionId", "(commons::INT)", Module.deps['TraceUtil'].traceConversions.convertInt(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    Server.prototype.getVersionString = function () {
        var versionString_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("versionString");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), versionString_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::Server)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#versionString", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    Server.prototype.setVersionString = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var versionString_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("versionString");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, versionString_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::Server)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#versionString", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {ServerConfig| null}
     */
    Server.prototype.getMeta = function () {
        var meta_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("meta");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getWrappableProperty(this._getValidClosetAddress(), meta_jni);
        //-- Convert abstract(transport::ServerConfig) from jni(size_t) to js(ServerConfig)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::Server)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#meta", "-->", "(transport::ServerConfig)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * @param {ServerConfig| null} value
     *
     */
    Server.prototype.setMeta = function (value) {
        //-- Convert abstract(transport::ServerConfig) from js(ServerConfig) to jni(size_t)
        var value_jni = ClosetObject_1.default._getValidClosetAddress(value);
        var meta_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("meta");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setWrappableProperty(this._getValidClosetAddress(), value_jni, meta_name_jni);
        Module.deps['TraceUtil'].log("(transport::Server)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#meta", "(transport::ServerConfig)", Module.deps['TraceUtil'].traceConversions.convertModel(value));
        return this;
    };
    /**
     * @return {boolean}
     */
    Server.prototype.getUseSSL = function () {
        var useSSL_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("useSSL");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getBooleanProperty(this._getValidClosetAddress(), useSSL_jni);
        //-- Convert abstract(commons::BOOLEAN) from jni(bool) to js(boolean)
        var rc = !!rc_jni;
        Module.deps['TraceUtil'].log("(transport::Server)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#useSSL", "-->", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(rc));
        return rc;
    };
    /**
     * @param {boolean} value
     *
     */
    Server.prototype.setUseSSL = function (value) {
        //-- Convert abstract(commons::BOOLEAN) from js(boolean) to jni(bool)
        var value_jni = !!value;
        var useSSL_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("useSSL");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setBooleanProperty(this._getValidClosetAddress(), value_jni, useSSL_name_jni);
        Module.deps['TraceUtil'].log("(transport::Server)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#useSSL", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    Server.prototype.getScheme = function () {
        var scheme_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("scheme");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), scheme_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::Server)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#scheme", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    Server.prototype.setScheme = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var scheme_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("scheme");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, scheme_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::Server)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#scheme", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    Server.prototype.getHostName = function () {
        var hostName_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("hostName");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), hostName_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::Server)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#hostName", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    Server.prototype.setHostName = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var hostName_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("hostName");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, hostName_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::Server)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#hostName", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {number}
     */
    Server.prototype.getPort = function () {
        var port_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("port");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getIntProperty(this._getValidClosetAddress(), port_jni);
        //-- Convert abstract(commons::INT) from jni(int) to js(number)
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::Server)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#port", "-->", "(commons::INT)", Module.deps['TraceUtil'].traceConversions.convertInt(rc));
        return rc;
    };
    /**
     * @param {number} value
     *
     */
    Server.prototype.setPort = function (value) {
        //-- Convert abstract(commons::INT) from js(number) to jni(int)
        var value_jni = value;
        var port_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("port");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setIntProperty(this._getValidClosetAddress(), value_jni, port_name_jni);
        Module.deps['TraceUtil'].log("(transport::Server)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#port", "(commons::INT)", Module.deps['TraceUtil'].traceConversions.convertInt(value));
        return this;
    };
    /**
     * @return {URL| null}
     */
    Server.prototype.getBaseURL = function () {
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_Server_getBaseURL(this._getValidClosetAddress());
        //-- Convert abstract(commons::URL) from jni(size_t) to js(URL)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::Server)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "getBaseURL", "-->", "(commons::URL)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    exports.default = Server;
});
