sas.ltjs.define(["require", "exports", "sas/ltjs/commons/ltjsEnvironment", "sas/ltjs/commons/WrappableCloset", "sas/ltjs/commons/events/EventDispatcher", "sas/ltjs/transport/lib", "sas/ltjs/transport/models/TransportModel", "sas/ltjs/transport/models/media/ReportImageInfo"], function (require, exports, ltjsEnvironment_1, WrappableCloset_1, EventDispatcher_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var ReportImages = ltjsEnvironment_1.createModule([114, 13, 50265, 50205], EventDispatcher_1.default);
    /**
     *
     */
    ReportImages._create = function () {
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_ReportImages_create();
        //-- Convert abstract(commons::VOID) from jni(void) to js()
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::ReportImages)", "static", "new", "-->", "(transport::ReportImages)", rc);
        return rc;
    };
    /**
     * @return {Array.<ReportImageInfo| null> | null}
     */
    ReportImages.prototype.getImages = function () {
        var images_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("images");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getWrappableVectorProperty(this._getValidClosetAddress(), images_jni);
        //-- Convert abstract(<transport::ReportImageInfo>) from jni(size_t) to js(ReportImageInfo)
        var rc = WrappableCloset_1.getWrapperArray(rc_jni);
        Module.deps['TraceUtil'].log("(transport::ReportImages)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#images", "-->", "(MONITORED_VECTOR<transport::ReportImageInfo>)", Module.deps['TraceUtil'].traceConversions.convertArray(rc, Module.deps['TraceUtil'].traceConversions.convertModel));
        return rc;
    };
    /**
     * @param {Array.<ReportImageInfo| null> | null} value
     *
     */
    ReportImages.prototype.setImages = function (value) {
        //-- Convert abstract(<transport::ReportImageInfo>) from js(ReportImageInfo) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertObjectArrayToC(value);
        var images_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("images");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setWrappableVectorProperty(this._getValidClosetAddress(), value_jni, images_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::ReportImages)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#images", "(MONITORED_VECTOR<transport::ReportImageInfo>)", Module.deps['TraceUtil'].traceConversions.convertArray(value, Module.deps['TraceUtil'].traceConversions.convertModel));
        return this;
    };
    exports.default = ReportImages;
});
