sas.ltjs.define(["require", "exports", "sas/ltjs/commons/ltjsEnvironment", "sas/ltjs/commons/WrappableCloset", "sas/ltjs/commons/ClosetObject", "sas/ltjs/commons/events/EventDispatcher", "sas/ltjs/transport/lib", "./ReportCollectionOwner", "sas/ltjs/transport/models/media/FolderMetadata", "./TransportModelReference", "./Connection"], function (require, exports, ltjsEnvironment_1, WrappableCloset_1, ClosetObject_1, EventDispatcher_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var Folder = ltjsEnvironment_1.createModule([114, 13, 50265, 50191, 50112], EventDispatcher_1.default);
    /**
     *
     */
    Folder._create = function () {
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_Folder_create();
        //-- Convert abstract(commons::VOID) from jni(void) to js()
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::Folder)", "static", "new", "-->", "(transport::Folder)", rc);
        return rc;
    };
    /**
     * @return {FolderMetadata| null}
     */
    Folder.prototype.getMeta = function () {
        var meta_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("meta");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getWrappableProperty(this._getValidClosetAddress(), meta_jni);
        //-- Convert abstract(transport::FolderMetadata) from jni(size_t) to js(FolderMetadata)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::Folder)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#meta", "-->", "(transport::FolderMetadata)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * @param {FolderMetadata| null} value
     *
     */
    Folder.prototype.setMeta = function (value) {
        //-- Convert abstract(transport::FolderMetadata) from js(FolderMetadata) to jni(size_t)
        var value_jni = ClosetObject_1.default._getValidClosetAddress(value);
        var meta_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("meta");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setWrappableProperty(this._getValidClosetAddress(), value_jni, meta_name_jni);
        Module.deps['TraceUtil'].log("(transport::Folder)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#meta", "(transport::FolderMetadata)", Module.deps['TraceUtil'].traceConversions.convertModel(value));
        return this;
    };
    /**
     * @return {Array.<TransportModelReference| null> | null}
     */
    Folder.prototype.getFolderReferences = function () {
        var folderReferences_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("folderReferences");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getWrappableVectorProperty(this._getValidClosetAddress(), folderReferences_jni);
        //-- Convert abstract(<transport::TransportModelReference>) from jni(size_t) to js(TransportModelReference)
        var rc = WrappableCloset_1.getWrapperArray(rc_jni);
        Module.deps['TraceUtil'].log("(transport::Folder)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#folderReferences", "-->", "(MONITORED_VECTOR<transport::TransportModelReference>)", Module.deps['TraceUtil'].traceConversions.convertArray(rc, Module.deps['TraceUtil'].traceConversions.convertModel));
        return rc;
    };
    /**
     * @param {Array.<TransportModelReference| null> | null} value
     *
     */
    Folder.prototype.setFolderReferences = function (value) {
        //-- Convert abstract(<transport::TransportModelReference>) from js(TransportModelReference) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertObjectArrayToC(value);
        var folderReferences_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("folderReferences");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setWrappableVectorProperty(this._getValidClosetAddress(), value_jni, folderReferences_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::Folder)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#folderReferences", "(MONITORED_VECTOR<transport::TransportModelReference>)", Module.deps['TraceUtil'].traceConversions.convertArray(value, Module.deps['TraceUtil'].traceConversions.convertModel));
        return this;
    };
    /**
     * @return {any| null}
     */
    Folder.prototype.getParent = function () {
        var parent_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("parent");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getWrappableProperty(this._getValidClosetAddress(), parent_jni);
        //-- Convert abstract(transport::Folder) from jni(size_t) to js(Folder)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::Folder)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#parent", "-->", "(transport::Folder)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * @param {any| null} value
     *
     */
    Folder.prototype.setParent = function (value) {
        //-- Convert abstract(transport::Folder) from js(Folder) to jni(size_t)
        var value_jni = ClosetObject_1.default._getValidClosetAddress(value);
        var parent_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("parent");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setWrappableProperty(this._getValidClosetAddress(), value_jni, parent_name_jni);
        Module.deps['TraceUtil'].log("(transport::Folder)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#parent", "(transport::Folder)", Module.deps['TraceUtil'].traceConversions.convertModel(value));
        return this;
    };
    /**
     * @return {Connection| null}
     */
    Folder.prototype.getConnection = function () {
        var connection_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("connection");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getWrappableProperty(this._getValidClosetAddress(), connection_jni);
        //-- Convert abstract(transport::Connection) from jni(size_t) to js(Connection)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::Folder)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#connection", "-->", "(transport::Connection)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * @param {Connection| null} value
     *
     */
    Folder.prototype.setConnection = function (value) {
        //-- Convert abstract(transport::Connection) from js(Connection) to jni(size_t)
        var value_jni = ClosetObject_1.default._getValidClosetAddress(value);
        var connection_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("connection");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setWrappableProperty(this._getValidClosetAddress(), value_jni, connection_name_jni);
        Module.deps['TraceUtil'].log("(transport::Folder)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#connection", "(transport::Connection)", Module.deps['TraceUtil'].traceConversions.convertModel(value));
        return this;
    };
    /**
     * @return {boolean}
     */
    Folder.prototype.getIsExpanded = function () {
        var isExpanded_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("isExpanded");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getBooleanProperty(this._getValidClosetAddress(), isExpanded_jni);
        //-- Convert abstract(commons::BOOLEAN) from jni(bool) to js(boolean)
        var rc = !!rc_jni;
        Module.deps['TraceUtil'].log("(transport::Folder)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#isExpanded", "-->", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(rc));
        return rc;
    };
    /**
     * @param {boolean} value
     *
     */
    Folder.prototype.setIsExpanded = function (value) {
        //-- Convert abstract(commons::BOOLEAN) from js(boolean) to jni(bool)
        var value_jni = !!value;
        var isExpanded_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("isExpanded");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setBooleanProperty(this._getValidClosetAddress(), value_jni, isExpanded_name_jni);
        Module.deps['TraceUtil'].log("(transport::Folder)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#isExpanded", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(value));
        return this;
    };
    /**
     * @return {number}
     */
    Folder.prototype.getLastUpdated = function () {
        var lastUpdated_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("lastUpdated");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getSASDatetimeProperty(this._getValidClosetAddress(), lastUpdated_jni);
        //-- Convert abstract(commons::SASDATETIME) from jni(double) to js(number)
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::Folder)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#lastUpdated", "-->", "(commons::SASDATETIME)", Module.deps['TraceUtil'].traceConversions.convertDouble(rc));
        return rc;
    };
    /**
     * @param {number} value
     *
     */
    Folder.prototype.setLastUpdated = function (value) {
        //-- Convert abstract(commons::SASDATETIME) from js(number) to jni(double)
        var value_jni = value;
        var lastUpdated_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("lastUpdated");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setSASDatetimeProperty(this._getValidClosetAddress(), value_jni, lastUpdated_name_jni);
        Module.deps['TraceUtil'].log("(transport::Folder)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#lastUpdated", "(commons::SASDATETIME)", Module.deps['TraceUtil'].traceConversions.convertDouble(value));
        return this;
    };
    /**
     * @return {number}
     */
    Folder.prototype.getLastVisited = function () {
        var lastVisited_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("lastVisited");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getSASDatetimeProperty(this._getValidClosetAddress(), lastVisited_jni);
        //-- Convert abstract(commons::SASDATETIME) from jni(double) to js(number)
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::Folder)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#lastVisited", "-->", "(commons::SASDATETIME)", Module.deps['TraceUtil'].traceConversions.convertDouble(rc));
        return rc;
    };
    /**
     * @param {number} value
     *
     */
    Folder.prototype.setLastVisited = function (value) {
        //-- Convert abstract(commons::SASDATETIME) from js(number) to jni(double)
        var value_jni = value;
        var lastVisited_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("lastVisited");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setSASDatetimeProperty(this._getValidClosetAddress(), value_jni, lastVisited_name_jni);
        Module.deps['TraceUtil'].log("(transport::Folder)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#lastVisited", "(commons::SASDATETIME)", Module.deps['TraceUtil'].traceConversions.convertDouble(value));
        return this;
    };
    /**
     * @return {number}
     */
    Folder.prototype.getDepth = function () {
        var depth_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("depth");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getIntProperty(this._getValidClosetAddress(), depth_jni);
        //-- Convert abstract(commons::INT) from jni(int) to js(number)
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::Folder)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#depth", "-->", "(commons::INT)", Module.deps['TraceUtil'].traceConversions.convertInt(rc));
        return rc;
    };
    /**
     * @param {number} value
     *
     */
    Folder.prototype.setDepth = function (value) {
        //-- Convert abstract(commons::INT) from js(number) to jni(int)
        var value_jni = value;
        var depth_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("depth");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setIntProperty(this._getValidClosetAddress(), value_jni, depth_name_jni);
        Module.deps['TraceUtil'].log("(transport::Folder)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#depth", "(commons::INT)", Module.deps['TraceUtil'].traceConversions.convertInt(value));
        return this;
    };
    /**
     * @return {boolean}
     */
    Folder.prototype.getIsSubscribed = function () {
        var isSubscribed_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("isSubscribed");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getBooleanProperty(this._getValidClosetAddress(), isSubscribed_jni);
        //-- Convert abstract(commons::BOOLEAN) from jni(bool) to js(boolean)
        var rc = !!rc_jni;
        Module.deps['TraceUtil'].log("(transport::Folder)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#isSubscribed", "-->", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(rc));
        return rc;
    };
    /**
     * @param {boolean} value
     *
     */
    Folder.prototype.setIsSubscribed = function (value) {
        //-- Convert abstract(commons::BOOLEAN) from js(boolean) to jni(bool)
        var value_jni = !!value;
        var isSubscribed_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("isSubscribed");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setBooleanProperty(this._getValidClosetAddress(), value_jni, isSubscribed_name_jni);
        Module.deps['TraceUtil'].log("(transport::Folder)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#isSubscribed", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    Folder.prototype.toString2 = function () {
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_Folder_toString2(this._getValidClosetAddress());
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::Folder)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "toString2", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    exports.default = Folder;
});
