sas.ltjs.define(["require", "exports", "sas/ltjs/commons/ltjsEnvironment", "sas/ltjs/commons/WrappableCloset", "sas/ltjs/commons/events/EventDispatcher", "sas/ltjs/transport/lib", "sas/ltjs/transport/models/TransportModel", "./ReportAsset"], function (require, exports, ltjsEnvironment_1, WrappableCloset_1, EventDispatcher_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var DownloadStatus = ltjsEnvironment_1.createModule([114, 13, 50265, 50091], EventDispatcher_1.default);
    /**
     *
     */
    DownloadStatus._create = function () {
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_DownloadStatus_create();
        //-- Convert abstract(commons::VOID) from jni(void) to js()
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::DownloadStatus)", "static", "new", "-->", "(transport::DownloadStatus)", rc);
        return rc;
    };
    /**
     * @return {Array.<ReportAsset| null> | null}
     */
    DownloadStatus.prototype.getAssets = function () {
        var assets_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("assets");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getWrappableVectorProperty(this._getValidClosetAddress(), assets_jni);
        //-- Convert abstract(<transport::ReportAsset>) from jni(size_t) to js(ReportAsset)
        var rc = WrappableCloset_1.getWrapperArray(rc_jni);
        Module.deps['TraceUtil'].log("(transport::DownloadStatus)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#assets", "-->", "(MONITORED_VECTOR<transport::ReportAsset>)", Module.deps['TraceUtil'].traceConversions.convertArray(rc, Module.deps['TraceUtil'].traceConversions.convertModel));
        return rc;
    };
    /**
     * @param {Array.<ReportAsset| null> | null} value
     *
     */
    DownloadStatus.prototype.setAssets = function (value) {
        //-- Convert abstract(<transport::ReportAsset>) from js(ReportAsset) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertObjectArrayToC(value);
        var assets_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("assets");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setWrappableVectorProperty(this._getValidClosetAddress(), value_jni, assets_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::DownloadStatus)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#assets", "(MONITORED_VECTOR<transport::ReportAsset>)", Module.deps['TraceUtil'].traceConversions.convertArray(value, Module.deps['TraceUtil'].traceConversions.convertModel));
        return this;
    };
    /**
     * @return {number}
     */
    DownloadStatus.prototype.getNumberOfRequiredAssets = function () {
        var numberOfRequiredAssets_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("numberOfRequiredAssets");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getIntProperty(this._getValidClosetAddress(), numberOfRequiredAssets_jni);
        //-- Convert abstract(commons::INT) from jni(int) to js(number)
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::DownloadStatus)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#numberOfRequiredAssets", "-->", "(commons::INT)", Module.deps['TraceUtil'].traceConversions.convertInt(rc));
        return rc;
    };
    /**
     * @param {number} value
     *
     */
    DownloadStatus.prototype.setNumberOfRequiredAssets = function (value) {
        //-- Convert abstract(commons::INT) from js(number) to jni(int)
        var value_jni = value;
        var numberOfRequiredAssets_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("numberOfRequiredAssets");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setIntProperty(this._getValidClosetAddress(), value_jni, numberOfRequiredAssets_name_jni);
        Module.deps['TraceUtil'].log("(transport::DownloadStatus)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#numberOfRequiredAssets", "(commons::INT)", Module.deps['TraceUtil'].traceConversions.convertInt(value));
        return this;
    };
    /**
     * @return {number}
     */
    DownloadStatus.prototype.getNumberOfAvailableAssets = function () {
        var numberOfAvailableAssets_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("numberOfAvailableAssets");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getIntProperty(this._getValidClosetAddress(), numberOfAvailableAssets_jni);
        //-- Convert abstract(commons::INT) from jni(int) to js(number)
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::DownloadStatus)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#numberOfAvailableAssets", "-->", "(commons::INT)", Module.deps['TraceUtil'].traceConversions.convertInt(rc));
        return rc;
    };
    /**
     * @param {number} value
     *
     */
    DownloadStatus.prototype.setNumberOfAvailableAssets = function (value) {
        //-- Convert abstract(commons::INT) from js(number) to jni(int)
        var value_jni = value;
        var numberOfAvailableAssets_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("numberOfAvailableAssets");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setIntProperty(this._getValidClosetAddress(), value_jni, numberOfAvailableAssets_name_jni);
        Module.deps['TraceUtil'].log("(transport::DownloadStatus)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#numberOfAvailableAssets", "(commons::INT)", Module.deps['TraceUtil'].traceConversions.convertInt(value));
        return this;
    };
    /**
     * @return {number}
     */
    DownloadStatus.prototype.getNumberOfPendingDownloads = function () {
        var numberOfPendingDownloads_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("numberOfPendingDownloads");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getIntProperty(this._getValidClosetAddress(), numberOfPendingDownloads_jni);
        //-- Convert abstract(commons::INT) from jni(int) to js(number)
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::DownloadStatus)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#numberOfPendingDownloads", "-->", "(commons::INT)", Module.deps['TraceUtil'].traceConversions.convertInt(rc));
        return rc;
    };
    /**
     * @param {number} value
     *
     */
    DownloadStatus.prototype.setNumberOfPendingDownloads = function (value) {
        //-- Convert abstract(commons::INT) from js(number) to jni(int)
        var value_jni = value;
        var numberOfPendingDownloads_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("numberOfPendingDownloads");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setIntProperty(this._getValidClosetAddress(), value_jni, numberOfPendingDownloads_name_jni);
        Module.deps['TraceUtil'].log("(transport::DownloadStatus)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#numberOfPendingDownloads", "(commons::INT)", Module.deps['TraceUtil'].traceConversions.convertInt(value));
        return this;
    };
    /**
     * @return {number}
     */
    DownloadStatus.prototype.getNumberOfFailedDownloads = function () {
        var numberOfFailedDownloads_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("numberOfFailedDownloads");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getIntProperty(this._getValidClosetAddress(), numberOfFailedDownloads_jni);
        //-- Convert abstract(commons::INT) from jni(int) to js(number)
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::DownloadStatus)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#numberOfFailedDownloads", "-->", "(commons::INT)", Module.deps['TraceUtil'].traceConversions.convertInt(rc));
        return rc;
    };
    /**
     * @param {number} value
     *
     */
    DownloadStatus.prototype.setNumberOfFailedDownloads = function (value) {
        //-- Convert abstract(commons::INT) from js(number) to jni(int)
        var value_jni = value;
        var numberOfFailedDownloads_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("numberOfFailedDownloads");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setIntProperty(this._getValidClosetAddress(), value_jni, numberOfFailedDownloads_name_jni);
        Module.deps['TraceUtil'].log("(transport::DownloadStatus)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#numberOfFailedDownloads", "(commons::INT)", Module.deps['TraceUtil'].traceConversions.convertInt(value));
        return this;
    };
    /**
     * @return {number}
     */
    DownloadStatus.prototype.getNumberOfDownloadsInProgress = function () {
        var numberOfDownloadsInProgress_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("numberOfDownloadsInProgress");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getIntProperty(this._getValidClosetAddress(), numberOfDownloadsInProgress_jni);
        //-- Convert abstract(commons::INT) from jni(int) to js(number)
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::DownloadStatus)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#numberOfDownloadsInProgress", "-->", "(commons::INT)", Module.deps['TraceUtil'].traceConversions.convertInt(rc));
        return rc;
    };
    /**
     * @param {number} value
     *
     */
    DownloadStatus.prototype.setNumberOfDownloadsInProgress = function (value) {
        //-- Convert abstract(commons::INT) from js(number) to jni(int)
        var value_jni = value;
        var numberOfDownloadsInProgress_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("numberOfDownloadsInProgress");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setIntProperty(this._getValidClosetAddress(), value_jni, numberOfDownloadsInProgress_name_jni);
        Module.deps['TraceUtil'].log("(transport::DownloadStatus)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#numberOfDownloadsInProgress", "(commons::INT)", Module.deps['TraceUtil'].traceConversions.convertInt(value));
        return this;
    };
    /**
     * @return {boolean}
     */
    DownloadStatus.prototype.getIsPaused = function () {
        var isPaused_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("isPaused");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getBooleanProperty(this._getValidClosetAddress(), isPaused_jni);
        //-- Convert abstract(commons::BOOLEAN) from jni(bool) to js(boolean)
        var rc = !!rc_jni;
        Module.deps['TraceUtil'].log("(transport::DownloadStatus)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#isPaused", "-->", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(rc));
        return rc;
    };
    /**
     * @param {boolean} value
     *
     */
    DownloadStatus.prototype.setIsPaused = function (value) {
        //-- Convert abstract(commons::BOOLEAN) from js(boolean) to jni(bool)
        var value_jni = !!value;
        var isPaused_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("isPaused");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setBooleanProperty(this._getValidClosetAddress(), value_jni, isPaused_name_jni);
        Module.deps['TraceUtil'].log("(transport::DownloadStatus)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#isPaused", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(value));
        return this;
    };
    /**
     * @return {boolean}
     */
    DownloadStatus.prototype.getNeedsPreviewsGenerated = function () {
        var needsPreviewsGenerated_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("needsPreviewsGenerated");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getBooleanProperty(this._getValidClosetAddress(), needsPreviewsGenerated_jni);
        //-- Convert abstract(commons::BOOLEAN) from jni(bool) to js(boolean)
        var rc = !!rc_jni;
        Module.deps['TraceUtil'].log("(transport::DownloadStatus)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#needsPreviewsGenerated", "-->", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(rc));
        return rc;
    };
    /**
     * @param {boolean} value
     *
     */
    DownloadStatus.prototype.setNeedsPreviewsGenerated = function (value) {
        //-- Convert abstract(commons::BOOLEAN) from js(boolean) to jni(bool)
        var value_jni = !!value;
        var needsPreviewsGenerated_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("needsPreviewsGenerated");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setBooleanProperty(this._getValidClosetAddress(), value_jni, needsPreviewsGenerated_name_jni);
        Module.deps['TraceUtil'].log("(transport::DownloadStatus)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#needsPreviewsGenerated", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(value));
        return this;
    };
    /**
     * @return {boolean}
     */
    DownloadStatus.prototype.getNeedsThumbnailsDownloaded = function () {
        var needsThumbnailsDownloaded_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("needsThumbnailsDownloaded");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getBooleanProperty(this._getValidClosetAddress(), needsThumbnailsDownloaded_jni);
        //-- Convert abstract(commons::BOOLEAN) from jni(bool) to js(boolean)
        var rc = !!rc_jni;
        Module.deps['TraceUtil'].log("(transport::DownloadStatus)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#needsThumbnailsDownloaded", "-->", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(rc));
        return rc;
    };
    /**
     * @param {boolean} value
     *
     */
    DownloadStatus.prototype.setNeedsThumbnailsDownloaded = function (value) {
        //-- Convert abstract(commons::BOOLEAN) from js(boolean) to jni(bool)
        var value_jni = !!value;
        var needsThumbnailsDownloaded_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("needsThumbnailsDownloaded");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setBooleanProperty(this._getValidClosetAddress(), value_jni, needsThumbnailsDownloaded_name_jni);
        Module.deps['TraceUtil'].log("(transport::DownloadStatus)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#needsThumbnailsDownloaded", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(value));
        return this;
    };
    exports.default = DownloadStatus;
});
