sas.ltjs.define(["require", "exports", "sas/ltjs/commons/ltjsEnvironment", "sas/ltjs/commons/events/EventDispatcher", "sas/ltjs/transport/lib", "sas/ltjs/transport/models/TransportModel", "sas/ltjs/transport/models/media/particles/SubscribeMethod"], function (require, exports, ltjsEnvironment_1, EventDispatcher_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var DisplayRecord = ltjsEnvironment_1.createModule([114, 13, 50265, 50089], EventDispatcher_1.default);
    /**
     *
     */
    DisplayRecord._create = function () {
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_DisplayRecord_create();
        //-- Convert abstract(commons::VOID) from jni(void) to js()
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::DisplayRecord)", "static", "new", "-->", "(transport::DisplayRecord)", rc);
        return rc;
    };
    /**
     * @return {boolean}
     */
    DisplayRecord.prototype.getIsDisplayed = function () {
        var isDisplayed_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("isDisplayed");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getBooleanProperty(this._getValidClosetAddress(), isDisplayed_jni);
        //-- Convert abstract(commons::BOOLEAN) from jni(bool) to js(boolean)
        var rc = !!rc_jni;
        Module.deps['TraceUtil'].log("(transport::DisplayRecord)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#isDisplayed", "-->", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(rc));
        return rc;
    };
    /**
     * @param {boolean} value
     *
     */
    DisplayRecord.prototype.setIsDisplayed = function (value) {
        //-- Convert abstract(commons::BOOLEAN) from js(boolean) to jni(bool)
        var value_jni = !!value;
        var isDisplayed_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("isDisplayed");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setBooleanProperty(this._getValidClosetAddress(), value_jni, isDisplayed_name_jni);
        Module.deps['TraceUtil'].log("(transport::DisplayRecord)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#isDisplayed", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(value));
        return this;
    };
    /**
     * @return {number}
     */
    DisplayRecord.prototype.getDisplayedCount = function () {
        var displayedCount_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("displayedCount");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getIntProperty(this._getValidClosetAddress(), displayedCount_jni);
        //-- Convert abstract(commons::INT) from jni(int) to js(number)
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::DisplayRecord)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#displayedCount", "-->", "(commons::INT)", Module.deps['TraceUtil'].traceConversions.convertInt(rc));
        return rc;
    };
    /**
     * @param {number} value
     *
     */
    DisplayRecord.prototype.setDisplayedCount = function (value) {
        //-- Convert abstract(commons::INT) from js(number) to jni(int)
        var value_jni = value;
        var displayedCount_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("displayedCount");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setIntProperty(this._getValidClosetAddress(), value_jni, displayedCount_name_jni);
        Module.deps['TraceUtil'].log("(transport::DisplayRecord)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#displayedCount", "(commons::INT)", Module.deps['TraceUtil'].traceConversions.convertInt(value));
        return this;
    };
    /**
     * @return {boolean}
     */
    DisplayRecord.prototype.getIsGenerateInProgress = function () {
        var isGenerateInProgress_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("isGenerateInProgress");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getBooleanProperty(this._getValidClosetAddress(), isGenerateInProgress_jni);
        //-- Convert abstract(commons::BOOLEAN) from jni(bool) to js(boolean)
        var rc = !!rc_jni;
        Module.deps['TraceUtil'].log("(transport::DisplayRecord)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#isGenerateInProgress", "-->", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(rc));
        return rc;
    };
    /**
     * @param {boolean} value
     *
     */
    DisplayRecord.prototype.setIsGenerateInProgress = function (value) {
        //-- Convert abstract(commons::BOOLEAN) from js(boolean) to jni(bool)
        var value_jni = !!value;
        var isGenerateInProgress_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("isGenerateInProgress");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setBooleanProperty(this._getValidClosetAddress(), value_jni, isGenerateInProgress_name_jni);
        Module.deps['TraceUtil'].log("(transport::DisplayRecord)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#isGenerateInProgress", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(value));
        return this;
    };
    /**
     * @return {number}
     */
    DisplayRecord.prototype.getDateCreated = function () {
        var dateCreated_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("dateCreated");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getSASDatetimeProperty(this._getValidClosetAddress(), dateCreated_jni);
        //-- Convert abstract(commons::SASDATETIME) from jni(double) to js(number)
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::DisplayRecord)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#dateCreated", "-->", "(commons::SASDATETIME)", Module.deps['TraceUtil'].traceConversions.convertDouble(rc));
        return rc;
    };
    /**
     * @param {number} value
     *
     */
    DisplayRecord.prototype.setDateCreated = function (value) {
        //-- Convert abstract(commons::SASDATETIME) from js(number) to jni(double)
        var value_jni = value;
        var dateCreated_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("dateCreated");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setSASDatetimeProperty(this._getValidClosetAddress(), value_jni, dateCreated_name_jni);
        Module.deps['TraceUtil'].log("(transport::DisplayRecord)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#dateCreated", "(commons::SASDATETIME)", Module.deps['TraceUtil'].traceConversions.convertDouble(value));
        return this;
    };
    /**
     * @return {number}
     */
    DisplayRecord.prototype.getDateUpdated = function () {
        var dateUpdated_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("dateUpdated");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getSASDatetimeProperty(this._getValidClosetAddress(), dateUpdated_jni);
        //-- Convert abstract(commons::SASDATETIME) from jni(double) to js(number)
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::DisplayRecord)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#dateUpdated", "-->", "(commons::SASDATETIME)", Module.deps['TraceUtil'].traceConversions.convertDouble(rc));
        return rc;
    };
    /**
     * @param {number} value
     *
     */
    DisplayRecord.prototype.setDateUpdated = function (value) {
        //-- Convert abstract(commons::SASDATETIME) from js(number) to jni(double)
        var value_jni = value;
        var dateUpdated_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("dateUpdated");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setSASDatetimeProperty(this._getValidClosetAddress(), value_jni, dateUpdated_name_jni);
        Module.deps['TraceUtil'].log("(transport::DisplayRecord)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#dateUpdated", "(commons::SASDATETIME)", Module.deps['TraceUtil'].traceConversions.convertDouble(value));
        return this;
    };
    /**
     * @return {number}
     */
    DisplayRecord.prototype.getDateLastViewed = function () {
        var dateLastViewed_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("dateLastViewed");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getSASDatetimeProperty(this._getValidClosetAddress(), dateLastViewed_jni);
        //-- Convert abstract(commons::SASDATETIME) from jni(double) to js(number)
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::DisplayRecord)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#dateLastViewed", "-->", "(commons::SASDATETIME)", Module.deps['TraceUtil'].traceConversions.convertDouble(rc));
        return rc;
    };
    /**
     * @param {number} value
     *
     */
    DisplayRecord.prototype.setDateLastViewed = function (value) {
        //-- Convert abstract(commons::SASDATETIME) from js(number) to jni(double)
        var value_jni = value;
        var dateLastViewed_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("dateLastViewed");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setSASDatetimeProperty(this._getValidClosetAddress(), value_jni, dateLastViewed_name_jni);
        Module.deps['TraceUtil'].log("(transport::DisplayRecord)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#dateLastViewed", "(commons::SASDATETIME)", Module.deps['TraceUtil'].traceConversions.convertDouble(value));
        return this;
    };
    /**
     * @return {SubscribeMethod}
     */
    DisplayRecord.prototype.getSubscribeMethod = function () {
        var subscribeMethod_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("subscribeMethod");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getIntProperty(this._getValidClosetAddress(), subscribeMethod_jni);
        //-- Convert abstract(transport::SubscribeMethod) from jni(int) to js(SubscribeMethod)
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::DisplayRecord)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#subscribeMethod", "-->", "(transport::SubscribeMethod::type)", Module.deps['TraceUtil'].traceConversions.convertEnum(rc));
        return rc;
    };
    /**
     * @param {SubscribeMethod} value
     *
     */
    DisplayRecord.prototype.setSubscribeMethod = function (value) {
        //-- Convert abstract(transport::SubscribeMethod) from js(SubscribeMethod) to jni(int)
        var value_jni = value;
        var subscribeMethod_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("subscribeMethod");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setIntProperty(this._getValidClosetAddress(), value_jni, subscribeMethod_name_jni);
        Module.deps['TraceUtil'].log("(transport::DisplayRecord)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#subscribeMethod", "(transport::SubscribeMethod::type)", Module.deps['TraceUtil'].traceConversions.convertEnum(value));
        return this;
    };
    exports.default = DisplayRecord;
});
