sas.ltjs.define(["require", "exports", "sas/ltjs/commons/ltjsEnvironment", "sas/ltjs/commons/WrappableCloset", "sas/ltjs/commons/ClosetObject", "sas/ltjs/commons/events/EventDispatcher", "sas/ltjs/transport/lib", "./ReportCollectionOwner", "./Report", "sas/ltjs/transport/depot/DepotConfiguration", "./Connection", "./SubscribedCollection"], function (require, exports, ltjsEnvironment_1, WrappableCloset_1, ClosetObject_1, EventDispatcher_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var DepotData = ltjsEnvironment_1.createModule([114, 13, 50265, 50191, 50082], EventDispatcher_1.default);
    /**
     *
     */
    DepotData._create = function () {
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_DepotData_create();
        //-- Convert abstract(commons::VOID) from jni(void) to js()
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::DepotData)", "static", "new", "-->", "(transport::DepotData)", rc);
        return rc;
    };
    /**
     * @return {Array.<Report| null> | null}
     */
    DepotData.prototype.getLegacyReports = function () {
        var legacyReports_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("legacyReports");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getWrappableVectorProperty(this._getValidClosetAddress(), legacyReports_jni);
        //-- Convert abstract(<transport::Report>) from jni(size_t) to js(Report)
        var rc = WrappableCloset_1.getWrapperArray(rc_jni);
        Module.deps['TraceUtil'].log("(transport::DepotData)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#legacyReports", "-->", "(MONITORED_VECTOR<transport::Report>)", Module.deps['TraceUtil'].traceConversions.convertArray(rc, Module.deps['TraceUtil'].traceConversions.convertModel));
        return rc;
    };
    /**
     * @param {Array.<Report| null> | null} value
     *
     */
    DepotData.prototype.setLegacyReports = function (value) {
        //-- Convert abstract(<transport::Report>) from js(Report) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertObjectArrayToC(value);
        var legacyReports_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("legacyReports");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setWrappableVectorProperty(this._getValidClosetAddress(), value_jni, legacyReports_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::DepotData)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#legacyReports", "(MONITORED_VECTOR<transport::Report>)", Module.deps['TraceUtil'].traceConversions.convertArray(value, Module.deps['TraceUtil'].traceConversions.convertModel));
        return this;
    };
    /**
     * @return {DepotConfiguration| null}
     */
    DepotData.prototype.getLastUsedConfiguration = function () {
        var lastUsedConfiguration_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("lastUsedConfiguration");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getWrappableProperty(this._getValidClosetAddress(), lastUsedConfiguration_jni);
        //-- Convert abstract(transport::DepotConfiguration) from jni(size_t) to js(DepotConfiguration)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::DepotData)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#lastUsedConfiguration", "-->", "(transport::DepotConfiguration)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * @param {DepotConfiguration| null} value
     *
     */
    DepotData.prototype.setLastUsedConfiguration = function (value) {
        //-- Convert abstract(transport::DepotConfiguration) from js(DepotConfiguration) to jni(size_t)
        var value_jni = ClosetObject_1.default._getValidClosetAddress(value);
        var lastUsedConfiguration_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("lastUsedConfiguration");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setWrappableProperty(this._getValidClosetAddress(), value_jni, lastUsedConfiguration_name_jni);
        Module.deps['TraceUtil'].log("(transport::DepotData)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#lastUsedConfiguration", "(transport::DepotConfiguration)", Module.deps['TraceUtil'].traceConversions.convertModel(value));
        return this;
    };
    /**
     * @return {Array.<Connection| null> | null}
     */
    DepotData.prototype.getConnections = function () {
        var connections_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("connections");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getWrappableVectorProperty(this._getValidClosetAddress(), connections_jni);
        //-- Convert abstract(<transport::Connection>) from jni(size_t) to js(Connection)
        var rc = WrappableCloset_1.getWrapperArray(rc_jni);
        Module.deps['TraceUtil'].log("(transport::DepotData)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#connections", "-->", "(MONITORED_VECTOR<transport::Connection>)", Module.deps['TraceUtil'].traceConversions.convertArray(rc, Module.deps['TraceUtil'].traceConversions.convertModel));
        return rc;
    };
    /**
     * @param {Array.<Connection| null> | null} value
     *
     */
    DepotData.prototype.setConnections = function (value) {
        //-- Convert abstract(<transport::Connection>) from js(Connection) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertObjectArrayToC(value);
        var connections_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("connections");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setWrappableVectorProperty(this._getValidClosetAddress(), value_jni, connections_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::DepotData)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#connections", "(MONITORED_VECTOR<transport::Connection>)", Module.deps['TraceUtil'].traceConversions.convertArray(value, Module.deps['TraceUtil'].traceConversions.convertModel));
        return this;
    };
    /**
     * @return {Array.<SubscribedCollection| null> | null}
     */
    DepotData.prototype.getCollections = function () {
        var collections_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("collections");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getWrappableVectorProperty(this._getValidClosetAddress(), collections_jni);
        //-- Convert abstract(<transport::SubscribedCollection>) from jni(size_t) to js(SubscribedCollection)
        var rc = WrappableCloset_1.getWrapperArray(rc_jni);
        Module.deps['TraceUtil'].log("(transport::DepotData)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#collections", "-->", "(MONITORED_VECTOR<transport::SubscribedCollection>)", Module.deps['TraceUtil'].traceConversions.convertArray(rc, Module.deps['TraceUtil'].traceConversions.convertModel));
        return rc;
    };
    /**
     * @param {Array.<SubscribedCollection| null> | null} value
     *
     */
    DepotData.prototype.setCollections = function (value) {
        //-- Convert abstract(<transport::SubscribedCollection>) from js(SubscribedCollection) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertObjectArrayToC(value);
        var collections_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("collections");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setWrappableVectorProperty(this._getValidClosetAddress(), value_jni, collections_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::DepotData)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#collections", "(MONITORED_VECTOR<transport::SubscribedCollection>)", Module.deps['TraceUtil'].traceConversions.convertArray(value, Module.deps['TraceUtil'].traceConversions.convertModel));
        return this;
    };
    /**
     * @return {string| null}
     */
    DepotData.prototype.getLastUsedLocale = function () {
        var lastUsedLocale_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("lastUsedLocale");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), lastUsedLocale_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::DepotData)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#lastUsedLocale", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    DepotData.prototype.setLastUsedLocale = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var lastUsedLocale_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("lastUsedLocale");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, lastUsedLocale_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::DepotData)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#lastUsedLocale", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    exports.default = DepotData;
});
