sas.ltjs.define(["require", "exports", "sas/ltjs/commons/ltjsEnvironment", "sas/ltjs/commons/WrappableCloset", "sas/ltjs/commons/ClosetObject", "sas/ltjs/commons/events/EventDispatcher", "sas/ltjs/transport/lib", "sas/ltjs/transport/models/TransportModel", "sas/ltjs/transport/models/media/cas/CASTableItem", "./CASColumn"], function (require, exports, ltjsEnvironment_1, WrappableCloset_1, ClosetObject_1, EventDispatcher_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var CASTable = ltjsEnvironment_1.createModule([114, 13, 50265, 50043], EventDispatcher_1.default);
    /**
     *
     */
    CASTable._create = function () {
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_CASTable_create();
        //-- Convert abstract(commons::VOID) from jni(void) to js()
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::CASTable)", "static", "new", "-->", "(transport::CASTable)", rc);
        return rc;
    };
    /**
     * @return {CASTableItem| null}
     */
    CASTable.prototype.getDetails = function () {
        var details_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("details");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getWrappableProperty(this._getValidClosetAddress(), details_jni);
        //-- Convert abstract(transport::CASTableItem) from jni(size_t) to js(CASTableItem)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::CASTable)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#details", "-->", "(transport::CASTableItem)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * @param {CASTableItem| null} value
     *
     */
    CASTable.prototype.setDetails = function (value) {
        //-- Convert abstract(transport::CASTableItem) from js(CASTableItem) to jni(size_t)
        var value_jni = ClosetObject_1.default._getValidClosetAddress(value);
        var details_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("details");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setWrappableProperty(this._getValidClosetAddress(), value_jni, details_name_jni);
        Module.deps['TraceUtil'].log("(transport::CASTable)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#details", "(transport::CASTableItem)", Module.deps['TraceUtil'].traceConversions.convertModel(value));
        return this;
    };
    /**
     * @return {Array.<CASColumn| null> | null}
     */
    CASTable.prototype.getColumns = function () {
        var columns_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("columns");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getWrappableVectorProperty(this._getValidClosetAddress(), columns_jni);
        //-- Convert abstract(<transport::CASColumn>) from jni(size_t) to js(CASColumn)
        var rc = WrappableCloset_1.getWrapperArray(rc_jni);
        Module.deps['TraceUtil'].log("(transport::CASTable)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#columns", "-->", "(MONITORED_VECTOR<transport::CASColumn>)", Module.deps['TraceUtil'].traceConversions.convertArray(rc, Module.deps['TraceUtil'].traceConversions.convertModel));
        return rc;
    };
    /**
     * @param {Array.<CASColumn| null> | null} value
     *
     */
    CASTable.prototype.setColumns = function (value) {
        //-- Convert abstract(<transport::CASColumn>) from js(CASColumn) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertObjectArrayToC(value);
        var columns_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("columns");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setWrappableVectorProperty(this._getValidClosetAddress(), value_jni, columns_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::CASTable)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#columns", "(MONITORED_VECTOR<transport::CASColumn>)", Module.deps['TraceUtil'].traceConversions.convertArray(value, Module.deps['TraceUtil'].traceConversions.convertModel));
        return this;
    };
    exports.default = CASTable;
});
